// <summary>ソースコード：グラフ表示モジュール　メイン画面フォーム</summary>
// <author>CommonMP</author>
using System;
using System.IO;
using System.Collections;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using System.Xml;

using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYSSOP.OptionImpl.HSViewer.DotNetViewer;

namespace CommonMP.HYMCO.OptionImpl.McGraphViewForDevelop
{
    /// <summary><para>class outline:</para>
    /// <para>グラフ表示モジュール　メイン画面フォーム</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/02/04][新規作成]</para>
    /// </remarks>
    public partial class McGraphViewDotNetForm : HySDotNetForm // : Form
    {
        /// <summary> 制御するクリーン </summary>
        protected McGraphViewDotNetScreen m_csGraphViewScreen = null;
        /// <summary> 雨量データフォルダ </summary>
        private String m_Folder_Rainfall = "";
        /// <summary> 水位データフォルダ </summary>
        private String m_Folder_WaterLevel = "";
        /// <summary> 流量データフォルダ </summary>
        private String m_Folder_FlowMeter = "";
        /// <summary> 断面図データフォルダ </summary>
        private String m_Folder_Danmen = "";

        /// <summary> 期間開始 </summary>
        public DateTime m_DtStart;
        /// <summary> 期間終了 </summary>
        public DateTime m_DtEnd;
        /// <summary> グラフ縦軸数 </summary>
        private int m_X_Num = 0;

        /// <summary> 雨量データリスト </summary>
        public McGraphViewRainfallItems[] m_RainfallItems = null;
        /// <summary> 雨量グラフY軸の最大値 </summary>
        private float m_RainfallMaxY = 10.0F;	// グラフY軸の最大値
        /// <summary> 雨量グラフY軸の最小値 </summary>
        private float m_RainfallMinY = 10.0F;	// グラフY軸の最小値
        /// <summary> 雨量グラフY軸のセパレート値 </summary>
        private float m_RainfallSepY = 2.0F;	// グラフY軸のセパレート値

        /// <summary> 水位データリスト </summary>
        public McGraphViewWaterLevelItems[] m_WaterLevelItems = null;
        /// <summary> 水位グラフY軸の最大値 </summary>
        private float m_WaterLevelMaxY = 5.0F;	// グラフY軸の最大値
        /// <summary> 水位グラフY軸の最大値 </summary>
        private float m_WaterLevelMinY = -5.0F;	// グラフY軸の最大値
        /// <summary> 水位グラフY軸のセパレート値 </summary>
        private float m_WaterLevelSepY = 1.0F;	// グラフY軸のセパレート値

        /// <summary> 基準水位数 </summary>
        private int m_BaseWaterLevelNum = 0;        //基準水位
        /// <summary> 基準水位リスト（名称） </summary>
        private String[] m_sBaseWaterLevel = null;  //基準水位
        /// <summary> 基準水位リスト </summary>
        private float[] m_fBaseWaterLevel = null;   //基準水位
        /// <summary> 断面図リスト数 </summary>
        private int m_DanmenListNum = 0;
        /// <summary> 断面図X、Yリスト </summary>
        private float[,] m_DanmenList = null;

        /// <summary> 断面図グラフY軸の最大値 </summary>
        private float m_DanmenMaxY = 0.0F;	// グラフY軸の最大値
        /// <summary> 断面図グラフY軸の最大値 </summary>
        private float m_DanmenMinY = 0.0F;	// グラフY軸の最大値
        /// <summary> 断面図グラフX軸の最大値 </summary>
        private float m_DanmenMaxX = 0.0F;	// グラフX軸の最大値
        /// <summary> 断面図グラフX軸の最大値 </summary>
        private float m_DanmenMinX = 0.0F;	// グラフX軸の最大値

        /// <summary> 流量データリスト </summary>
        public McGraphViewFlowMeterItems[] m_FlowMeterItems = null;
        /// <summary> 流量グラフY軸の最大値 </summary>
        private float m_FlowMeterMaxY = 50.0F;	// グラフY軸の最大値
        /// <summary> 流量グラフY軸の最大値 </summary>
        private float m_FlowMeterMinY = 0.0F;	// グラフY軸の最大値
        
        
        /// <summary> 水位グラフY軸の表示目盛掛け率 </summary>
        private float m_WaterLevelRateY = 0.0F;     //add 2011.03.08
        /// <summary> 流量グラフY軸の表示目盛掛け率 </summary>
        private float m_FlowMeterRateY = 0.0F;      //add 2011.03.08
      

        /// <summary> グラフ自動調整表示の有無 </summary>
        private bool m_IsAutoFit = true;    //[2010.06.03]

// start of 印刷機能追加
        //印刷用・領域取得関数のインポート
        [System.Runtime.InteropServices.DllImport(@"C:\WINDOWS\system32\gdi32.dll")]
        private static extern int BitBlt(IntPtr hDestDC, int x, int y, int nWidth, int nHeight,
                                         IntPtr hSrcDC, int xSrc, int ySrc, int dwRop);

        /// <summary>印刷用ビットマップ</summary>
        private Bitmap m_bit_img = null;//印刷用ビットマップ

        /// <summary>印刷用プリントドキュメント</summary>
        private System.Drawing.Printing.PrintDocument m_pd = null;
// end of 印刷機能追加

        #region 内部メソッド
        #region フォルダ選択
        /// <summary><para>method outline:</para>
        /// <para>フォルダ選択</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_selectFolder(ref h_folder, h_textBox);</para>
        /// </example>
        /// <param name="h_folder">フォルダ名</param>
        /// <param name="h_textBox">フォルダ名格納テキストボックス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _selectFolder(
            ref String h_folder,
            System.Windows.Forms.TextBox h_textBox
            )
        {
            try
            {
                //FolderBrowserDialogクラスのインスタンスを作成
                FolderBrowserDialog a_fbd = new FolderBrowserDialog();

                //上部に表示する説明テキストを指定する
                //フォルダを指定してください。
                a_fbd.Description = Properties.HysAddinHydroHyetoGraphResources.MSG_INFO_SPECIFY_FOLDER;
                //ルートフォルダを指定する
                //デフォルトでDesktop
                //a_fbd.RootFolder = Environment.SpecialFolder.Desktop;
                //a_fbd.RootFolder = Environment.SpecialFolder.Desktop;
                //最初に選択するフォルダを指定する
                //RootFolder以下にあるフォルダである必要がある
                a_fbd.SelectedPath = System.IO.Directory.GetCurrentDirectory();
                //a_fbd.SelectedPath = @"C:\Windows";
                //ユーザーが新しいフォルダを作成できるようにする
                //デフォルトでTrue
                a_fbd.ShowNewFolderButton = true;

                //ダイアログを表示する
                if (a_fbd.ShowDialog(this) == DialogResult.OK)
                {
                    //選択されたフォルダを表示する
                    h_folder = a_fbd.SelectedPath.Trim();
                    h_textBox.Text = h_folder;
                    //Console.WriteLine(a_fbd.SelectedPath);
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
            }
        }
        #endregion
        #region ファイルリストの設定（チェックリストボックス）
        /// <summary><para>method outline:</para>
        /// <para>ファイルリストの設定（チェックリストボックス）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_setFileCheckListBoxByFolder(ref h_folder, h_clb);</para>
        /// </example>
        /// <param name="h_folder">フォルダ</param>
        /// <param name="h_clb">チェックリストボックス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _setFileCheckListBoxByFolder(
            String h_folder,
            System.Windows.Forms.CheckedListBox h_clb
            )
        {
            try{
                h_clb.Items.Clear();

                //String a_currentPath = System.IO.Directory.GetCurrentDirectory();

                //System.IO.Directory.SetCurrentDirectory(h_folder);

                //"C:\My Documents"以下のファイルをすべて取得
                string[] a_files = System.IO.Directory.GetFiles(
                    h_folder, "*.csv", System.IO.SearchOption.TopDirectoryOnly);

                for(int a_iCnt = 1; a_iCnt <= a_files.Length; a_iCnt++){
                    a_files[a_iCnt - 1] = a_files[a_iCnt - 1].Replace(h_folder,"").Replace("\\","");
                }

                //ListBox1に結果を表示する
                h_clb.Items.AddRange(a_files);

                //System.IO.Directory.SetCurrentDirectory(a_currentPath);
            }
            catch(Exception exp){
                Console.WriteLine(exp.Message);
            }
        }
        #endregion
        #region ファイルリストの設定（リストボックス）
        /// <summary><para>method outline:</para>
        /// <para>ファイルリストの設定（リストボックス）</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_setFileListBoxByFolder(ref h_folder, h_lb);</para>
        /// </example>
        /// <param name="h_folder">フォルダ名</param>
        /// <param name="h_lb">リストボックス</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _setFileListBoxByFolder(
            String h_folder,
            System.Windows.Forms.ListBox h_lb
            )
        {
            try
            {
                h_lb.Items.Clear();

                //String a_currentPath = System.IO.Directory.GetCurrentDirectory();

                //System.IO.Directory.SetCurrentDirectory(h_folder);

                //"C:\My Documents"以下のファイルをすべて取得
                string[] a_files = System.IO.Directory.GetFiles(
                    h_folder, "*.csv", System.IO.SearchOption.TopDirectoryOnly);

                for (int a_iCnt = 1; a_iCnt <= a_files.Length; a_iCnt++)
                {
                    a_files[a_iCnt - 1] = a_files[a_iCnt - 1].Replace(h_folder, "").Replace("\\", "");
                }

                //ListBox1に結果を表示する
                h_lb.Items.AddRange(a_files);

                //System.IO.Directory.SetCurrentDirectory(a_currentPath);
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
            }
        }
        #endregion

        #region 雨量実測値の読み込み
        /// <summary><para>method outline:</para>
        /// <para>雨量実測値の読み込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_readRainfallCSVFile(ref h_items, h_fname);</para>
        /// </example>
        /// <param name="h_items">McGraphViewRainfallItems：雨量データリスト</param>
        /// <param name="h_fname">ファイル名</param>
        /// <returns></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _readRainfallCSVFile(
            ref McGraphViewRainfallItems h_items,
            string h_fname
            )
        {
            try
            {
                //h_items.Clear();
                //m_RainfallMaxY = 0;
                //m_RainfallMaxX = -1;
                /* //********** 速度改善他対応 2011.03.04 del_s **************************************************
                Boolean a_IsFound = false;
                String a_sStart = m_DtStart.ToString("yyyy/MM/dd HH:mm");
                String a_sEnd = m_DtEnd.ToString("yyyy/MM/dd HH:mm");
                //********** 速度改善他対応 2011.03.04 del_e ************************************************** */
                //********** 速度改善他対応 2011.03.04 add_s **************************************************
                int iDataIdx = 0;       //格納するデータリストのインデックス
                int iTargetCnt = 0;     //プロット対象データ件数(欠測値除く)
                //********** 速度改善他対応 2011.03.04 add_e **************************************************

                using (StreamReader a_sr = new StreamReader(h_fname, System.Text.Encoding.GetEncoding(932)))
                {
                    String a_delimStr = ",";
                    Char[] a_delimiter = a_delimStr.ToCharArray();
                    String[] a_split;
                    String a_sLine = null;
                    //3行目までは、ヘッダ部の為、読み飛ばす。
                    a_sLine = a_sr.ReadLine();
                    a_sLine = a_sr.ReadLine();
                    a_sLine = a_sr.ReadLine();
                    while ((a_sLine = a_sr.ReadLine()) != null)
                    {
                        //m_RainfallMaxX++;
                        a_split = a_sLine.Split(a_delimiter);


                        //********** 速度改善他対応 2011.03.04 add_s **************************************************
                        DateTime cs_DTChange = DateTime.Parse(a_split[0].Trim());   //時刻
                        float fValue = Convert.ToSingle(a_split[1].Trim());         //Data0


                        if (cs_DTChange > m_DtEnd)
                            break;      //期間終了を超えたら読込み終了
                        if (cs_DTChange < m_DtStart)
                            continue;   //期間開始に達していない場合は読み飛ばし

                        string sCurTime = cs_DTChange.ToString("yyyy/MM/dd HH:mm");


                        while (h_items[iDataIdx].sTimeOrDay.CompareTo(sCurTime) < 0)
                        {   //格納する時刻インデックスまで進める
                            iDataIdx++;
                        }
                        if (h_items[iDataIdx].sTimeOrDay.Equals(sCurTime))
                        {   //時刻が一致するなら格納
                            h_items[iDataIdx].Rainfall = fValue;

                            //最小・最大値セット
                            if (fValue != McGraphViewDefine.g_InvalidValue)
                            {   //欠測値以外なら最小・最大値セット
                                if (iTargetCnt == 0)
                                {   //最初の対象となるデータの場合、最小・最大値を初期化
                                    m_RainfallMaxY = fValue;
                                }
                                m_RainfallMaxY = Math.Max(m_RainfallMaxY, fValue);
                                
                                iTargetCnt++;
                            }
                        }
                        //********** 速度改善他対応 2011.03.04 add_e **************************************************

                        /* //********** 速度改善他対応 2011.03.04 del_s **************************************************
                        //雨量は水位よりも１つ分少なくなる。
                        for (int a_iCnt = 0; a_iCnt < m_X_Num; a_iCnt++)
                        {
                            //if (h_items[a_iCnt].sTimeOrDay.Equals(String.Format("{0:yyyy/MM/dd HH:mm}", a_split[0])) == true)
                            if ((h_items[a_iCnt].sTimeOrDay.CompareTo(a_sStart)>=0) && (h_items[a_iCnt].sTimeOrDay.CompareTo(a_sEnd)<=0))
                            {
                                if (h_items[a_iCnt].sTimeOrDay.Equals(DateTime.Parse(a_split[0]).ToString("yyyy/MM/dd HH:mm")) == true)
                                {
                                    if (a_IsFound == false)
                                    {
                                        m_RainfallMaxY = McGraphViewDefine.g_InvalidValue;
                                        a_IsFound = true;
                                    }

                                    h_items[a_iCnt].Rainfall = Convert.ToSingle(a_split[1].Trim());

                                    //[2010.06.01]bug-fixed.↓
                                    if (h_items[a_iCnt].Rainfall != McGraphViewDefine.g_InvalidValue)
                                    {
                                        if (h_items[a_iCnt].Rainfall > m_RainfallMaxY)
                                        {
                                            m_RainfallMaxY = h_items[a_iCnt].Rainfall;
                                        }
                                    }
                                    //[2010.06.01]bug-fixed.↑

                                    break;
                                }
                            }
                        }
                        //********** 速度改善他対応 2011.03.04 del_e ************************************************** */
                    }
                }

                //[2010.06.02]↓
                //[2010.06.02]↑
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
            }
        }
        #endregion
        #region 水位実測値の読み込み
        /// <summary><para>method outline:</para>
        /// <para>水位実測値の読み込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_readWaterLevelCSVFile(h_idx, ref h_items, h_fname);</para>
        /// </example>
        /// <param name="h_idx">int：インデックス</param>
        /// <param name="h_items">McGraphViewWaterLevelItems：水位データリスト</param>
        /// <param name="h_fname">ファイル名</param>
        /// <returns></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _readWaterLevelCSVFile(
            int h_idx,  //[2010.05.07]
            ref McGraphViewWaterLevelItems h_items,
            string h_fname
            )
        {
            try
            {
                //h_items.Clear();
                //m_WaterLevelMaxY = 0;
                //m_WaterLevelMinY = 0;
                //m_WaterLevelMaxX = -1;
                /* //********** 速度改善他対応 2011.03.04 del_s **************************************************
                Boolean a_IsFound = false;
                String a_sStart = m_DtStart.ToString("yyyy/MM/dd HH:mm");
                String a_sEnd = m_DtEnd.ToString("yyyy/MM/dd HH:mm");
                //********** 速度改善他対応 2011.03.04 del_e ************************************************** */
                //********** 速度改善他対応 2011.03.04 add_s **************************************************
                int iDataIdx = 0;       //格納するデータリストのインデックス
                int iTargetCnt = 0;     //プロット対象データ件数(欠測値除く)
                //********** 速度改善他対応 2011.03.04 add_e **************************************************

                using (StreamReader a_sr = new StreamReader(h_fname, System.Text.Encoding.GetEncoding(932)))
                {
                    String a_delimStr = ",";
                    Char[] a_delimiter = a_delimStr.ToCharArray();
                    String[] a_split;
                    String a_sLine = null;
                    //3行目までは、ヘッダ部の為、読み飛ばす。
                    a_sLine = a_sr.ReadLine();
                    a_sLine = a_sr.ReadLine();
                    a_sLine = a_sr.ReadLine();
                    while ((a_sLine = a_sr.ReadLine()) != null)
                    {
                        //m_WaterLevelMaxX++;
                        a_split = a_sLine.Split(a_delimiter);


                        //********** 速度改善他対応 2011.03.04 add_s **************************************************
                        DateTime cs_DTChange = DateTime.Parse(a_split[0].Trim());   //時刻
                        float fValue = Convert.ToSingle(a_split[1].Trim());         //Data0
                        if (m_WaterLevelRateY != 0 && fValue != McGraphViewDefine.g_InvalidValue)
                        {   //表示目盛掛け率が設定されている場合、データ単位の変換を行う
                            fValue *= m_WaterLevelRateY;
                        }

                        if (cs_DTChange > m_DtEnd)
                            break;      //期間終了を超えたら読込み終了
                        if (cs_DTChange < m_DtStart)
                            continue;   //期間開始に達していない場合は読み飛ばし

                        string sCurTime = cs_DTChange.ToString("yyyy/MM/dd HH:mm");
                        while (h_items[iDataIdx].sTimeOrDay.CompareTo(sCurTime) < 0)
                        {   //格納する時刻インデックスまで進める
                            iDataIdx++;
                        }
                        if (h_items[iDataIdx].sTimeOrDay.Equals(sCurTime))
                        {   //時刻が一致するなら格納
                            h_items[iDataIdx].WaterLevel = fValue;

                            //最小・最大値セット
                            if (fValue != McGraphViewDefine.g_InvalidValue)
                            {   //欠測値以外なら最小・最大値セット
                                if (h_idx == 0 && iTargetCnt == 0)
                                {   //最初の対象となるデータの場合、最小・最大値を初期化
                                    m_WaterLevelMinY = fValue;
                                    m_WaterLevelMaxY = fValue;
                                }
                                m_WaterLevelMinY = Math.Min(m_WaterLevelMinY, fValue);
                                m_WaterLevelMaxY = Math.Max(m_WaterLevelMaxY, fValue);

                                iTargetCnt++;
                            }
                        }
                        //********** 速度改善他対応 2011.03.04 add_e **************************************************

                        /* //********** 速度改善他対応 2011.03.04 del_s **************************************************
                        for (int a_iCnt = 0; a_iCnt <= m_X_Num; a_iCnt++)
                        {
                            //if (h_items[a_iCnt].sTimeOrDay.Equals(String.Format("{0:yyyy/MM/dd HH:mm}", a_split[0])) == true)
                            if ((h_items[a_iCnt].sTimeOrDay.CompareTo(a_sStart) >= 0) && (h_items[a_iCnt].sTimeOrDay.CompareTo(a_sEnd) <= 0))
                            {
                                if (h_items[a_iCnt].sTimeOrDay.Equals(DateTime.Parse(a_split[0]).ToString("yyyy/MM/dd HH:mm")) == true)
                                {
                                    if (a_IsFound == false)
                                    {
                                        if (h_idx == 0) //[2010.05.07]
                                        {
                                            m_WaterLevelMaxY = 0;   // McGraphViewDefine.g_InvalidValue;
                                            m_WaterLevelMinY = 0;   // McGraphViewDefine.g_InvalidValue;
                                        }
                                        a_IsFound = true;
                                    }

                                    h_items[a_iCnt].WaterLevel = Convert.ToSingle(a_split[1].Trim());

                                    //[2010.06.01]bug-fixed.↓
                                    if (h_items[a_iCnt].WaterLevel != McGraphViewDefine.g_InvalidValue)
                                    {
                                        if (h_items[a_iCnt].WaterLevel > m_WaterLevelMaxY)
                                        {
                                            m_WaterLevelMaxY = h_items[a_iCnt].WaterLevel;
                                        }
                                        if (h_items[a_iCnt].WaterLevel < m_WaterLevelMinY)
                                        {
                                            m_WaterLevelMinY = h_items[a_iCnt].WaterLevel;
                                        }
                                    }
                                    //[2010.06.01]bug-fixed.↑

                                    break;
                                }
                            }
                        }
                        //********** 速度改善他対応 2011.03.04 del_e ************************************************** */
                    }
                }

                if (m_WaterLevelMaxY == 0.0F)
                {
                    m_WaterLevelMaxY = 5.0F;
                }

                m_WaterLevelMaxY = Convert.ToSingle(Math.Ceiling(m_WaterLevelMaxY));

                float a_fTmp = Math.Abs(m_WaterLevelMinY);
                a_fTmp = Convert.ToSingle(Math.Ceiling(a_fTmp));
                if (m_WaterLevelMinY < 0)
                {
                    m_WaterLevelMinY = -a_fTmp;
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
            }
        }
        #endregion
        #region 流量実測値の読み込み
        /// <summary><para>method outline:</para>
        /// <para>流量実測値の読み込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_readWaterLevelCSVFile(h_idx, ref h_items, h_fname);</para>
        /// </example>
        /// <param name="h_idx">int：インデックス</param>
        /// <param name="h_items">McGraphViewFlowMeterItems：流量データリスト</param>
        /// <param name="h_fname">ファイル名</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _readFlowMeterCSVFile(
            int h_idx,  //[2010.05.07]
            ref McGraphViewFlowMeterItems h_items,
            string h_fname
            )
        {
            try
            {
                //h_items.Clear();
                //m_FlowMeterMaxY = 0;
                //m_FlowMeterMinY = 0;
                //m_FlowMeterMaxX = -1;
                /* //********** 速度改善他対応 2011.03.04 del_s **************************************************
                Boolean a_IsFound = false;
                String a_sStart = m_DtStart.ToString("yyyy/MM/dd HH:mm");
                String a_sEnd = m_DtEnd.ToString("yyyy/MM/dd HH:mm");
                //********** 速度改善他対応 2011.03.04 del_e ************************************************** */
                //********** 速度改善他対応 2011.03.04 add_s **************************************************
                int iDataIdx = 0;       //格納するデータリストのインデックス
                int iTargetCnt = 0;     //プロット対象データ件数(欠測値除く)
                //********** 速度改善他対応 2011.03.04 add_e **************************************************

                using (StreamReader a_sr = new StreamReader(h_fname, System.Text.Encoding.GetEncoding(932)))
                {
                    String a_delimStr = ",";
                    Char[] a_delimiter = a_delimStr.ToCharArray();
                    String[] a_split;
                    String a_sLine = null;
                    //3行目までは、ヘッダ部の為、読み飛ばす。
                    a_sLine = a_sr.ReadLine();
                    a_sLine = a_sr.ReadLine();
                    a_sLine = a_sr.ReadLine();
                    while ((a_sLine = a_sr.ReadLine()) != null)
                    {
                        //m_FlowMeterMaxX++;
                        a_split = a_sLine.Split(a_delimiter);


                        //********** 速度改善他対応 2011.03.04 add_s **************************************************
                        DateTime cs_DTChange = DateTime.Parse(a_split[0].Trim());   //時刻
                        float fValue = Convert.ToSingle(a_split[1].Trim());         //Data0
                        if (m_FlowMeterRateY != 0 && fValue != McGraphViewDefine.g_InvalidValue)
                        {   //表示目盛掛け率が設定されている場合、データ単位の変換を行う
                            fValue *= m_FlowMeterRateY;
                        }

                        if (cs_DTChange > m_DtEnd)
                            break;      //期間終了を超えたら読込み終了
                        if (cs_DTChange < m_DtStart)
                            continue;   //期間開始に達していない場合は読み飛ばし

                        string sCurTime = cs_DTChange.ToString("yyyy/MM/dd HH:mm");
                        while (h_items[iDataIdx].sTimeOrDay.CompareTo(sCurTime) < 0)
                        {   //格納する時刻インデックスまで進める
                            iDataIdx++;
                        }
                        if (h_items[iDataIdx].sTimeOrDay.Equals(sCurTime))
                        {   //時刻が一致するなら格納
                            h_items[iDataIdx].FlowMeter = fValue;

                            //最小・最大値セット
                            if (fValue != McGraphViewDefine.g_InvalidValue)
                            {   //欠測値以外なら最小・最大値セット
                                if (h_idx == 0 && iTargetCnt == 0)
                                {   //最初の対象となるデータの場合、最小・最大値を初期化
                                    m_FlowMeterMinY = fValue;
                                    m_FlowMeterMaxY = fValue;
                                }
                                m_FlowMeterMinY = Math.Min(m_FlowMeterMinY, fValue);
                                m_FlowMeterMaxY = Math.Max(m_FlowMeterMaxY, fValue);

                                iTargetCnt++;
                            }
                        }
                        //********** 速度改善他対応 2011.03.04 add_e **************************************************

                        /* //********** 速度改善他対応 2011.03.04 del_s **************************************************
                        for (int a_iCnt = 0; a_iCnt <= m_X_Num; a_iCnt++)
                        {
                            //if (h_items[a_iCnt].sTimeOrDay.Equals(String.Format("{0:yyyy/MM/dd HH:mm}", a_split[0])) == true)
                            if ((h_items[a_iCnt].sTimeOrDay.CompareTo(a_sStart) >= 0) && (h_items[a_iCnt].sTimeOrDay.CompareTo(a_sEnd) <= 0))
                            {
                                if (h_items[a_iCnt].sTimeOrDay.Equals(DateTime.Parse(a_split[0]).ToString("yyyy/MM/dd HH:mm")) == true)
                                {
                                    if (a_IsFound == false)
                                    {
                                        if (h_idx == 0) //[2010.05.07]
                                        {
                                            m_FlowMeterMaxY = 0;    // McGraphViewDefine.g_InvalidValue;
                                            m_FlowMeterMinY = 0;    // McGraphViewDefine.g_InvalidValue;
                                        }
                                        a_IsFound = true;
                                    }

                                    h_items[a_iCnt].FlowMeter = Convert.ToSingle(a_split[1].Trim());

                                    //[2010.06.01]bug-fixed.↓
                                    if (h_items[a_iCnt].FlowMeter != McGraphViewDefine.g_InvalidValue)
                                    {
                                        if (h_items[a_iCnt].FlowMeter > m_FlowMeterMaxY)
                                        {
                                            m_FlowMeterMaxY = h_items[a_iCnt].FlowMeter;
                                        }
                                        if (h_items[a_iCnt].FlowMeter < m_FlowMeterMinY)
                                        {
                                            m_FlowMeterMinY = h_items[a_iCnt].FlowMeter;
                                        }
                                    }
                                    //[2010.06.01]bug-fixed.↑

                                    break;
                                }
                            }
                        }
                        //********** 速度改善他対応 2011.03.04 del_e ************************************************** */
                    }
                }

                if (m_FlowMeterMaxY == 0.0F)
                {
                    m_FlowMeterMaxY = 50.0F;
                }

                m_FlowMeterMaxY = Convert.ToSingle(Math.Ceiling(m_FlowMeterMaxY));

                float a_fTmp = Math.Abs(m_FlowMeterMinY);
                a_fTmp = Convert.ToSingle(Math.Ceiling(a_fTmp));
                if (m_FlowMeterMinY < 0)
                {
                    m_FlowMeterMinY = -a_fTmp;
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
            }
        }
        #endregion
        #region 断面データの読み込み
        /// <summary><para>method outline:</para>
        /// <para>断面データの読み込み</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_readDanmenCSVFile(h_fname);</para>
        /// </example>
        /// <param name="h_fname">ファイル名</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _readDanmenCSVFile(
            string h_fname
            )
        {
            try
            {
                m_BaseWaterLevelNum = 0;
                m_sBaseWaterLevel = null;
                m_fBaseWaterLevel = null;   
                m_DanmenListNum = 0;
                m_DanmenList = null;
                m_DanmenMaxY = 0;
                m_DanmenMinY = 0;
                m_DanmenMaxX = 0;
                m_DanmenMinX = 0;

                int a_iCnt = 0;

                using (StreamReader a_sr = new StreamReader(h_fname, System.Text.Encoding.GetEncoding(932)))
                {
                    String a_delimStr = ",";
                    Char[] a_delimiter = a_delimStr.ToCharArray();
                    String[] a_split;
                    String a_sLine = null;
                    //1行目：基準水位タイトル
                    a_sLine = a_sr.ReadLine();
                    //2行目：基準水位の数
                    a_sLine = a_sr.ReadLine();
                    m_BaseWaterLevelNum = Convert.ToInt32(a_sLine);
                    m_sBaseWaterLevel = new String[m_BaseWaterLevelNum];
                    m_fBaseWaterLevel = new float[m_BaseWaterLevelNum];
                    while ((a_sLine = a_sr.ReadLine()) != null)
                    {
                        a_split = a_sLine.Split(a_delimiter);
                        m_sBaseWaterLevel[a_iCnt] = a_split[0];
                        m_fBaseWaterLevel[a_iCnt] = Convert.ToSingle(a_split[1]);
                        a_iCnt++;
                        if (a_iCnt >= m_BaseWaterLevelNum)
                        {
                            break;
                        }
                    }

                    //1行目：断面タイトル
                    a_sLine = a_sr.ReadLine();
                    //2行目：断面の数
                    a_sLine = a_sr.ReadLine();
                    m_DanmenList = new float[Convert.ToInt32(a_sLine.Trim()), 2];
                    while ((a_sLine = a_sr.ReadLine()) != null)
                    {
                        //0：X、1：Y
                        a_split = a_sLine.Split(a_delimiter);

                        m_DanmenList[m_DanmenListNum, 0] = Convert.ToSingle(a_split[0]);
                        //m_DanmenList[m_DanmenListNum, 0] = m_DanmenListNum;
                        m_DanmenList[m_DanmenListNum, 1] = Convert.ToSingle(a_split[1]);

                        //X軸
                        if (m_DanmenList[m_DanmenListNum, 0] > m_DanmenMaxX)
                        {
                            m_DanmenMaxX = m_DanmenList[m_DanmenListNum, 0];
                        }
                        if (m_DanmenList[m_DanmenListNum, 0] < m_DanmenMinX)
                        {
                            m_DanmenMinX = m_DanmenList[m_DanmenListNum, 0];
                        }
                        //Y軸
                        if (m_DanmenList[m_DanmenListNum, 1] > m_DanmenMaxY)
                        {
                            m_DanmenMaxY = m_DanmenList[m_DanmenListNum, 1];
                        }
                        if (m_DanmenList[m_DanmenListNum, 1] < m_DanmenMinY)
                        {
                            m_DanmenMinY = m_DanmenList[m_DanmenListNum, 1];
                        }

                        m_DanmenListNum++;
                    }
                }

                m_DanmenMaxY = Convert.ToSingle(Math.Ceiling(m_DanmenMaxY));
                float a_fTmp = Math.Abs(m_DanmenMinY);
                a_fTmp = Convert.ToSingle(Math.Ceiling(a_fTmp));
                if (m_DanmenMinY < 0)
                {
                    m_DanmenMinY = -a_fTmp;
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
            }
        }
        #endregion

        #region 雨量描画
        /// <summary><para>method outline:</para>
        /// <para>雨量描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_drawRainfall();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _drawRainfall()
        {
            try
            {
                //********** 速度改善他対応 2011.03.04 add_s **************************************************
                int iX_Num = m_X_Num;
                //********** 速度改善他対応 2011.03.04 add_e **************************************************
                m_RainfallMaxY = 10.0F;	// グラフY軸の最大値
                m_RainfallMinY = 0.0F;	// グラフY軸の最小値
                m_RainfallSepY = 2.0F;	// グラフY軸のセパレート値

                //McGraphViewRainfallItems[] a_items = null;
                m_RainfallItems = null;

                int a_idx = 0;
                m_RainfallItems = new McGraphViewRainfallItems[lbRainfall.SelectedItems.Count];
                foreach (string a_sVal in lbRainfall.SelectedItems)
                {
                    m_RainfallItems[a_idx] = new McGraphViewRainfallItems();
                    m_RainfallItems[a_idx].FileName = a_sVal;

                    //凡例リストから色を取得
                    m_RainfallItems[a_idx].LineColor = legendList1.GetLegend(Properties.HysAddinHydroHyetoGraphResources.PRECIPITATION, a_sVal);    //雨量


                    /* //********** 速度改善他対応 2011.03.04 del_s **************************************************
                    //雨量は水位よりも１個分少なくなる
                    //[2010.03.07]
                    for (int a_iCnt = 1; a_iCnt <= m_X_Num; a_iCnt++)
                    {
                        McGraphViewRainfallItem a_item = new McGraphViewRainfallItem();
                        if (rdoByMinute.Checked == true)
                        {   //分単位
                            a_item.sTimeOrDay = m_DtStart.AddMinutes(a_iCnt).ToString("yyyy/MM/dd HH:mm");
                            //a_item.sTimeOrDay = m_DtStart.AddMinutes(a_iCnt).ToString("yyyy/MM/dd HH:mm");
                            //a_item.sTimeOrDay = m_DtStart.AddMinutes(a_iCnt*10).ToString("yyyy/MM/dd HH:mm");
                        }
                        else if (rdoByHour.Checked == true)
                        {   //時間単位
                            a_item.sTimeOrDay = m_DtStart.AddHours(a_iCnt).ToString("yyyy/MM/dd HH:00");
                            //a_item.sTimeOrDay = m_DtStart.AddHours(a_iCnt).ToString("yyyy/MM/dd HH:00");
                        }
                        a_item.TimeOrDay = a_iCnt - 1;  //雨量は水位よりも１個分少なくなる。
                        a_item.Rainfall = McGraphViewDefine.g_InvalidValue2; //[2010.06.02]
                        //a_item.Rainfall = McGraphViewDefine.g_InvalidValue; //[2010.06.02]
                        m_RainfallItems[a_idx].Add(a_item);	// Listに追加
                    }
                    //********** 速度改善他対応 2011.03.04 del_e ************************************************** */
                    //********** 速度改善他対応 2011.03.04 add_s **************************************************
                    //入力データ間隔を調べる
                    int iTimeStep = 60;     //雨量データ間隔(分)
                    string sLine = null;
                    int iLine = 0;
                    DateTime[] dteTime = {m_DtStart, m_DtStart};
                    using (StreamReader reader = new StreamReader(m_Folder_Rainfall + "\\" + a_sVal, System.Text.Encoding.GetEncoding(932)))
                    {
                        while ((sLine = reader.ReadLine()) != null)
                        {
                            iLine++;
                            if (iLine <= 3)
                            {
                                continue;  //ヘッダー3行読み飛ばし
                            }
                            else if (iLine <= 5)
                            {
                                string[] cols = sLine.Split(',');
                                dteTime[iLine - 4] = DateTime.Parse(cols[0].Trim());
                                if ((iLine - 4) == 1)
                                {   //2件データを読んだら、間隔を調べる
                                    TimeSpan tsDlt = dteTime[1] - dteTime[0];
                                    iTimeStep = Convert.ToInt32(tsDlt.TotalMinutes);
                                    break;
                                }
                            }
                        }
                    }

                    //雨量は「分単位/時間単位」の選択にかかわらず、入力データ間隔を優先
                    TimeSpan ts = m_DtEnd - m_DtStart;
                    iX_Num = Convert.ToInt32(ts.TotalMinutes / iTimeStep);
                    for (int a_iCnt = 1; a_iCnt <= iX_Num; a_iCnt++)
                    {
                        McGraphViewRainfallItem a_item = new McGraphViewRainfallItem();
                        a_item.sTimeOrDay = m_DtStart.AddMinutes(a_iCnt * iTimeStep).ToString("yyyy/MM/dd HH:mm");
                        a_item.TimeOrDay = a_iCnt - 1;                          //雨量は水位よりも１個分少なくなる。
                        a_item.Rainfall = McGraphViewDefine.g_InvalidValue2;
                        m_RainfallItems[a_idx].Add(a_item);	                    // Listに追加
                    }
                    //********** 速度改善他対応 2011.03.04 add_e **************************************************

                    _readRainfallCSVFile(
                        ref m_RainfallItems[a_idx],
                        m_Folder_Rainfall + "\\" + a_sVal
                        );
                    a_idx++;
                }

                //[2010.06.02]↓
                //Y軸最大値
                if (McGraphViewDefine.g_Rainfall_MaxY == McGraphViewDefine.g_InvalidValue)
                {
                    if (m_RainfallMaxY == McGraphViewDefine.g_InvalidValue)
                    {
                        m_RainfallMaxY = 10.0F;
                    }
                }
                else
                {
                    m_RainfallMaxY = McGraphViewDefine.g_Rainfall_MaxY;
                }
                //Y軸最小値
                if (McGraphViewDefine.g_Rainfall_MinY == McGraphViewDefine.g_InvalidValue)
                {
                    //m_RainfallMinY = 0.0F;
                }
                else
                {
                    m_RainfallMinY = McGraphViewDefine.g_Rainfall_MinY;
                }
                /*
                if (m_RainfallMaxY == 0.0F)
                {
                    m_RainfallMaxY = 10.0F;
                }
                 */

                //m_RainfallMaxY += (Math.Abs(m_RainfallMaxY) % 2);
                //m_RainfallMinY -= (Math.Abs(m_RainfallMinY) % 2);

                double a_dLen = Math.Ceiling(m_RainfallMaxY - m_RainfallMinY);
                int a_iLen = 0;
                if (a_dLen > 5)
                {
                    a_iLen = Convert.ToInt32(Math.Floor(a_dLen) / 5);
                    //int a_iLen = a_dLen.ToString().Length;
                    if ((a_iLen % 2) != 0)
                    {
                        a_iLen += (a_iLen % 2);
                    }
                }
                else
                {
                    a_iLen = 1;
                }
                m_RainfallSepY = a_iLen;

                if ((Math.Abs(m_RainfallMaxY) % m_RainfallSepY) != 0)
                {
                    m_RainfallMaxY += (m_RainfallSepY - (Math.Abs(m_RainfallMaxY) % m_RainfallSepY));
                }
                if ((Math.Abs(m_RainfallMinY) % m_RainfallSepY) != 0)
                {
                    m_RainfallMinY -= (m_RainfallSepY - (Math.Abs(m_RainfallMinY) % m_RainfallSepY));
                }

                /*
                m_RainfallMaxY = Convert.ToSingle(Math.Ceiling(m_RainfallMaxY));
                double a_mod = m_RainfallMaxY % 2;
                if (a_mod != 0)
                {
                    m_RainfallMaxY++;
                }
                m_RainfallSepY = Convert.ToSingle(Math.Ceiling(m_RainfallMaxY / 5));
                a_mod = m_RainfallSepY % 2;
                if (a_mod != 0)
                {
                    m_RainfallSepY++;
                }
                a_mod = m_RainfallMaxY % m_RainfallSepY;
                if (a_mod != 0)
                {
                    m_RainfallMaxY = ((m_RainfallMaxY / m_RainfallSepY) + 1) * m_RainfallSepY;
                }
                 */
                //[2010.06.02]↑

                McGraphViewRainfall a_gw = new McGraphViewRainfall();

                a_gw.m_sep_bottom = 10;
                a_gw.m_sep_left = 30;   //[2010.03.07]
                a_gw.m_sep_right = 50;  //[2010.03.07]
                a_gw.m_sep_top = 10;

                /*
                float a_fTmp = (this.picRainfall.Height - (a_gw.m_sep_top + a_gw.m_sep_bottom)) / (m_RainfallMaxY - 0);
                if ((a_fTmp * m_RainfallSepY) < (a_gw.m_font1.Size * 2))
                {
                    m_RainfallSepY = Convert.ToInt32((a_gw.m_font1.Size * 2) / a_fTmp);
                    //m_WaterLevelSepY = 10;
                }
                else
                {
                    //m_WaterLevelSepY = 0;
                }
                 */

                a_gw.ImageWidth = this.picRainfall.Width;	// 出力グラフ画像の横サイズ（pixel）
                a_gw.ImageHeight = this.picRainfall.Height;	// 出力グラフ画像の縦サイズ（pixel）
                a_gw.GraphKind = enumGraphKind.IsTime;	// グラフ種別（1：日表、2：月表）
                //a_gw.GraphXSum = 24;	// グラフX軸のセパレート数
                //a_gw.OutImgaeFileName = "c:\\Inetpub\\wwwroot\\ObcDamTest\\test.png";	// 出力画像ファイル名（PNGのみサポート）
                a_gw.InvalidValue = McGraphViewDefine.g_InvalidValue;	// 欠測値
                a_gw.GraphMaxY = m_RainfallMaxY;	// グラフY軸の最大値
                a_gw.GraphMinY = m_RainfallMinY;	// グラフY軸の最小値
                a_gw.GraphSepY = m_RainfallSepY;	// グラフY軸のセパレート値
                //********** 速度改善他対応 2011.03.04 mod_s **************************************************
                //a_gw.GraphMaxX = m_X_Num;		// グラフX軸の最大値
                a_gw.GraphMaxX = iX_Num;		// グラフX軸の最大値
                //********** 速度改善他対応 2011.03.04 mod_e **************************************************
                a_gw.GraphMinX = 0F;		//[2010.03.07] グラフX軸の最小値
                a_gw.GraphSepX = 1;   //[2010.03.07]

                /*
                if (rdoByMinute.Checked == true)
                {   //分単位
                    a_gw.GraphSepX = 1;
                    //a_gw.GraphSepX = 6F;
                }
                else if (rdoByHour.Checked == true)
                {   //時間単位
                    a_gw.GraphSepX = 1;
                }
                 */
 
                a_gw.GraphXKind = enumXKind.IsTimeOrDay;	// X軸の種別（0：数値、1：時刻or日付）
                a_gw.GraphHasLegend = enumHasLegend.HasFalse;	// 凡例の表示・非表示
                a_gw.GraphYReverse = true;	// Y軸の反転

                a_gw.GraphHasMeasureX = false;   // X軸の目盛表示
                /*
                if (m_RainfallItems.Count > 0)
                {
                    a_gw.GraphHasMeasureX = true;   // X軸の目盛表示
                }
                else
                {
                    a_gw.GraphHasMeasureX = false;   // X軸の目盛表示
                }
                 **/
                a_gw.GraphMeasureXFormat = "0"; // X軸の目盛書式
                a_gw.GraphMeasureXKind = false; // X軸の目盛線

                a_gw.GraphHasMeasureY = true;   // Y軸の目盛表示
                /*
                if (m_RainfallItems.Count > 0)
                {
                    a_gw.GraphHasMeasureY = true;   // Y軸の目盛表示
                }
                else
                {
                    a_gw.GraphHasMeasureY = false;   // Y軸の目盛表示
                }
                 */
                a_gw.GraphMeasureYFormat = "0"; // Y軸の目盛書式
                a_gw.GraphMeasureYKind = false; // Y軸の目盛線

                int a_mode = 0;
                if (rdoByMinute.Checked == true)
                {   //分単位
                    a_mode = 0;
                }
                else if (rdoByHour.Checked == true)
                {   //時間単位
                    a_mode = 1;
                }
                a_gw.InitGraph(m_DtStart, m_DtEnd, a_mode);	//[2010.03.07] グラフの初期化

                if (m_RainfallItems != null)
                {
                    for (int a_iCnt = 0; a_iCnt < m_RainfallItems.Length; a_iCnt++)
                    {
                        a_gw.SetRainfallItems(m_RainfallItems[a_iCnt]);	// X,Y値のプロット
                    }
                }

                a_gw.DrawGraphBackGround();	// グラフの初期化

                this.picRainfall.Image = a_gw.m_bm;
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
            }
        }
        #endregion
        #region 水位描画
        /// <summary><para>method outline:</para>
        /// <para>水位描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_drawWaterLevel();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _drawWaterLevel()
        {
            try
            {
                m_WaterLevelMaxY = 5.0F;	// グラフY軸の最大値
                m_WaterLevelMinY = -5.0F;	// グラフY軸の最大値
                m_WaterLevelSepY = 1.0F;	// グラフY軸のセパレート値
                m_FlowMeterMaxY = 50.0F;	// グラフY軸の最大値
                m_FlowMeterMinY = 0.0F;	// グラフY軸の最大値

                // 断面
                m_DanmenListNum = 0;
                m_DanmenList = null;
                m_DanmenMaxY = 0;
                m_DanmenMinY = 0;

                foreach (string a_sVal in lbDanmen.SelectedItems)
                {
                    _readDanmenCSVFile(
                        m_Folder_Danmen + "\\" + a_sVal
                        );
                }

                // 水位
                //McGraphViewWaterLevelItems[] a_items = null;
                m_WaterLevelItems = null;

                int a_idx = 0;
                m_WaterLevelItems = new McGraphViewWaterLevelItems[clbWaterLevel.CheckedItems.Count];
                foreach (string a_sVal in clbWaterLevel.CheckedItems)
                {
                    m_WaterLevelItems[a_idx] = new McGraphViewWaterLevelItems();
                    m_WaterLevelItems[a_idx].FileName = a_sVal;

                    //凡例リストから色・線種を取得
                    string sLineStyle;
                    float fLineSize, fMarkSize;
                    bool bDrawLine, bDrawPoint;
                    m_WaterLevelItems[a_idx].LineColor = legendList1.GetLegend(Properties.HysAddinHydroHyetoGraphResources.WATER_LEVEL,  //水位
                        a_sVal, out sLineStyle, out fLineSize, out fMarkSize, out bDrawLine, out bDrawPoint);
                    m_WaterLevelItems[a_idx].LineStyle = legendList1.GetDashStyle(sLineStyle);
                    m_WaterLevelItems[a_idx].LineSize = fLineSize;
                    m_WaterLevelItems[a_idx].MarkSize = fMarkSize;
                    if (bDrawLine)  m_WaterLevelItems[a_idx].PlotKind = enumPlotKind.Line;
                    if (bDrawPoint) m_WaterLevelItems[a_idx].PlotForm = enumPlotForm.FillCircle;


                    //[2010.03.07]
                    for (int a_iCnt = 0; a_iCnt <= m_X_Num; a_iCnt++)
                    {
                        McGraphViewWaterLevelItem a_item = new McGraphViewWaterLevelItem();
                        if (rdoByMinute.Checked == true)
                        {   //分単位
                            a_item.sTimeOrDay = m_DtStart.AddMinutes(a_iCnt).ToString("yyyy/MM/dd HH:mm");
                            //a_item.sTimeOrDay = m_DtStart.AddMinutes(a_iCnt).ToString("yyyy/MM/dd HH:mm");
                            //a_item.sTimeOrDay = m_DtStart.AddMinutes(a_iCnt * 10).ToString("yyyy/MM/dd HH:mm");

                            //a_item.WaterLevel = McGraphViewDefine.g_InvalidValue2;   //[2010.06.02]
                        }
                        else if (rdoByHour.Checked == true)
                        {   //時間単位
                            a_item.sTimeOrDay = m_DtStart.AddHours(a_iCnt).ToString("yyyy/MM/dd HH:00");
                            //a_item.sTimeOrDay = m_DtStart.AddHours(a_iCnt).ToString("yyyy/MM/dd HH:00");

                            //a_item.WaterLevel = McGraphViewDefine.g_InvalidValue;   //[2010.06.02]
                        }
                        a_item.TimeOrDay = a_iCnt;
                        a_item.WaterLevel = McGraphViewDefine.g_InvalidValue2; //[2010.06.02]
                        //a_item.WaterLevel = McGraphViewDefine.g_InvalidValue; //[2010.06.02]
                        m_WaterLevelItems[a_idx].Add(a_item);	// Listに追加
                    }
                    _readWaterLevelCSVFile(
                        a_idx,  //[2010.05.07]
                        ref m_WaterLevelItems[a_idx],
                        m_Folder_WaterLevel + "\\" + a_sVal
                        );
                    a_idx++;
                }

                if (m_WaterLevelMaxY < m_DanmenMaxY)
                {
                    m_WaterLevelMaxY = m_DanmenMaxY;
                }
                if (m_WaterLevelMinY > m_DanmenMinY)
                {
                    m_WaterLevelMinY = m_DanmenMinY;
                }

                //[2010.03.07]
                //Y軸最大値
                if (McGraphViewDefine.g_WaterLevel_MaxY == McGraphViewDefine.g_InvalidValue)
                {
                    if (m_WaterLevelMaxY == McGraphViewDefine.g_InvalidValue)
                    {
                        m_WaterLevelMaxY = 5.0F;
                    }
                }
                else
                {
                    m_WaterLevelMaxY = McGraphViewDefine.g_WaterLevel_MaxY;
                }
                //Y軸最小値
                if (McGraphViewDefine.g_WaterLevel_MinY == McGraphViewDefine.g_InvalidValue)
                {
                    if (m_WaterLevelMinY == McGraphViewDefine.g_InvalidValue)
                    {
                        m_WaterLevelMinY = -5.0F;
                    }
                }
                else
                {
                    m_WaterLevelMinY = McGraphViewDefine.g_WaterLevel_MinY;
                }
                double a_dLen = Math.Ceiling(m_WaterLevelMaxY - m_WaterLevelMinY);
                int a_iLen = 0;
                if (a_dLen > 10)
                {
                    a_iLen = Convert.ToInt32(Math.Floor(a_dLen) / 10);
                    //int a_iLen = a_dLen.ToString().Length;
                    if ((a_iLen % 2) != 0)
                    {
                        a_iLen += (a_iLen % 2);
                    }
                }
                else
                {
                    a_iLen = 1;
                }
                m_WaterLevelSepY = a_iLen;

                if ((Math.Abs(m_WaterLevelMaxY) % m_WaterLevelSepY) != 0)
                {
                    m_WaterLevelMaxY += (m_WaterLevelSepY - (Math.Abs(m_WaterLevelMaxY) % m_WaterLevelSepY));
                }
                if ((Math.Abs(m_WaterLevelMinY) % m_WaterLevelSepY) != 0)
                {
                    m_WaterLevelMinY -= (m_WaterLevelSepY - (Math.Abs(m_WaterLevelMinY) % m_WaterLevelSepY));
                }

                /*
                double a_mod = m_WaterLevelMaxY % 1;
                //double a_mod = m_WaterLevelMaxY % 1;
                if (a_mod != 0)
                {
                    m_WaterLevelMaxY++;
                }
                m_WaterLevelSepY = Convert.ToSingle(Math.Ceiling(m_WaterLevelMaxY / 5));
                a_mod = m_WaterLevelSepY % 1;
                //a_mod = m_WaterLevelSepY % 2;
                if (a_mod != 0)
                {
                    m_WaterLevelSepY++;
                }
                a_mod = m_WaterLevelMaxY % m_WaterLevelSepY;
                if (a_mod != 0)
                {
                    m_WaterLevelMaxY = ((m_WaterLevelMaxY / m_WaterLevelSepY) + 1) * m_WaterLevelSepY;
                }
                */

                //m_WaterLevelSepY = 10;

                // 流量
                //McGraphViewFlowMeterItems[] a_items2 = null;
                m_FlowMeterItems = null;

                a_idx = 0;
                m_FlowMeterItems = new McGraphViewFlowMeterItems[clbFlowMeter.CheckedItems.Count];
                foreach (string a_sVal in clbFlowMeter.CheckedItems)
                {
                    m_FlowMeterItems[a_idx] = new McGraphViewFlowMeterItems();
                    m_FlowMeterItems[a_idx].FileName = a_sVal;

                    //凡例リストから色・線種を取得
                    string sLineStyle;
                    float fLineSize, fMarkSize;
                    bool bDrawLine, bDrawPoint;
                    m_FlowMeterItems[a_idx].LineColor = legendList1.GetLegend(Properties.HysAddinHydroHyetoGraphResources.DISCHARGE, a_sVal,    //流量
                        out sLineStyle, out fLineSize, out fMarkSize, out bDrawLine, out bDrawPoint);
                    m_FlowMeterItems[a_idx].LineStyle = legendList1.GetDashStyle(sLineStyle);
                    m_FlowMeterItems[a_idx].LineSize = fLineSize;
                    m_FlowMeterItems[a_idx].MarkSize = fMarkSize;
                    if (bDrawLine)  m_FlowMeterItems[a_idx].PlotKind = enumPlotKind.Line;
                    if (bDrawPoint) m_FlowMeterItems[a_idx].PlotForm = enumPlotForm.FillCircle;

                    for (int a_iCnt = 0; a_iCnt <= m_X_Num; a_iCnt++)
                    {
                        McGraphViewFlowMeterItem a_item2 = new McGraphViewFlowMeterItem();
                        if (rdoByMinute.Checked == true)
                        {   //分単位
                            a_item2.sTimeOrDay = m_DtStart.AddMinutes(a_iCnt).ToString("yyyy/MM/dd HH:mm");
                            //a_item2.sTimeOrDay = m_DtStart.AddMinutes(a_iCnt).ToString("yyyy/MM/dd HH:mm");
                            //a_item.sTimeOrDay = m_DtStart.AddMinutes(a_iCnt * 10).ToString("yyyy/MM/dd HH:mm");
                            
                            //a_item2.FlowMeter = McGraphViewDefine.g_InvalidValue2;  //[2010.06.02]
                        }
                        else if (rdoByHour.Checked == true)
                        {   //時間単位
                            a_item2.sTimeOrDay = m_DtStart.AddHours(a_iCnt).ToString("yyyy/MM/dd HH:00");
                            //a_item2.sTimeOrDay = m_DtStart.AddHours(a_iCnt).ToString("yyyy/MM/dd HH:00");
                            
                            //a_item2.FlowMeter = McGraphViewDefine.g_InvalidValue;   //[2010.06.02]
                        }
                        a_item2.TimeOrDay = a_iCnt;
                        a_item2.FlowMeter = McGraphViewDefine.g_InvalidValue2; //[2010.06.02]
                        //a_item2.FlowMeter = McGraphViewDefine.g_InvalidValue; //[2010.06.02]
                        m_FlowMeterItems[a_idx].Add(a_item2);	// Listに追加
                    }
                    _readFlowMeterCSVFile(
                        a_idx,  //[2010.05.07]
                        ref m_FlowMeterItems[a_idx],
                        m_Folder_FlowMeter + "\\" + a_sVal
                        );
                    a_idx++;
                }

                McGraphViewWaterLevel a_gw = new McGraphViewWaterLevel();

                //a_gw.m_sep_bottom = 0;
                a_gw.m_sep_left = 30;   //[2010.03.07]
                a_gw.m_sep_right = 50;  //[2010.03.07]
                a_gw.m_sep_top = 10;

                //m_WaterLevelMaxY = 100;
                //m_WaterLevelMinY = 0;
                //m_WaterLevelSepY = 1;

                /*
                float a_fTmp = (this.picWaterLevel.Height - (a_gw.m_sep_top + a_gw.m_sep_bottom)) / (m_WaterLevelMaxY - m_WaterLevelMinY);
                if ((a_fTmp * m_WaterLevelSepY) < (a_gw.m_font1.Size*2))
                {
                    m_WaterLevelSepY = Convert.ToInt32((a_gw.m_font1.Size * 2) / a_fTmp);
                }
                else
                {
                }
                 */ 

                a_gw.ImageWidth = this.picWaterLevel.Width;	// 出力グラフ画像の横サイズ（pixel）
                a_gw.ImageHeight = this.picWaterLevel.Height;	// 出力グラフ画像の縦サイズ（pixel）
                a_gw.GraphKind = enumGraphKind.IsTime;	// グラフ種別（1：日表、2：月表）
                //a_gw.GraphXSum = 24;	// グラフX軸のセパレート数
                //a_gw.OutImgaeFileName = "c:\\Inetpub\\wwwroot\\ObcDamTest\\test.png";	// 出力画像ファイル名（PNGのみサポート）
                a_gw.InvalidValue = McGraphViewDefine.g_InvalidValue;	// 欠測値
                a_gw.GraphMaxY = m_WaterLevelMaxY;	// グラフY軸の最大値
                a_gw.GraphMinY = m_WaterLevelMinY;	// グラフY軸の最小値
                a_gw.GraphSepY = m_WaterLevelSepY;	// グラフY軸のセパレート値
                a_gw.GraphMaxX = m_X_Num;		// グラフX軸の最大値
                a_gw.GraphMinX = 0F;		//[2010.03.07] グラフX軸の最小値
                a_gw.GraphSepX = 1;       //[2010.03.07]

                /*
                if (rdoByMinute.Checked == true)
                {   //分単位
                    a_gw.GraphSepX = 1;
                    //a_gw.GraphSepX = 6F;
                }
                else if (rdoByHour.Checked == true)
                {   //時間単位
                    a_gw.GraphSepX = 1;
                }
                 */
                a_gw.GraphXKind = enumXKind.IsTimeOrDay;	// X軸の種別（0：数値、1：時刻or日付）
                a_gw.GraphHasLegend = enumHasLegend.HasFalse;	// 凡例の表示・非表示
                a_gw.GraphYReverse = false;	// Y軸の反転
                a_gw.StartTime = m_DtStart; //[2010.03.07]

                a_gw.GraphHasMeasureX = false;   // X軸の目盛表示
                /*
                if (m_WaterLevelItems.Count > 0)
                {
                    a_gw.GraphHasMeasureX = true;   // X軸の目盛表示
                }
                else
                {
                    a_gw.GraphHasMeasureX = false;   // X軸の目盛表示
                }
                 */
                a_gw.GraphMeasureXFormat = "0"; // X軸の目盛書式
                a_gw.GraphMeasureXKind = false; // X軸の目盛線

                a_gw.GraphHasMeasureY = true;   // Y軸の目盛表示
                /*
                if (m_WaterLevelItems.Count > 0)
                {
                    a_gw.GraphHasMeasureY = true;   // Y軸の目盛表示
                }
                else
                {
                    a_gw.GraphHasMeasureY = false;   // Y軸の目盛表示
                }
                 */ 
                a_gw.GraphMeasureYFormat = "0"; // Y軸の目盛書式
                a_gw.GraphMeasureYKind = false; // Y軸の目盛線

                int a_mode = 0;
                if (rdoByMinute.Checked == true)
                {   //分単位
                    a_mode = 0;
                }
                else if (rdoByHour.Checked == true)
                {   //時間単位
                    a_mode = 1;
                }

                //[2010.03.07]
                //Y軸最大値
                if (McGraphViewDefine.g_FlowMeter_MaxY == McGraphViewDefine.g_InvalidValue)
                {
                    /*
                    if (m_FlowMeterMaxY == McGraphViewDefine.g_InvalidValue)
                    {
                        m_FlowMeterMaxY = 5.0F;
                    }
                     */ 
                }
                else
                {
                    m_FlowMeterMaxY = McGraphViewDefine.g_FlowMeter_MaxY;
                }
                //Y軸最小値
                if (McGraphViewDefine.g_FlowMeter_MinY == McGraphViewDefine.g_InvalidValue)
                {
                    /*
                    if (m_FlowMeterMinY == McGraphViewDefine.g_InvalidValue)
                    {
                        m_FlowMeterMinY = -5.0F;
                    }
                     */ 
                }
                else
                {
                    m_FlowMeterMinY = McGraphViewDefine.g_FlowMeter_MinY;
                }
                a_gw.InitGraph(m_DtStart, m_DtEnd, a_mode, ref m_FlowMeterMinY, ref m_FlowMeterMaxY);	//[2010.03.07] グラフの初期化
                /*
                // 水面の描画
                a_gw.DrawWaterSection(Color.Aquamarine, 4.5);

                // 断面の描画
                float[,] a_dList = new float[5, 2];
                a_dList[0, 0] = 0;
                a_dList[0, 1] = 4.8F;
                a_dList[1, 0] = 1;
                a_dList[1, 1] = 2.8F;
                a_dList[2, 0] = 2;
                a_dList[2, 1] = 1.8F;
                a_dList[3, 0] = 3;
                a_dList[3, 1] = 3.8F;
                a_dList[4, 0] = 4;
                a_dList[4, 1] = 4.8F;

                a_gw.DrawCrossSection(Color.LightSalmon, "", 5, a_dList);
                */

                // 断面の描画
                a_gw.DrawCrossSection(
                    Color.Wheat,
                    "",
                    m_DanmenListNum,
                    m_DanmenList,
                    m_DanmenMinX,
                    m_DanmenMaxX
                    );
                //a_gw.DrawCrossSection(Color.LightSalmon, "", m_DanmenListNum, m_DanmenList);

                a_gw.DrawGraphBackGround();	// グラフの初期化

                //基準水位の描画
		        Pen a_pen = new Pen(Color.Black,1.5F);
		        SolidBrush a_brush = new SolidBrush(Color.Black);
                //float a_pyv = 0;
                Font a_font = new Font(Properties.HysAddinHydroHyetoGraphResources.DEFAULT_FONT_NAME,
                    float.Parse(Properties.HysAddinHydroHyetoGraphResources.DEFAULT_FONT_SIZE));
                for (int a_iCnt = 0; a_iCnt < m_BaseWaterLevelNum; a_iCnt++)
                {
                    a_gw.PlotGraphValue(
                        a_pen,
                        a_brush,
                        0,
                        m_fBaseWaterLevel[a_iCnt],
                        m_X_Num,
                        ref m_fBaseWaterLevel[a_iCnt],
                        enumPlotKind.Line,
                        enumPlotForm.Nothing
                        );

                    float a_x = 0;
                    if ((a_iCnt % 2) == 0)
                    {
                        a_x = a_gw.m_sep_left + 4;
                    }
                    else
                    {
                        a_x = a_gw.ImageWidth - a_gw.m_sep_right - 120;
                    }
                    a_gw.m_g.DrawString(
                        Properties.HysAddinHydroHyetoGraphResources.SYMBOL_WATER_LEVEL + m_sBaseWaterLevel[a_iCnt],
                        a_font,
                        Brushes.Black,
                        new PointF(a_x, a_gw.ImageHeight - (a_gw.m_sep_bottom + ((m_fBaseWaterLevel[a_iCnt] - a_gw.m_min_y_val) * a_gw.m_sep_y_graph)) - 12)
                        );
                }

                //水位の描画
                if (m_WaterLevelItems != null)
                {
                    for (int a_iCnt = 0; a_iCnt < m_WaterLevelItems.Length; a_iCnt++)
                    {
                        a_gw.SetWaterLevelItems(m_WaterLevelItems[a_iCnt]);	// X,Y値のプロット
                    }
                }

                //流量の描画
                if (m_FlowMeterItems != null)
                {
                    //a_gw.GraphMaxY = m_FlowMeterMaxY;	// グラフY軸の最大値
                    //a_gw.GraphMinY = m_FlowMeterMinY;	// グラフY軸の最小値
                    //a_gw.InitializeSeparate();

                    for (int a_iCnt = 0; a_iCnt < m_FlowMeterItems.Length; a_iCnt++)
                    {
                        a_gw.SetFlowMeterItems(m_FlowMeterItems[a_iCnt]);	// X,Y値のプロット
                    }
                }

                this.picWaterLevel.Image = a_gw.m_bm;
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
            }
        }
        #endregion
        
        #region 再描画
        /// <summary><para>method outline:</para>
        /// <para>再描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_redraw(h_hour_st,h_minute_st,h_hour_ed,h_minute_ed);</para>
        /// </example>
        /// <param name="h_hour_st">表示開始時刻（時間）</param>
        /// <param name="h_minute_st">表示開始時刻（分）</param>
        /// <param name="h_hour_ed">表示終了時刻（時間）</param>
        /// <param name="h_minute_ed">表示終了時刻（分）</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _redraw(
            int h_hour_st,
            int h_minute_st,
            int h_hour_ed,
            int h_minute_ed
            )
        {
            Cursor a_preCursor = Cursor.Current;

            try
            {
                Cursor.Current = Cursors.WaitCursor;

                m_DtStart = new DateTime(
                    dtpStart.Value.Year,
                    dtpStart.Value.Month,
                    dtpStart.Value.Day,
                    h_hour_st,  //Convert.ToInt32(cmbHourStart.SelectedValue),
                    h_minute_st,  //Convert.ToInt32(cmbMinuteStart.SelectedValue),
                    0
                    );
                m_DtEnd = new DateTime(
                    dtpEnd.Value.Year,
                    dtpEnd.Value.Month,
                    dtpEnd.Value.Day,
                    h_hour_ed, //Convert.ToInt32(cmbHourEnd.SelectedValue),
                    h_minute_ed,  //Convert.ToInt32(cmbMinuteEnd.SelectedValue),
                    0
                    );

                TimeSpan a_ts = m_DtEnd - m_DtStart;

                if (rdoByMinute.Checked == true)
                {   //分単位
                    m_X_Num = (Convert.ToInt32(a_ts.TotalMinutes));
                }
                else if (rdoByHour.Checked == true)
                {   //時間単位
                    m_X_Num = (Convert.ToInt32(a_ts.TotalHours));
                }

                //[2010.03.07]日時範囲の計算
                /*
                TimeSpan a_tTmp = m_DtEnd - m_DtStart;
                if (a_tTmp.Days < 7)
                {   //1週間以内
                    if (m_DtEnd.Day > m_DtStart.Day)
                    {   //日付が異なる
                        //2日分とする。
                        m_X_Num = 24 * (a_tTmp.Days + 1);
                        switch (a_tTmp.Days)
                        {
                            case 1:
                                m_X_Sep = 2;
                                break;
                            case 2:
                                m_X_Sep = 2;
                                break;
                            case 3:
                                m_X_Sep = 4;
                                break;
                            case 4:
                                m_X_Sep = 4;
                                break;
                            case 5:
                                m_X_Sep = 4;
                                break;
                            case 6:
                                m_X_Sep = 6;
                                break;
                            //case 7:
                            //    m_X_Sep = 6;
                            //    break;
                        }
                    }
                    else
                    {   //日付が同じ
                        //該当日分とする。
                        m_X_Num = 24;
                        m_X_Sep = 1;
                    }
                }
                else if(a_tTmp.Days < 31)
                {   //1週間～１ヶ月以内
                    m_X_Num = 24 * (a_tTmp.Days + 1);
                    if (a_tTmp.Days == 7)
                    {
                        m_X_Sep = 8;
                    }else if((a_tTmp.Days>=8) && (a_tTmp.Days<=15)){
                            m_X_Sep = 12;
                    }else if((a_tTmp.Days>=16) && (a_tTmp.Days<=30)){
                        m_X_Sep = 24;
                    }
                }
                else if (a_tTmp.Days < 366)
                {   //1ヶ月から1年以内
                    m_X_Num = 24 * (a_tTmp.Days + 1);
                    if (a_tTmp.Days == 31)
                    {
                        m_X_Sep = 24;
                    }
                    else if ((a_tTmp.Days >= 16) && (a_tTmp.Days <= 365))
                    {
                        m_X_Sep = 24 * 30;
                    }
                }
                else
                {   //1年越え
                    m_X_Num = 24 * (a_tTmp.Days + 1);
                    m_X_Sep = 24 * 366;
                }

                m_DtStart2 = new DateTime(
                    dtpStart.Value.Year,
                    dtpStart.Value.Month,
                    dtpStart.Value.Day,
                    0,
                    0,
                    0
                    );
                m_DtEnd2 = new DateTime(
                    dtpEnd.Value.Year,
                    dtpEnd.Value.Month,
                    dtpEnd.Value.Day,
                    23,
                    59,
                    0
                    );
                if (rdoByMinute.Checked == true)
                {   //分単位
                    m_X_Num *= 60;
                    m_X_Sep *= 60;
                }
                else if (rdoByHour.Checked == true)
                {   //時間単位
                }
                */

                _drawRainfall();
                _drawWaterLevel();
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
            }
            finally
            {
                Cursor.Current = a_preCursor;
            }
        }
        #endregion
        
        #region 開始・終了時刻再設定
        /// <summary><para>method outline:</para>
        /// <para>開始・終了時刻再設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_getTimeStampAll();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _getTimeStampAll()
        {
            String a_sStart = "";
            String a_sEnd = "";
            //String a_sStart = m_DtStart.ToString("yyyy/MM/dd HH:mm");
            //String a_sEnd = m_DtEnd.ToString("yyyy/MM/dd HH:mm");

            String a_sTmp = "";
            String a_sTmp1 = "";
            String a_sTmp2 = "";
            String a_sTmp3 = "";

            //雨量の開始・終了時刻を取得
            foreach (string a_sVal in lbRainfall.SelectedItems)
            {
                _getTimeStampParts(
                    ref a_sStart,
                    ref a_sEnd,
                    m_Folder_Rainfall + "\\" + a_sVal
                    );
            }

            //水位の開始・終了時刻を取得
            foreach (string a_sVal in clbWaterLevel.CheckedItems)
            {
                _getTimeStampParts(
                    ref a_sStart,
                    ref a_sEnd,
                    m_Folder_WaterLevel + "\\" + a_sVal
                    );
            }

            //流量の開始・終了時刻を取得
            foreach (string a_sVal in clbFlowMeter.CheckedItems)
            {
                _getTimeStampParts(
                    ref a_sStart,
                    ref a_sEnd,
                    m_Folder_FlowMeter + "\\" + a_sVal
                    );
            }

            if (a_sStart.Length > 0)
            {
                a_sTmp = DateTime.Parse(a_sStart).ToString("yyyy/MM/dd HH:mm");
                a_sTmp1 = DateTime.Parse(a_sStart).ToString("yyyy/MM/dd");
                a_sTmp2 = DateTime.Parse(a_sStart).ToString("HH");
                a_sTmp3 = DateTime.Parse(a_sStart).ToString("mm");

                dtpStart.Text = a_sTmp1;
                cmbHourStart.Text = a_sTmp2;
                cmbMinuteStart.Text = a_sTmp3;
            }

            if (a_sEnd.Length > 0)
            {
                a_sTmp = DateTime.Parse(a_sEnd).ToString("yyyy/MM/dd HH:mm");
                a_sTmp1 = DateTime.Parse(a_sEnd).ToString("yyyy/MM/dd");
                a_sTmp2 = DateTime.Parse(a_sEnd).ToString("HH");
                a_sTmp3 = DateTime.Parse(a_sEnd).ToString("mm");

                dtpEnd.Text = a_sTmp1;
                cmbHourEnd.Text = a_sTmp2;
                cmbMinuteEnd.Text = a_sTmp3;
            }
        }
        #endregion
        #region 開始・終了時刻再設定
        /// <summary><para>method outline:</para>
        /// <para>開始・終了時刻再設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_getTimeStampParts(h_sStart,h_sEnd,h_fname);</para>
        /// </example>
        /// <param name="h_sStart">開始時刻</param>
        /// <param name="h_sEnd">終了時刻</param>
        /// <param name="h_fname">ファイル名</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _getTimeStampParts(
            ref String h_sStart,
            ref String h_sEnd,
            String h_fname
            )
        {
            Boolean a_IsFirst = false;

            String a_sStart = "";
            String a_sEnd = "";

            if (h_sStart.Length > 0)
            {
                a_sStart = DateTime.Parse(h_sStart).ToString("yyyy/MM/dd HH:mm");
            }
            if (h_sEnd.Length > 0)
            {
                a_sEnd = DateTime.Parse(h_sEnd).ToString("yyyy/MM/dd HH:mm");
            }

            //String a_sStart = m_DtStart.ToString("yyyy/MM/dd HH:mm");
            //String a_sEnd = m_DtEnd.ToString("yyyy/MM/dd HH:mm");

            using (StreamReader a_sr = new StreamReader(h_fname, System.Text.Encoding.GetEncoding(932)))
            {
                String a_delimStr = ",";
                Char[] a_delimiter = a_delimStr.ToCharArray();
                String[] a_split;
                String a_sLine = null;
                String a_sTmp = "";
                //String a_sTmp1 = "";
                //String a_sTmp2 = "";
                //String a_sTmp3 = "";

                //3行目までは、ヘッダ部の為、読み飛ばす。
                a_sLine = a_sr.ReadLine();
                a_sLine = a_sr.ReadLine();
                a_sLine = a_sr.ReadLine();

                a_IsFirst = true;  
                while ((a_sLine = a_sr.ReadLine()) != null)
                {
                    //m_RainfallMaxX++;
                    a_split = a_sLine.Split(a_delimiter);

                    a_sTmp = DateTime.Parse(a_split[0]).ToString("yyyy/MM/dd HH:mm");
                    //a_sTmp1 = DateTime.Parse(a_split[0]).ToString("yyyy/MM/dd");
                    //a_sTmp2 = DateTime.Parse(a_split[0]).ToString("HH");
                    //a_sTmp3 = DateTime.Parse(a_split[0]).ToString("mm");

                    //開始時刻
                    if (a_IsFirst == true)
                    {
                        if (h_sStart.Length == 0)
                        {
                            h_sStart = a_split[0];
                        }
                        else
                        {
                            if (a_sTmp.CompareTo(a_sStart) < 0)
                            {
                                h_sStart = a_sTmp;
                            }
                        }
                        a_IsFirst = false;
                    }

                    //終了時刻
                    if (h_sEnd.Length == 0)
                    {
                        h_sEnd = a_split[0];
                        a_sEnd = DateTime.Parse(h_sEnd).ToString("yyyy/MM/dd HH:mm");
                    }
                    else
                    {
                        if (a_sTmp.CompareTo(a_sEnd) > 0)
                        {
                            h_sEnd = a_sTmp;
                            a_sEnd = DateTime.Parse(h_sEnd).ToString("yyyy/MM/dd HH:mm");
                        }
                    }
                }
            }
        }
        #endregion
        
        #endregion

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McGraphViewDotNetForm csNewProjectForm = new McGraphViewDotNetForm();</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>使用禁止</para>
        /// </remarks>
        protected McGraphViewDotNetForm()
        {
            InitializeComponent();
        }
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McGraphViewDotNetForm csNewProjectForm = new McGraphViewDotNetForm(csScreen);</para>
        /// </example>
        /// <param name="csScreen">スクリーンクラス</param>
        /// <returns>McDotNetNewProjectForm 生成されたインスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McGraphViewDotNetForm(HySScreen csScreen)
        {
            InitializeComponent();
            m_csScreen = csScreen;
            m_csGraphViewScreen = csScreen as McGraphViewDotNetScreen; // 便利の為

            //凡例の色･線種変更時イベント割付
            legendList1.LegendStyleChanged += new EventHandler(legendList1_LegendStyleChanged);
        }

        /// <summary><para>method outline:</para>
        /// <para>フォームを閉じた時の処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McGraphViewDotNetForm_FormClosed( sender, e )：フォームを閉じた時のイベント処理</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void McGraphViewDotNetForm_FormClosed(object sender, FormClosedEventArgs e)
        {
            m_csGraphViewScreen.CloseScreen();  //⇒★[2010.01.29]
        }

        /// <summary><para>method outline:</para>
        /// <para>フォームを閉じようとした時の処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McGraphViewDotNetForm_FormClosing( sender, e )：フォームが閉じようとしたときのイベント処理</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void McGraphViewDotNetForm_FormClosing(object sender, FormClosingEventArgs e)
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>フォームロード</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McGraphViewDotNetForm_Load( sender, e )：フォームがロードされたときのイベント</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void McGraphViewDotNetForm_Load(object sender, EventArgs e)
        {
            cmbHourStart.SelectedIndex = 0;
            cmbHourEnd.SelectedIndex = 23;
            cmbMinuteStart.SelectedIndex = 0;
            cmbMinuteEnd.SelectedIndex = 00;

            cmbTargetData.SelectedIndex = 0;

            _redraw(0,0,23,0);

        }

        /// <summary><para>method outline:</para>
        /// <para>雨量フォルダ選択</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> btnFolder_Rainfall_Click( sender, e )：（雨量フォルダ選択ボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void btnFolder_Rainfall_Click(object sender, EventArgs e)
        {
            _selectFolder(ref m_Folder_Rainfall, txtFolder_Rainfall);
            _setFileListBoxByFolder(m_Folder_Rainfall, lbRainfall);

            //凡例から削除
            legendList1.DelGroupList(Properties.HysAddinHydroHyetoGraphResources.PRECIPITATION);   //雨量
        }
        /// <summary><para>method outline:</para>
        /// <para>水位フォルダ選択</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> btnFolder_WaterLevel_Click( sender, e )：（水位フォルダ選択ボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void btnFolder_WaterLevel_Click(object sender, EventArgs e)
        {
            _selectFolder(ref m_Folder_WaterLevel, txtFolder_WaterLevel);
            _setFileCheckListBoxByFolder(m_Folder_WaterLevel, clbWaterLevel);

            //凡例から削除
            legendList1.DelGroupList(Properties.HysAddinHydroHyetoGraphResources.WATER_LEVEL);   //水位
        }
        /// <summary><para>method outline:</para>
        /// <para>流量フォルダ選択</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> btnFloder_FlowMeter_Click( sender, e )：（流量フォルダ選択ボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void btnFloder_FlowMeter_Click(object sender, EventArgs e)
        {
            _selectFolder(ref m_Folder_FlowMeter, txtFolder_FlowMeter);
            _setFileCheckListBoxByFolder(m_Folder_FlowMeter, clbFlowMeter);

            //凡例から削除
            legendList1.DelGroupList(Properties.HysAddinHydroHyetoGraphResources.DISCHARGE);   //流量
        }
        /// <summary><para>method outline:</para>
        /// <para>断面フォルダ選択</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> btnFolder_Danmen_Click( sender, e )：（断面フォルダ選択ボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void btnFolder_Danmen_Click(object sender, EventArgs e)
        {
            _selectFolder(ref m_Folder_Danmen, txtFolder_Danmen);
            _setFileListBoxByFolder(m_Folder_Danmen, lbDanmen);
        }

        /// <summary><para>method outline:</para>
        /// <para>表示対象コンボボックス変更時</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> cmbTargetData_SelectedIndexChanged( sender, e )：表示対象コンボボックス変更時のイベント</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void cmbTargetData_SelectedIndexChanged(object sender, EventArgs e)
        {
            try
            {
                lbRainfall.Visible = false;
                clbWaterLevel.Visible = false;
                clbFlowMeter.Visible = false;
                lbDanmen.Visible = false;

                switch (cmbTargetData.SelectedIndex)
                {
                    case 0:     //雨量データ
                        lbRainfall.Visible = true;
                        break;
                    case 1:     //水位データ
                        clbWaterLevel.Visible = true;
                        break;
                    case 2:     //流量データ
                        clbFlowMeter.Visible = true;
                        break;
                    case 3:     //断面データ
                        lbDanmen.Visible = true;
                        break;
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>水位データファイル選択変更時</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> clbWaterLevel_SelectedIndexChanged( sender, e )：水位データチェック変更時のイベント</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void clbWaterLevel_SelectedIndexChanged(object sender, EventArgs e)
        {
            //選択ファイルを凡例一覧に追加
            string sGroup = Properties.HysAddinHydroHyetoGraphResources.WATER_LEVEL; //水位
            for (int i = 0; i < clbWaterLevel.Items.Count; i++)
            {
                string sFileName = clbWaterLevel.Items[i].ToString();
                if (clbWaterLevel.CheckedIndices.Contains(i))
                {   //選択されている場合、凡例に追加
                    legendList1.AddList(sGroup, sFileName);
                }
                else
                {   //選択されていない場合、凡例から削除
                    legendList1.DelList(sGroup, sFileName);
                }
            }

            //[2010.03.22]ファイルの内容から開始・終了時刻を再設定する。
            //[2010.06.03]
            if (m_IsAutoFit == true)
            {
                _getTimeStampAll();
            }
            _redraw(
                Convert.ToInt32(cmbHourStart.SelectedItem),
                Convert.ToInt32(cmbMinuteStart.SelectedItem),
                Convert.ToInt32(cmbHourEnd.SelectedItem),
                Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                );
            //_drawWaterLevel();
        }

        /// <summary><para>method outline:</para>
        /// <para>流量データファイル選択変更時</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> clbFlowMeter_SelectedIndexChanged( sender, e )：流量データチェック変更時のイベント</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void clbFlowMeter_SelectedIndexChanged(object sender, EventArgs e)
        {
            //選択ファイルを凡例一覧に追加
            string sGroup = Properties.HysAddinHydroHyetoGraphResources.DISCHARGE; //流量
            for (int i = 0; i < clbFlowMeter.Items.Count; i++)
            {
                string sFileName = clbFlowMeter.Items[i].ToString();
                if (clbFlowMeter.CheckedIndices.Contains(i))
                {   //選択されている場合、凡例に追加
                    legendList1.AddList(sGroup, sFileName);
                }
                else
                {   //選択されていない場合、凡例から削除
                    legendList1.DelList(sGroup, sFileName);
                }
            }

            //[2010.03.22]ファイルの内容から開始・終了時刻を再設定する。
            //[2010.06.03]
            if (m_IsAutoFit == true)
            {
                _getTimeStampAll();
            }
            _redraw(
                Convert.ToInt32(cmbHourStart.SelectedItem),
                Convert.ToInt32(cmbMinuteStart.SelectedItem),
                Convert.ToInt32(cmbHourEnd.SelectedItem),
                Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                );
            //_drawWaterLevel();
        }

        /// <summary><para>method outline:</para>
        /// <para>雨量データファイル選択変更時</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> lbRainfall_SelectedIndexChanged( sender, e )：雨量データ選択変更時のイベント</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void lbRainfall_SelectedIndexChanged(object sender, EventArgs e)
        {
            //選択ファイルを凡例一覧に追加
            string sGroup = Properties.HysAddinHydroHyetoGraphResources.PRECIPITATION; //雨量
            for (int i = 0; i < lbRainfall.Items.Count; i++)
            {
                string sFileName = lbRainfall.Items[i].ToString();
                if (i == lbRainfall.SelectedIndex)
                {   //選択されている場合、凡例に追加
                    legendList1.AddList(sGroup, sFileName);
                }
                else
                {   //選択されていない場合、凡例から削除
                    legendList1.DelList(sGroup, sFileName);
                }
            }

            //[2010.03.22]ファイルの内容から開始・終了時刻を再設定する。
            //[2010.06.03]
            if (m_IsAutoFit == true)
            {
                _getTimeStampAll();
            }
            _redraw(
                Convert.ToInt32(cmbHourStart.SelectedItem),
                Convert.ToInt32(cmbMinuteStart.SelectedItem),
                Convert.ToInt32(cmbHourEnd.SelectedItem),
                Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                );
            //_drawRainfall();
        }

        /// <summary><para>method outline:</para>
        /// <para>断面データファイル選択変更時</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> lbDanmen_SelectedIndexChanged( sender, e )：断面データ選択変更時のイベント</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void lbDanmen_SelectedIndexChanged(object sender, EventArgs e)
        {
            _drawWaterLevel();
        }

        /// <summary><para>method outline:</para>
        /// <para>凡例の色･線種変更時</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> legendList1_LegendStyleChanged( sender, e )：凡例の変更フォームのOKボタンを押す</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void legendList1_LegendStyleChanged(object sender, EventArgs e)
        {
            if (m_IsAutoFit == true)
            {
                _getTimeStampAll();
            }
            _redraw(
                Convert.ToInt32(cmbHourStart.SelectedItem),
                Convert.ToInt32(cmbMinuteStart.SelectedItem),
                Convert.ToInt32(cmbHourEnd.SelectedItem),
                Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                );
        }

        /// <summary><para>method outline:</para>
        /// <para>再描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> btnRedraw_Click( sender, e )：（再描画ボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void btnRedraw_Click(object sender, EventArgs e)
        {
            m_IsAutoFit = false;    //[2010.06.03]
            _redraw(
                Convert.ToInt32(cmbHourStart.SelectedItem),
                Convert.ToInt32(cmbMinuteStart.SelectedItem),
                Convert.ToInt32(cmbHourEnd.SelectedItem),
                Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                );
        }

        /// <summary><para>method outline:</para>
        /// <para>グラフ設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> btnSetGraph_Click( sender, e )：（グラフ設定ボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void btnSetGraph_Click(object sender, EventArgs e)
        {
            McGraphSetForm a_frm = null;

            try
            {
                a_frm = new McGraphSetForm();
                a_frm.AxisLabelHyeto = labelAxisRain.Text;
                a_frm.AxisLabelHydroLeft = labelAxisLevel.Text;
                a_frm.AxisLabelHydroRight = labelAxisFlow.Text;
                a_frm.AxisRateHydroLeft = m_WaterLevelRateY;
                a_frm.AxisRateHydroRight = m_FlowMeterRateY;

                if (a_frm.ShowDialog(this) == DialogResult.OK)
                {
                    labelAxisRain.Text = a_frm.AxisLabelHyeto;
                    labelAxisLevel.Text = a_frm.AxisLabelHydroLeft;
                    labelAxisFlow.Text = a_frm.AxisLabelHydroRight;
                    m_WaterLevelRateY = a_frm.AxisRateHydroLeft;
                    m_FlowMeterRateY = a_frm.AxisRateHydroRight;
                }
            }
            catch (Exception exp)
            {
                Console.Write(exp.Message);
            }
            finally
            {
                if (a_frm != null)
                    a_frm.Dispose();
                a_frm = null;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>描画リセット</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> btnResetDraw_Click( sender, e )：（リセットボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void btnResetDraw_Click(object sender, EventArgs e)
        {
            //[2010.06.03]ファイルの内容から開始・終了時刻を再設定する。
            m_IsAutoFit = true;
            _getTimeStampAll();
            _redraw(
                Convert.ToInt32(cmbHourStart.SelectedItem),
                Convert.ToInt32(cmbMinuteStart.SelectedItem),
                Convert.ToInt32(cmbHourEnd.SelectedItem),
                Convert.ToInt32(cmbMinuteEnd.SelectedItem)
                );
            //_drawRainfall();
        }
// start of 印刷機能追加
        /// <summary><para>method outline:</para>
        /// <para>取得領域ビットマップ化処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Bitmap btmp = CaptureControl( ctrl )</para>
        /// </example>
        /// <param name="ctrl">ウインドウ部品（コントロール）</param>
        /// <returns>Bitmap : 取得領域内の画像</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public Bitmap CaptureControl(Control ctrl)
        {
            Graphics g = ctrl.CreateGraphics();
            //ctrl（panel）の大きさのBitmapを生成
            Bitmap b_img = new Bitmap(ctrl.ClientRectangle.Width, ctrl.ClientRectangle.Height, g);
            Graphics memg = Graphics.FromImage(b_img);
            //BitBltの引数の用意
            IntPtr dc1 = g.GetHdc();
            IntPtr dc2 = memg.GetHdc();
            const int SRCCOPY = 0xCC0020;
            //Bitmap取得
            BitBlt(dc2, 0, 0, b_img.Width, b_img.Height, dc1, 0, 0, SRCCOPY);
            //解放処理
            g.ReleaseHdc(dc1);
            memg.ReleaseHdc(dc2);
            memg.Dispose();
            g.Dispose();
            return b_img;
        }

        /// <summary><para>method outline:</para>
        /// <para>プリントイベント処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> pd_PrintPage += new System.Drawing.Printing.PrintPageEventHandler(pd_PrintPage)</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">プリントイベント(PrintPageEvent)</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void pd_PrintPage(object sender, System.Drawing.Printing.PrintPageEventArgs e)
        {
            //画像を描画する
            //********** 速度改善他対応 2011.03.04 mod_s **************************************************
            //e.Graphics.DrawImage(m_bit_img, 0, 0);
            e.Graphics.DrawImage(m_bit_img, 60, 60);
            //********** 速度改善他対応 2011.03.04 mod_s **************************************************
            //印刷の次のページがないこと
            e.HasMorePages = false;
            
        }

        /// <summary><para>method outline:</para>
        /// <para>印刷処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> print_button_Click( sender, e )：（印刷ボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void print_button_Click(object sender, EventArgs e)
        {
            //印刷用ビットマップの取得
            //********** 速度改善他対応 2011.03.04 mod_s **************************************************
            //m_bit_img = (CaptureControl(panel1));
            m_bit_img = CreateGraphForPrint();
            //********** 速度改善他対応 2011.03.04 mod_e **************************************************

            //プリントドキュメントの生成
            m_pd = new System.Drawing.Printing.PrintDocument();

            //PrintPageイベントハンドラの追加
            m_pd.PrintPage +=
                new System.Drawing.Printing.PrintPageEventHandler(pd_PrintPage);

            //プリントダイアログの生成
            PrintDialog pdlg = new PrintDialog();
            pdlg.UseEXDialog = true;
            //PrintDocumentを指定
            pdlg.Document = m_pd;
            //印刷の選択ダイアログを表示する
            if (pdlg.ShowDialog() == DialogResult.OK)
            {
                //********** 速度改善他対応 2011.03.04 add_s **************************************************
                //プリンター設定
                m_pd.PrinterSettings = pdlg.PrinterSettings;

                //ページ設定
                foreach (System.Drawing.Printing.PaperSize ps in m_pd.PrinterSettings.PaperSizes)
                {
                    if (ps.Kind == System.Drawing.Printing.PaperKind.A4)
                    {
                        m_pd.DefaultPageSettings.PaperSize = ps;
                        m_pd.DefaultPageSettings.Landscape = true;    //横
                        break;
                    }
                }
                //********** 速度改善他対応 2011.03.04 add_s **************************************************

                //OKがクリックされた時は印刷する
                m_pd.Print();
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>印刷プレビュー表示処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Preview_button_Click( sender, e )：（印刷ﾌﾟﾚﾋﾞｭｰボタンクリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void Preview_button_Click(object sender, EventArgs e)
        {
            // start of 印刷プレビュー処理修正
            try
            {
                //印刷用ビットマップの取得
                //********** 速度改善他対応 2011.03.04 mod_s **************************************************
                //m_bit_img = (CaptureControl(panel1));
                m_bit_img = CreateGraphForPrint();
                //********** 速度改善他対応 2011.03.04 mod_e **************************************************

                //プリントドキュメントの生成
                m_pd = new System.Drawing.Printing.PrintDocument();

                //PrintPageイベントハンドラの追加
                m_pd.PrintPage +=
                    new System.Drawing.Printing.PrintPageEventHandler(pd_PrintPage);

                //プレビューフォームのインスタンス生成
                PrintPreviewDialog ppd = new PrintPreviewDialog();
                //プレビューするPrintDocumentを設定
                ppd.Document = m_pd;

                //********** 速度改善他対応 2011.03.04 add_s **************************************************
                //プリンター設定
                m_pd.PrinterSettings = ppd.Document.PrinterSettings;

                //ページ設定
                foreach (System.Drawing.Printing.PaperSize ps in m_pd.PrinterSettings.PaperSizes)
                {
                    if (ps.Kind == System.Drawing.Printing.PaperKind.A4)
                    {
                        m_pd.DefaultPageSettings.PaperSize = ps;
                        m_pd.DefaultPageSettings.Landscape = true;    //横
                        break;
                    }
                }
                //********** 速度改善他対応 2011.03.04 add_s **************************************************

                //印刷プレビューダイアログを表示する
                ppd.ShowDialog();
                //bitmap解放
                m_bit_img.Dispose();
            }
            catch
            {
                // 例外を此処で捕捉して任意処理実施
            }
            // end of 印刷プレビュー処理修正
        }

        // end of 印刷機能追加

        //********** 速度改善他対応 2011.03.04 add_s **************************************************
        /// <summary><para>method outline:</para>
        /// <para>画像保存処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SaveImage_button_Click( sender, e )：（画像保存クリック）</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void SaveImage_button_Click(object sender, EventArgs e)
        {
            //--------------------------------------------------
            // 保存先選択ダイアログ表示
            //--------------------------------------------------
            SaveFileDialog sfd = new SaveFileDialog();
            //はじめのファイル名を指定する
            sfd.FileName = "graph1.png";
            sfd.InitialDirectory = HySEnvInf.GetHomeDirectory().ToString();
            sfd.Filter = string.Format(Properties.HysAddinHydroHyetoGraphResources.FILE_DLG_FILTER_ANY, "png");
            //ダイアログボックスを閉じる前に現在のディレクトリを復元するようにする
            sfd.RestoreDirectory = true;
            
            //ダイアログを表示する
            if (sfd.ShowDialog() != DialogResult.OK)
            {   //キャンセルボタンがクリックされたとき
                return;  
            }

            //--------------------------------------------------
            // 保存用画像作成
            //--------------------------------------------------
            using (Bitmap bmp = CreateGraphForPrint())
            {
                //保存
                bmp.Save(sfd.FileName, System.Drawing.Imaging.ImageFormat.Png);
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>凡例を付け足した画像作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Bitmap bmp = CreateGraphForPrint()</para>
        /// </example>
        /// <returns>凡例付き画像</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private Bitmap CreateGraphForPrint()
        {
            Graphics g = null;
            Bitmap bmpLeg = null;
            try
            {
                int iLegendWidth = 0;
                if (chkPrintLegend.Checked)
                {
                    //凡例を付け足す
                    legendList1.DrawLegend(ref bmpLeg, chkPrintFileName.Checked);

                    //凡例のサイズ
                    iLegendWidth = bmpLeg.Width + 10;
                }

                Bitmap bmp = new Bitmap(panel1.Width + iLegendWidth + 10, panel1.Height + 10);
                
                //Graphicsオブジェクトを取得
                g = Graphics.FromImage(bmp);
                //背景を白色にする
                g.FillRectangle(Brushes.White, 0, 0, bmp.Width, bmp.Height);

                //グラフを合成
                g.DrawImage(picRainfall.Image, 0, 15);                          //ハイエトグラフ描画
                g.DrawImage(picWaterLevel.Image, 0, picRainfall.Height + 30);   //ハイドログラフ描画

                //ラベル描画
                using (SolidBrush bs = new SolidBrush(Color.Black))
                {
                    Font ft = labelAxisRain.Font;
                    g.DrawString(labelAxisRain.Text, ft, bs, 30, 5);
                    g.DrawString(labelAxisLevel.Text, ft, bs, 30, picRainfall.Height + 20);
                    //右軸ラベルは右寄せ
                    RectangleF rect = new RectangleF(0, picRainfall.Height + 20, panel1.Width - 50, 18);
                    StringFormat sformat = new StringFormat();
                    sformat.Alignment = StringAlignment.Far;
                    g.DrawString(labelAxisFlow.Text, ft, bs, rect, sformat);
                }

                if (bmpLeg != null)
                {   //凡例を合成
                    int iLegeTop = Math.Max((panel1.Height - bmpLeg.Height - 50), 5);
                    g.DrawImage(bmpLeg, picWaterLevel.Image.Width + 10, iLegeTop);
                }

                return bmp;
            }
            finally
            {
                if (bmpLeg != null)
                {
                    bmpLeg.Dispose();
                    bmpLeg = null;
                }
                if (g != null)
                {
                    g.Dispose();
                    g = null;
                }
            }
        }
        //********** 速度改善他対応 2011.03.04 add_s **************************************************

    }
}