﻿//using System;
//using System.Collections.Generic;
//using System.Text;
using System;
using System.Data;
using System.Drawing;
using System.Drawing.Imaging;
using System.IO;

namespace CommonMP.HYMCO.OptionImpl.McGraphViewForDevelop
{
    /// <summary><para>class outline:</para>
    /// <para>雨量データグラフ表示</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/02/04][新規作成]</para>
    /// </remarks>
    public class McGraphViewRainfall : McGraphViewImageLib
    {
		/**********************************************************************
		 * 定数の定義
		**********************************************************************/
        /// <summary> 描画色：ペン </summary>
        private Pen m_pen_Rainfall = new Pen(Color.Black, 0.5F);
		//protected SolidBrush m_brush_Rainfall = new SolidBrush(Color.Red);
        /// <summary> 描画色：塗りつぶし </summary>
        private SolidBrush m_brush_Rainfall = new SolidBrush(Color.DeepSkyBlue);
        //private SolidBrush m_brush_Rainfall = new SolidBrush(Color.FromArgb(200, 255, 0, 0));

		/**********************************************************************
		 * 変数の定義
		**********************************************************************/
        /// <summary> 対象年（西暦4桁） </summary>
        private string m_Year;		// 対象年（西暦4桁）
        /// <summary> 対象月 </summary>
        private string m_Month;		// 対象月
        /// <summary> 対象日 </summary>
        private string m_Day;		// 対象日
        /// <summary> 対象時間 </summary>
        private string m_Hour;		// 対象時間
		//private clsCommon m_clsCommon = new clsCommon();

		/**********************************************************************
		 * プロパティの定義
		**********************************************************************/
        /// <summary>
        /// 対象年（西暦4桁）
        /// </summary>
		public string Year	// 対象年（西暦4桁）
		{
			set
			{
				m_Year = value;
			}
			get
			{
				return m_Year;
			}
		}
        /// <summary>
        /// 対象月
        /// </summary>
		public string Month	// 対象月
		{
			set
			{
				m_Month = value;
			}
			get
			{
				return m_Month;
			}
		}
        /// <summary>
        /// 対象日
        /// </summary>
		public string Day	// 対象日
		{
			set
			{
				m_Day = value;
			}
			get
			{
				return m_Day;
			}
		}
        /// <summary>
        /// 対象時間
        /// </summary>
		public string Hour	// 対象時間
		{
			set
			{
				m_Hour = value;
			}
			get
			{
				return m_Hour;
			}
		}
        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McGraphViewRainfall csRainfall = new McGraphViewRainfall()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public McGraphViewRainfall()
		{
			
		}

		//*********************************************************************
		// @(f)
		// 機能      : グラフの初期化
		//
		// 引数      : なし
		//
		// 返り値    : なし
		//
		// 機能説明  :
		//
		// 備考      :
		//
		//*********************************************************************
        /// <summary><para>method outline:</para>
        /// <para>グラフの初期化</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>InitGraph(h_stTime, h_edTime, h_mode)</para>
        /// </example>
        /// <param name="h_stTime">DateTime：スタート時間</param>
        /// <param name="h_edTime">DateTime：終了時間</param>
        /// <param name="h_mode">int 0：分単位，1：時間単位</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
		public void InitGraph(
            DateTime h_stTime,
            DateTime h_edTime,
            int h_mode  //0：分単位、1：時間単位
            )
		{
            /*
            DateTime a_stTime = h_stTime;
            DateTime a_edTime = h_edTime;

            //[2010.03.07]X軸の調整
            TimeSpan a_ts = h_stTime - h_edTime;
            float a_fTmpX = (ImageWidth - (m_sep_left + m_sep_right)) / (GraphMaxX - GraphMinX);
            if ((a_fTmpX * GraphSepX) < (m_font1.Size * 2))
            {
                GraphSepX = Convert.ToInt32((m_font1.Size * 2) / a_fTmpX);
            }
            else
            {
            }
             */

            //Y軸の調整
            /*
            float a_fTmpY = (ImageHeight - (m_sep_top + m_sep_bottom)) / (GraphMaxY - GraphMinY);
            if ((a_fTmpY * GraphSepY) < (m_font1.Size * 2))
            {
                GraphSepY = Convert.ToInt32((m_font1.Size * 2) / a_fTmpY);
            }
            else
            {
            }
            */

            InitializeGraph();

            //X軸の目盛表示
            //[2010.03.07]日時範囲の計算
            DateTime a_stTime = h_stTime;
            TimeSpan a_tTmp = h_edTime - h_stTime;
            int a_Xnum = 0;
            int a_Xsep = 0;
            int a_disp = 0; //1：時間表示、2：日表示、3：月表示、4：年表示
            if (a_tTmp.Days < 7)
            {   //1週間以内
                a_disp = 1;
                if (h_edTime.Day > h_stTime.Day)
                {   //日付が異なる
                    //2日分とする。
                    a_Xnum = 24 * (a_tTmp.Days + 1);
                    switch (a_tTmp.Days)
                    {
                        case 0:
                            a_Xsep = 1;
                            break;
                        case 1:
                            a_Xsep = 2;
                            break;
                        case 2:
                            a_Xsep = 2;
                            break;
                        case 3:
                            a_Xsep = 4;
                            break;
                        case 4:
                            a_Xsep = 4;
                            break;
                        case 5:
                            a_Xsep = 4;
                            break;
                        case 6:
                            a_Xsep = 6;
                            break;
                        //case 7:
                        //    a_Xsep = 6;
                        //    break;
                    }
                }
                else
                {   //日付が同じ
                    //該当日分とする。
                    a_Xnum = 24;
                    a_Xsep = 1;
                }
            }
            else if (a_tTmp.Days < 31)
            {   //1週間～１ヶ月以内
                a_Xnum = 24 * (a_tTmp.Days + 1);
                if (a_tTmp.Days == 7)
                {
                    a_disp = 1;
                    a_Xsep = 8;
                }
                else if ((a_tTmp.Days >= 8) && (a_tTmp.Days <= 15))
                {
                    a_disp = 1;
                    a_Xsep = 12;
                }
                else if ((a_tTmp.Days >= 16) && (a_tTmp.Days <= 30))
                {
                    a_disp = 2;
                    a_Xsep = 24;
                }
            }
            else if (a_tTmp.Days < 366)
            {   //1ヶ月から1年以内
                a_Xnum = 24 * (a_tTmp.Days + 1);
                if (a_tTmp.Days == 31)
                {
                    a_disp = 2;
                    a_Xsep = 24;
                }
                else if ((a_tTmp.Days >= 16) && (a_tTmp.Days <= 365))
                {
                    a_disp = 3;
                    a_Xsep = 24 * 30;
                }
            }
            else
            {   //1年越え
                a_disp = 4;
                a_Xnum = 24 * (a_tTmp.Days + 1);
                a_Xsep = 24 * 366;
            }

            if (h_mode == 0)
            {   //分単位
                a_Xnum *= 60;
                a_Xsep *= 60;
            }

            Pen m_pen2 = new Pen(Color.LightGray, 0.5f);
            m_pen2.DashStyle = System.Drawing.Drawing2D.DashStyle.Dash;

            string a_day = "";  // h_stTime.ToString("yyyy/MM/dd");
            for (int a_iCnt = 1; a_iCnt <= GraphMaxX + 1; a_iCnt += Convert.ToInt32(GraphSepX))
            {
                string a_sVal = "";
                //string a_sValXM = "";
                //string a_sValXM2 = "";
                //string a_sValXM3 = "";
                //string a_sValXM4 = "";
                string a_sValXyear = "";
                string a_sValXmonth = "";
                string a_sValXday = "";

                if (((a_iCnt - 1) % a_Xsep) == 0)
                {
                    if (h_mode == 0)
                    {   //分単位
                        a_stTime = h_stTime.AddMinutes((a_iCnt - 1));
                    }
                    else
                    {   //時間単位
                        a_stTime = h_stTime.AddHours((a_iCnt - 1));
                    }

                    switch (a_disp)
                    {
                        case 1:     //時間表示
                            //a_sValXM = "(時)";
                            //a_sValXM2 = "日";
                            //a_sValXM3 = "月";
                            //a_sValXM4 = "年";
                            a_sVal = a_stTime.ToString("HH");
                            a_sValXday = a_stTime.ToString("dd");
                            a_sValXmonth = a_stTime.ToString("MM");
                            a_sValXyear = a_stTime.ToString("yyyy");
                            if (a_day.Length > 0)
                            {
                                if (a_day.Substring(8, 2).Equals(a_sValXday) == true)
                                {
                                    a_sValXday = "";
                                }
                                if (a_day.Substring(5, 2).Equals(a_sValXmonth) == true)
                                {
                                    a_sValXmonth = "";
                                }
                                if (a_day.Substring(0, 4).Equals(a_sValXyear) == true)
                                {
                                    a_sValXyear = "";
                                }
                            }
                            break;
                        case 2:     //日表示
                            //a_sValXM = "(日)";
                            //a_sValXM2 = "月";
                            //a_sValXM3 = "年";
                            //a_sValXM4 = "";
                            a_sVal = a_stTime.ToString("dd");
                            a_sValXday = a_stTime.ToString("MM");
                            a_sValXmonth = a_stTime.ToString("yyyy");
                            a_sValXyear = "";
                            if (a_day.Length > 0)
                            {
                                if (a_day.Substring(5, 2).Equals(a_sValXday) == true)
                                {
                                    a_sValXday = "";
                                }
                                if (a_day.Substring(0, 4).Equals(a_sValXmonth) == true)
                                {
                                    a_sValXmonth = "";
                                }
                            }
                            break;
                        case 3:     //月表示
                            //a_sValXM = "(月)";
                            //a_sValXM2 = "年";
                            //a_sValXM3 = "";
                            //a_sValXM4 = "";
                            a_sVal = a_stTime.ToString("MM");
                            a_sValXday = a_stTime.ToString("yyyy");
                            a_sValXmonth = "";
                            a_sValXyear = "";
                            if (a_day.Length > 0)
                            {
                                if (a_day.Substring(0, 4).Equals(a_sValXday) == true)
                                {
                                    a_sValXday = "";
                                }
                            }
                            break;
                        case 4:     //年表示
                            //a_sValXM = "(年)";
                            //a_sValXM2 = "";
                            //a_sValXM3 = "";
                            //a_sValXM4 = "";
                            a_sVal = a_stTime.ToString("yyyy");
                            a_sValXday = "";
                            a_sValXmonth = "";
                            a_sValXyear = "";
                            if (a_day.Length > 0)
                            {
                            }
                            break;
                    }
                }

                //タイトル
                /*
                m_g.DrawString(
                    a_sValXM,
                    m_font1,
                    Brushes.Black,
                    new PointF(
                        m_sep_left + GraphMaxX * m_sep_x_graph + Convert.ToSingle(m_font1.Size * 2.5),
                        ImageHeight - m_sep_bottom + m_font1.Size / 2)
                    );
                m_g.DrawString(
                    a_sValXM2,
                    m_font1,
                    Brushes.Black,
                    new PointF(
                        m_sep_left + GraphMaxX * m_sep_x_graph + Convert.ToSingle(m_font1.Size * 3.0),
                        ImageHeight - m_sep_bottom + Convert.ToSingle(m_font1.Size * 1.8))
                    );
                m_g.DrawString(
                    a_sValXM3,
                    m_font1,
                    Brushes.Black,
                    new PointF(
                        m_sep_left + GraphMaxX * m_sep_x_graph + Convert.ToSingle(m_font1.Size * 3.0),
                        ImageHeight - m_sep_bottom + Convert.ToSingle(m_font1.Size * 3))
                    );
                m_g.DrawString(
                    a_sValXM4,
                    m_font1,
                    Brushes.Black,
                    new PointF(
                        m_sep_left + GraphMaxX * m_sep_x_graph + Convert.ToSingle(m_font1.Size * 3.0),
                        ImageHeight - m_sep_bottom + Convert.ToSingle(m_font1.Size * 4.3))
                    );

                //X値
                m_g.DrawString(
                    a_sVal,
                    m_font1,
                    Brushes.Black,
                    new PointF(
                        m_sep_left + (a_iCnt - 1) * m_sep_x_graph - m_font1.Size / 2,  //m_sep_left + (a_iCnt - 1) * m_sep_x_graph - m_sep_x_graph / 2 + m_font1.Size / 2,
                        ImageHeight - m_sep_bottom + m_font1.Size / 2)
                    );

                //if (a_day.Equals(a_stTime.ToString("yyyy/MM/dd")) == false)
                //{
                m_g.DrawString(
                    a_sValXday,
                    m_font1,
                    Brushes.Black,
                    new PointF(
                        m_sep_left + (a_iCnt - 1) * m_sep_x_graph - m_font1.Size / 2,
                        ImageHeight - m_sep_bottom + Convert.ToSingle(m_font1.Size * 1.8))
                    );
                m_g.DrawString(
                    a_sValXmonth,
                    m_font1,
                    Brushes.Black,
                    new PointF(
                        m_sep_left + (a_iCnt - 1) * m_sep_x_graph - m_font1.Size / 2,  // + m_font1.Size / 2,
                        ImageHeight - m_sep_bottom + Convert.ToSingle(m_font1.Size * 3))
                    );
                m_g.DrawString(
                    a_sValXyear,
                    m_font1,
                    Brushes.Black,
                    new PointF(
                        m_sep_left + (a_iCnt - 1) * m_sep_x_graph - m_font1.Size / 2,  // + m_font1.Size / 2,
                        ImageHeight - m_sep_bottom + Convert.ToSingle(m_font1.Size * 4.3))
                    );
                a_day = a_stTime.ToString("yyyy/MM/dd");
                //}
                */

                if (a_sVal.Length > 0)
                {   //表示あり
                    if ((a_iCnt > 1) && (a_iCnt <= GraphMaxX))
                    {
                        m_g.DrawLine(
                            m_pen2,
                            m_sep_left + ((m_sep_x_val * (a_iCnt - 1)) * m_sep_x_graph),
                            m_Height - m_sep_bottom,
                            m_sep_left + ((m_sep_x_val * (a_iCnt - 1)) * m_sep_x_graph),
                            m_sep_top
                            );
                    }
                }
            }

			_drawGraphBackGround();
		}

		//*********************************************************************
		// @(f)
		// 機能      : 雨量の値設定
		//
		// 引数      : ARG1 - weaterRainfallItemsオブジェクト
		//
		// 返り値    : なし
		//
		// 機能説明  :
		//
		// 備考      :
		//
		//*********************************************************************
        /// <summary><para>method outline:</para>
        /// <para>雨量の値設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetRainfallItems(val)</para>
        /// </example>
        /// <param name="val">McGraphViewRainfallItems：雨量オブジェクト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetRainfallItems(McGraphViewRainfallItems val)
		{
			_setGraphValue(val);
		}

		//*********************************************************************
		// @(f)
		// 機能      : グラフの描画実行
		//
		// 引数      : なし
		//
		// 返り値    : なし
		//
		// 機能説明  :
		//
		// 備考      :
		//
		//*********************************************************************
        /*/// <summary><para>method outline:</para>
        /// <para>グラフの描画実行</para>
        /// </summary>
		public void MakeGraph()
		{
            MakeImageFile();
		}
        */
		//*********************************************************************
		// @(f)
		// 機能      : グラフの背景描画
		//
		// 引数      : なし
		//
		// 返り値    : なし
		//
		// 機能説明  :
		//
		// 備考      :
		//
		//*********************************************************************
        /// <summary><para>method outline:</para>
        /// <para>グラフの背景描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_drawGraphBackGround()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
		private void _drawGraphBackGround()
		{
            //string a_strTmp = "";
			//string a_strTmp2 = "";

			//-----------------------------------------------------------------
			// 凡例の描画
			//-----------------------------------------------------------------
            /*
			DrawLegend(
				m_pen_Rainfall,
				m_brush_Rainfall,
				"雨量",
				1,
                enumPlotKind.Nothing,
                enumPlotForm.Nothing
				);
            */
			//-----------------------------------------------------------------
			// タイトル文字の描画
			//-----------------------------------------------------------------
			// Y軸
            /*
			DrawYUnitString(
				"(mm)"
				);
             */

            /*[2010.03.07]
            DrawYTitleStringVertical(
				"雨量",
                ""
				);
            m_g.DrawString(
                "(mm)",
                m_font1,Brushes.Black,
                new PointF(0, ImageHeight - m_sep_bottom - m_font1.Size)
                );
             */

			// X軸
			// タイトル文字の描画
            /*
			if (GraphKind == enumGraphKind.IsTime)
			{
				a_strTmp = "(時)";
				a_strTmp2 = "時刻";
			}
			else if (GraphKind == enumGraphKind.IsDay)
			{
				a_strTmp = "(日)";
				a_strTmp2 = "日";
			}
             */
            /*
			DrawXUnitString(
				a_strTmp
				);
             */ 
			/*
            DrawXTitleString(
				a_strTmp2
				);
            */
		}	

		//*********************************************************************
		// @(f)
		// 機能      : グラフの最低雨量・最高雨量・相対雨量の値描画
		//
		// 引数      : ARG1 - weatherRainfallItemsオブジェクト
		//
		// 返り値    : なし
		//
		// 機能説明  :
		//
		// 備考      :
		//
		//*********************************************************************
        /// <summary><para>method outline:</para>
        /// <para>グラフの最低雨量・最高雨量・相対雨量の値描画</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>_setGraphValue(val)</para>
        /// </example>
        /// <param name="val">McGraphViewRainfallItems: 雨量データリスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void _setGraphValue(McGraphViewRainfallItems val)
		{
            try
            {
                int a_iListCount = val.Count;	// リスト数を取得
                float a_prev_Rainfall = InvalidValue;
                float a_prev_X = 0;

                m_brush_Rainfall.Color = val.LineColor;   //色変更

                for (int a_iCnt = 1; a_iCnt <= a_iListCount; a_iCnt++)
                {
                    //-------------------------------------------------------------
                    // 雨量の表示
                    //-------------------------------------------------------------
                    PlotGraphValue(
                        m_pen_Rainfall,
                        m_brush_Rainfall,
                        val[a_iCnt - 1].TimeOrDay,
                        val[a_iCnt - 1].Rainfall,
                        a_prev_X,
                        ref a_prev_Rainfall,
                        //a_iCnt,
                        enumPlotKind.Bar,
                        enumPlotForm.Nothing
                        );

                    a_prev_X = val[a_iCnt - 1].TimeOrDay;
                }
            }
            catch (Exception exp)
            {
                Console.WriteLine(exp.Message);
            }
        }	
    }
}
