﻿//using System;
//using System.Collections.Generic;
//using System.Text;
using System;
using System.Collections;

namespace CommonMP.HYMCO.OptionImpl.McGraphViewForDevelop
{
    /// <summary><para>class outline:</para>
    /// <para>雨量データコレクション</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2010/02/04][新規作成]</para>
    /// </remarks>
    public class McGraphViewRainfallItems : CollectionBase
    {
        /**********************************************************************
         * 変数の定義
        **********************************************************************/
        /// <summary> ファイル名 </summary>
        private string m_sFileName = "";
        /// <summary> 処理中インデックス </summary>
        private int m_NowIdx = 1;
        //private string[] m_AlertMsg = null;
        /// <summary> 線の色 </summary>
        private System.Drawing.Color m_LineColor = System.Drawing.Color.DeepSkyBlue;

        /**********************************************************************
         * プロパティの定義
        **********************************************************************/
        /// <summary>
        /// ファイル名
        /// </summary>
        public string FileName	//ファイル名
        {
            set
            {
                m_sFileName = value;
            }
            get
            {
                return m_sFileName;
            }
        }

        /// <summary>
        /// 処理中インデックス
        /// </summary>
        public int NowIdx	//インデックス
        {
            set
            {
                m_NowIdx = value;
            }
            get
            {
                return m_NowIdx;
            }
        }

        ///// <summary>
        ///// 
        ///// </summary>
        //public string[] AlertMsg	//アラートメッセージ
        //{
        //    set
        //    {
        //        m_AlertMsg = value;
        //    }
        //    get
        //    {
        //        return m_AlertMsg;
        //    }
        //}

        /// <summary>
        /// 線の色
        /// </summary>
        public System.Drawing.Color LineColor
        {
            set
            {
                m_LineColor = value;
            }
            get
            {
                return m_LineColor;
            }
        }


        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McGraphViewRainfallItems csRainfallItems = new McGraphViewRainfallItems()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
		public McGraphViewRainfallItems()
		{
			
		}
        /// <summary><para>method outline:</para>
        /// <para>雨量データ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McGraphViewRainfallItem csRainfallItem = csRainfallItems[index]</para>
        /// </example>
        /// <param name="index">インデックス</param>
        /// <returns>雨量データ</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
		public McGraphViewRainfallItem this[ int index ]  
		{
			get  
			{
				return( (McGraphViewRainfallItem) List[index] );
			}
			set  
			{
				List[index] = value;
			}
		}
        /// <summary><para>method outline:</para>
        /// <para>追加</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Add(value)</para>
        /// </example>
        /// <param name="value">McGraphViewRainfallItem：雨量の値</param>
        /// <returns>新しい要素が挿入された位置</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
		public int Add( McGraphViewRainfallItem value )  
		{
			return( List.Add( value ) );
		}
        /// <summary><para>method outline:</para>
        /// <para>インデックス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>IndexOf(value)</para>
        /// </example>
        /// <param name="value">McGraphViewRainfallItem：雨量の値</param>
        /// <returns>リストに存在する場合は value のインデックス。それ以外の場合は -1</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
		public int IndexOf( McGraphViewRainfallItem value )  
		{
			return( List.IndexOf( value ) );
		}
        /// <summary><para>method outline:</para>
        /// <para>挿入</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Insert(index, value)</para>
        /// </example>
        /// <param name="index">int：インデックス</param>
        /// <param name="value">McGraphViewRainfallItem：雨量の値</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
		public void Insert( int index, McGraphViewRainfallItem value )  
		{
			List.Insert( index, value );
		}
        /// <summary><para>method outline:</para>
        /// <para>削除</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Remove(value)</para>
        /// </example>
        /// <param name="value">McGraphViewRainfallItem：雨量の値</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
		public void Remove( McGraphViewRainfallItem value )  
		{
			List.Remove( value );
		}
        /// <summary><para>method outline:</para>
        /// <para>特定の値が格納されているか判定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Contains(value)</para>
        /// </example>
        /// <param name="value">McGraphViewRainfallItem：雨量の値</param>
        /// <returns>true=存在する/false=しない</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
		public bool Contains( McGraphViewRainfallItem value )  
		{
			// If value is not of type Int16, this will return false.
			return( List.Contains( value ) );
		}
        /*
        /// <summary>
        /// OnInsert
        /// </summary>
        /// <param name="index">インデックス</param>
        /// <param name="value">値</param>
		protected override void OnInsert( int index, Object value )  
		{
			//			if ( value.GetType() != Type.GetType("McGraphViewRainfallItem") )
			//				throw new ArgumentException( "value must be of type McGraphViewRainfallItem.", "value" );
		}
        /// <summary>
        /// OnRemove
        /// </summary>
        /// <param name="index">インデックス</param>
        /// <param name="value">値</param>
		protected override void OnRemove( int index, Object value )  
		{
			//			if ( value.GetType() != Type.GetType("McGraphViewRainfallItem") )
			//				throw new ArgumentException( "value must be of type McGraphViewRainfallItem.", "value" );
		}
        /// <summary>
        /// OnSet
        /// </summary>
        /// <param name="index">インデックス</param>
        /// <param name="oldValue">値</param>
        /// <param name="newValue">値</param>
		protected override void OnSet( int index, Object oldValue, Object newValue )  
		{
			//			if ( newValue.GetType() != Type.GetType("McGraphViewRainfallItem") )
			//				throw new ArgumentException( "newValue must be of type McGraphViewRainfallItem.", "newValue" );
		}
        /// <summary>
        /// OnValidate
        /// </summary>
        /// <param name="value">値</param>
		protected override void OnValidate( Object value )  
		{
			//			if ( value.GetType() != Type.GetType("McGraphViewRainfallItem") )
			//				throw new ArgumentException( "value must be of type McGraphViewRainfallItem." );
		}
        */
    }
}
