using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYMCO.OptionImpl.McGraphViewForDevelop
{
    /// <summary><para>class outline:</para>
    /// <para>定義情報クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.0.0][2009/12/01][新規作成]</para>
    /// </remarks>
    public class McGraphViewDefine
    {
        // ===========================
        // 種別識別子関係
        // ===========================
        /// <summary>業務種別識別子：システム内でユニークな値としてください</summary>
        static public readonly HySKind MCGRAPHVIEW_BUSINESS_KIND = new HySObjectKind("HsAddin.McGraphViewBusiProc");
        /// <summary>画面ファクトリーID：システム内でユニークな値としてください</summary>
        static public readonly HySIdentifier MCGRAPHVIEW_FACTORY_ID_SCREEN = new HySID("HsAddin.McGraphView.Factory.Screen");
        /// <summary>ビューア内処理ファクトリー：システム内でユニークな値としてください</summary>
        static public readonly HySIdentifier MCGRAPHVIEW_FACTORY_ID_VIEWRJOB = new HySID("HsAddin.McGraphView.Factory.ViewerJob");


        // ===========================
        // 画面識別子関係
        // ===========================
        /// <summary>プロジェクト管理画面：本業務内でユニークな値としてください</summary>
        static public readonly HySKind MCGRAPHVIEW_SCREEN = new HySObjectKind("McGraphView.Screen");
        // ToDo 画面のIDを追加（画面数分）


        // ===========================
        // メニューコールバック番号定義関係
        // ===========================
        /// <summary>何らかの処理：本業務内でユニークな値としてください</summary>
        static public readonly long MCGRAPHVIEW_DO_SOMETHING = 1;
        /// <summary>サンプル画面表示開始：本業務内でユニークな値としてください</summary>
        static public readonly long MCGRAPHVIEW_DISP_SCREEN = 10;
        // ToDo メニューからのコールバック番号を追加定義（メニュー数分）

        // ===========================
        // グラフ設定
        // ===========================
        /// <summary>欠測値</summary>
        static public readonly float g_InvalidValue = -9999;
        /// <summary>欠測値</summary>
        static public readonly float g_InvalidValue2 = -9998;  //[2010.06.01]
        /// <summary>雨量Y軸最大値</summary>
        static public float g_Rainfall_MaxY = g_InvalidValue;
        /// <summary>雨量Y軸最小値</summary>
        static public float g_Rainfall_MinY = g_InvalidValue;

        /// <summary>水位Y軸最大値</summary>
        static public float g_WaterLevel_MaxY = g_InvalidValue;
        /// <summary>水位Y軸最小値</summary>
        static public float g_WaterLevel_MinY = g_InvalidValue;

        /// <summary>流量Y軸最大値</summary>
        static public float g_FlowMeter_MaxY = g_InvalidValue;
        /// <summary>流量Y軸最小値</summary>
        static public float g_FlowMeter_MinY = g_InvalidValue;

        /// <summary>未使用</summary>
        static public Boolean g_IsLine = true;
        /// <summary>未使用</summary>
        static public Boolean g_IsPoint = true;
    }
}
