﻿/// <summary>
/// プロジェクト共通データアクセス
/// </summary>
/// <create>2010/01/26</create>
/// <modifier></modifier>
/// <modify></modify>
/// <modification></modification>
using System;
using System.Collections;
using System.Collections.Generic;
using System.Text;

namespace lsor
{
    #region プロジェクト共通データアクセスクラス

    /// <summary><para>class outline:</para>
    /// <para>プロジェクト共通データアクセスクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[ver 1.0.0][2010/02/02][新規作成]</para>
    /// </remarks>
    [Serializable]
    public class CommonData
    {

        #region 定数

        /// <summary>最大ファイルID</summary>
        public const int MAX_FILE_ID = 50;

        /// <summary>河川名キー</summary>
        public static readonly string KEY_RIVER_NM = Properties.HySAddinLsor2VieweEXEResources.RIVER_NAME;
        /// <summary>topoIDキー</summary>
        public const string KEY_TOPO_ID = "topoID";
        /// <summary>断面IDキー</summary>
        public static readonly string KEY_SLICE_NO = Properties.HySAddinLsor2VieweEXEResources.CROSS_SECTION_ID;
        /// <summary>累加距離キー</summary>
        public static readonly string KEY_SUM_DISTANCE = Properties.HySAddinLsor2VieweEXEResources.CUMULATIVE_DISTANCE;

        #endregion

        #region プライベート変数

        /// <summary>入力ファイルリスト</summary>
        private List<InputFile> _fileList = new List<InputFile>();

        /// <summary>河川リスト</summary>
        private List<RiverData> _riverList = new List<RiverData>();

        /// <summary>流下能力算定データ</summary>
        private FlowCommonData _flowData = new FlowCommonData();

        #endregion

        #region プロパティ

        #region プロジェクトファイル名

        /// <summary><para>method outline:</para>
        /// <para>プロジェクトファイル名の設定・取得する</para>
        /// </summary>
        /// <value>プロジェクトファイル名</value>
        /// <example><para>usage:</para>
        /// <para>string strFileNm = clsCommonData.ProjectFileNm()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string ProjectFileNm { get; set; }

        #endregion

        #region 入力ファイルリスト

        /// <summary><para>method outline:</para>
        /// <para>入力ファイルリストの設定・取得する</para>
        /// </summary>
        /// <value>入力ファイルリスト</value>
        /// <example><para>usage:</para>
        /// <para>List＜InputFile＞ fileList = clsCommonData.FileList()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public List<InputFile> FileList
        {
            get { return this._fileList; }
            set { this._fileList = value; }
        }

        #endregion

        #region 河川リスト

        /// <summary><para>method outline:</para>
        /// <para>河川リストの設定・取得する</para>
        /// </summary>
        /// <value>河川リスト</value>
        /// <example><para>usage:</para>
        /// <para>List＜RiverData＞ riverList = clsCommonData.RiverList()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public List<RiverData> RiverList
        {
            get { return this._riverList; }
            set { this._riverList = value; }
        }

        #endregion

        #region 流下能力算定データ

        /// <summary><para>method outline:</para>
        /// <para>流下能力算定データの設定・取得する</para>
        /// </summary>
        /// <value>流下能力算定データ</value>
        /// <example><para>usage:</para>
        /// <para>FlowCommonData flowData = clsCommonData.FlowData()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public FlowCommonData FlowData
        {
            get { return this._flowData; }
            set { this._flowData = value; }
        }

        #endregion


        #endregion
    }

    #endregion

    #region 入力ファイル

    /// <summary><para>class outline:</para>
    /// <para>入力ファイル制御クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[ver 1.0.0][2010/02/02][新規作成]</para>
    /// </remarks>
    public class InputFile
    {

        #region プライベート変数

        /// <summary>データ格納用リスト</summary>
        private List<ColumnData> _columnList = new List<ColumnData>();
        /// <summary>CSVデータ格納用２次元配列</summary>
        private ArrayList _csvData = new ArrayList();   // CSVデータ格納用２次元配列

        #endregion

        #region プロパティ

        /// <summary><para>method outline:</para>
        /// <para>ファイルIDの設定・取得する</para>
        /// </summary>
        /// <value>ファイルID</value>
        /// <example><para>usage:</para>
        /// <para>string strFileId = clsCommonData.FileId()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string FileId { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>ファイル名の設定・取得する</para>
        /// </summary>
        /// <value>ファイル名</value>
        /// <example><para>usage:</para>
        /// <para>string strFileNm = clsCommonData.FileNm()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string FileNm { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>未保存フラグの設定・取得する</para>
        /// </summary>
        /// <value>未保存フラグ</value>
        /// <example><para>usage:</para>
        /// <para>bool bUnsaveFlg = clsCommonData.UnsaveFlg()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool UnsaveFlg { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>名前を付けて保存のファイル名の設定・取得する</para>
        /// </summary>
        /// <value>名前を付けて保存のファイル名</value>
        /// <example><para>usage:</para>
        /// <para>string strNewFileNm = clsCommonData.NewFileNm()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string NewFileNm { get; set; }

        #region 項目リスト

        /// <summary><para>method outline:</para>
        /// <para>項目リストのファイル名の設定・取得する</para>
        /// </summary>
        /// <value>項目リストのファイル名</value>
        /// <example><para>usage:</para>
        /// <para>List＜ColumnData＞ columnList = clsCommonData.ColumnList()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public List<ColumnData> ColumnList
        {
            get { return this._columnList; }
            set { this._columnList = value; }
        }

        #endregion

        #region CSVデータ

        /// <summary><para>method outline:</para>
        /// <para>CSVデータのファイル名の設定・取得する</para>
        /// </summary>
        /// <value>CSVデータのファイル名</value>
        /// <example><para>usage:</para>
        /// <para>ArrayList csvDataList = clsCommonData.CsvData()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        [System.Xml.Serialization.XmlArrayItem(typeof(string[]))]
        public ArrayList CsvData
        {
            get { return this._csvData; }
            set { this._csvData = value; }
        }
        #endregion

        #endregion

    }

    #endregion

    #region 河川データ

    /// <summary><para>class outline:</para>
    /// <para>河川データ制御クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[ver 1.0.0][2010/02/02][新規作成]</para>
    /// </remarks>
    public class RiverData
    {

        #region プライベート変数

        /// <summary>グラフプロパティ（データ系列）リスト</summary>
        private List<GraphPropData> _graphPropList = new List<GraphPropData>();
        /// <summary>グラフ表示設定データ</summary>
        private GraphSettingData _graphSettingData = new GraphSettingData();

        #endregion

        #region プロパティ

        /// <summary><para>method outline:</para>
        /// <para>河川名の設定・取得する</para>
        /// </summary>
        /// <value>河川名</value>
        /// <example><para>usage:</para>
        /// <para>string strRiverNm = clsCommonData.RiverNm()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string RiverNm { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>topoIDの設定・取得する</para>
        /// </summary>
        /// <value>topoID</value>
        /// <example><para>usage:</para>
        /// <para>string strTopoId = clsCommonData.TopoId()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string TopoId { get; set; }

        #region グラフプロパティ（データ系列）リスト

        /// <summary><para>method outline:</para>
        /// <para>グラフプロパティ（データ系列）リストの設定・取得する</para>
        /// </summary>
        /// <value>グラフプロパティ（データ系列）リスト</value>
        /// <example><para>usage:</para>
        /// <para>List＜GraphPropData＞ graphPropList = clsCommonData.GraphPropList()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public List<GraphPropData> GraphPropList
        {
            get { return this._graphPropList; }
            set { this._graphPropList = value; }
        }

        #endregion

        #region グラフ表示設定

        /// <summary><para>method outline:</para>
        /// <para>グラフ表示設定の設定・取得する</para>
        /// </summary>
        /// <value>グラフ表示設定</value>
        /// <example><para>usage:</para>
        /// <para>GraphSettingData graphSettingData = clsCommonData.GraphSettingData()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public GraphSettingData GraphSettingData
        {
            get { return this._graphSettingData; }
            set { this._graphSettingData = value; }
        }

        #endregion


        #endregion

    }

    #endregion

    #region グラフプロパティデータ

    /// <summary><para>class outline:</para>
    /// <para>グラフプロパティデータ制御クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[ver 1.0.0][2010/02/02][新規作成]</para>
    /// </remarks>
    public class GraphPropData
    {

        #region プロパティ

        /// <summary><para>method outline:</para>
        /// <para>ファイルIDの設定・取得する</para>
        /// </summary>
        /// <value>ファイルID</value>
        /// <example><para>usage:</para>
        /// <para>string strFileId = clsCommonData.FileId()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string FileId { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>項目名の設定・取得する</para>
        /// </summary>
        /// <value>項目名</value>
        /// <example><para>usage:</para>
        /// <para>string strColumnNm = clsCommonData.ColumnNm()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string ColumnNm { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>凡例表示名の設定・取得する</para>
        /// </summary>
        /// <value>凡例表示名</value>
        /// <example><para>usage:</para>
        /// <para>string strNotesNm = clsCommonData.NotesNm()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string NotesNm { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>スケールの設定・取得する</para>
        /// </summary>
        /// <value>スケール</value>
        /// <example><para>usage:</para>
        /// <para>int iScaleType = clsCommonData.ScaleType()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public int ScaleType { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>線表示有無の設定・取得する</para>
        /// </summary>
        /// <value>線表示有無</value>
        /// <example><para>usage:</para>
        /// <para>bool bLineDisp = clsCommonData.LineDisp()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool LineDisp { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>線種の設定・取得する</para>
        /// </summary>
        /// <value>線種</value>
        /// <example><para>usage:</para>
        /// <para>int iLineType = clsCommonData.LineType()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public int LineType { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>線色の設定・取得する</para>
        /// </summary>
        /// <value>線色</value>
        /// <example><para>usage:</para>
        /// <para>int iLineColor = clsCommonData.LineColor()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public int LineColor { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>太さの設定・取得する</para>
        /// </summary>
        /// <value>太さ</value>
        /// <example><para>usage:</para>
        /// <para>int iLineSize = clsCommonData.LineSize()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public int LineSize { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>シンボル形状の設定・取得する</para>
        /// </summary>
        /// <value>シンボル形状</value>
        /// <example><para>usage:</para>
        /// <para>int iSymbolType = clsCommonData.SymbolType()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public int SymbolType { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>シンボル色の設定・取得する</para>
        /// </summary>
        /// <value>シンボル色</value>
        /// <example><para>usage:</para>
        /// <para>int iSymbolColor = clsCommonData.SymbolColor()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public int SymbolColor { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>シンボルサイズの設定・取得する</para>
        /// </summary>
        /// <value>シンボルサイズ</value>
        /// <example><para>usage:</para>
        /// <para>int iSymbolSize = clsCommonData.SymbolSize()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public int SymbolSize { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>シンボル表示有無の設定・取得する</para>
        /// </summary>
        /// <value>シンボル表示有無</value>
        /// <example><para>usage:</para>
        /// <para>bool bSymbolDisp = clsCommonData.SymbolDisp()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool SymbolDisp { get; set; }

        #endregion

    }

    #endregion

    #region グラフ表示設定データ

    /// <summary><para>class outline:</para>
    /// <para>グラフ表示設定データ制御クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[ver 1.0.0][2010/02/02][新規作成]</para>
    /// </remarks>
    public class GraphSettingData
    {

        #region プロパティ

        /// <summary><para>method outline:</para>
        /// <para>タイトルの設定・取得する</para>
        /// </summary>
        /// <value>タイトル</value>
        /// <example><para>usage:</para>
        /// <para>string strTitle = clsCommonData.Title()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string Title { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>X軸反転表示の設定・取得する</para>
        /// </summary>
        /// <value>X軸反転表示</value>
        /// <example><para>usage:</para>
        /// <para>bool bX_ReverseFlg = clsCommonData.X_ReverseFlg()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool X_ReverseFlg { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>X軸自動スケールの設定・取得する</para>
        /// </summary>
        /// <value>X軸自動スケール</value>
        /// <example><para>usage:</para>
        /// <para>bool bX_AutoScaleFlg = clsCommonData.X_AutoScaleFlg()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool X_AutoScaleFlg { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>X軸開始の設定・取得する</para>
        /// </summary>
        /// <value>X軸開始</value>
        /// <example><para>usage:</para>
        /// <para>string strX_MinValue = clsCommonData.X_MinValue()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string X_MinValue { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>X軸終了の設定・取得する</para>
        /// </summary>
        /// <value>X軸終了</value>
        /// <example><para>usage:</para>
        /// <para>string strX_MaxValue = clsCommonData.X_MaxValue()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string X_MaxValue { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>X軸単位の設定・取得する</para>
        /// </summary>
        /// <value>X軸単位</value>
        /// <example><para>usage:</para>
        /// <para>bool bX_UnitDispFlg = clsCommonData.X_UnitDispFlg()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool X_UnitDispFlg { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>X軸数値の設定・取得する</para>
        /// </summary>
        /// <value>X軸数値</value>
        /// <example><para>usage:</para>
        /// <para>bool bX_ValueDispFlg = clsCommonData.X_ValueDispFlg()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool X_ValueDispFlg { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>X軸グリッドの設定・取得する</para>
        /// </summary>
        /// <value>X軸グリッド</value>
        /// <example><para>usage:</para>
        /// <para>bool bX_GridDispFlg = clsCommonData.X_GridDispFlg()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool X_GridDispFlg { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>X軸断面No.の設定・取得する</para>
        /// </summary>
        /// <value>X軸断面No.</value>
        /// <example><para>usage:</para>
        /// <para>bool bX_SliceNoDispFlg = clsCommonData.X_SliceNoDispFlg()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool X_SliceNoDispFlg { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>Y軸左自動スケールの設定・取得する</para>
        /// </summary>
        /// <value>Y軸左自動スケール</value>
        /// <example><para>usage:</para>
        /// <para>bool bYL_AutoScaleFlg = clsCommonData.YL_AutoScaleFlg()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool YL_AutoScaleFlg { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>Y軸左上限の設定・取得する</para>
        /// </summary>
        /// <value>Y軸左上限</value>
        /// <example><para>usage:</para>
        /// <para>string strYL_MaxValue = clsCommonData.YL_MaxValue()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string YL_MaxValue { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>Y軸左下限の設定・取得する</para>
        /// </summary>
        /// <value>Y軸左下限</value>
        /// <example><para>usage:</para>
        /// <para>string strYL_MinValue = clsCommonData.YL_MinValue()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string YL_MinValue { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>Y軸左単位の設定・取得する</para>
        /// </summary>
        /// <value>Y軸左単位</value>
        /// <example><para>usage:</para>
        /// <para>string strYL_UnitType = clsCommonData.YL_UnitType()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string YL_UnitType { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>Y軸左数値の設定・取得する</para>
        /// </summary>
        /// <value>Y軸左数値</value>
        /// <example><para>usage:</para>
        /// <para>bool bYL_ValueDispFlg = clsCommonData.YL_ValueDispFlg()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool YL_ValueDispFlg { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>Y軸グリッドの設定・取得する</para>
        /// </summary>
        /// <value>Y軸グリッド</value>
        /// <example><para>usage:</para>
        /// <para>bool bY_GridDispFlg = clsCommonData.Y_GridDispFlg()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool Y_GridDispFlg { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>Y軸右自動スケールの設定・取得する</para>
        /// </summary>
        /// <value>Y軸右自動スケール</value>
        /// <example><para>usage:</para>
        /// <para>bool bYR_AutoScaleFlg = clsCommonData.YR_AutoScaleFlg()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool YR_AutoScaleFlg { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>Y軸右上限の設定・取得する</para>
        /// </summary>
        /// <value>Y軸右上限</value>
        /// <example><para>usage:</para>
        /// <para>string strYR_MaxValue = clsCommonData.YR_MaxValue()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string YR_MaxValue { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>Y軸右下限の設定・取得する</para>
        /// </summary>
        /// <value>Y軸右下限</value>
        /// <example><para>usage:</para>
        /// <para>string strYR_MinValue = clsCommonData.YR_MinValue()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string YR_MinValue { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>Y軸右単位の設定・取得する</para>
        /// </summary>
        /// <value>Y軸右単位</value>
        /// <example><para>usage:</para>
        /// <para>string strYR_UnitType = clsCommonData.YR_UnitType()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string YR_UnitType { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>Y軸右数値の設定・取得する</para>
        /// </summary>
        /// <value>Y軸右数値</value>
        /// <example><para>usage:</para>
        /// <para>bool bYR_ValueDispFlg = clsCommonData.YR_ValueDispFlg()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool YR_ValueDispFlg { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>設定済みフラグの設定・取得する</para>
        /// </summary>
        /// <value>設定済みフラグ</value>
        /// <example><para>usage:</para>
        /// <para>bool bInitializeFlg = clsCommonData.InitializeFlg()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool InitializeFlg { get; set; }

        #endregion

    }

    #endregion

    #region 項目データ

    /// <summary><para>class outline:</para>
    /// <para>項目データ制御クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[ver 1.0.0][2010/02/02][新規作成]</para>
    /// </remarks>
    public class ColumnData
    {

        #region プロパティ

        /// <summary><para>method outline:</para>
        /// <para>項目名の設定・取得する</para>
        /// </summary>
        /// <value>項目名</value>
        /// <example><para>usage:</para>
        /// <para>string strColumnNm = clsCommonData.ColumnNm()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string ColumnNm { get; set; }
        /// <summary><para>method outline:</para>
        /// <para>データ型の設定・取得する</para>
        /// </summary>
        /// <value>データ型</value>
        /// <example><para>usage:</para>
        /// <para>string strDataType = clsCommonData.DataType()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string DataType { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>単位の設定・取得する</para>
        /// </summary>
        /// <value>単位</value>
        /// <example><para>usage:</para>
        /// <para>string strUnitType = clsCommonData.UnitType()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string UnitType { get; set; }

        #endregion

    }

    #endregion

    #region 流下能力算定データ

    /// <summary><para>class outline:</para>
    /// <para>流下能力算定データ制御クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[ver 1.0.0][2010/02/02][新規作成]</para>
    /// </remarks>
    public class FlowCommonData
    {

        #region プライベート変数

        /// <summary>算定用データリスト</summary>
        private List<FlowFileData> _flowSourceList = new List<FlowFileData>();
        // 評価水位データリスト
        /// <summary>評価水位データリスト</summary>
        private List<FlowFileData> _flowTargetList = new List<FlowFileData>();

        #endregion

        #region プロパティ

        #region 算定用データリスト

        /// <summary><para>method outline:</para>
        /// <para>算定用データリストの設定・取得する</para>
        /// </summary>
        /// <value>算定用データリスト</value>
        /// <example><para>usage:</para>
        /// <para>List＜FlowFileData＞ flowSourceList = clsCommonData.FlowSourceList()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public List<FlowFileData> FlowSourceList
        {
            get { return this._flowSourceList; }
            set { this._flowSourceList = value; }
        }

        #endregion

        #region 評価水位データリスト

        /// <summary><para>method outline:</para>
        /// <para>評価水位データリストの設定・取得する</para>
        /// </summary>
        /// <value>評価水位データリスト</value>
        /// <example><para>usage:</para>
        /// <para>List＜FlowFileData＞ FlowTargetList = clsCommonData.FlowTargetList()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public List<FlowFileData> FlowTargetList
        {
            get { return this._flowTargetList; }
            set { this._flowTargetList = value; }
        }

        #endregion

        #endregion

    }

    #endregion

    #region 流下能力算定ファイルデータ

    /// <summary><para>class outline:</para>
    /// <para>流下能力算定ファイルデータ制御クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[ver 1.0.0][2010/02/02][新規作成]</para>
    /// </remarks>
    public class FlowFileData
    {
        #region プロパティ

        /// <summary><para>method outline:</para>
        /// <para>ファイルIDの設定・取得する</para>
        /// </summary>
        /// <value>ファイルID</value>
        /// <example><para>usage:</para>
        /// <para>string strFileId = clsCommonData.FileId()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string FileId { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>項目名（水位）の設定・取得する</para>
        /// </summary>
        /// <value>項目名（水位）</value>
        /// <example><para>usage:</para>
        /// <para>string strColumnNmH = clsCommonData.ColumnNmH()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string ColumnNmH { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>項目名（流量）の設定・取得する</para>
        /// </summary>
        /// <value>項目名（流量）</value>
        /// <example><para>usage:</para>
        /// <para>string strColumnNmQ = clsCommonData.ColumnNmQ()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string ColumnNmQ { get; set; }

        #endregion

    }

    #endregion

}
