﻿/// <summary>
/// タブページ表示管理
/// </summary>
/// <create>2010/01/27</create>
/// <modifier></modifier>
/// <modify></modify>
/// <modification></modification>
using System;
using System.Collections.Generic;
using System.Text;
using System.Windows.Forms;

namespace lsor
{
    /// <summary><para>class outline:</para>
    /// <para>タブページ表示管理出力制御クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[ver 1.0.0][2010/02/02][新規作成]</para>
    /// </remarks>
    public class TabPageManager
    {
        #region プライベートクラス

        /// <summary><para>class outline:</para>
        /// <para>タブページ表示管理プライベートクラス</para>
        /// </summary>
        /// <remarks><para>history:</para>
        /// <para>[ver 1.0.0][2010/02/02][新規作成]</para>
        /// </remarks>
        private class TabPageInfo
        {
            #region パブリック変数

            /// <summary>タブページ</summary>
            public TabPage TabPage;
            /// <summary>表示・非表示</summary>
            public bool Visible;

            #endregion

            #region コンストラクタ

            /// <summary><para>method outline:</para>
            /// <para>コンストラクタ</para>
            /// </summary>
            /// <example><para>usage:</para>
            /// <para>TabPageInfo csTabPageInfo = new TabPageInfo(page, v)</para>
            /// </example>
            /// <param name="page">タブページ</param>
            /// <param name="v">表示・非表示</param>
            /// <returns>タブページ表示管理プライベートクラス</returns>
            /// <exception cref="">無し</exception>
            /// <remarks><para>remarks:</para>
            /// <para>無し</para>
            /// </remarks>
            public TabPageInfo(TabPage page, bool v)
            {
                TabPage = page;
                Visible = v;
            }

            #endregion
        }

        #endregion

        #region プライベート変数

        /// <summary>タブページ情報</summary>
        private TabPageInfo[] _tabPageInfos = null;
        /// <summary>タブコントロール</summary>
        private TabControl _tabControl = null;

        #endregion

        #region コンストラクタ

        /// <summary><para>method outline:</para>
        /// <para>TabPageManagerクラスのインスタンスを作成する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>TabPageManager csTabPageManager = new TabPageManager(crl)</para>
        /// </example>
        /// <param name="crl">基になるTabControlオブジェクト</param>
        /// <returns>TabPageManagerクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public TabPageManager(TabControl crl)
        {
            this._tabControl = crl;
            this._tabPageInfos = new TabPageInfo[this._tabControl.TabPages.Count];
            for (int i = 0; i < this._tabControl.TabPages.Count; i++)
                this._tabPageInfos[i] =
                    new TabPageInfo(this._tabControl.TabPages[i], true);
        }

        #endregion

        #region パブリックメソッド

        /// <summary><para>method outline:</para>
        /// <para>TabPageの表示・非表示を変更する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>createResultKeyCols()</para>
        /// </example>
        /// <param name="index">変更するTabPageのIndex番号</param>
        /// <param name="v">表示するときはTrue。非表示にするときはFalse。</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void ChangeTabPageVisible(int index, bool v)
        {
            if (this._tabPageInfos[index].Visible == v)
                return;

            this._tabPageInfos[index].Visible = v;
            this._tabControl.SuspendLayout();
            this._tabControl.TabPages.Clear();
            for (int i = 0; i < this._tabPageInfos.Length; i++)
            {
                if (this._tabPageInfos[i].Visible)
                    this._tabControl.TabPages.Add(_tabPageInfos[i].TabPage);
            }
            this._tabControl.ResumeLayout();
        }

        #endregion
    }
}
