﻿/// <summary>
/// 列変更ダイアログ画面
/// </summary>
/// <create>2010/01/28</create>
/// <modifier></modifier>
/// <modify></modify>
/// <modification></modification>
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace lsor
{
    /// <summary><para>class outline:</para>
    /// <para>列変更ダイアログ画面出力制御クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[ver 1.0.0][2010/02/02][新規作成]</para>
    /// </remarks>
    public partial class DataColChg : Form
    {
        #region プライベート変数

        /// <summary>プロジェクト共通データ</summary>
        private CommonData _commonData = new CommonData();
        /// <summary>ファイルIDインデックス</summary>
        private int _fileIdx;
        /// <summary>列インデックス</summary>
        private int _columnIdx;

        #endregion

        #region プロパティ

        #region 項目名

        /// <summary><para>method outline:</para>
        /// <para>項目名を設定・取得する</para>
        /// </summary>
        /// <value>項目名</value>
        /// <example><para>usage:</para>
        /// <para>string strColumnNm = dlgDataColChg.ColumnNm()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string ColumnNm { get; set; }

        #endregion

        #region データ型

        /// <summary><para>method outline:</para>
        /// <para>データ型("char", "int", "double")を設定・取得する</para>
        /// </summary>
        /// <value>データ型("char", "int", "double")</value>
        /// <example><para>usage:</para>
        /// <para>string strDataType = dlgDataColChg.DataType()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string DataType { get; set; }

        #endregion

        #region 単位

        /// <summary><para>method outline:</para>
        /// <para>単位を設定・取得する</para>
        /// </summary>
        /// <value>単位</value>
        /// <example><para>usage:</para>
        /// <para>string strUnitType = dlgDataColChg.UnitType()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string UnitType { get; set; }

        #endregion

        #endregion

        #region コンストラクタ

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DataColChg csDataColChg = new DataColChg(commonData, fileIdx, columnIdx)</para>
        /// </example>
        /// <param name="commonData">共通データ</param>
        /// <param name="fileIdx">ファイルIDインデックス</param>
        /// <param name="columnIdx">列インデックス</param>
        /// <returns>列変更ダイアログ画面制御クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public DataColChg(CommonData commonData, int fileIdx, int columnIdx)
        {
            this._commonData = commonData;
            this._fileIdx = fileIdx;
            this._columnIdx = columnIdx;
            InitializeComponent();
        }
        #endregion

        #region イベントハンドラ

        #region 取消ボタン_Click

        /// <summary><para>method outline:</para>
        /// <para>取消ボタンクリック時の処理</para>
        /// </summary>
        /// <param name="sender">発生元オブジェクト</param>
        /// <param name="e">イベントの追加情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void cmdCancel_Click(object sender, EventArgs e)
        {
            // FormClosingで処理
            this.Close();
        }
        #endregion

        #region 追加ボタン_Click

        /// <summary><para>method outline:</para>
        /// <para>追加ボタンクリック時の処理</para>
        /// </summary>
        /// <param name="sender">発生元オブジェクト</param>
        /// <param name="e">イベントの追加情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void cmdAdd_Click(object sender, EventArgs e)
        {
            // FormClosingで処理
            this.Close();
        }
        #endregion

        #region フォームを閉じるときの処理

        /// <summary><para>method outline:</para>
        /// <para>フォームを閉じるときの処理</para>
        /// </summary>
        /// <param name="sender">発生元オブジェクト</param>
        /// <param name="e">イベントの追加情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DataColAdd_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (this.DialogResult == DialogResult.OK)
            {
                if (txtColumnNm.Text == "" || cboDataType.Text == "" || txtUnitType.Text == "")
                {
                    // メッセージ:未入力の項目があります。
                    MessageBox.Show(Properties.HySAddinLsor2VieweEXEResources.MSG_ERROR_ITEMS_NOT_ENTERED,
                        Properties.HySAddinLsor2VieweEXEResources.CAPTION_CHANGE_COLUMN,
                        MessageBoxButtons.OK, MessageBoxIcon.Error);
                    e.Cancel = true;
                    return;
                }
                else
                {
                    // 項目名の重複チェック
                    for (int i = 0; i < this._commonData.FileList[_fileIdx].ColumnList.Count; i++)
                    {
                        if (i != _columnIdx
                            && txtColumnNm.Text == this._commonData.FileList[_fileIdx].ColumnList[i].ColumnNm)
                        {
                            // 重複している
                            // メッセージ:項目名が重複しています。
                            MessageBox.Show(Properties.HySAddinLsor2VieweEXEResources.MSG_ERROR_DUPLICATE_ITEM_NAMES,
                                Properties.HySAddinLsor2VieweEXEResources.CAPTION_CHANGE_COLUMN,
                                MessageBoxButtons.OK, MessageBoxIcon.Error);
                            e.Cancel = true;
                            return;
                        }
                    }

                    this.ColumnNm = txtColumnNm.Text;
                    this.DataType = cboDataType.Text;
                    switch (cboDataType.SelectedIndex)
                    {
                        case 0:
                            this.DataType = "char";
                            break;
                        case 1:
                            this.DataType = "int";
                            break;
                        case 2:
                            this.DataType = "double";
                            break;
                        default:
                            break;
                    }
                    this.UnitType = txtUnitType.Text;
                }

            }
        }
        #endregion

        #region フォームロード時の処理

        /// <summary><para>method outline:</para>
        /// <para>フォームロード時の処理</para>
        /// </summary>
        /// <param name="sender">発生元オブジェクト</param>
        /// <param name="e">イベントの追加情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DataColAdd_Load(object sender, EventArgs e)
        {
            txtColumnNm.Text = this.ColumnNm;
            cboDataType.Text = this.DataType;
            txtUnitType.Text = this.UnitType;
            switch (this.DataType)
            {
                case "char":
                    cboDataType.SelectedIndex = 0;
                    break;
                case "int":
                    cboDataType.SelectedIndex = 1;
                    break;
                case "double":
                    cboDataType.SelectedIndex = 2;
                    break;
                default:
                    break;
            }
        }
        #endregion

        #endregion
    }
}
