﻿/// <summary>
/// 行追加ダイアログ画面
/// </summary>
/// <create>2010/01/28</create>
/// <modifier></modifier>
/// <modify></modify>
/// <modification></modification>
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace lsor
{
    /// <summary><para>class outline:</para>
    /// <para>行追加ダイアログ画面出力制御クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[ver 1.0.0][2010/02/02][新規作成]</para>
    /// </remarks>
    public partial class DataRowAdd : Form
    {
        #region プライベート変数

        /// <summary>プロジェクト共通データ</summary>
        private CommonData _commonData = new CommonData();

        #endregion

        #region プロパティ

        #region 河川名

        /// <summary><para>method outline:</para>
        /// <para>河川名を設定・取得する</para>
        /// </summary>
        /// <value>河川名</value>
        /// <example><para>usage:</para>
        /// <para>string strRiverNm = dlgDataRowAdd.RiverNm()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string RiverNm { get; set; }

        #endregion

        #region 断面No

        /// <summary><para>method outline:</para>
        /// <para>断面Noを設定・取得する</para>
        /// </summary>
        /// <value>断面No</value>
        /// <example><para>usage:</para>
        /// <para>string strSliceNo = dlgDataRowAdd.SliceNo()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string SliceNo { get; set; }

        #endregion

        #region 累加距離

        /// <summary><para>method outline:</para>
        /// <para>断面Noを設定・取得する</para>
        /// </summary>
        /// <value>断面No</value>
        /// <example><para>usage:</para>
        /// <para>string strSumDistance = dlgDataRowAdd.SumDistance()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string SumDistance { get; set; }

        #endregion

        #endregion

        #region コンストラクタ

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>DataRowAdd csDataRowAdd = new DataRowAdd(commonData)</para>
        /// </example>
        /// <param name="commonData">共通データ</param>
        /// <returns>行追加ダイアログ画面出力制御クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public DataRowAdd(CommonData commonData)
        {
            this._commonData = commonData;
            InitializeComponent();
        }
        #endregion

        #region イベントハンドラ

        /// <summary><para>method outline:</para>
        /// <para>取消ボタンクリック時の処理</para>
        /// </summary>
        /// <param name="sender">発生元オブジェクト</param>
        /// <param name="e">イベントの追加情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void cmdCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        /// <summary><para>method outline:</para>
        /// <para>追加ボタンクリック時の処理</para>
        /// </summary>
        /// <param name="sender">発生元オブジェクト</param>
        /// <param name="e">イベントの追加情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void cmdAdd_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        /// <summary><para>method outline:</para>
        /// <para>フォームを閉じるときの処理</para>
        /// </summary>
        /// <param name="sender">発生元オブジェクト</param>
        /// <param name="e">イベントの追加情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DataRowAdd_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (this.DialogResult == DialogResult.OK)
            {
                if (cboRiverNm.Text == "" || txtSliceNo.Text == "" || txtSumDistance.Text == "")
                {
                    // メッセージ:未入力の項目があります。
                    MessageBox.Show(Properties.HySAddinLsor2VieweEXEResources.MSG_ERROR_ITEMS_NOT_ENTERED,
                        Properties.HySAddinLsor2VieweEXEResources.CAPTION_ADDITION_ROW,
                        MessageBoxButtons.OK, MessageBoxIcon.Error);
                    e.Cancel = true;
                    return;
                }
                else
                {
                    try
                    {

                        this.RiverNm = cboRiverNm.Text;
                        this.SliceNo = txtSliceNo.Text;
                        this.SumDistance = double.Parse(txtSumDistance.Text).ToString();
                        this.SumDistance = txtSumDistance.Text;
                    }
                    catch
                    {
                        // メッセージ:累加距離は数値で入力してください。
                        MessageBox.Show(Properties.HySAddinLsor2VieweEXEResources.MSG_ERROR_CUMULATIVE_DISTANCE_IN_NUMBERS,
                            Properties.HySAddinLsor2VieweEXEResources.CAPTION_ADDITION_ROW,
                            MessageBoxButtons.OK, MessageBoxIcon.Error);
                        e.Cancel = true;
                        return;
                    }

                }

            }
        }

        /// <summary><para>method outline:</para>
        /// <para>フォームロード時の処理</para>
        /// </summary>
        /// <param name="sender">発生元オブジェクト</param>
        /// <param name="e">イベントの追加情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void DataRowAdd_Load(object sender, EventArgs e)
        {
            // コントロール初期化
            cboRiverNm.Text = "";
            txtSliceNo.Text = "";
            txtSumDistance.Text = "";

            cboRiverNm.Items.Clear();
            // コンボボックスに河川リストをセット
            for (int i = 0; i < this._commonData.RiverList.Count; i++)
            {
                cboRiverNm.Items.Add(this._commonData.RiverList[i].RiverNm);
            }
        }

        #endregion
    }
}
