﻿/// <summary>
/// 流下能力算定項目選択ダイアログ
/// </summary>
/// <create>2010/02/02</create>
/// <modifier></modifier>
/// <modify></modify>
/// <modification></modification>
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace lsor
{
    /// <summary><para>class outline:</para>
    /// <para>流下能力算定項目選択ダイアログ出力制御クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[ver 1.0.0][2010/02/02][新規作成]</para>
    /// </remarks>
    public partial class FlowSourceAdd : Form
    {
        #region プロパティ

        /// <summary><para>method outline:</para>
        /// <para>ファイルIDを設定・取得する</para>
        /// </summary>
        /// <value>ファイルID</value>
        /// <example><para>usage:</para>
        /// <para>string strFileId = dlgFlowSourceAdd.FileId()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string FileId { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>項目名Qを設定・取得する</para>
        /// </summary>
        /// <value>ファイルID</value>
        /// <example><para>usage:</para>
        /// <para>string strItemNameQ = dlgFlowSourceAdd.ItemNameQ()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string ItemNameQ { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>項目名Hを設定・取得する</para>
        /// </summary>
        /// <value>ファイルID</value>
        /// <example><para>usage:</para>
        /// <para>string strItemNameH = dlgFlowSourceAdd.ItemNameH()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string ItemNameH { get; set; }

        #endregion

        #region プライベートメンバ

        /// <summary>共通データ</summary>
        private CommonData _commonData;

        #endregion

        #region パブリックメンバ

        #endregion

        #region コンストラクタ

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>FlowSourceAdd csFlowSourceAdd = new FlowSourceAdd(commonData)</para>
        /// </example>
        /// <param name="commonData">共通データ</param>
        /// <returns>流下能力算定項目選択ダイアログ出力制御クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public FlowSourceAdd(CommonData commonData)
        {
            this._commonData = commonData;

            InitializeComponent();
        }

        #endregion

        #region プライベートメソッド

        /// <summary><para>method outline:</para>
        /// <para>ファイルIDリストを更新する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>updateFileIdList()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void updateFileIdList()
        {
            cboFileID.Items.Clear();

            string[] fileId = Util.GetFileIdList(this._commonData);
            if (fileId != null && fileId.Length > 0)
            {
                for (int n = 0; n < fileId.Length; n++)
                {
                    cboFileID.Items.Add(fileId[n]);
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>項目名リストを更新する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>updateItemNameList()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void updateItemNameList()
        {
            cboItemNameQ.Items.Clear();
            cboItemNameH.Items.Clear();

            string[] itemName = Util.GetItemNameList(this._commonData, cboFileID.Text);
            if (itemName != null && itemName.Length > 0)
            {
                for (int n = 0; n < itemName.Length; n++)
                {
                    cboItemNameQ.Items.Add(itemName[n]);
                    cboItemNameH.Items.Add(itemName[n]);
                }
            }
        }

        #endregion

        #region イベントハンドラ

        /// <summary><para>method outline:</para>
        /// <para>閉じるボタンクリック時の処理</para>
        /// </summary>
        /// <param name="sender">発生元オブジェクト</param>
        /// <param name="e">イベントの追加情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void cmdCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        /// <summary><para>method outline:</para>
        /// <para>追加ボタンクリック時の処理</para>
        /// </summary>
        /// <param name="sender">発生元オブジェクト</param>
        /// <param name="e">イベントの追加情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void cmdAdd_Click(object sender, EventArgs e)
        {
            this.Close();   // FormClosingで処理
        }

        /// <summary><para>method outline:</para>
        /// <para>追加ダイアログロード時の処理</para>
        /// </summary>
        /// <param name="sender">発生元オブジェクト</param>
        /// <param name="e">イベントの追加情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void GraphPropAdd_Load(object sender, EventArgs e)
        {
            this.FileId = "";
            this.ItemNameQ = "";
            this.ItemNameH = "";

            updateFileIdList();
        }

        /// <summary><para>method outline:</para>
        /// <para>ファイルIDコンボボックス変更時の処理</para>
        /// </summary>
        /// <param name="sender">発生元オブジェクト</param>
        /// <param name="e">イベントの追加情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void cboFileID_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (cboFileID.SelectedIndex >= 0)
            {
                updateItemNameList();
                cboItemNameQ.Enabled = true;
                cboItemNameH.Enabled = true;
            }
            else
            {
                cboItemNameQ.Items.Clear();
                cboItemNameQ.Enabled = false;
                cboItemNameH.Items.Clear();
                cboItemNameH.Enabled = false;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>追加ダイアログを閉じるときの処理</para>
        /// </summary>
        /// <param name="sender">発生元オブジェクト</param>
        /// <param name="e">イベントの追加情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void FlowSourceAdd_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (this.DialogResult == DialogResult.OK)
            {
                if (cboFileID.SelectedIndex < 0 || cboFileID.SelectedIndex >= cboFileID.Items.Count)
                {
                    // メッセージ:ファイルIDを選択してください。
                    MessageBox.Show(Properties.HySAddinLsor2VieweEXEResources.MSG_ERROR_CHOOSE_FILE_ID,
                        Properties.HySAddinLsor2VieweEXEResources.CAPTION_INPUT_VALIDATION,
                        MessageBoxButtons.OK, MessageBoxIcon.Error);
                    e.Cancel = true;
                    return;
                }
                if (cboItemNameQ.SelectedIndex < 0 || cboItemNameQ.SelectedIndex >= cboItemNameQ.Items.Count)
                {
                    // メッセージ:項目名（流量）を選択してください。
                    MessageBox.Show(Properties.HySAddinLsor2VieweEXEResources.MSG_ERROR_SELECT_DISCHARGE_ITEM_NAME,
                        Properties.HySAddinLsor2VieweEXEResources.CAPTION_INPUT_VALIDATION,
                        MessageBoxButtons.OK, MessageBoxIcon.Error);
                    e.Cancel = true;
                    return;
                }
                if (cboItemNameH.SelectedIndex < 0 || cboItemNameH.SelectedIndex >= cboItemNameH.Items.Count)
                {
                    // メッセージ:項目名（水位）を選択してください。
                    MessageBox.Show(Properties.HySAddinLsor2VieweEXEResources.MSG_ERROR_SELECT_WATER_LEVEL_ITEM_NAME,
                        Properties.HySAddinLsor2VieweEXEResources.CAPTION_INPUT_VALIDATION,
                        MessageBoxButtons.OK, MessageBoxIcon.Error);
                    e.Cancel = true;
                    return;
                }
                this.FileId = cboFileID.Text;
                this.ItemNameQ = cboItemNameQ.Text;
                this.ItemNameH = cboItemNameH.Text;
            }
        }

        #endregion
    }
}
