﻿/// <summary>
/// データ系列追加画面
/// </summary>
/// <create>2010/01/26</create>
/// <modifier></modifier>
/// <modify></modify>
/// <modification></modification>
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace lsor
{
    /// <summary><para>class outline:</para>
    /// <para>データ系列追加画面出力制御クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[ver 1.0.0][2010/02/02][新規作成]</para>
    /// </remarks>
    public partial class GraphPropAdd : Form
    {
        #region プロパティ

        /// <summary><para>method outline:</para>
        /// <para>ファイルIDを設定・取得する</para>
        /// </summary>
        /// <value>ファイルID</value>
        /// <example><para>usage:</para>
        /// <para>string strFileId = dlgGraphPropAdd.FileId()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string FileId { get; set; }

        /// <summary><para>method outline:</para>
        /// <para>項目名を設定・取得する</para>
        /// </summary>
        /// <value>項目名</value>
        /// <example><para>usage:</para>
        /// <para>string strItemName = dlgGraphPropAdd.ItemName()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string ItemName { get; set; }

        #endregion

        #region プライベートメンバ変数

        /// <summary>プロジェクト共通データ</summary>
        private CommonData _commonData;

        #endregion

        #region コンストラクタ

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GraphPropAdd csGraphPropAdd = new GraphPropAdd(commonData)</para>
        /// </example>
        /// <param name="commonData">共通データ</param>
        /// <returns>データ系列追加画面出力制御クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public GraphPropAdd(CommonData commonData)
        {
            _commonData = commonData;

            InitializeComponent();
        }

        #endregion

        #region プライベートメソッド

        #region ファイルIDの更新

        /// <summary><para>method outline:</para>
        /// <para>有効なファイルIDの一覧を取得してファイルIDリストを更新する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>updateFileIdList()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void updateFileIdList()
        {
            // 「ファイルID」コンボをクリア
            cboFileID.Items.Clear();

            // 共通データから「ファイルID」のリストを取得してセット
            string[] fileId = Util.GetFileIdList(_commonData);
            if (fileId != null && fileId.Length > 0)
            {
                for (int n = 0; n < fileId.Length; n++)
                {
                    cboFileID.Items.Add(fileId[n]);
                }
            }
        }

        #endregion

        #region 項目名の更新

        /// <summary><para>method outline:</para>
        /// <para>選択中のファイルIDに応じて項目名リストを更新する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>updateItemNameList()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void updateItemNameList()
        {
            // 「項目名」のコンボをクリア
            cboItemName.Items.Clear();

            // 共通データから「ファイルID」に含まれる「項目名」のリストを取得してセット
            string[] itemName = Util.GetItemNameList(_commonData, cboFileID.Text);
            if (itemName != null && itemName.Length > 0)
            {
                for (int n = 0; n < itemName.Length; n++)
                {
                    cboItemName.Items.Add(itemName[n]);
                }
            }
        }

        #endregion

        #endregion

        #region イベントメソッド

        #region [取消]ボタン押下時

        /// <summary><para>method outline:</para>
        /// <para>「取消」ボタンクリック時の処理</para>
        /// </summary>
        /// <param name="sender">発生元オブジェクト</param>
        /// <param name="e">イベントの追加情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void cmdCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        #endregion

        #region [追加]ボタン押下時

        /// <summary><para>method outline:</para>
        /// <para>「追加」ボタンクリック時の処理</para>
        /// </summary>
        /// <param name="sender">発生元オブジェクト</param>
        /// <param name="e">イベントの追加情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void cmdAdd_Click(object sender, EventArgs e)
        {
            this.Close();   // 入力値のチェックはFormClosingイベントで処理
        }

        #endregion

        #region フォームロード時

        /// <summary><para>method outline:</para>
        /// <para>フォームロード時の処理</para>
        /// </summary>
        /// <param name="sender">発生元オブジェクト</param>
        /// <param name="e">イベントの追加情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void GraphPropAdd_Load(object sender, EventArgs e)
        {
            // プロパティのクリア
            this.FileId = "";
            this.ItemName = "";

            // 「ファイルID」コンボの更新
            updateFileIdList();
        }

        #endregion

        #region 「ファイルID」コンボ更新時

        /// <summary><para>method outline:</para>
        /// <para>ファイルIDリスト更新時の処理</para>
        /// </summary>
        /// <param name="sender">発生元オブジェクト</param>
        /// <param name="e">イベントの追加情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void cboFileID_SelectedIndexChanged(object sender, EventArgs e)
        {
            // 「ファイルID」が選択された
            if (cboFileID.SelectedIndex >= 0)
            {
                // 「項目名」コンボを更新
                updateItemNameList();
                // 「項目名」コンボを編集可能に
                cboItemName.Enabled = true;
            }
            else
            {
                // 「項目名」コンボのクリア
                cboItemName.Items.Clear();
                // 「項目名」コンボを編集不可に
                cboItemName.Enabled = false;
            }
        }

        #endregion

        #region フォームクローズ直前時

        /// <summary><para>method outline:</para>
        /// <para>フォームクローズ直前の処理</para>
        /// </summary>
        /// <param name="sender">発生元オブジェクト</param>
        /// <param name="e">イベントの追加情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void GraphPropAdd_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (this.DialogResult == DialogResult.OK)
            {
                // 「ファイルID」のチェック
                if (cboFileID.SelectedIndex < 0 || cboFileID.SelectedIndex >= cboFileID.Items.Count)
                {
                    // メッセージ:ファイルIDを選択してください。
                    MessageBox.Show(Properties.HySAddinLsor2VieweEXEResources.MSG_ERROR_CHOOSE_FILE_ID,
                        Properties.HySAddinLsor2VieweEXEResources.CAPTION_ADDING_DATA_SERIES);
                    e.Cancel = true;
                    return;
                }
                // 「項目名」のチェック
                if (cboItemName.SelectedIndex < 0 || cboItemName.SelectedIndex >= cboItemName.Items.Count)
                {
                    // メッセージ:項目名を選択してください。
                    MessageBox.Show(Properties.HySAddinLsor2VieweEXEResources.MSG_ERROR_SELECT_ITEM_NAME,
                        Properties.HySAddinLsor2VieweEXEResources.CAPTION_ADDING_DATA_SERIES);
                    e.Cancel = true;
                    return;
                }

                // プロパティを更新
                this.FileId = cboFileID.Text;
                this.ItemName = cboItemName.Text;
            }
        }

        #endregion

        #endregion
    }
}
