﻿/// <summary>
/// 表示設定画面
/// </summary>
/// <create>2010/01/26</create>
/// <modifier></modifier>
/// <modify></modify>
/// <modification></modification>
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace lsor
{
    /// <summary><para>class outline:</para>
    /// <para>表示設定画面出力制御クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[ver 1.0.0][2010/02/02][新規作成]</para>
    /// </remarks>
    public partial class GraphSetting : Form
    {
        #region プロパティ

        /// <summary><para>method outline:</para>
        /// <para>河川名を設定・取得する</para>
        /// </summary>
        /// <value>河川名</value>
        /// <example><para>usage:</para>
        /// <para>string strRiver = dlgGraphSetting.CurrentRiver()</para>
        /// </example>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public string CurrentRiver { get; set; }

        #endregion

        #region プライベートメンバ変数

        /// <summary>プロジェクト共通データ</summary>
        private CommonData _commonData;

        #endregion

        #region コンストラクタ

        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>GraphSetting csGraphSetting = new GraphSetting(commonData)</para>
        /// </example>
        /// <param name="commonData">共通データ</param>
        /// <returns>表示設定画面出力制御クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public GraphSetting(CommonData commonData)
        {
            _commonData = commonData;
            if (_commonData == null)
            {
                _commonData = new CommonData();
            }

            InitializeComponent();
        }

        #endregion

        #region プライベートメソッド

        #region 表示設定の保存

        /// <summary><para>method outline:</para>
        /// <para>表示設定を共通データに書き込む処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SaveSettings()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private bool SaveSettings()
        {
            bool bExchange;

            // 河川データの取得
            RiverData rd = Util.GetRiverData(_commonData, this.CurrentRiver);
            if (rd == null)
            {
                // メッセージ:河川データが見つかりません。
                MessageBox.Show(Properties.HySAddinLsor2VieweEXEResources.MSG_ERROR_NOT_FIND_RIVER_DATA,
                    Properties.HySAddinLsor2VieweEXEResources.CAPTION_DISPLAY_SETTING);
                return (false);
            }

            // 保存用表示設定の生成
            GraphSettingData s = new GraphSettingData();

            // タイトル
            s.Title = txtTitle.Text;

            // X軸設定
            if (!Util.IsBlank(txtMinX.Text) && !Util.IsDouble(txtMinX.Text))
            {
                // メッセージ:X軸:開始の値が無効です。
                MessageBox.Show(Properties.HySAddinLsor2VieweEXEResources.MSG_ERROR_X_AXIS_START_VALUE_NOT_VALID);
                return (false);
            }
            if (!Util.IsBlank(txtMaxX.Text) && !Util.IsDouble(txtMaxX.Text))
            {
                // メッセージ:X軸:終了の値が無効です。
                MessageBox.Show(Properties.HySAddinLsor2VieweEXEResources.MSG_ERROR_X_AXIS_END_VALUE_NOT_VALID);
                return (false);
            }
            if (!chkAutoX.Checked && Util.IsBlank(txtMinX.Text))
            {
                // メッセージ:自動スケールでない場合はX軸:開始に値を入力してください。
                MessageBox.Show(Properties.HySAddinLsor2VieweEXEResources.MSG_ERROR_INPUT_X_AXIS_START_VALUE);
                return (false);
            }
            if (!chkAutoX.Checked && Util.IsBlank(txtMaxX.Text))
            {
                // メッセージ:自動スケールでない場合はX軸:終了に値を入力してください。
                MessageBox.Show(Properties.HySAddinLsor2VieweEXEResources.MSG_ERROR_INPUT_X_AXIS_END_VALUE);
                return (false);
            }
            if (!Util.IsBlank(txtMinX.Text) && !Util.IsBlank(txtMaxX.Text)
             && double.Parse(txtMinX.Text) >= double.Parse(txtMaxX.Text))
            {
                bExchange = true;
            }
            else
            {
                bExchange = false;
            }
            s.X_AutoScaleFlg = chkAutoX.Checked;
            s.X_MinValue = bExchange ? Util.ToDoubleString(txtMaxX.Text) : Util.ToDoubleString(txtMinX.Text);
            s.X_MaxValue = bExchange ? Util.ToDoubleString(txtMinX.Text) : Util.ToDoubleString(txtMaxX.Text);
            s.X_UnitDispFlg = chkUnitX.Checked;
            s.X_ValueDispFlg = chkValueX.Checked;
            s.X_GridDispFlg = chkGridX.Checked;
            s.X_SliceNoDispFlg = chkSectionX.Checked;
            s.X_ReverseFlg = chkReverseX.Checked;

            // Y軸-左設定
            if (!Util.IsBlank(txtMinYL.Text) && !Util.IsDouble(txtMinYL.Text))
            {
                // メッセージ:Y軸-左:下限の値が無効です。
                MessageBox.Show(Properties.HySAddinLsor2VieweEXEResources.MSG_ERROR_Y_AXIS_LEFT_MINIMUM_VALUE_NOT_VALID);
                return (false);
            }
            if (!Util.IsBlank(txtMaxYL.Text) && !Util.IsDouble(txtMaxYL.Text))
            {
                // メッセージ:Y軸-左:上限の値が無効です。
                MessageBox.Show(Properties.HySAddinLsor2VieweEXEResources.MSG_ERROR_Y_AXIS_LEFT_MAXIMUM_VALUE_NOT_VALID);
                return (false);
            }
            if (!chkAutoYL.Checked && Util.IsBlank(txtMinYL.Text))
            {
                // メッセージ:自動スケールでない場合はY軸-左:下限に値を入力してください。
                MessageBox.Show(Properties.HySAddinLsor2VieweEXEResources.MSG_ERROR_INPUT_Y_AXIS_LEFT_MINIMUM_VALUE);
                return (false);
            }
            if (!chkAutoYL.Checked && Util.IsBlank(txtMaxYL.Text))
            {
                // メッセージ:自動スケールでない場合はY軸-左:上限に値を入力してください。
                MessageBox.Show(Properties.HySAddinLsor2VieweEXEResources.MSG_ERROR_INPUT_Y_AXIS_LEFT_MAXIMUM_VALUE);
                return (false);
            }
            if (!Util.IsBlank(txtMinYL.Text) && !Util.IsBlank(txtMaxYL.Text)
             && double.Parse(txtMinYL.Text) >= double.Parse(txtMaxYL.Text))
            {
                bExchange = true;
            }
            else
            {
                bExchange = false;
            }
            s.YL_AutoScaleFlg = chkAutoYL.Checked;
            s.YL_MaxValue = bExchange ? Util.ToDoubleString(txtMinYL.Text) : Util.ToDoubleString(txtMaxYL.Text);
            s.YL_MinValue = bExchange ? Util.ToDoubleString(txtMaxYL.Text) : Util.ToDoubleString(txtMinYL.Text);
            s.YL_UnitType = txtUnitYL.Text;
            s.YL_ValueDispFlg = chkValueYL.Checked;
            s.Y_GridDispFlg = chkGridYL.Checked;

            // Y軸-右設定
            if (!Util.IsBlank(txtMinYR.Text) && !Util.IsDouble(txtMinYR.Text))
            {
                // メッセージ:Y軸-右:下限の値が無効です。
                MessageBox.Show(Properties.HySAddinLsor2VieweEXEResources.MSG_ERROR_Y_AXIS_RIGHT_MINIMUM_VALUE_NOT_VALID);
                return (false);
            }
            if (!Util.IsBlank(txtMaxYR.Text) && !Util.IsDouble(txtMaxYR.Text))
            {
                // メッセージ:Y軸-右:上限の値が無効です。
                MessageBox.Show(Properties.HySAddinLsor2VieweEXEResources.MSG_ERROR_Y_AXIS_RIGHT_MAXIMUM_VALUE_NOT_VALID);
                return (false);
            }
            if (!chkAutoYR.Checked && Util.IsBlank(txtMinYR.Text))
            {
                // メッセージ:自動スケールでない場合はY軸-右:下限に値を入力してください。
                MessageBox.Show(Properties.HySAddinLsor2VieweEXEResources.MSG_ERROR_INPUT_Y_AXIS_RIGHT_MINIMUM_VALUE);
                return (false);
            }
            if (!chkAutoYR.Checked && Util.IsBlank(txtMaxYR.Text))
            {
                // メッセージ:自動スケールでない場合はY軸-右:上限に値を入力してください。
                MessageBox.Show(Properties.HySAddinLsor2VieweEXEResources.MSG_ERROR_INPUT_Y_AXIS_RIGHT_MAXIMUM_VALUE);
                return (false);
            }
            if (!Util.IsBlank(txtMinYR.Text) && !Util.IsBlank(txtMaxYR.Text)
             && double.Parse(txtMinYR.Text) >= double.Parse(txtMaxYR.Text))
            {
                bExchange = true;
            }
            else
            {
                bExchange = false;
            }
            s.YR_AutoScaleFlg = chkAutoYR.Checked;
            s.YR_MaxValue = bExchange ? Util.ToDoubleString(txtMinYR.Text) : Util.ToDoubleString(txtMaxYR.Text);
            s.YR_MinValue = bExchange ? Util.ToDoubleString(txtMaxYR.Text) : Util.ToDoubleString(txtMinYR.Text);
            s.YR_UnitType = txtUnitYR.Text;
            s.YR_ValueDispFlg = chkValueYR.Checked;

            // 設定済み
            s.InitializeFlg = true;

            // 表示設定の書き込み
            rd.GraphSettingData = s;

            return (true);
        }

        #endregion

        #region 表示設定の読み込み

        /// <summary><para>method outline:</para>
        /// <para>表示設定を共通データから読み込む処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>LoadSettings()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void LoadSettings()
        {
            // 河川データの取得
            RiverData rd = Util.GetRiverData(_commonData, this.CurrentRiver);
            if (rd != null && rd.GraphSettingData != null && rd.GraphSettingData.InitializeFlg)
            {
                // 表示設定の取得
                GraphSettingData s = rd.GraphSettingData;

                // タイトル
                if (s.Title != null && s.Title.Length > 0)
                {
                    txtTitle.Text = s.Title;
                }

                // X軸設定
                chkAutoX.Checked = s.X_AutoScaleFlg;
                txtMinX.Text = Util.ToDoubleString(s.X_MinValue);
                txtMaxX.Text = Util.ToDoubleString(s.X_MaxValue);
                chkUnitX.Checked = s.X_UnitDispFlg;
                chkValueX.Checked = s.X_ValueDispFlg;
                chkGridX.Checked = s.X_GridDispFlg;
                chkSectionX.Checked = s.X_SliceNoDispFlg;
                chkReverseX.Checked = s.X_ReverseFlg;

                // Y軸-左設定
                chkAutoYL.Checked = s.YL_AutoScaleFlg;
                txtMaxYL.Text = Util.ToDoubleString(s.YL_MaxValue);
                txtMinYL.Text = Util.ToDoubleString(s.YL_MinValue);
                txtUnitYL.Text = s.YL_UnitType;
                chkValueYL.Checked = s.YL_ValueDispFlg;
                chkGridYL.Checked = s.Y_GridDispFlg;

                // Y軸-右設定
                chkAutoYR.Checked = s.YR_AutoScaleFlg;
                txtMaxYR.Text = Util.ToDoubleString(s.YR_MaxValue);
                txtMinYR.Text = Util.ToDoubleString(s.YR_MinValue);
                txtUnitYR.Text = s.YR_UnitType;
                chkValueYR.Checked = s.YR_ValueDispFlg;
            }
        }

        #endregion

        #endregion

        #region イベントメソッド

        #region [取消]ボタン押下時

        /// <summary><para>method outline:</para>
        /// <para>[取消]ボタンクリック時の処理</para>
        /// </summary>
        /// <param name="sender">発生元オブジェクト</param>
        /// <param name="e">イベントの追加情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void cmdCancel_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        #endregion

        #region [適用]ボタン押下時

        /// <summary><para>method outline:</para>
        /// <para>[適用]ボタンクリック時の処理</para>
        /// </summary>
        /// <param name="sender">発生元オブジェクト</param>
        /// <param name="e">イベントの追加情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void cmdSubmit_Click(object sender, EventArgs e)
        {
            this.Close();   // 入力値のチェックはFormClosingイベントで処理
        }

        #endregion

        #region フォームロード時

        /// <summary><para>method outline:</para>
        /// <para>フォームロード時の処理</para>
        /// </summary>
        /// <param name="sender">発生元オブジェクト</param>
        /// <param name="e">イベントの追加情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void GraphSetting_Load(object sender, EventArgs e)
        {
            // 設定の読み込み
            LoadSettings();
        }

        #endregion

        #region フォームクローズ直前

        /// <summary><para>method outline:</para>
        /// <para>フォームクローズ直前の処理</para>
        /// </summary>
        /// <param name="sender">発生元オブジェクト</param>
        /// <param name="e">イベントの追加情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void GraphSetting_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (this.DialogResult == DialogResult.OK)
            {
                if (SaveSettings() == false)
                {
                    e.Cancel = true;
                }
            }
        }

        #endregion

        #endregion
    }
}
