﻿// <summary>ソースコード：ツールのパッケージ化　ツール出力情報クラス</summary>
// <author>CommonMP</author>

using System;
using System.Collections.Generic;
using System.Text;

using CommonMP.HYSSOP.CoreImpl.HSData;

namespace CommonMP.HYSSOP.OptionImpl.HySToolExport
{
    /// <summary><para>class outline:</para>
    /// <para>パッケージ出力　ツール出力情報クラス</para>
    /// </summary>
    /// <remarks><para>remarks:</para>
    /// <para>無し</para>
    /// </remarks>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.3.0][2012/12/10][新規作成]</para>
    /// </remarks>
    public class HySToolExportInfo
    {
        /// <summary>プロジェクトフォルダ名</summary>
        private HySString m_csProjectFolderFullPath = null;
        /// <summary>ツール出力先パス</summary>
        private HySString m_csToolExportFullPath = null;
        /// <summary>開発コード出力要否</summary>
        private bool m_bIsOutputSourceCode = false;
        /// <summary>ツールプロジェクト実行形式ファイルパスリスト</summary>
        private HySDataLinkedList m_csBinaryFullPathList = null;
        /// <summary>ツールアイコンパスリスト</summary>
        private HySDataLinkedList m_csToolIconFullPathList = null;
        /// <summary>ツール解説書ファイルパスリスト</summary>
        private HySDataLinkedList m_csManualFullPathList = null;
        /// <summary>ツールプロジェクト開発コードファイルパスリスト</summary>
        private HySDataLinkedList m_csDevSrcFullPathList = null;


        /// <summary><para>method outline:</para>
        /// <para>コンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HySToolExportInfo csExportInfo = new HySToolExportInfo(csProjectFolderFullPath, csExportFullpath, csBinaryFullPathList, csToolIconFullpathList)</para>
        /// </example>
        /// <param name="csProjectFolderFullPath">プロジェクトフォルダ名</param>
        /// <param name="csExportFullpath">アーカイブ出力先パス</param>
        /// <param name="csBinaryFullPathList">実行形式ファイルパスリスト</param>
        /// <param name="csToolIconFullpathList">ツールアイコンファイルパスリスト</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySToolExportInfo(
            HySString csProjectFolderFullPath,
            HySString csExportFullpath,
            HySDataLinkedList csBinaryFullPathList,
            HySDataLinkedList csToolIconFullPathList
            )
        {
            m_csProjectFolderFullPath = csProjectFolderFullPath;

            m_csToolExportFullPath = csExportFullpath;

            m_csBinaryFullPathList = csBinaryFullPathList;

            m_csToolIconFullPathList = csToolIconFullPathList;
           
        }

        /// <summary><para>method outline:</para>
        /// <para>プロジェクトフォルダ名取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csProjectFolderFullPath = GetProjectFolderFullpath() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns><para>プロジェクトフォルダ名</para></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetProjectFolderFullpath()
        {
            return m_csProjectFolderFullPath;
        }

        /// <summary><para>method outline:</para>
        /// <para>アーカイブファイルパス取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySString csExportFileFullpath = GetArchiveFileFullpath() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns><para>アーカイブ出力先パス</para></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySString GetArchiveFileFullpath()
        {
            return m_csToolExportFullPath;
        }

        /// <summary><para>method outline:</para>
        /// <para>開発コード出力要否設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetOutputSourceCode(bIsOutputSource)</para>
        /// </example>
        /// <param name="bIsOutputSource">開発コード出力要否</param>
        /// <returns><para>無し</para></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetOutputSourceCode(bool bIsOutputSource)
        {
            m_bIsOutputSourceCode = bIsOutputSource;
        }

        /// <summary><para>method outline:</para>
        /// <para>開発コード出力要否取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bIsOutputSource = GetOutputSourceCode() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns><para>開発コード出力要否</para></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public bool GetOutputSourceCode()
        {
            return m_bIsOutputSourceCode;
        }

        /// <summary><para>method outline:</para>
        /// <para>ツールプロジェクト実行形式ファイルパスリスト取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataLinkedList csBinaryPathList = GetBinaryFullpathList() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns><para>実行形式ファイルパスリスト</para></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDataLinkedList GetBinaryFullpathList()
        {
            return m_csBinaryFullPathList;
        }

        /// <summary><para>method outline:</para>
        /// <para>ツールアイコンパスリスト取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataLinkedList csToolIconPathList = GetToolIconFullpathList() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns><para>ツールアイコンパスリスト</para></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDataLinkedList GetToolIconFullpathList()
        {
            return m_csToolIconFullPathList;
        }

        /// <summary><para>method outline:</para>
        /// <para>ツール解説書ファイルパスリスト設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetManualFullpathList(csManualPathList)</para>
        /// </example>
        /// <param name="csManualPathList">ツール解説書ファイルパスリスト</param>
        /// <returns><para>無し</para></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetManualFullpathList(HySDataLinkedList csManualPathList)
        {
            m_csManualFullPathList = csManualPathList;
        }

        /// <summary><para>method outline:</para>
        /// <para>ツール解説書ファイルパスリスト取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataLinkedList csManualFullpathList = GetManualFullpathList() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns><para>ツール解説書ファイルパスリスト</para></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDataLinkedList GetManualFullPathList()
        {
            return m_csManualFullPathList;
        }

        /// <summary><para>method outline:</para>
        /// <para>ツールプロジェクト開発コードファイルパスリスト設定</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> SetDevelopmentSourceFullPathList(csDevSrcFullParhList)</para>
        /// </example>
        /// <param name="csDevSrcFullParhList">ツールプロジェクト開発コードファイルパスリスト</param>
        /// <returns><para>無し</para></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public void SetDevelopmentSourceFullPathList(HySDataLinkedList csDevSrcFullParhList)
        {
            m_csDevSrcFullPathList = csDevSrcFullParhList;
        }

        /// <summary><para>method outline:</para>
        /// <para>ツールプロジェクト開発コードファイルパスリスト取得</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySDataLinkedList csDevSrcFullpathList = GetDevelopmentSourceFullPathList() </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns><para>ツールプロジェクト開発コードファイルパスリスト</para></returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HySDataLinkedList GetDevelopmentSourceFullPathList()
        {
            return m_csDevSrcFullPathList;
        }
    }
}
