﻿// <summary>ソースコード：ツールのパッケージ化　ツールのパッケージ化画面起動クラス</summary>
// <author>CommonMP</author>

using System;
using System.Diagnostics;
using System.Windows.Forms;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace CommonMP.HYSSOP.OptionImpl.HySToolExport
{
    /// <summary><para>class outline:</para>
    /// <para>ツールのパッケージ化画面プロセス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.3.0][2012/12/10][新規作成]</para>
    /// </remarks>
    public class HySToolExportProgram
    {
        /// <summary><para>class outline:</para>
        /// <para>アプリケーションのメイン エントリ ポイントです。</para>
        /// </summary>
        /// <remarks><para>history:</para>
        /// <para>[CommonMP][ver 1.3.0][2012/12/10][新規作成]</para>
        /// </remarks>
        [STAThread]
        static void Main(string[] args)
        {
            int iRtn = 0;
            Process csThisProcess = Process.GetCurrentProcess();
            int iThisProcessId = csThisProcess.Id;

            // 同名プロセス一覧取得
            Process[] csProcesses = Process.GetProcessesByName(csThisProcess.ProcessName);
            // 二重起動チェックを行う
            if (csProcesses.Length <= 1)
            {
                // 起動されていない場合は起動する
                // 地域情報をTheadにセット
                System.Threading.Thread.CurrentThread.CurrentUICulture = System.Globalization.CultureInfo.CurrentCulture;

                Application.EnableVisualStyles();
                Application.SetCompatibleTextRenderingDefault(false);
                Application.Run(new HySToolExportForm());
            }

            System.Environment.Exit(iRtn);
        }

        /// <summary><para>method outline:</para>
        /// <para>スタートログ作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>StartLOG()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        static public void StartLOG()
        {
            string sLogName = HySEnvInf.GetHomeDirectory().ToString() + "\\log\\HySToolExport.log";

            HySFile csErrFile = new HySFile(sLogName);
            csErrFile.Delete();

            csErrFile.Open(HySFile.OPEN_MODE.CREATE_NEW, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.MK_DIR);
            csErrFile.WriteText(DateTime.Now.ToString() + " << ツールのパッケージ化画面起動 >>");
            csErrFile.Close();
        }

        /// <summary><para>method outline:</para>
        /// <para>エラーログ作成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>ErrorLOG()</para>
        /// </example>
        /// <param name="sClassNameAndMethodName">クラス及びメソッド名</param>
        /// <param name="sMsg">メッセージ</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        static public void ErrorLOG(string sClassNameAndMethodName, string sMsg)
        {
            DateTime csDatatime = DateTime.Now;
            string sLogName = HySEnvInf.GetHomeDirectory().ToString() + "\\log\\HySToolExport.log";

            HySFile csErrFile = new HySFile(sLogName);
            csErrFile.Open(HySFile.OPEN_MODE.APPEND, HySFile.READ_WRITE_MODE.WRITE, HySFile.DIRECTORY_MODE.NOT_MK_DIR);
            csErrFile.WriteText(csDatatime.ToString() + " <" + sClassNameAndMethodName + ">  " + sMsg);
            csErrFile.Close();
        }
    }
}
