﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;
using Microsoft.VisualBasic;
using Microsoft.VisualBasic.FileIO;

using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

namespace HysCSVCoverter
{
    /// <summary><para>class outline:</para>
    /// <para>ＣＳＶ時系列ファイル変換ツール</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][ver 1.6.0][2016/02/16][新規作成]</para>
    /// </remarks>
    public partial class HyssopBaseCSVCoverter : Form
    {
        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>HyssopBaseCSVCoverter csCoverter = new HyssopBaseCSVCoverter()</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HyssopBaseCSVCoverter()
        {
            InitializeComponent();

            // 初期設定処理
            init();
        }

        /// <summary><para>method outline:</para>
        /// <para>初期設定処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>init()</para>
        /// </example>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void init()
        {
            // アプリケーションホームディレクトリを設定
            HySIniFile csIniFile = null;
            DirectoryInfo csDi = Directory.GetParent(Directory.GetCurrentDirectory());
            HySString csPath = new HySString(csDi.ToString());

            HySString csIniPath = csPath + new HySString("\\conf\\") + new HySString("CommonMPData.ini");
            csIniFile = new HySIniFile(csIniPath);

            // 初期表示位置
            HySString csDataHome = csIniFile.GetValue(new HySString("DATAHOME"));

            if (Path.IsPathRooted(csDataHome.ToString()) == false)
            {
                // 相対パス
                csDataHome = csPath + "\\" + csDataHome;
            }

            textBox1.Text = Path.GetFullPath(csDataHome.ToString());
        }

        /// <summary><para>method outline</para>
        /// <para>「フォルダ参照」ボタンクリック時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.ButtonFolder.Click += new System.EventHandler(this.SelectFolder);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ButtonFolder_Click(object sender, EventArgs e)
        {
            // フォルダ参照画面作成
            FolderBrowserDialog csFolderBrowserDlg = new FolderBrowserDialog();

            // 画面設定
            csFolderBrowserDlg.Description = Properties.Resources.MSG_DATAFOLDER;
            csFolderBrowserDlg.ShowNewFolderButton = false;
            csFolderBrowserDlg.SelectedPath = textBox1.Text;

            // フォルダ参照画面表示
            if (csFolderBrowserDlg.ShowDialog(this) == DialogResult.OK)
            {
                textBox1.Text = csFolderBrowserDlg.SelectedPath;
            }
        }

        /// <summary><para>method outline</para>
        /// <para>「変換」ボタンクリック時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.ButtonConv.Click += new System.EventHandler(this.Cancel);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ButtonConv_Click(object sender, EventArgs e)
        {
            // メッセージ表示：ＣＳＶ時系列入力ファイルの英語化変換を行います。
            DialogResult result = MessageBox.Show(Properties.Resources.MSG_CONV1 + "\n" + Properties.Resources.MSG_CONV2,
                                                  Properties.Resources.MSG_CONV3, MessageBoxButtons.OKCancel, MessageBoxIcon.Information);

            if (result != DialogResult.OK)
            {
                return;
            }

            string[] sFiles = Directory.GetFiles(textBox1.Text);

            if (sFiles == null || sFiles.Length == 0)
            {
                // メッセージ表示：変換対象ファイルがありません。
                MessageBox.Show(Properties.Resources.ERROR_CONV1, Properties.Resources.ERROR_CONV2, MessageBoxButtons.OK, MessageBoxIcon.Error);
                return;
            }

            string sConvFile = "";

            for (int iLoop = 0; iLoop < sFiles.Length; iLoop++)
            {
                // ＣＳＶファイルフォーマット変換処理
                bool bRtn = ConvertCSVFile(sFiles[iLoop]);

                if (bRtn == true)
                {
                    sConvFile += Path.GetFileName(sFiles[iLoop]) + "\n";
                }
            }

            if (sConvFile.Length == 0)
            {
                // メッセージ表示：変換対象ファイルがありません。
                MessageBox.Show(Properties.Resources.ERROR_CONV1,
                                Properties.Resources.MSG_CONV3, MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
            else
            {
                // メッセージ表示：下記のファイルを変換しました。
                MessageBox.Show(Properties.Resources.MSG_CONV4 + "\n" + sConvFile,
                                Properties.Resources.MSG_CONV3, MessageBoxButtons.OK, MessageBoxIcon.Information);
            }
        }

        /// <summary><para>method outline</para>
        /// <para>「閉じる」ボタンクリック時処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.ButtonClose.Click += new System.EventHandler(this.Cancel);</para>
        /// </example>
        /// <param name="sender">object</param>
        /// <param name="e">Event</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private void ButtonClose_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        /// <summary><para>method outline</para>
        /// <para>ＣＳＶファイルフォーマット変換処理</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>this.ButtonClose.Click += new System.EventHandler(this.Cancel);</para>
        /// </example>
        /// <param name="sCsvFile">ＣＳＶファイル</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        private bool ConvertCSVFile(string sCsvFile)
        {
            if (sCsvFile.Length == 0)
            {
                return false;
            }

            string sCut = sCsvFile.Substring(sCsvFile.Length - 3);

            if (sCut.Equals("csv") == false)
            {
                return false;
            }

            // 変換元ファイル名称
            sCsvFile = sCsvFile.Substring(0, sCsvFile.Length - 4);

            string sOrgFile = sCsvFile + ".csv";
            string sCnvFile = sCsvFile + "_HysCSVCoverter.csv";

            try
            {
                // CSVファイルに書き込むときに使うEncoding
                System.Text.Encoding enc = System.Text.Encoding.GetEncoding("Shift_JIS");

                // 書き込むファイルを開く
                System.IO.StreamWriter sw = new System.IO.StreamWriter(sCnvFile, false, enc);

                TextFieldParser parser = new TextFieldParser(sOrgFile, System.Text.Encoding.GetEncoding("Shift_JIS"));

                // 区切り文字はコンマ
                parser.TextFieldType = FieldType.Delimited;
                parser.SetDelimiters(",");
                parser.TrimWhiteSpace = false;

                int line = 0;
                int col = 0;
                int iDataType = 0;

                while (!parser.EndOfData)
                {
                    ++line;
                    col = 0;
                    string[] row = parser.ReadFields(); // １行読み込み
                    string value = "";

                    // 配列rowの要素は読み込んだ行の各フィールドの値
                    foreach (string field in row)
                    {
                        ++col;
                        value = field;

                        if (line == 1 && col == 1)
                        {
                            if (field.Equals("HySCSVFileData") == true)
                            {
                                // １次元時系列
                                iDataType = 1;
                            }
                            if (field.Equals("HySCSVFileDim2Data") == true)
                            {
                                // ２次元時系列
                                iDataType = 2;
                            }
                            if (field.Equals("HySCSVFileDim3Data") == true)
                            {
                                // ３次元時系列
                                iDataType = 3;
                            }
                        }

                        // １、２、３次元時系列
                        if (line == 2 && col == 1 && (iDataType == 1 || iDataType == 2 || iDataType == 3))
                        {
                            value = "DataType";
                        }
                        if (line == 2 && col == 2 && (iDataType == 1 || iDataType == 2 || iDataType == 3))
                        {
                            value = "TimeSeries";
                        }

                        // ２、３次元時系列
                        if (line == 3 && col == 1 && (iDataType == 2 || iDataType == 3))
                        {
                            value = "Array";
                        }
                        if (line == 3 && col == 3 && (iDataType == 2 || iDataType == 3))
                        {
                            value = "x";
                        }

                        // ３次元時系列
                        if (line == 3 && col == 5 && iDataType == 3)
                        {
                            value = "x";
                        }

                        sw.Write(value);

                        if (col < row.Length)
                        {
                            sw.Write(',');
                        }
                    }
                    sw.Write("\r\n");
                }
                parser.Close();
                sw.Close();

                // 変換元ファイルを削除
                File.Delete(sOrgFile);
                File.Move(sCnvFile, sOrgFile);

                if (iDataType == 0)
                {
                    // 変換対象ファイルなし
                    return false;
                }
            }
            catch (Exception)
            {
                File.Delete(sCnvFile);
                return false;
            }

            return true;
        }
    }
}
