﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYMCO.CoreImpl.Data;


namespace CommonMP.HYMCO.Ocean.McOceanBaseModel
{
    /// <summary><para>class outline:</para>
    /// <para> 人間の行動 (HumanAct) モデル内演算中データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[2021/12/31][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    [Serializable]
    public class MzOceanHumanActCalInfo : MzOceanModelElementCalInfo
    {
        /// <summary> 人間の行為間隔  </summary>
        public double m_HmnActTimeSpan = 24 * 3600;


        /// <summary>要求O2</summary>
        public double m_HmnReqO2 = 0.0;
        /// <summary>受け取ったO2</summary>
        public double m_HmnRcvO2 = 0.0;

        /// <summary> 排出CO2</summary>
        public double m_HmnCO2Emission = 0.0;

        /// <summary> １日当たりの排出CO2 g/Day </summary>
        public double m_HmnCO2EmissionDay = 0.0;

        //-----------------------------------
        /// <summary>設備  [億円]</summary>
        public double m_Facility = 100.0;
        /// <summary>減価償却率 :年利(1～0) </summary>
        public double m_DepreciationRate = 0.03;

        /// <summary>累積：負債 [億円]</summary>
        public double m_Debt = 100.0;
        /// <summary>（負債と返却）利率:年利(1～0)</summary>
        public double m_DebtInterestRate = 0.03;
        /// <summary>累積：自己資本 [億円]</summary>
        public double m_CapitalStock = 0.0;
        /// <summary>自己手持ちキャッシュ [億円]</summary>
        public double m_Chash = 100.0;
        //------------ 物品売買用 ------------------
        // 例えば、原料の購入、製品の販売等
        /// <summary> 購入資材・原料  [ｔ]  製品を生産するために使用するもの</summary>
        public double m_Materials = 0;
        /// <summary> 購入資材・原料単価</summary>
        public double m_MaterialsUnitCost = 0;
        /// <summary> 製品の量  [ｔ] 生産したもの:売るもの</summary>
        public double m_dProduct = 0;
        /// <summary> 供給能力  [ｔ] </summary>
        public double m_dFeedCapability = 0;
        /// <summary> 購入・小売り単価 　　万円／小売り単位 </summary>
        public double m_dNowUnitCost = 1;
        /// <summary> 購買用意金 　　億円 </summary>
        public double m_dNowDealingChash = 0;
        /// <summary> 次回購入予定額 　　億円 </summary>
        public double m_dNextDealingChash = 0;



        public MzOceanHumanActCalInfo()
        {
        }

        public override void Clear()
        {
            base.Clear();
            m_HmnReqO2 = 0;
            m_HmnRcvO2 = 0;
            m_HmnCO2Emission =0;

            m_Facility = 0;
            //m_DepreciationRate = 0;

            m_CapitalStock = 0;
            m_Chash = 0;

            m_Debt = 0;

            m_dNowDealingChash = 0;
            m_dNextDealingChash = m_dNowDealingChash;
            m_Materials = 0;
            m_dFeedCapability = 0;
            m_dProduct = 0;

        }

        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別院スタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            MzOceanHumanActCalInfo csRtn = new MzOceanHumanActCalInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            base.CopyInfo(csOrgInfo);
            MzOceanHumanActCalInfo csOrgDt = (MzOceanHumanActCalInfo)csOrgInfo;

            m_Facility = csOrgDt.m_Facility;
            m_DepreciationRate = csOrgDt.m_DepreciationRate;
            m_CapitalStock = csOrgDt.m_CapitalStock;
            m_Chash = csOrgDt.m_Chash;

            m_Debt = csOrgDt.m_Debt;
            m_DebtInterestRate = csOrgDt.m_DebtInterestRate;

            m_Materials = csOrgDt.m_Materials;
            m_MaterialsUnitCost = csOrgDt.m_MaterialsUnitCost;
            m_dProduct = csOrgDt.m_dProduct;
            m_dNowUnitCost = csOrgDt.m_dNowUnitCost;
            m_dFeedCapability = csOrgDt.m_dFeedCapability;
            m_dNowDealingChash = csOrgDt.m_dNowDealingChash;
            m_dNextDealingChash = csOrgDt.m_dNextDealingChash;

           
            m_HmnActTimeSpan = csOrgDt.m_HmnActTimeSpan;
            m_HmnReqO2 = csOrgDt.m_HmnReqO2;
            m_HmnRcvO2 = csOrgDt.m_HmnRcvO2;
            m_HmnCO2Emission = csOrgDt.m_HmnCO2Emission;
            m_HmnCO2EmissionDay = csOrgDt.m_HmnCO2EmissionDay;

            return true;
        }
    }
}
