﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSTools;



namespace CommonMP.HYMCO.Ocean.McOceanBaseModel
{
    /// <summary><para>class outline:</para>
    /// <para> 海洋モデル共通定義クラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][2021/12/31][新規作成]</para>
    /// </remarks>
    public class MzOceanBaseDefine
    {
        //****************************
        //===== 海洋モデル用 定義 ========
        //****************************
        /// <summary>モデルファクトリ</summary>
        public static readonly HySID OCEANBASE_MODEL_LIB = new HySID("Mc.OcanBaseModel.Fctry");

        //--------------------------------
        //　モデル定義
        //--------------------------------
        /// <summary>ネクトン類（Nekton) （魚類含む）モデル種別</summary>
        public static readonly HySObjectKind NEKTONS_KIND = new HySObjectKind("Nektons_Mdl");
        /// <summary>ネクトン類（Nekton) （魚類含む）モデル名称</summary>
        public static readonly HySString NEKTONS_NAME = new HySString("ネクトン類");

        /// <summary>カイアシ類（Copepods) 動物プランクトンの一種：モデル種別</summary>
        public static readonly HySObjectKind COPEPODS_KIND = new HySObjectKind("copepods_Mdl");
        /// <summary>カイアシ類（Bacteria) 動物プランクトンの一種：モデル名称</summary>
        public static readonly HySString COPEPODS_NAME = new HySString("カイアシ類");

        /// <summary>動物プランクトン（Zpoplankton)＿複数＿モデル種別</summary>
        public static readonly HySObjectKind ZOOPLANKTONS_KIND = new HySObjectKind("Zpoplanktons_Mdl");
        /// <summary>動物プランクトン（Zpoplankton)＿複数＿モデル名称</summary>
        public static readonly HySString ZOOPLANKTONS_NAME = new HySString("動物プランクトン");

        /// <summary>植物プランクトン（Phytoplankton)＿複数＿モデル種別</summary>
        public static readonly HySObjectKind  PHYTOPLANKTONS_KIND = new HySObjectKind("Phytoplanktons_Mdl");
        /// <summary>植物プランクトン（Phytoplankton )＿複数＿モデル名称</summary>
        public static readonly HySString PHYTOPLANKTONS_NAME = new HySString("植物プランクトン");

        /// <summary>珪藻類プランクトン（Diatoms)＿複数＿モデル種別</summary>
        public static readonly HySObjectKind DIATOMS_KIND = new HySObjectKind("Diatoms_Mdl");
        /// <summary>珪藻類プランクトン（Diatoms )＿複数＿モデル名称</summary>
        public static readonly HySString DIATOMS_NAME = new HySString("珪藻類（Diatoms)");

        /// <summary>円石藻 えんせきそう（Coccolithales）＿モデル種別</summary>
        public static readonly HySObjectKind COCCOLITHALES_KIND = new HySObjectKind("Phytoplanktons_Mdl");
        /// <summary>円石藻 えんせきそう（Coccolithales）＿モデル名称</summary>
        public static readonly HySString COCCOLITHALES_NAME = new HySString("円石藻（Coccolithales）");


        /// <summary>細菌（Bacteria) モデル種別</summary>
        public static readonly HySObjectKind BACTERIA_KIND = new HySObjectKind("Bacteria_Mdl");
        /// <summary>細菌（Bacteria) モデル名称</summary>
        public static readonly HySString BACTERIA_NAME = new HySString("細菌");

        /// <summary>ウイルス（Virus) モデル種別</summary>
        public static readonly HySObjectKind VIRUS_KIND = new HySObjectKind("Virus_Mdl");
        /// <summary>ウイルス（Virus) モデル名称</summary>
        public static readonly HySString VIRUS_NAME = new HySString("ウイルス");

        /// <summary>栄養素（Nutrient) モデル種別</summary>
        public static readonly HySObjectKind FERTILIZER_KIND = new HySObjectKind("Fertilizer_Mdl");
        /// <summary>栄養素（Nutrient) モデル名称</summary>
        public static readonly HySString FERTILIZER_NAME = new HySString("養分(植物プランクトン用)");

        /// <summary>デトリタス（Detritus) モデル種別</summary>
        public static readonly HySObjectKind DETRITUS_KIND = new HySObjectKind("Detritus_Mdl");
        /// <summary>デトリタス（Detritus) モデル名称</summary>
        public static readonly HySString DETRITUS_NAME = new HySString("デトリタス");

            /// <summary>ミネラル（Mineral) モデル種別</summary>
            public static readonly HySObjectKind MINERAL_KIND = new HySObjectKind("Mineral_Mdl");
            /// <summary>ミネラル（Mineral) モデル名称</summary>
            public static readonly HySString MINERAL_NAME = new HySString("ミネラル");

        /// <summary>ガス（Gas) モデル種別</summary>
        public static readonly HySObjectKind DISSOLVE_GAS_KIND = new HySObjectKind("dissolveＧas_Mdl");
        /// <summary>ガス（Gas) モデル名称</summary>
        public static readonly HySString DISSOLVE_GAS_NAME = new HySString("溶融ガス(主にO2,CO2)");

            /// <summary>粒子状有機物（POM） モデル種別</summary>
            public static readonly HySObjectKind POM_KIND = new HySObjectKind("POM_Mdl");
            /// <summary>粒子状有機物（POM） モデル名称</summary>
            public static readonly HySString POM_NAME = new HySString("粒子状有機物（POM）");

            /// <summary>溶存有機物（DOM） モデル種別</summary>
            public static readonly HySObjectKind DOM_KIND = new HySObjectKind("DOM_Mdl");
            /// <summary>溶存有機物（DOM） モデル名称</summary>
            public static readonly HySString DOM_NAME = new HySString("溶存有機物（DOM）");

            /// <summary>粒子状無機物（Inorganic_Particulates_Mdl） モデル種別</summary>
            public static readonly HySObjectKind InO_PARTICULATES_KIND = new HySObjectKind("Inorganic_Particulates_Mdl");
            /// <summary>粒子状無機物（Inorganic_Particulates_Mdl） モデル名称</summary>
            public static readonly HySString InO_PARTICULATES_NAME = new HySString("粒子状無機物（Inorganic Particulates）");


        // ネクトン (nekton) は、水棲生物を生活様式で分類した1つである。遊泳生物。ネクトンの生活様式を遊泳性と呼ぶ。 プランクトンと共に、水底にも水面にも接さず水中に住み、漂泳生物にまとめられる。漂泳生物のうち水流に逆らって遊泳できるのがネクトン、ないのがプランクトンである。対して水底に住むのはベントス、水面上に住むのはニューストン（英語版）である。
        //魚類の大半、海獣類、頭足類の大半と一部の二枚貝、甲殻類の一部がネクトンに分類される。プランクトンやベントスと異なり、ネクトンは動物のみである。これらの一部は、成体はネクトンだが幼生の間はプランクトンとなる「一時プランクトン」である。ネクトンでも小型のものは、遊泳能力が比較的低くプランクトンに近い「マイクロネクトン」である。
        // Benthos ベントス　：　底生生物
        // nutrients(複数形)栄養物
        // デトライタス（英：Detritus）はデトリタスとも呼ばれ、デトリタス (Detritus) とは、生物遺体や生物由来の物質の破片や微生物の死骸、あるいはそれらの排泄物を起源とする微細な有機物粒子のことであり[1]、通常はその表面や内部に繁殖した微生物群集を伴う。
        // mineral 無機物、(栄養素としての)鉱物質、ミネラル
        // 粒子状有機物（POM）や溶存有機物（DOM）を経て，栄養塩に戻ってゆく

        //--------------------------------
        // 海洋　　　　全体／一部エリア
        //--------------------------------
        /// <summary>海の海域全体モデル種別</summary>
        public static readonly HySObjectKind OCEAN_OVERALL_KIND = new HySObjectKind("Ocean_Overall_Mdl");
        /// <summary>海の海域全体モデル名称</summary>
        public static readonly HySString OCEAN_OVERALL_NAME = new HySString("海洋全体面");

        /// <summary>海の地域１単位面(Ocean Column)モデル種別</summary>
        public static readonly HySObjectKind OCEAN_COLUMN_KIND = new HySObjectKind("Ocean_Column_Mdl");
        /// <summary>海の地域１単位面(Ocean Column)モデル名称</summary>
        public static readonly HySString OCEAN_COLUMN_NAME = new HySString("海洋の地域１単位面");

        //--------------------------------
        // 深度による分類
        //--------------------------------
        //海洋の層 Ocean layer
        /// <summary>大気圏（atmosphere) モデル種別</summary>
        public static readonly HySObjectKind ATMOSPHERE_KIND = new HySObjectKind("Atmosphere_Mdl");
        /// <summary>大気圏（atmosphere) モデル名称</summary>
        public static readonly HySString ATMOSPHERE_NAME = new HySString("大気圏");

            /// <summary>海面（sea surface) モデル種別</summary>
            public static readonly HySObjectKind SEA_SURFACE_KIND = new HySObjectKind("Sea_Surface_Mdl");
            /// <summary>海面（sea surface) モデル名称</summary>
            public static readonly HySString SEA_SURFACE_NAME = new HySString("海面");


        //------------------

        /// <summary>人間による施肥料 モデル種別</summary>
        public static readonly HySObjectKind HUMAN_FERTILIZER_KIND = new HySObjectKind("Human_FertilizerAction");
        /// <summary>人間による施肥料 モデル名称</summary>
        public static readonly HySString HUMAN_FERTILIZER_NAME = new HySString("海洋への施肥");

        /// <summary>人間による漁獲 モデル種別</summary>
        public static readonly HySObjectKind HUMAN_FISHING_KIND = new HySObjectKind("Human_Fishing_Mdl");
        /// <summary>人間による漁獲  モデル名称</summary>
        public static readonly HySString HUMAN_FISHING_NAME = new HySString("漁の捕獲");

        //------------------ 経済モデル ------------------------
        /// <summary>人間活動モデル種別</summary>
        public static readonly HySObjectKind HUMAN_EC_ACTION_KIND = new HySObjectKind("Human_ECAction");
        /// <summary>人間活動 モデル名称</summary>
        public static readonly HySString HUMAN_EC_ACTION_NAME = new HySString("人間の活動");
        /// <summary>洋上での人間活動モデル種別</summary>
        public static readonly HySObjectKind HUMAN_SEA_EC_ACTION_KIND = new HySObjectKind("Human_SEA_ECAction");
        /// <summary>洋上での人間活動 モデル名称</summary>
        public static readonly HySString HUMAN_SEA_EC_ACTION_NAME = new HySString("人間の活動（海洋関係）");

        /// <summary> C02排出調査　モデル種別</summary>
        public static readonly HySObjectKind CO2_RESEARCH_EMISSION_KIND = new HySObjectKind("Oz_Research_CO2Absorption");
        /// <summary> C02排出調査　モデル種別</summary>
        public static readonly HySString CO2_RESEARCH_EMISSION_NAME = new HySString("海洋でのCO2吸収調査");

        /// <summary>遠海洋開発事業者 モデル種別</summary>
        public static readonly HySObjectKind HUMAN_OCEAN_DEVELOP_KIND = new HySObjectKind("Human_Ocean_Developer");
        /// <summary>遠海洋開発事業者 モデル名称</summary>
        public static readonly HySString HUMAN_OCEAN_DEVELOP_NAME = new HySString("遠海洋開発事業者");

        /// <summary> 肥料工場 モデル種別</summary>
        public static readonly HySObjectKind HUMAN_FERTILIZZER_FACTORY_KIND = new HySObjectKind("FertilizerFactory_Mdl");
        /// <summary> 肥料工場 モデル名称</summary>
        public static readonly HySString HUMAN_FERTILIZZER_FACTORY_NAME = new HySString("肥料生産工場");
        /// <summary> バイオ燃料洋上プラント モデル種別</summary>
        public static readonly HySObjectKind HUMAN_BIOFUEL_FACTORY_KIND = new HySObjectKind("Bio-Fuel_Factory_Mdl");
        /// <summary> バイオ燃料洋上プラント モデル名称</summary>
        public static readonly HySString HUMAN_BIOFUEL_FACTORY_NAME = new HySString("バイオ燃料洋上プラント");

        /// <summary>社会 モデル種別</summary>
        public static readonly HySObjectKind HUMAN_JPN_SOCIETY_KIND = new HySObjectKind("JPN_Society");
        /// <summary>社会 モデル名称</summary>
        public static readonly HySString HUMAN_JPN_SOCIETY_NAME = new HySString("日本社会(海洋モデル上)");

        /// <summary>日本国 モデル種別</summary>
        public static readonly HySObjectKind JAPAN_KIND = new HySObjectKind("Mz_Japan");
        /// <summary>日本国 モデル名称</summary>
        public static readonly HySString JAPAN_NAME = new HySString("日本国");
        /// <summary>諸外国 モデル種別</summary>
        public static readonly HySObjectKind FOREIGN_COUNTRYS_KIND = new HySObjectKind("Mz_Foreign_Countrys");
        /// <summary>諸外国 モデル名称</summary>
        public static readonly HySString FOREIGN_COUNTRYS_NAME = new HySString("諸外国");


        //------------------ 分岐・合流 モデル ------------------------
        /// <summary> 分岐・合流 モデル種別</summary>
        public static readonly HySObjectKind BRANCH_CONFLUENT_KIND = new HySObjectKind("CmnBranchConfluentModel_Mdl");
        /// <summary> 分岐・合流 モデル名称</summary>
        public static readonly HySString BRANCH_CONFLUENTBRANCH_CONFLUENT_NAME = new HySString("分岐・合流");
        

        //------------------ 出力モデル ------------------------
        /// <summary> CSV_OUT モデル種別</summary>
        public static readonly HySObjectKind DEBUG_CSV_OUT_KIND = new HySObjectKind("CSV_OUT_Mdl");
        /// <summary> CSV_OUT モデル名称</summary>
        public static readonly HySString DEBUG_CSV_OUT_NAME = new HySString("海洋モデル(ﾃﾞｨﾊﾞｯｸﾞ用)ＣＳＶ出力");


        // 大気圏（たいきけん、英: atmosphere）
        // 海面（かいめん） sea surface  
        // 有光層 photic zone もしくは photic layer
        // 有光層の定義には広義のものと狭義のものとがある。広義の有光層は、生物が光を感じる限界（海面の 1/109 くらいの光強度）までの層を指す。一方狭義の有光層は、光合成生物の補償深度（海面の 1/102 くらいの光強度）以浅の層を指す。この層は真光層（euphotic zone、ギリシャ語で『よく光る』の意）と呼ばれる事もあり、真光層に含まれない微弱な光（光合成の収支を維持できない量の光）が到達する層を薄光層や透光層(disphotic zone)として呼び分ける。
        //    広義の有光層 ＝ 狭義の有光層（真光層）＋薄光層（透光層）
        // 無光層（むこうそう、aphotic zone）は、湖沼や海において太陽光の届かない領域のことである。

        //海面表層 海面から海面下200メートルまでの層
        //Epipelagic zone
        //中深層 海面下200メートルから1000メートルまでの層を指す  この層では、従属栄養性のバクテリアが最も多い[4]。この層に生息する主な魚介類はメカジキ、イカ、オオカミウオ科、コウイカなどである。
        //Mesopelagic zone
        //漸深層 海面下1000メートルから3000メートル（4000メートルとされることもある）付近までの層を指す。この深さ以上では、太陽光は全く届かず、アンコウのような生物発光をする生物の光以外は光がない。海洋植物は見られず、多くの動物種はは上層から沈降してくるマリンスノー等のデトリタスや他の生物などを捕食する。この層にいる他の主な生物には、ダイオウイカなどのイカやジュウモンジダコなどがいる。
        //Bathypelagic zone
        //深海層 海面下3000メートル（4000メートルとされることもある）から海底まで、または海溝等のより深い場所では6000メートル付近までの層を指す。この深さでは低温高圧で光がなく、生物数や生物種は非常に少ない
        //Abyssopelagic zone
        //超深海層
        //hadopelagic zone


        /// <summary>有光層：真光層（sea surface) モデル種別</summary>
        public static readonly HySObjectKind EUPHOTIC_ZONE_KIND = new HySObjectKind("euphotic_zone_Mdl");
        /// <summary>有光層：真光層（sea surface) モデル名称</summary>
        public static readonly HySString EUPHOTIC_ZONE_NAME = new HySString("真光層(有光層)");

        /// <summary>無光層（sea surface) モデル種別</summary>
        public static readonly HySObjectKind APHOTIC_ZONE_KIND = new HySObjectKind("aphotic_zone_Mdl");
        /// <summary>無光層（sea surface) モデル名称</summary>
        public static readonly HySString APHOTIC_ZONE_NAME = new HySString("真光層(有光層)");



        /// <summary>表層混合層(surface mixed layer) モデル種別</summary>
        public static readonly HySObjectKind SURFACE_ZONE_KIND = new HySObjectKind("Surface_Mixed_zone_Mdl");
        /// <summary>表層混合層(surface mixed layer) モデル名称</summary>
        public static readonly HySString SURFACE_ZONE_NAME = new HySString("表層混合層(surface mixed layer)");

        /// <summary>真光層（Epipelagic zone) モデル種別</summary>
        public static readonly HySObjectKind EPIPELAGIC_ZONE_KIND = new HySObjectKind("Epipelagic_zone_Mdl");
        /// <summary>真光層（Epipelagic zone) モデル名称</summary>
        public static readonly HySString EPIPELAGIC_ZONE_NAME = new HySString("真光層(euphotic zone)");

        /// <summary>透光層（disphotic zone) モデル種別</summary>
        public static readonly HySObjectKind DISPHOTIC_ZONE_KIND = new HySObjectKind("disphotic_zone_Mdl");
        /// <summary>透光層（disphotic zone) モデル名称</summary>
        public static readonly HySString DISPHOTIC_ZONE_NAME = new HySString("真光層(disphotic zone)");

        /// <summary>中深層（Mesopelagic zone) モデル種別</summary>
        public static readonly HySObjectKind MESOPELAGIC_ZONE_KIND = new HySObjectKind("Mesopelagic_zone_Mdl");
        /// <summary>中深層（Mesopelagic zone) モデル名称</summary>
        public static readonly HySString MESOPELAGIC_ZONE_NAME = new HySString("中深層（Mesopelagic zone)");

        /// <summary>漸深層（Bathypelagic zone) モデル種別</summary>
        public static readonly HySObjectKind BATHYPELAGIC_ZONE_KIND = new HySObjectKind("Bathypelagic_zone_Mdl");
        /// <summary>漸深層（Bathypelagic zone) モデル名称</summary>
        public static readonly HySString BATHYPELAGIC_ZONE_NAME = new HySString("漸深層（Bathypelagic zone)");

        /// <summary>深海層（Abyssopelagic zone) モデル種別</summary>
        public static readonly HySObjectKind ABYSSOPELAGIC_ZONE_KIND = new HySObjectKind("Abyssopelagic_zone_Mdl");
        /// <summary>深海層（Abyssopelagic zone) モデル名称</summary>
        public static readonly HySString ABYSSOPELAGIC_ZONE_NAME = new HySString("深海層（Abyssopelagic zone)");

        /// <summary>超深海層（hadopelagic zone) モデル種別</summary>
        public static readonly HySObjectKind HADOPELAGIC_ZONE_KIND = new HySObjectKind("hadopelagic_zone_Mdl");
        /// <summary>超深海層（hadopelagic zone) モデル名称</summary>
        public static readonly HySString PADOPELAGIC_ZONE_NAME = new HySString("超深海層");

        /// <summary>海底（hadopelagic zone) モデル種別</summary>
        public static readonly HySObjectKind BOTTOM_ZONE_KIND = new HySObjectKind("Bottom_zone_Mdl");
        /// <summary>海底（hadopelagic zone) モデル名称</summary>
        public static readonly HySString BOTTOM_ZONE_NAME = new HySString("海底");


        // 海洋表層  marine surface layer / ocean surface water
        // 中層水:    intermediate water   北太平洋中層水（North Pacific Intermediate Water）北太平洋ほぼ全域の300mから800mの深さに存在し、水平方向に一様な密度（26.8σθ）、塩分（33.9～34.0psu）、水温（6～７℃）を示す「水塊」
        // 海洋深層水  oceanic deep water    一般的には、太陽光が届かない水深200mより深いところにある海水のことを言います。
        // 底層水:   bottom water

        /// <summary>海底（Bottom) モデル種別</summary>
        public static readonly HySObjectKind BOTTOM_KIND = new HySObjectKind("Bottom_Mdl");
        /// <summary>海底（Bottom) モデル名称</summary>
        public static readonly HySString BOTTOM_NAME = new HySString("海底");

        //--------------------------------
        //--------------------------------
        // 物質循環接続名
        //--------------------------------
        //--------------------------------
        /// <summary></summary>
        public static int TransDataKindNum = 9;

        /// <summary>光合成による栄養吸収：植物プランクトン</summary>
        public static readonly HySID PHOTOSYNTHESIS = new HySID("Photosynthesis");
        public static readonly HySID PHOTOSYNTHESIS_F = new HySID("F)_Photosynthesis");
        public static readonly HySID PHOTOSYNTHESIS_B = new HySID("B)_Photosynthesis");
        /// <summary>光合成ＣＯ2吸収</summary>
        public static readonly HySID CO2_ABSORPTION = new HySID("Oz_CO2_absorption");
        public static readonly HySID CO2_ABSORPTION_F = new HySID("F)_Oz_CO2_absorption");
        public static readonly HySID CO2_ABSORPTION_B = new HySID("B)_Oz_CO2_absorption");
        /// <summary> バクテリアによる肥料成分生成 </summary>
        public static readonly HySID BCT_FERTILIZER = new HySID("Oz_Bct_fertilizer");
        /// <summary>気体の海洋への溶け込み</summary>
        public static readonly HySID GASS_DISSOLVE = new HySID("Oz_Gass_dissolve");
        /// <summary> 人間の施肥 </summary>
        public static readonly HySID HUMAN_FERTILIZER = new HySID("Oz_Humanfertilizer");
        /// <summary> 経済:人間の施肥 </summary>
        public static readonly HySID EC_HUMAN_FERTILIZER = new HySID("OzEC_Humanfertilizer");

        /// <summary>呼吸</summary>
        public static readonly HySID BREATHING = new HySID("Oz_Breathing");
        public static readonly HySID BREATHING_F = new HySID("F)_Oz_Breathing");
        public static readonly HySID BREATHING_B = new HySID("B)_Oz_Breathing");
        /// <summary>捕食</summary>
        public static readonly HySID PREDATION = new HySID("Oz_Predation");
        public static readonly HySID PREDATION_F = new HySID("F)_Oz_Predation");
        public static readonly HySID PREDATION_B = new HySID("B)_Oz_Predation");
        /// <summary>腐敗：decompose、消化：digestion</summary>
        public static readonly HySID DECOMPOSE = new HySID("Oz_decompose");
        public static readonly HySID DECOMPOSE_F = new HySID("F)Oz_decompose");
        public static readonly HySID DECOMPOSE_B = new HySID("B)Oz_decompose");
        /// <summary>排泄：excretion、または 死</summary>
        public static readonly HySID EXCRETION_DEATH = new HySID("Oz_excretion_Death"); 
        /// <summary>感染：infection</summary>
        public static readonly HySID INFECTION = new HySID("Oz_Infection");
        ///// <summary>死：death</summary>
        //public static readonly HySID DEATH = new HySID("Oz_Death");
 
        /// <summary>粒状有機／無機物　量 [g/m3]</summary>
        public static readonly HySID PARTICULATES = new HySID("Oz_Mass_Particulates");
        ///// <summary>ガス [g/m3]</summary>
        //public static readonly HySID GASS = new HySID("Oz_Gass_");

        /// <summary> 調査：C02吸収量 [t]</summary>
        public static readonly HySID RESEARCH_CO2_ABSORPTION = new HySID("Oz_Resarch_CO2_Absorption");

        /// <summary> C02排出　</summary>
        public static readonly HySID CO2_EMISSION = new HySID("Oz_CO2_Emission");

        /// <summary>キャッシュ  [G\] </summary>
        public static readonly HySID CHASH = new HySID("Oz_Cash");
        public static readonly HySID CHASH_F = new HySID("F)_Oz_Cash");
        public static readonly HySID CHASH_B = new HySID("B)_Oz_Cash");

        /// <summary>売買  </summary>
        public static readonly HySID DEALING = new HySID("Oz_Dealing");
        public static readonly HySID DEALING_F = new HySID("F)_Oz_Dealing");
        public static readonly HySID DEALING_B = new HySID("B)_Oz_Dealing");

        /// <summary> 生産品：Product  </summary>
        public static readonly HySID PRODUCT = new HySID("Oz_Product");
        public static readonly HySID PRODUCT_FISH = new HySID("Oz_Product_Fish");
        public static readonly HySID PRODUCT_FERTILIZER = new HySID("Oz_Product_Feritilizer");

        /// <summary>バイオ燃料  </summary>
        public static readonly HySID PRODUCT_BIO_FUEL = new HySID("Oz_Product_BioFuel");
        /// <summary>食品  </summary>
        public static readonly HySID PRODUCT_FOOD = new HySID("Oz_Product_Food");
        /// <summary>CO2排出権  </summary>
        public static readonly HySID CO2_EMISSION_CREDIT = new HySID("CO2_emission_credit");

        /// <summary>投資  </summary>
        public static readonly HySID SCINVESTMENT = new HySID("SC_investment");
        /// <summary>雇用  </summary>
        public static readonly HySID SC_EMPLOYMENT = new HySID("SC_Employment");
        /// <summary>税金  </summary>
        public static readonly HySID SC_TAX = new HySID("SC_Tax");

        /// <summary> 汎用データ  </summary>
        public static readonly HySID COMMON_DATA = new HySID("Oz_CommonData");
        public static readonly HySID F_COMMON_DATA = new HySID("F)_Oz_CommonData");
        public static readonly HySID B_COMMON_DATA = new HySID("B)_Oz_CommonData");

        /// <summary>ディバッグ用のIN/OUT</summary>
        public static readonly HySID DEBUG_OUT = new HySID("Oz_D1:Debug_OUT");
        //public static readonly HySID DEBUG_IN1 = new HySID("Oz_1D:Debug_IN");
        //public static readonly HySID DEBUG_IN2 = new HySID("Oz_2D:Debug_IN");

        //-------------------------------------
        /// <summary>粒状サイズ（分類）</summary>
        public static readonly int iPARTICLE_SIZE_NUM = 22;
    }

}
