﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.Interface.HSViewer;

using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;
using CommonMP.HYMCO.CoreImpl.Controller;
using CommonMP.HYMCO.Interface.Viewer;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;
using CommonMP.HYMCO.CoreImpl.Data.StructInfo;

using CommonMP.HYMCO.CoreImpl.Model;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYSSOP.CoreImpl.HSController;

using CommonMP.HYMCO.CoreOptionl.HymcoStandardModel;

using CommonMP.HYMCO._SYSTEM_;

namespace CommonMP.HYMCO._SYSTEM_
{
    /// <summary><para>class outline:</para>
    /// <para>海洋モデルファクトリ生成</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[CommonMP][2021/12/31][新規作成]</para>
    /// </remarks>
    public class HYMCO_MODEL_FACTORY_CREATOR_IMPLE : HYMCO_MODEL_FACTORY_CREATOR
    {
        /// <summary><para>method outline:</para>
        /// <para>コンストラクター</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HYMCO_MODEL_FACTORY_CREATOR_IMPLE csFactCrt = new HYMCO_MODEL_FACTORY_CREATOR_IMPLE( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>生成インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public HYMCO_MODEL_FACTORY_CREATOR_IMPLE()
        {
        }

        /// <summary><para>method outline:</para>
        /// <para>演算モデルファクトリクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McModelFactory csCalModelFactory = CreateFactory( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>演算モデルファクトリクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public CommonMP.HYMCO.Interface.Model.McModelFactory CreateFactory()
        {
            return new CommonMP.HYMCO.Ocean.McOceanBaseModel.MzOceanModelBaseFactory();
        }
   
    }
}


namespace CommonMP.HYMCO.Ocean.McOceanBaseModel
{

    /// <summary><para>class outline:</para>
    /// <para>モデルファクトリクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[2021/12/31][新規作成]</para>
    /// </remarks>
    public class MzOceanModelBaseFactory : McBasicModelFactoryBase
    {

        /// <summary><para>method outline:</para>
        /// <para>デフォルトコンストラクタ</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>McSampleModelFactory csFactory = new McSampleModelFactory()</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>インスタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public MzOceanModelBaseFactory()
        {
            McStructErrorInfo csChkInf = new McStructCheckData();

            //--------------------
            MzOceanAreaColumnModel OceanColumModel = new MzOceanAreaColumnModel();
            McCalInfo csMdlInf = this.CreateCalInfo(MzOceanBaseDefine.OCEAN_COLUMN_KIND);
            OceanColumModel.SetCalInfo(csMdlInf); // 演算データ積み込み
            McCellModelPropertyIF csMdlProperty = this.CreateModelProperty(MzOceanBaseDefine.OCEANBASE_MODEL_LIB, MzOceanBaseDefine.OCEAN_COLUMN_KIND);
            OceanColumModel.SetProperty(csMdlProperty, ref csChkInf);
            McPropertyInfoRoot csMdlInitty = this.CreateModelInitialInfo(MzOceanBaseDefine.OCEANBASE_MODEL_LIB, MzOceanBaseDefine.OCEAN_COLUMN_KIND);
            MzOceanModelElement.OceanColumModel = OceanColumModel;
            //OceanBaseModel.m_gOceanColumModel.Initialize

            //--------------------
            //MzOceanSeaSurfaceModel gOceanSurfaceModel = new MzOceanSeaSurfaceModel();
            //csMdlInf = this.CreateCalInfo(MzOceanBaseDefine.SEA_SURFACE_KIND);
            //gOceanSurfaceModel.SetCalInfo(csMdlInf); // 演算データ積み込み
            //csMdlProperty = this.CreateModelProperty(MzOceanBaseDefine.OCEANBASE_MODEL_LIB, MzOceanBaseDefine.SEA_SURFACE_KIND);
            //gOceanSurfaceModel.SetProperty(csMdlProperty, ref csChkInf);
            //csMdlInitty = this.CreateModelInitialInfo(MzOceanBaseDefine.OCEANBASE_MODEL_LIB, MzOceanBaseDefine.SEA_SURFACE_KIND);
            //MzOceanModelElement.OceanSurfaceModel = gOceanSurfaceModel;

            //--------------------
            MzOceanAtmosphere OceanAtmosphereModel = new MzOceanAtmosphere();
            csMdlInf = this.CreateCalInfo(MzOceanBaseDefine.ATMOSPHERE_KIND);
            OceanAtmosphereModel.SetCalInfo(csMdlInf); // 演算データ積み込み
            csMdlProperty = this.CreateModelProperty(MzOceanBaseDefine.OCEANBASE_MODEL_LIB, MzOceanBaseDefine.ATMOSPHERE_KIND);
            OceanAtmosphereModel.SetProperty(csMdlProperty, ref csChkInf);
            csMdlInitty = this.CreateModelInitialInfo(MzOceanBaseDefine.OCEANBASE_MODEL_LIB, MzOceanBaseDefine.ATMOSPHERE_KIND);
            MzOceanModelElement.OceanAtmosphereModel = OceanAtmosphereModel;

            ////--------------------
            //MzOceanDissolveGass OceanGassModel = new MzOceanDissolveGass();
            //csMdlInf = this.CreateCalInfo(MzOceanBaseDefine.DISSOLVE_GAS_KIND);
            //OceanGassModel.SetCalInfo(csMdlInf); // 演算データ積み込み
            //csMdlProperty = this.CreateModelProperty(MzOceanBaseDefine.OCEANBASE_MODEL_LIB, MzOceanBaseDefine.DISSOLVE_GAS_KIND);
            //OceanGassModel.SetProperty(csMdlProperty, ref csChkInf);
            //csMdlInitty = this.CreateModelInitialInfo(MzOceanBaseDefine.OCEANBASE_MODEL_LIB, MzOceanBaseDefine.DISSOLVE_GAS_KIND);
            //MzOceanModelElement.OceanGassModel = OceanGassModel;


        }


        /// <summary><para>method outline:</para>
        /// <para>ファクトリ識別子を生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> HySID csFactID = CreateFactoryID( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>ファクトリ識別子</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override HySID CreateFactoryID()
        {
            return MzOceanBaseDefine.OCEANBASE_MODEL_LIB;
        }

        /// <summary><para>method outline:</para>
        /// <para>演算モデルクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalModel csCalModel = CreateCalModel(csModelKind) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>演算モデルクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCalModel CreateCalModel(HySObjectKind csModelKind)
        {
            McCalModel csCalModel = null;
                       
            if (csModelKind == MzOceanBaseDefine.OCEAN_COLUMN_KIND)
            {
                MzOceanAreaColumnModel OceanColumModel = new MzOceanAreaColumnModel();
                MzOceanModelElement.OceanColumModel = OceanColumModel;
                csCalModel = OceanColumModel;
            }
            //if (csModelKind == MzOceanBaseDefine.NEKTONS_KIND)
            //{
            //    csCalModel = new MzOceanNektons();
            //}
            ////else if (csModelKind == MzOceanBaseDefine.COPEPODS_KIND)
            ////{
            ////    csCalModel = new MzOceanCopepods();
            ////}
            //else if (csModelKind == MzOceanBaseDefine.ZOOPLANKTONS_KIND)
            //{
            //    csCalModel = new MzOceanZpoplanktons();
            //}
            //else if (csModelKind == MzOceanBaseDefine.PHYTOPLANKTONS_KIND)
            //{
            //    csCalModel = new MzOceanPhytoplanktons();
            //}
            //else if (csModelKind == MzOceanBaseDefine.BACTERIA_KIND)
            //{
            //    csCalModel = new MzOceanBacterias();
            //}
            //else if (csModelKind == MzOceanBaseDefine.VIRUS_KIND)
            //{
            //    csCalModel = new MzOceanVirus();
            //}
            //else if (csModelKind == MzOceanBaseDefine.FERTILIZER_KIND)
            //{
            //    csCalModel = new MzOceanNutrient();
            //}
            //else if (csModelKind == MzOceanBaseDefine.DETRITUS_KIND)
            //{
            //    csCalModel = new MzOceanDetritus();
            //}
            ////else if (csModelKind == MzOceanBaseDefine.MINERAL_KIND)
            ////{
            ////    csCalModel = new MzOceanMineral();
            ////}
            //else if (csModelKind == MzOceanBaseDefine.DISSOLVE_GAS_KIND)
            //{
            //    MzOceanDissolveGass OceanGassModel = new MzOceanDissolveGass();
            //    MzOceanModelElement.OceanGassModel = OceanGassModel;
            //    csCalModel = OceanGassModel;
            //}
            ////else if (csModelKind == MzOceanBaseDefine.POM_KIND)
            ////{
            ////    csCalModel = new MzOceanPOM();
            ////}
            ////else if (csModelKind == MzOceanBaseDefine.DOM_KIND)
            ////{
            ////    csCalModel = new MzOceanDOM();
            ////}
            ////else if (csModelKind == MzOceanBaseDefine.InO_PARTICULATES_KIND)
            ////{
            ////    csCalModel = new MzOceanInorganicParticulates();
            ////}
            //----------------
            //else if (csModelKind == MzOceanBaseDefine.OCEAN_OVERALL_KIND)
            //{
            //    //csCalModel = new MzOceanAreaColumnModel();
            //}

            else if (csModelKind == MzOceanBaseDefine.ATMOSPHERE_KIND)
            {
                MzOceanAtmosphere OceanAtmosphereModel = new MzOceanAtmosphere();
                MzOceanModelElement.OceanAtmosphereModel = OceanAtmosphereModel;
                csCalModel = OceanAtmosphereModel;
            }
            //else if (csModelKind == MzOceanBaseDefine.SEA_SURFACE_KIND)
            //{
            //    MzOceanSeaSurfaceModel OceanSurfaceModel = new MzOceanSeaSurfaceModel();
            //    MzOceanModelElement.OceanSurfaceModel = OceanSurfaceModel;
            //    csCalModel = OceanSurfaceModel;
            //}
            //----------------
            //else if (csModelKind == MzOceanBaseDefine.HUMAN_FERTILIZER_KIND)
            //{
            //    csCalModel = new MzOceanHmnFertilization();
            //}
            //else if (csModelKind == MzOceanBaseDefine.HUMAN_FISHING_KIND)
            //{
            //    csCalModel = new MzOceanHmnFishing();
            //}
            //----------------
            //else if (csModelKind == MzOceanBaseDefine.BRANCH_CONFLUENT_KIND)
            //{
            //    csCalModel = new MzCmnBranchConfluentModel();
            //}
            //--------------- 経済モデル ------------
            //else if (csModelKind == MzOceanBaseDefine.HUMAN_JPN_SOCIETY_KIND)
            //{
            //    csCalModel = new MzEcJapanSociety();
            //}
            //else if (csModelKind == MzOceanBaseDefine.HUMAN_FERTILIZZER_FACTORY_KIND)
            //{
            //    csCalModel = new MzHmnFertilizerFactory();
            //}
            //else if (csModelKind == MzOceanBaseDefine.HUMAN_BIOFUEL_FACTORY_KIND)
            //{
            //    csCalModel = new MzHmnBiofuelFactory();
            //}
            //else if (csModelKind == MzOceanBaseDefine.HUMAN_EC_ACTION_KIND || csModelKind == MzOceanBaseDefine.HUMAN_SEA_EC_ACTION_KIND)
            //{
            //    csCalModel = new MzOcnECHmnAction();
            //}
            //else if (csModelKind == MzOceanBaseDefine.CO2_RESEARCH_EMISSION_KIND)
            //{   // C02排出調査
            //    csCalModel = new MzOcnResearchCO2();
            //}
            //else if (csModelKind == MzOceanBaseDefine.HUMAN_OCEAN_DEVELOP_KIND)
            //{
            //    csCalModel = new MzHmnOceanDvlpCo();
            //}
            //----------------------------------
            //else if (csModelKind == MzOceanBaseDefine.JAPAN_KIND)
            //{
            //    csCalModel = new Mz_Japan();
            //}
            //else if (csModelKind == MzOceanBaseDefine.FOREIGN_COUNTRYS_KIND)
            //{
            //    csCalModel = new Mz_ForeignCountry();
            //}
            //--------------- ＣＳＶ出力モデル ------------
            else if (csModelKind == MzOceanBaseDefine.DEBUG_CSV_OUT_KIND)
            {
                csCalModel = new MzOceanOutCSV();
            }
            return csCalModel;
        }

        /// <summary><para>method outline:</para>
        /// <para>要素内演算中データクラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McCalInfo csCalModel = CreateCalInfo( csModelKind ) </para>
        /// </example>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>要素内演算中データクラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCalInfo CreateCalInfo(HySObjectKind csModelKind)
        {
            McCalInfo csCalInfoData = null;
                       
            if (csModelKind == MzOceanBaseDefine.OCEAN_COLUMN_KIND)
            {
                csCalInfoData = new MzOceanAreaColumnModelCalInfo();
            }
            //if (csModelKind == MzOceanBaseDefine.NEKTONS_KIND)
            //{
            //    csCalInfoData = new MzOceanNektonsCalInfo();
            //}
            ////else if (csModelKind == MzOceanBaseDefine.COPEPODS_KIND)
            ////{
            ////    csCalInfoData = new MzOceanCopepodsCalInfo();
            ////}
            //else if (csModelKind == MzOceanBaseDefine.ZOOPLANKTONS_KIND)
            //{
            //    csCalInfoData = new MzOceanZpoplanktonsCalInfo();
            //}
            //else if (csModelKind == MzOceanBaseDefine.PHYTOPLANKTONS_KIND)
            //{
            //    csCalInfoData = new MzOceanPhytoplanktonsCalInfo();
            //}
            //else if (csModelKind == MzOceanBaseDefine.BACTERIA_KIND)
            //{
            //    csCalInfoData = new MzOceanBacteriasCalInfo();
            //}
            //else if (csModelKind == MzOceanBaseDefine.VIRUS_KIND)
            //{
            //    csCalInfoData = new MzOceanVirusCalInfo();
            //}
            //else if (csModelKind == MzOceanBaseDefine.FERTILIZER_KIND)
            //{
            //    csCalInfoData = new MzOceanNutrientCalInfo();
            //}
            //else if (csModelKind == MzOceanBaseDefine.DETRITUS_KIND)
            //{
            //    csCalInfoData = new MzOceanDetritusCalInfo();
            //}
            ////else if (csModelKind == MzOceanBaseDefine.MINERAL_KIND)
            ////{
            ////    csCalInfoData = new MzOceanMineralCalInfo();
            ////}
            //else if (csModelKind == MzOceanBaseDefine.DISSOLVE_GAS_KIND)
            //{
            //    csCalInfoData = new MzOceanDissolveGassCalInfo();
            //}
            ////else if (csModelKind == MzOceanBaseDefine.POM_KIND)
            ////{
            ////    csCalInfoData = new MzOceanPOMCalInfo();
            ////}
            ////else if (csModelKind == MzOceanBaseDefine.DOM_KIND)
            ////{
            ////    csCalInfoData = new MzOceanDOMCalInfo();
            ////}
            ////else if (csModelKind == MzOceanBaseDefine.InO_PARTICULATES_KIND)
            ////{
            ////    csCalInfoData = new MzOceanInorganicParticulatesCalInfo();
            ////}
            ////----------------
            //else if (csModelKind == MzOceanBaseDefine.OCEAN_OVERALL_KIND)
            //{
            //    //csCalInfoData = new MzOceanAreaColumnModelCalInfo();
            //}

            else if (csModelKind == MzOceanBaseDefine.ATMOSPHERE_KIND)
            {
                csCalInfoData = new MzOceanAtmosphereCalInfo();
            }
            ////else if (csModelKind == MzOceanBaseDefine.SEA_SURFACE_KIND)
            ////{
            ////    csCalInfoData = new MzOceanSeaSurfaceModelCalInfo();
            ////}
            ////----------------
            //else if (csModelKind == MzOceanBaseDefine.HUMAN_FERTILIZER_KIND)
            //{
            //    csCalInfoData = new MzOceanHmnFertilizationCalInfo();
            //}
            //else if (csModelKind == MzOceanBaseDefine.HUMAN_FISHING_KIND)
            //{
            //    csCalInfoData = new MzOceanHmnFishingCalInfo();
            //}
            //----------------
            else if (csModelKind == MzOceanBaseDefine.BRANCH_CONFLUENT_KIND)
            {
                csCalInfoData = new MzCmnBranchConfluentCalInfo();
            }
            //--------------- 経済モデル ------------
            //else if (csModelKind == MzOceanBaseDefine.HUMAN_JPN_SOCIETY_KIND)
            //{
            //    csCalInfoData = new MzEcJapanSocietyCalInfo();
            //}
            //else if (csModelKind == MzOceanBaseDefine.HUMAN_FERTILIZZER_FACTORY_KIND)
            //{
            //    csCalInfoData = new MzHmnFertilizerFactoryCalInfo();
            //}
            //else if (csModelKind == MzOceanBaseDefine.HUMAN_BIOFUEL_FACTORY_KIND)
            //{
            //    csCalInfoData = new MzHmnBiofuelFactoryCalInfo();
            //}
            //else if (csModelKind == MzOceanBaseDefine.HUMAN_EC_ACTION_KIND || csModelKind == MzOceanBaseDefine.HUMAN_SEA_EC_ACTION_KIND)
            //{
            //    csCalInfoData = new MzOcnECHmnActionCalInfo();
            //}
            //else if (csModelKind == MzOceanBaseDefine.CO2_RESEARCH_EMISSION_KIND)
            //{   // C02排出調査
            //    csCalInfoData = new MzOcnResearchCO2CalInfo();
            //}
            //else if (csModelKind == MzOceanBaseDefine.HUMAN_OCEAN_DEVELOP_KIND)
            //{
            //    csCalInfoData = new MzHmnOceanDvlpCoCalInfo();
            //}
            ////----------------------------------
            //else if (csModelKind == MzOceanBaseDefine.JAPAN_KIND)
            //{
            //    csCalInfoData = new Mz_JapanCalInfo();
            //}
            //else if (csModelKind == MzOceanBaseDefine.FOREIGN_COUNTRYS_KIND)
            //{
            //    csCalInfoData = new Mz_ForeignCountryCalInfo();
            //}
            //--------------- ＣＳＶ出力モデル ------------
            else if (csModelKind == MzOceanBaseDefine.DEBUG_CSV_OUT_KIND)
            {
                csCalInfoData = new MzOceanOutCSVCalInfo();
            }
            return csCalInfoData;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルプロパティ表示／設定情報クラス生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csPropertyInf = CreateModelPropertyInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>モデルプロパティ表示／設定情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McCellModelPropertyIF CreateModelProperty(HySID csLibraryID, HySObjectKind csModelKind)
        {
            if (this.EqualFactory(csLibraryID) == false)
            {
                return null;
            }

            McCellModelPropertyInfo csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);
            //　共通設定:  計算　δT設定
            csRtnCellPrptyDt.SetStepTime((double)4 * 3600); // δT設定　sec ＝４時間

            // 
            if (csModelKind == MzOceanBaseDefine.OCEAN_COLUMN_KIND)
            {   // 海洋の層 (Ocean layer)クラス
                // 層設定
                this.SetLayer(ref csRtnCellPrptyDt, 7, 6000); //, 10 * 10);

                csRtnCellPrptyDt.AddInfoType("m_dFace", "海面の広さ[Km □]", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("m_dFace", 100.0);

                csRtnCellPrptyDt.AddInfoType("L0", "層の名称", McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo("L0", "表層混合層(surface mixed zone)");
                csRtnCellPrptyDt.AddInfoType("L1", "層の名称", McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo("L1", "真光層（euphotic zone)");
                csRtnCellPrptyDt.AddInfoType("L2", "層の名称", McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo("L2", "透光層（disphotic zone)");
                csRtnCellPrptyDt.AddInfoType("L3", "層の名称", McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo("L3", "中深層（Mesopelagic zone)");
                csRtnCellPrptyDt.AddInfoType("L4", "層の名称", McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo("L4", "漸深層（Bathypelagic zone)");
                csRtnCellPrptyDt.AddInfoType("L5", "層の名称", McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo("L5", "深海層（Abyssopelagic zone)");
                csRtnCellPrptyDt.AddInfoType("L6", "層の名称", McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo("L6", "海底（Bottom）");


                // 受信可能なパターン
                {
                    //  
                    McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.BREATHING, csModelKind);
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);  // 受信可能パターンの追加                                                          //  
                    csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.BCT_FERTILIZER, csModelKind);
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);  // 受信可能パターンの追加
                    csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.PREDATION, csModelKind);
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);  // 受信可能パターンの追加
                    csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.DECOMPOSE, csModelKind);
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);  // 受信可能パターンの追加
                }
                // 送信パターンの設定
                {
                    McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.BREATHING, csModelKind);
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);  // 送信可能パターンの追加
                    csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.BCT_FERTILIZER, csModelKind);
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);  // 送信可能パターンの追加
                    csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.PREDATION, csModelKind);
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);  // 送信可能パターンの追加
                    csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.DECOMPOSE, csModelKind);
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);  // 送信可能パターンの追加
                }
            }

            //else if (csModelKind == MzOceanBaseDefine.NEKTONS_KIND)
            //{   // ネクトンモデル
            //    // 代謝関係
            //    this.SetMetabolism(ref csRtnCellPrptyDt, 50.0, 25.0, 1.03, 0.2, 0.02, 1.03);
            //    this.SetMetabolism2(ref csRtnCellPrptyDt, 16E-3, 28E-3, 0.01);
            //    this.SetEexcretion(ref csRtnCellPrptyDt, 0.8, 0.1);
            //    this.SetDeath(ref csRtnCellPrptyDt, 0.001);
            //    csRtnCellPrptyDt.AddInfoType("m_CapturedRatio", "捕まり易さ：確率", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_CapturedRatio", 0.0025);
            //    // 層設定
            //    this.SetLayer(ref csRtnCellPrptyDt, 7, 6000); //, 10 * 10);
            //    // 受信可能なパターン
            //    {
            //        // 呼吸
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.BREATHING, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);    // 受信可能パターンの追加

            //        // 捕食
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.PREDATION, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);    // 受信可能パターンの追加
            //    }
            //    // 送信パターンの設定
            //    {
            //        // 被捕食(漁獲)
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.PREDATION, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);  // 送信可能パターンの追加

            //        // 排泄 or 死
            //         = csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.EXCRETION_DEATH, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加

            //        // ===== start of for Debug =====
            //        csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(MzOceanBaseDefine.DEBUG_OUT, McTranInfoDefine.D1_CELL_SERIAL, "ディバッグ情報出力") as McTranInfoPattern;
            //        {
            //            // セル内変数設定
            //            HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3);
            //            {
            //                csCellChara.SetDataKind(0, "m_TotalSelfMass", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "t/m3"); // ｇ/(立方ｍ)
            //                csCellChara.SetDataKind(1, "O2", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
            //                csCellChara.SetDataKind(2, "CO2", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
            //            }
            //            csTrnPtn.SetCellDataCharacteristic(csCellChara);
            //            csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
            //        }
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加
            //        // ===== end of for Debug =====

            //    }
            //}
            //else if (csModelKind == MzOceanBaseDefine.COPEPODS_KIND)
            //{   // カイアシ類クラス
            //    // 層設定
            //    this.SetLayer(ref csRtnCellPrptyDt, 7, 6000); //, 10 * 10);
            //    // 代謝関係
            //    this.SetMetabolism(ref csRtnCellPrptyDt, 1.0, 0.02, 1.03, 0.1, 0.02, 1.03);
            //    this.SetMetabolism2(ref csRtnCellPrptyDt, 16E-3, 28E-3, 1.5);
            //    this.SetEexcretion(ref csRtnCellPrptyDt, 0.95, 0.1);
            //    csRtnCellPrptyDt.AddInfoType("m_CapturedRatio", "捕まり易さ：確率", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_CapturedRatio", 0.05);

            //    // 受信可能なパターン
            //    {
            //        // 呼吸
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.BREATHING, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);    // 受信可能パターンの追加

            //        // 捕食
            //         = csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.PREDATION, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);    // 受信可能パターンの追加
            //    }
            //    // 送信パターンの設定
            //    {
            //        // 被捕食
            //        McTranInfoPattern  = csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.PREDATION, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);  // 送信可能パターンの追加

            //        // 排泄 or 死
            //         = csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.EXCRETION_DEATH, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加

            //        // ===== start of for Debug =====
            //        csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(MzOceanBaseDefine.DEBUG_OUT, McTranInfoDefine.D1_CELL_SERIAL, "ディバッグ情報出力") as McTranInfoPattern;
            //        {
            //            // セル内変数設定
            //            HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3);
            //            {
            //                csCellChara.SetDataKind(0, "m_TotalSelfMass", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "t/m3"); // ｇ/(立方ｍ)
            //                csCellChara.SetDataKind(1, "O2", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
            //                csCellChara.SetDataKind(2, "CO2", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
            //            }
            //            csTrnPtn.SetCellDataCharacteristic(csCellChara);
            //            csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
            //        }
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加
            //        // ===== end of for Debug =====
            //    }
            //}
            //else if (csModelKind == MzOceanBaseDefine.ZOOPLANKTONS_KIND)
            //{   // 動物プランクトン（Zpoplankton)クラス
            //    // 代謝関係
            //    this.SetMetabolism(ref csRtnCellPrptyDt, 0.5, (0.05 * 0.05 * 0.05 * 1.02), 1.02, 0.5, 0.02, 1.03);
            //    this.SetMetabolism2(ref csRtnCellPrptyDt, 16E-3, 28E-3, 1.5);
            //    this.SetEexcretion(ref csRtnCellPrptyDt, 0.65, 0.4);
            //    this.SetDeath(ref csRtnCellPrptyDt, 0.001);
            //    csRtnCellPrptyDt.AddInfoType("m_CapturedRatio", "捕まり易さ：確率", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_CapturedRatio", 0.05);

            //    // 層設定
            //    this.SetLayer(ref csRtnCellPrptyDt, 7, 6000); //, 10 * 10);
            //    // 受信可能なパターン
            //    {
            //        // 呼吸
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.BREATHING, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);    // 受信可能パターンの追加

            //        // 捕食
            //         = csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.PREDATION, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);    // 受信可能パターンの追加
            //    }
            //    // 送信パターンの設定
            //    {
            //        // 被捕食
            //        McTranInfoPattern  = csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.PREDATION, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);  // 送信可能パターンの追加

            //        // 排泄 or 死
            //         = csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.EXCRETION_DEATH, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加

            //        // ===== start of for Debug =====
            //        csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(MzOceanBaseDefine.DEBUG_OUT, McTranInfoDefine.D1_CELL_SERIAL, "ディバッグ情報出力") as McTranInfoPattern;
            //        {
            //            // セル内変数設定
            //            HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3);
            //            {
            //                csCellChara.SetDataKind(0, "m_TotalSelfMass", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "t/m3"); // ｇ/(立方ｍ)
            //                csCellChara.SetDataKind(1, "O2", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
            //                csCellChara.SetDataKind(2, "CO2", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
            //            }
            //            csTrnPtn.SetCellDataCharacteristic(csCellChara);
            //            csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
            //        }
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加
            //        // ===== end of for Debug =====
            //    }
            //}
            //else if (csModelKind == MzOceanBaseDefine.PHYTOPLANKTONS_KIND)
            //{   // 植物プランクトン（Phytoplankton)クラス
            //    csRtnCellPrptyDt.AddInfoType("m_CapturedRatio", "捕まり易さ：確率", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_CapturedRatio", 0.05);
            //    this.SetDeath(ref csRtnCellPrptyDt, 0.001);

            //    csRtnCellPrptyDt.AddInfoType("m_dSelfSize", "一個体の大きさ mm ", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_dSelfSize", 0.04);
            //    csRtnCellPrptyDt.AddInfoType("m_dSelfWeight", "一個体の体重 g ", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_dSelfWeight", 0.004 * 0.004 * 0.004 * 3 * 1.02);
            //    csRtnCellPrptyDt.AddInfoType("m_dBulkDensity", "比重 ", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_dBulkDensity", 1.03);
            //    // 代謝関係
            //    csRtnCellPrptyDt.AddInfoType("m_dVMax", "理想時最大成長係数", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_dVMax", 6.0);
            //    csRtnCellPrptyDt.AddInfoType("m_dLight", "懸濁による減光係数", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_dLight", 5000.0);

            //    csRtnCellPrptyDt.AddInfoType("m_dN0", "肥料（窒素）成長 要因係数", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_dN0", 1.0);
            //    csRtnCellPrptyDt.AddInfoType("m_dP0", "肥料（リン）成長 要因係数", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_dP0", 1.0);
            //    csRtnCellPrptyDt.AddInfoType("m_dFe0", "肥料（鉄）成長 要因係数", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_dFe0", 1.0);
            //    csRtnCellPrptyDt.AddInfoType("m_dSi0", "肥料（珪素）成長 要因係数", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_dSi0", 1.0);

            //    csRtnCellPrptyDt.AddInfoType("m_dNmin", "細胞内最小（窒素）量", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_dNmin", 16E-6);
            //    csRtnCellPrptyDt.AddInfoType("m_dPmin", "細胞内最小（リン）量", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_dPmin", 3E-6);
            //    csRtnCellPrptyDt.AddInfoType("m_dFemin", "細胞内最小（鉄）量", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_dFemin", 1E-6);
            //    csRtnCellPrptyDt.AddInfoType("m_dSimin", "細胞内最小（珪素）量", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_dSimin", 1E-6);

            //    csRtnCellPrptyDt.AddInfoType("m_dKCO2", "吸収するCO2係数", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_dKCO2", 28.0E-3);
            //    csRtnCellPrptyDt.AddInfoType("m_dKO2", "排出するO2係数", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_dKO2", 16.0E-3);

            //    csRtnCellPrptyDt.AddInfoType("m_dKfN", "吸収するN係数", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_dKfN", 16E-6);
            //    csRtnCellPrptyDt.AddInfoType("m_dKfP", "吸収するP係数", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_dKfP", 4E-6);
            //    csRtnCellPrptyDt.AddInfoType("m_dKfSi", "吸収するSi係数", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_dKfSi", 1E-6);
            //    csRtnCellPrptyDt.AddInfoType("m_dKfFe", "吸収するFe係数", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_dKfFe", 1E-6);

            //    csRtnCellPrptyDt.AddInfoType("d_AbsO2", "呼吸に関するO2 係数", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("d_AbsO2", 4.0);
            //    csRtnCellPrptyDt.AddInfoType("d_AbsCO2", "呼吸に関するCO2 係数", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("d_AbsCO2", 4.0);
            //    csRtnCellPrptyDt.AddInfoType("d_KConsume", "消費量係数", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("d_KConsume", 0.5);
            //    csRtnCellPrptyDt.AddInfoType("d_KDetritus", "枯死率", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("d_KDetritus", 0.001);

            //    // 層設定
            //    this.SetLayer(ref csRtnCellPrptyDt, 7, 6000); //, 10 * 10); 1.0, 0.01,
            //    // 受信可能なパターン
            //    {
            //        //  光合成養分吸収
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.PHOTOSYNTHESIS, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);    // 受信可能パターンの追加

            //        // 光合成ＣＯ２吸収
            //         = csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.CO2_ABSORPTION, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);    // 受信可能パターンの追加
            //    }
            //    // 送信パターンの設定
            //    {
            //        // 被捕食
            //        McTranInfoPattern  = csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.PREDATION, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);  // 送信可能パターンの追加

            //        // 排泄 or 死
            //         = csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.EXCRETION_DEATH, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加

            //        // ===== start of for Debug =====
            //        csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(MzOceanBaseDefine.DEBUG_OUT, McTranInfoDefine.D1_CELL_SERIAL, "ディバッグ情報出力") as McTranInfoPattern;
            //        {
            //            // セル内変数設定
            //            HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(7);
            //            {
            //                csCellChara.SetDataKind(0, "m_TotalSelfMass", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "t/m3"); // ｇ/(立方ｍ)
            //                csCellChara.SetDataKind(1, "CO2", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
            //                csCellChara.SetDataKind(2, "O2", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
            //                csCellChara.SetDataKind(3, "N", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
            //                csCellChara.SetDataKind(4, "P", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
            //                csCellChara.SetDataKind(5, "Si", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
            //                csCellChara.SetDataKind(6, "Fe", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
            //            }
            //            csTrnPtn.SetCellDataCharacteristic(csCellChara);
            //            csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
            //        }
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加
            //        // ===== end of for Debug =====

            //    }
            //}
            //else if (csModelKind == MzOceanBaseDefine.BACTERIA_KIND)
            //{   // 細菌（Bacteria)クラス
            //    // 代謝関係
            //    this.SetMetabolism(ref csRtnCellPrptyDt,
            //        2.0E-6, (2.0E-6 * 2.0E-6 * 2.0E-6 * 1.02), 1.02,
            //         0.45, 0.05E-2, 1.0);
            //    this.SetMetabolism2(ref csRtnCellPrptyDt, 16E-3, 28E-3, 7.0);
            //    this.SetEexcretion(ref csRtnCellPrptyDt, 0.6, 0.4);
            //    this.SetDeath(ref csRtnCellPrptyDt, 0.001);
            //    csRtnCellPrptyDt.AddInfoType("m_CapturedRatio", "捕まり易さ：確率", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_CapturedRatio", 0.005);

            //    csRtnCellPrptyDt.AddInfoType("m_DkK_N", "分解時の（窒素）発生係数 [g/g]", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_DkK_N", 16.0E-6);
            //    csRtnCellPrptyDt.AddInfoType("m_DkK_P", "分解時の（リン）発生係数 [g/g]", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_DkK_P", 3.0E-6);
            //    csRtnCellPrptyDt.AddInfoType("m_DkK_Si", "分解時の（Si）発生係数 [g/g]", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_DkK_Si", 1.0E-8);
            //    csRtnCellPrptyDt.AddInfoType("m_DkK_Fe", "分解時の（Fe）発生係数 [g/g]", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_DkK_Fe", 1.0E-8);

            //    // 層設定
            //    this.SetLayer(ref csRtnCellPrptyDt, 7, 6000); //, 10 * 10);

            //    // 受信可能なパターン
            //    {
            //        // 呼吸
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.BREATHING, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);    // 受信可能パターンの追加

            //        // 捕食 = デトリタスを分解
            //         = csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.PREDATION, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);    // 受信可能パターンの追加

            //        // 感染（ウイルス感染）
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.INFECTION, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);  // 受信可能パターンの追加
            //    }
            //    // 送信パターンの設定
            //    {
            //        // 被捕食：プランクトンから捕食される
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.PREDATION, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);  // 送信可能パターンの追加

            //        // 死
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.EXCRETION_DEATH, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加

            //        // 海洋分解物が肥料要素となる
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.FERTILIZER, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加

            //        // 感染
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.INFECTION, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);  // 受信可能パターンの追加

            //        // ===== start of for Debug =====
            //        csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(MzOceanBaseDefine.DEBUG_OUT, McTranInfoDefine.D1_CELL_SERIAL, "ディバッグ情報出力") as McTranInfoPattern;
            //        {
            //            // セル内変数設定
            //            HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(3);
            //            {
            //                csCellChara.SetDataKind(0, "m_TotalSelfMass", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "t/m3"); // ｇ/(立方ｍ)
            //                csCellChara.SetDataKind(1, "O2", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
            //                csCellChara.SetDataKind(2, "CO2", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
            //            }
            //            csTrnPtn.SetCellDataCharacteristic(csCellChara);
            //            csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
            //        }
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加
            //        // ===== end of for Debug =====
            //    }
            //}
            //else if (csModelKind == MzOceanBaseDefine.VIRUS_KIND)
            //{   // ウイルス（Virus)クラス
            //    // 層設定
            //    this.SetMetabolism2(ref csRtnCellPrptyDt, 16E-3, 28E-3, 32.0);
            //    this.SetLayer(ref csRtnCellPrptyDt, 7, 6000); //, 10 * 10);


            //    // 受信可能なパターン
            //    {
            //        //// 感染
            //        //McTranInfoPattern csTrnPtn = McFlowObjFactory.CreateFlow(McOceanBaseDefine.PREDATION, csModelKind);
            //        //csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);  // 受信可能パターンの追加
            //    }
            //    // 送信パターンの設定
            //    {
            //        // 感染
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.PREDATION, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);  // 受信可能パターンの追加
            //        // 排泄 or 死
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.EXCRETION_DEATH, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加
            //    }
            //}
            //else if (csModelKind == MzOceanBaseDefine.DETRITUS_KIND)
            //{   // デトリタス（Detritus)クラス
            //    csRtnCellPrptyDt.AddInfoType("m_CapturedRatio", "被捕獲：確率", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_CapturedRatio", 0.4);

            //    csRtnCellPrptyDt.AddInfoType("m_AggregationRatio10", "凝集率(<10μm)", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_AggregationRatio10", 0.05);
            //    csRtnCellPrptyDt.AddInfoType("m_AggregationRatio100", "凝集率(<100μm)", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_AggregationRatio100", 0.025);
            //    csRtnCellPrptyDt.AddInfoType("m_AggregationRatio1000", "凝集率(<1mm)", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_AggregationRatio1000", 0.01);

            //    // 層設定
            //    this.SetLayer(ref csRtnCellPrptyDt, 7, 6000); //, 10 * 10);
            //    // 受信可能なパターン
            //    {
            //        // 排泄 or  死 
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.EXCRETION_DEATH, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);    // 送信可能パターンの追加
            //    }
            //    // 送信パターンの設定
            //    {
            //        // 被捕食
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.PREDATION, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加                                                                  

            //        //// 海洋肥料
            //        //csTrnPtn = McFlowObjFactory.CreateFlow(McOceanBaseDefine.FERTILIZER, csModelKind);
            //        //csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加

            //        // ===== start of for Debug =====
            //        csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(MzOceanBaseDefine.DEBUG_OUT, McTranInfoDefine.D1_CELL_SERIAL, "ディバッグ情報出力") as McTranInfoPattern;
            //        {
            //            // セル内変数設定
            //            HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(4);
            //            {
            //                csCellChara.SetDataKind(0, "m_TotalSelfMass", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
            //                csCellChara.SetDataKind(1, "CO2", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
            //                csCellChara.SetDataKind(2, "O2", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
            //                csCellChara.SetDataKind(3, "m_C", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
            //            }
            //            csTrnPtn.SetCellDataCharacteristic(csCellChara);
            //            csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
            //        }
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加
            //        // ===== end of for Debug =====
            //    }
            //}

            //else if (csModelKind == MzOceanBaseDefine.MINERAL_KIND)
            //{   // ミネラル（Mineral) クラス
            //}

            //else if (csModelKind == MzOceanBaseDefine.FERTILIZER_KIND)
            //{   // 栄養素（Nutrient) クラス

            //    csRtnCellPrptyDt.AddInfoType("m_Density_Si", "SiO2密度  [g/cm^3]", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_Density_Si", 2.65);
            //    csRtnCellPrptyDt.AddInfoType("m_Dissolve_Si", "SiO2溶解度係数", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_Dissolve_Si", 30.0E-3);
            //    csRtnCellPrptyDt.AddInfoType("m_Density_Fe", "Fe2O密度  [g/cm^3]", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_Density_Fe", 5.24);
            //    csRtnCellPrptyDt.AddInfoType("m_Dissolve_Fe", "Fe2O溶融係数", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_Dissolve_Fe", 30.0E-3);

            //    // 層設定
            //    this.SetLayer(ref csRtnCellPrptyDt, 7, 6000); //, 10 * 10);

            //    // 受信可能なパターン
            //    {
            //        //  海洋肥料
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.FERTILIZER, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);  // 受信可能パターンの追加
            //        //  人間による施肥
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.HUMAN_FERTILIZER, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);  // 受信可能パターンの追加

            //    }
            //    // 送信パターンの設定
            //    {
            //        //  光合成
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.PHOTOSYNTHESIS, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加

            //        // ===== start of for Debug =====
            //        csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(MzOceanBaseDefine.DEBUG_OUT, McTranInfoDefine.D1_CELL_SERIAL, "ディバッグ情報出力") as McTranInfoPattern;
            //        {
            //            // セル内変数設定
            //            HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(4);
            //            {
            //                csCellChara.SetDataKind(0, "m_N", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
            //                csCellChara.SetDataKind(1, "m_P", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
            //                csCellChara.SetDataKind(2, "m_Si", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
            //                csCellChara.SetDataKind(3, "m_Fe", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
            //            }
            //            csTrnPtn.SetCellDataCharacteristic(csCellChara);
            //            csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
            //        }
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加
            //        // ===== end of for Debug =====
            //    }
            //}

            //else if (csModelKind == MzOceanBaseDefine.DISSOLVE_GAS_KIND)
            //{   // ガス（Gas)クラス

            //    csRtnCellPrptyDt.AddInfoType("O2_L0", "真光層へのO2流れ込み:海洋ベルトコンベア等で運ばれてくるO2の量", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("O2_L0", 1.0);
            //    csRtnCellPrptyDt.AddInfoType("O2_L1", "透光層へのO2流れ込み:海洋ベルトコンベア等で運ばれてくるO2の量", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("O2_L1", 0.01E-2);
            //    csRtnCellPrptyDt.AddInfoType("O2_L2", "中深層へのO2流れ込み:海洋ベルトコンベア等で運ばれてくるO2の量", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("O2_L2", 0.01E-2);
            //    csRtnCellPrptyDt.AddInfoType("O2_L3", "漸深層へのO2流れ込み:海洋ベルトコンベア等で運ばれてくるO2の量", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("O2_L3", 0.025E-1);
            //    csRtnCellPrptyDt.AddInfoType("O2_L4", "深海層へのO2流れ込み:海洋ベルトコンベア等で運ばれてくるO2の量", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("O2_L4", 0.05E-1);
            //    csRtnCellPrptyDt.AddInfoType("O2_L5", "海底へのO2流れ込み:海洋ベルトコンベア等で運ばれてくるO2の量", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("O2_L5", 0.025E-2);

            //    csRtnCellPrptyDt.AddInfoType("CO2_L0", "真光層へのCO2流れ込み:海洋ベルトコンベア等で運び出されるCO2の量", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("CO2_L0", 1.0);
            //    csRtnCellPrptyDt.AddInfoType("CO2_L1", "透光層へのCO2流れ込み:海洋ベルトコンベア等で運び出されるCO2の量", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("CO2_L1", 0.01E-2);
            //    csRtnCellPrptyDt.AddInfoType("CO2_L2", "中深層へのCO2流れ込み:海洋ベルトコンベア等で運び出されるCO2の量", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("CO2_L2", 0.01E-2);
            //    csRtnCellPrptyDt.AddInfoType("CO2_L3", "漸深層へのCO2流れ込み:海洋ベルトコンベア等で運び出されるCO2の量", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("OC2_L3", 0.025E-1);
            //    csRtnCellPrptyDt.AddInfoType("CO2_L4", "深海層へのCO2流れ込み:海洋ベルトコンベア等で運び出されるCO2の量", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("CO2_L4", 0.05E-1);
            //    csRtnCellPrptyDt.AddInfoType("CO2_L5", "海底へのCO2流れ込み:海洋ベルトコンベア等で運び出されるCO2の量", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("CO2_L5", 0.025E-2);

            //    // 層設定
            //    this.SetLayer(ref csRtnCellPrptyDt, 7, 6000); //, 10 * 10);

            //    // 受信可能なパターン
            //    {
            //        //  大気からの溶け込み
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.GASS_DISSOLVE, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);  // 受信可能パターンの追加
            //    }
            //    // 送信パターンの設定
            //    {
            //        // 光合成によるCO2吸収
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.CO2_ABSORPTION, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);  // 送信可能パターンの追加

            //        // 呼吸
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.BREATHING, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);  // 受信可能パターンの追加

            //        // ===== start of for Debug =====
            //        csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(MzOceanBaseDefine.DEBUG_OUT, McTranInfoDefine.D1_CELL_SERIAL, "ディバッグ情報出力") as McTranInfoPattern;
            //        {
            //            // セル内変数設定
            //            HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(4);
            //            {
            //                csCellChara.SetDataKind(0, "海中溶融O2量", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/Day"); // ｇ/(立方ｍ)
            //                csCellChara.SetDataKind(1, "海中溶融CO2量", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/Day"); // ｇ/(立方ｍ)
            //                csCellChara.SetDataKind(2, "O2平均放出量", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/Day"); // ｇ/(立方ｍ)
            //                csCellChara.SetDataKind(3, "CO2平均放出量", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/Day"); // ｇ/(立方ｍ)
            //            }
            //            csTrnPtn.SetCellDataCharacteristic(csCellChara);
            //            csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
            //        }
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加
            //        // ===== end of for Debug =====
            //    }
            //}
            //else if (csModelKind == MzOceanBaseDefine.POM_KIND)
            //{   // 粒子状有機物（POM）クラス
            //    // 層設定
            //    this.SetLayer(ref csRtnCellPrptyDt, 7, 6000); //, 10 * 10);


            //    // 受信可能なパターン
            //    {
            //        // 腐敗・消化 
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.DECOMPOSE, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);  // 受信可能パターンの追加
            //    }
            //    // 送信パターンの設定
            //    {
            //        //  
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.PREDATION, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加                                                                  

            //        // 海洋肥料
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.FERTILIZER, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加
            //    }
            //}
            //else if (csModelKind == MzOceanBaseDefine.DOM_KIND)
            //{   // 溶存有機物（DOM） クラス
            //    // 層設定
            //    this.SetLayer(ref csRtnCellPrptyDt, 7, 6000); //, 10 * 10);


            //    // 受信可能なパターン
            //    {
            //        // 腐敗・消化 
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.DECOMPOSE, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);  // 受信可能パターンの追加
            //    }
            //    // 送信パターンの設定
            //    {
            //        //  
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.PREDATION, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加                                                                  

            //        // 海洋肥料
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.FERTILIZER, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加
            //    }
            //}
            //else if (csModelKind == MzOceanBaseDefine.InO_PARTICULATES_KIND)
            //{   // 粒子状無機物（Inorganic_Particulates_Mdl）クラス
            //    // 層設定
            //    this.SetLayer(ref csRtnCellPrptyDt, 7, 6000); //, 10 * 10);


            //    // 受信可能なパターン
            //    {
            //        // 腐敗・消化 
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.DECOMPOSE, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);  // 受信可能パターンの追加
            //    }
            //    // 送信パターンの設定
            //    {
            //        //  
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.PREDATION, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加                                                                  

            //        // 海洋肥料
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.FERTILIZER, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加
            //    }
            //}
            ////----------------
            else if (csModelKind == MzOceanBaseDefine.ATMOSPHERE_KIND)
            {   // 大気圏（atmosphere)クラス

                // 層設定
                this.SetLayer(ref csRtnCellPrptyDt, 7, 6000); //, 10 * 10);

                // 受信可能なパターン
                {
                    // 人間の行為によるCO2排出量 
                    McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.CO2_EMISSION, csModelKind);
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);  // 受信可能パターンの追加
                }
                // 送信パターンの設定
                {
                    //  大気からの溶け込み
                    McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.GASS_DISSOLVE, csModelKind);
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
                    // CO2調査
                    csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.RESEARCH_CO2_ABSORPTION, csModelKind);
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);

                    // ===== start of for Debug =====
                    csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(MzOceanBaseDefine.DEBUG_OUT, McTranInfoDefine.D1_CELL_SERIAL, "ディバッグ情報出力") as McTranInfoPattern;
                    {
                        // セル内変数設定
                        HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(2);
                        {
                            csCellChara.SetDataKind(0, "O2平均放出量", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "t/(Day・100Km□)"); // ｇ/(立方ｍ)
                            csCellChara.SetDataKind(1, "CO2平均放出量", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "t/(Day・100Km□)"); // ｇ/(立方ｍ)
                        }
                        csTrnPtn.SetCellDataCharacteristic(csCellChara);
                        csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
                    }
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加
                    // ===== end of for Debug =====

                }
            }
            //else if (csModelKind == MzOceanBaseDefine.SEA_SURFACE_KIND)
            //{   // 海面（sea surface)クラス
            //    // 層設定
            //    this.SetLayer(ref csRtnCellPrptyDt, 7, 6000); //, 10 * 10);


            //    // 受信可能なパターン
            //    {
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.BREATHING, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);  // 受信可能パターンの追加
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.PARTICULATES, csModelKind, " :珪素");
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);  // 受信可能パターンの追加
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.PARTICULATES, csModelKind, " :鉄");
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);  // 受信可能パターンの追加
            //    }
            //    // 送信パターンの設定
            //    {
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.BREATHING, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);  // 送信可能パターンの追加
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.FERTILIZER, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);  // 受信可能パターンの追加
            //    }
            //}
            //else if (csModelKind == MzOceanBaseDefine.OCEAN_OVERALL_KIND)
            //{
            //}
            ////----------------
            //else if (csModelKind == MzOceanBaseDefine.HUMAN_FERTILIZER_KIND)
            //{   // 人間による施肥料 
            //    SetHumanActionSpanTime(ref csRtnCellPrptyDt, "散布間隔 [日]", 7.0);
            //    SetHumanActionCO2Emission(ref csRtnCellPrptyDt, "CO2排出量[Kg/日]", 28E3 / 365);

            //    // 層設定
            //    this.SetLayer(ref csRtnCellPrptyDt, 7, 6000);

            //    // 受信可能なパターン
            //    {
            //        // 海洋設肥
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.EC_HUMAN_FERTILIZER, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
            //        // 受信可能パターンの追加  
            //        //  運用経費
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.CHASH, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);  // 受信可能パターンの追加  
            //    }
            //    // 送信パターンの設定
            //    {   // 海洋設肥
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.HUMAN_FERTILIZER, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);  // 送信可能パターンの追加
            //        // 人間の行為によるCO2排出
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.CO2_EMISSION, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);  // 送信可能パターンの追加

            //        // ===== start of for Debug =====
            //        csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(MzOceanBaseDefine.DEBUG_OUT, McTranInfoDefine.D1_CELL_SERIAL, "ディバッグ情報出力") as McTranInfoPattern;
            //        {
            //            // セル内変数設定
            //            HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(6);
            //            {
            //                csCellChara.SetDataKind(0, "m_N_Fertilize", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "t/m3"); // ｇ/(立方ｍ)
            //                csCellChara.SetDataKind(1, "m_P_Fertilize", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
            //                csCellChara.SetDataKind(2, "m_IOPMass_Si", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
            //                csCellChara.SetDataKind(3, "m_Si_Size", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "t/m3"); // ｇ/(立方ｍ)
            //                csCellChara.SetDataKind(4, "m_IOPMass_Fe", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
            //                csCellChara.SetDataKind(5, "m_Fe_Size", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m3"); // ｇ/(立方ｍ)
            //            }
            //            csTrnPtn.SetCellDataCharacteristic(csCellChara);
            //            csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
            //        }
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加
            //        // ===== end of for Debug =====

            //    }
            //}
            //else if (csModelKind == MzOceanBaseDefine.HUMAN_FISHING_KIND)
            //{   // 漁獲
            //    SetHumanActionSpanTime(ref csRtnCellPrptyDt, "操業間隔[日]", 0.5);
            //    SetHumanActionCO2Emission(ref csRtnCellPrptyDt, "CO2排出量[Kg/日]", 28E3 / 365);
            //    csRtnCellPrptyDt.AddInfoType("m_dNowUnitCost", "単価［万円／小売り単位]", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_dNowUnitCost", 100.0);

            //    // 層設定
            //    this.SetLayer(ref csRtnCellPrptyDt, 7, 6000);

            //    // 受信可能なパターン
            //    {
            //        // 捕食(漁獲)
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.PREDATION, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);  // 送信可能パターンの追加  
            //        //  運用経費
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.CHASH, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);  // 受信可能パターンの追加  
            //    }
            //    // 送信パターンの設定
            //    {
            //        // 漁獲した量
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.PRODUCT_FISH, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);  // 送信可能パターンの追加

            //        // 人間の行為によるCO2排出
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.CO2_EMISSION, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);  // 送信可能パターンの追加

            //        // ===== start of for Debug =====
            //        csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(MzOceanBaseDefine.DEBUG_OUT, McTranInfoDefine.D1_CELL_SERIAL, "ディバッグ情報出力") as McTranInfoPattern;
            //        {
            //            // セル内変数設定
            //            HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(6);
            //            {
            //                csCellChara.SetDataKind(0, "m_CatchFishMass[0]", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "t"); // ｇ/(立方ｍ)
            //                csCellChara.SetDataKind(1, "m_CatchFishMass[1]", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "t"); // ｇ/(立方ｍ)
            //                csCellChara.SetDataKind(2, "m_CatchFishMass[2]", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "t"); // ｇ/(立方ｍ)
            //                csCellChara.SetDataKind(3, "m_dFeedCapability", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "t"); // ｇ/(立方ｍ)
            //                csCellChara.SetDataKind(4, "m_TotalReqFishMass", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "t"); // ｇ/(立方ｍ)
            //                csCellChara.SetDataKind(5, "m_dNextDealingChash", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "億円"); // ｇ/(立方ｍ)
            //            }
            //            csTrnPtn.SetCellDataCharacteristic(csCellChara);
            //            csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
            //        }
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加
            //        // ===== end of for Debug =====

            //    }
            //}
            ////--------------- 経済モデル ------------
            //else if (csModelKind == MzOceanBaseDefine.HUMAN_JPN_SOCIETY_KIND)
            //{
            //    csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);
            //    //SetHumanActionCO2Emission(ref csRtnCellPrptyDt, "CO2排出量[Kg/日]", 28E3 / 365);
            //    SetHumanActionSpanTime(ref csRtnCellPrptyDt, "活動間隔 [日]", 30.0);
            //    // 受信可能なパターン
            //    {
            //        // 雇用
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.SC_EMPLOYMENT, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
            //        // 税金
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.SC_TAX, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
            //        // 海産 食品購入
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.PRODUCT_FOOD, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
            //        // バイオ燃料購入
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.PRODUCT_BIO_FUEL, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
            //        // CO2排出権購入
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.CO2_EMISSION_CREDIT, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
            //    }
            //    // 送信パターンの設定
            //    {
            //        // 各種事業運営費等
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.CHASH, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
            //        // 投資等
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.SCINVESTMENT, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);

            //        // ===== start of for Debug =====
            //        csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(MzOceanBaseDefine.DEBUG_OUT, McTranInfoDefine.D1_CELL_SERIAL, "ディバッグ情報出力") as McTranInfoPattern;
            //        {
            //            // セル内変数設定
            //            HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(5);
            //            {
            //                csCellChara.SetDataKind(0, "m_Chash", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "億円");
            //                csCellChara.SetDataKind(1, "手持ち排出権量", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "t");
            //                csCellChara.SetDataKind(2, "手持ち排出権資産", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "億円");
            //                csCellChara.SetDataKind(3, "m_d2ndFuelStock", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "億円");
            //                csCellChara.SetDataKind(4, "m_dFishFoods", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "億円");
            //            }
            //            csTrnPtn.SetCellDataCharacteristic(csCellChara);
            //            csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
            //        }
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
            //        // ===== end of for Debug =====
            //    }
            //}
            //else if (csModelKind == MzOceanBaseDefine.HUMAN_FERTILIZZER_FACTORY_KIND)
            //{   // 肥料生産工場
            //    //csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);
            //    SetHumanActionSpanTime(ref csRtnCellPrptyDt, "納入間隔 [日]", 1.0);
            //    SetHumanActionCO2Emission(ref csRtnCellPrptyDt, "CO2排出量[Kg/日]", 28E3 / 365);

            //    csRtnCellPrptyDt.AddInfoType("m_Si_Size", "Si無機物サイズ[mm]", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_Si_Size", 1E-3);
            //    csRtnCellPrptyDt.AddInfoType("m_Fe_Size", "Fe無機物サイズ[mm]", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_Fe_Size", 1E-3);
            //    csRtnCellPrptyDt.AddInfoType("m_SI", "出荷量：Si含有量[t/日]", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_SI", 1.5);
            //    csRtnCellPrptyDt.AddInfoType("m_FE", "出荷量Fe含有量[t/日]", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_FE", 1.5);
            //    csRtnCellPrptyDt.AddInfoType("m_N", "出荷量N含有量[t/日]", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_N", 8.0);
            //    csRtnCellPrptyDt.AddInfoType("m_P", "出荷量P含有量[t/日]", McDefine.ValKind.DOUBLE);
            //    csRtnCellPrptyDt.SetInfo("m_P", 6.0);

            //    // 受信可能なパターン
            //    {
            //        //  原料購入
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.DEALING, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);  // 受信可能パターンの追加                                                          //  
            //        //  操業経費
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.CHASH, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);  // 受信可能パターンの追加                                                          //  
            //    }
            //    // 送信パターンの設定
            //    {   // 海洋設肥
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.EC_HUMAN_FERTILIZER, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);  // 送信可能パターンの追加
            //        // 人間の行為によるCO2排出
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.CO2_EMISSION, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);  // 送信可能パターンの追加

            //        // ===== start of for Debug =====
            //        csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(MzOceanBaseDefine.DEBUG_OUT, McTranInfoDefine.D1_CELL_SERIAL, "ディバッグ情報出力") as McTranInfoPattern;
            //        {
            //            // セル内変数設定
            //            HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(4);
            //            {
            //                csCellChara.SetDataKind(0, "生産量：N", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "t"); // ｇ/(立方ｍ)
            //                csCellChara.SetDataKind(1, "生産量：P", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "t"); // ｇ/(立方ｍ)
            //                csCellChara.SetDataKind(2, "生産量：Si", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "t"); // ｇ/(立方ｍ)
            //                csCellChara.SetDataKind(3, "生産量：Fe", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "t"); // ｇ/(立方ｍ)
            //            }
            //            csTrnPtn.SetCellDataCharacteristic(csCellChara);
            //            csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
            //        }
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加
            //        // ===== end of for Debug =====

            //    }
            //}
            //else if (csModelKind == MzOceanBaseDefine.HUMAN_BIOFUEL_FACTORY_KIND)
            //{
            //    // バイオ燃料生産プラント
            //    //csRtnCellPrptyDt.SetStepTime((double)4 * 3600); // δT設定　sec ＝４時間
            //    SetHumanActionSpanTime(ref csRtnCellPrptyDt, "納入間隔 [日]", 1.0);
            //    SetHumanActionCO2Emission(ref csRtnCellPrptyDt, "CO2排出量[Kg/日]", 28E3 / 365);
            //    //SetHumanActionValue(ref csRtnCellPrptyDt, "生産への直接寄与率(0～1)", 1.0);
            //    // 受信可能なパターン
            //    {
            //        //  原料購入
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.PRODUCT_FISH, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);  // 受信可能パターンの追加                                                          //  
            //        //  操業経費
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.CHASH, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);  // 受信可能パターンの追加                                                          //  
            //    }
            //    // 送信パターンの設定
            //    {
            //        // バイオ燃料納入
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.PRODUCT_BIO_FUEL, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);  // 送信可能パターンの追加
            //        // 人間の行為によるCO2排出
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.CO2_EMISSION, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);  // 送信可能パターンの追加

            //        // ===== start of for Debug =====
            //        csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(MzOceanBaseDefine.DEBUG_OUT, McTranInfoDefine.D1_CELL_SERIAL, "ディバッグ情報出力") as McTranInfoPattern;
            //        {
            //            // セル内変数設定
            //            HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(4);
            //            {
            //                csCellChara.SetDataKind(0, "バイオ燃料出荷量", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "t");
            //                csCellChara.SetDataKind(1, "原料量", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "t");
            //                csCellChara.SetDataKind(2, "CO2排出量", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "Kg/Day");
            //                csCellChara.SetDataKind(3, "m_Chash", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "億円");
            //            }
            //            csTrnPtn.SetCellDataCharacteristic(csCellChara);
            //            csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
            //        }
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);    // 送信可能パターンの追加
            //        // ===== end of for Debug =====

            //    }

            //}
            //else if (csModelKind == MzOceanBaseDefine.HUMAN_EC_ACTION_KIND || csModelKind == MzOceanBaseDefine.HUMAN_SEA_EC_ACTION_KIND)
            //{
            //    // 人間行動クラス
            //    //csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);
            //    //csRtnCellPrptyDt.SetStepTime((double)4 * 3600); // δT設定　sec ＝４時間
            //    SetHumanActionSpanTime(ref csRtnCellPrptyDt, "納入間隔 [日]", 1.0);
            //    SetHumanActionCO2Emission(ref csRtnCellPrptyDt, "CO2排出量[Kg/日]", 28E3 / 365);
            //    SetHumanActionValue(ref csRtnCellPrptyDt, "生産への直接寄与率(0～1)", 1.0);
            //    // 受信可能なパターン
            //    {
            //        //  経費
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.CHASH, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.DEALING, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
            //    }
            //    // 送信パターンの設定
            //    {
            //        // 人間の行為によるCO2排出
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.CO2_EMISSION, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);

            //        // ===== start of for Debug =====
            //        csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(MzOceanBaseDefine.DEBUG_OUT, McTranInfoDefine.D1_CELL_SERIAL, "ディバッグ情報出力") as McTranInfoPattern;
            //        {
            //            // セル内変数設定
            //            HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(6);
            //            {
            //                csCellChara.SetDataKind(0, "m_Chash", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "億円");
            //                csCellChara.SetDataKind(1, "m_NonMaterial_Val", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "億円");
            //                csCellChara.SetDataKind(2, "m_OrdersPlaced", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "億円");
            //                csCellChara.SetDataKind(3, "m_Payment", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "億円");
            //                csCellChara.SetDataKind(4, "m_Claimed", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "億円");
            //                csCellChara.SetDataKind(5, "m_EstimatedCost", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "億円");
            //            }
            //            csTrnPtn.SetCellDataCharacteristic(csCellChara);
            //            csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
            //        }
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
            //        // ===== end of for Debug =====

            //    }
            //}
            //else if (csModelKind == MzOceanBaseDefine.CO2_RESEARCH_EMISSION_KIND)
            //{
            //    // C02排出調査
            //    //csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);
            //    //csRtnCellPrptyDt.SetStepTime((double)4 * 3600); // δT設定　sec ＝４時間
            //    SetHumanActionSpanTime(ref csRtnCellPrptyDt, "納入間隔 [日]", 1.0);
            //    SetHumanActionCO2Emission(ref csRtnCellPrptyDt, "CO2排出量[Kg/日]", 28E3 / 365);
            //    SetHumanActionValue(ref csRtnCellPrptyDt, "生産への直接寄与率(0～1)", 1.0);
            //    // 受信可能なパターン
            //    {
            //        //  経費
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.CHASH, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
            //        //
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.DEALING, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
            //        // CO2調査
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.RESEARCH_CO2_ABSORPTION, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
            //    }
            //    // 送信パターンの設定
            //    {
            //        // 人間の行為によるCO2排出
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.CO2_EMISSION, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
            //        // CO2調査
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.RESEARCH_CO2_ABSORPTION, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);

            //        // ===== start of for Debug =====
            //        csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(MzOceanBaseDefine.DEBUG_OUT, McTranInfoDefine.D1_CELL_SERIAL, "ディバッグ情報出力") as McTranInfoPattern;
            //        {
            //            // セル内変数設定
            //            HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(9);
            //            {
            //                csCellChara.SetDataKind(0, "m_meanCO2Emission", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m2");
            //                csCellChara.SetDataKind(1, "m_meanCO2Absorption", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m2");
            //                csCellChara.SetDataKind(2, "m_meanO2Emission", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "g/m");
            //                csCellChara.SetDataKind(3, "m_Chash", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "億円");
            //                csCellChara.SetDataKind(4, "m_NonMaterial_Val", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "億円");
            //                csCellChara.SetDataKind(5, "m_OrdersPlaced", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "億円");
            //                csCellChara.SetDataKind(6, "m_Payment", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "億円");
            //                csCellChara.SetDataKind(7, "m_Claimed", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "億円");
            //                csCellChara.SetDataKind(8, "m_EstimatedCost", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "億円");
            //            }
            //            csTrnPtn.SetCellDataCharacteristic(csCellChara);
            //            csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
            //        }
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
            //        // ===== end of for Debug =====

            //    }
            //}
            //else if (csModelKind == MzOceanBaseDefine.HUMAN_OCEAN_DEVELOP_KIND)
            //{
            //    //csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);
            //    //csRtnCellPrptyDt.SetStepTime((double)4 * 3600); // δT設定　sec ＝４時間
            //    SetHumanActionSpanTime(ref csRtnCellPrptyDt, "納入間隔 [日]", 1.0);
            //    SetHumanActionCO2Emission(ref csRtnCellPrptyDt, "CO2排出量[Kg/日]", 28E3 / 365);
            //    //SetHumanActionValue(ref csRtnCellPrptyDt, "生産への直接寄与率(0～1)",1.0);
            //    // 受信可能なパターン
            //    {
            //        // 漁獲買い上げ
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.PRODUCT_FISH, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
            //        // 投資等受け入れ
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.CHASH, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
            //        // バイオ燃料購入
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.PRODUCT_BIO_FUEL, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
            //        // CO2調査
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.RESEARCH_CO2_ABSORPTION, csModelKind);
            //        csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);
            //    }
            //    // 送信パターンの設定
            //    {
            //        // 各種事業運営費等
            //        McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.CHASH, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);

            //        //バイオ燃料納入
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.PRODUCT_BIO_FUEL, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
            //        // 海産 食品納入
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.PRODUCT_FOOD, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);

            //        // CO2排出権納入
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.CO2_EMISSION_CREDIT, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);

            //        // 税金納入
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.SC_TAX, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
            //        // 雇用
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.SC_EMPLOYMENT, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);

            //        // 人間の行為によるCO2排出
            //        csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.CO2_EMISSION, csModelKind);
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);  // 送信可能パターンの追加

            //        // ===== start of for Debug =====
            //        csTrnPtn = csRtnCellPrptyDt.CreateTranInforPattern(MzOceanBaseDefine.DEBUG_OUT, McTranInfoDefine.D1_CELL_SERIAL, "ディバッグ情報出力") as McTranInfoPattern;
            //        {
            //            // セル内変数設定
            //            HySDataCharacteristicInCell csCellChara = csTrnPtn.CreateCellDataCharacteristic(8);
            //            {
            //                csCellChara.SetDataKind(0, "m_Chash", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "億円");
            //                csCellChara.SetDataKind(1, "m_CO2_Emission_Credit", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "t");
            //                csCellChara.SetDataKind(2, "m_CO2_Emission_Capability", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "t");
            //                csCellChara.SetDataKind(3, "m_CO2_Credit_DealingChash", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "億円");
            //                csCellChara.SetDataKind(4, "m_d2ndFuelStock", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "億円");
            //                csCellChara.SetDataKind(5, "m_ddFishProduct", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "億円");
            //                csCellChara.SetDataKind(6, "m_dDealingChash", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "億円");
            //                csCellChara.SetDataKind(6, "m_meanTtlCO2Emission", HySDataCharacteristicInCell.DATA_KIND.ANY_VALUE, "t");
            //            }
            //            csTrnPtn.SetCellDataCharacteristic(csCellChara);
            //            csTrnPtn.SetInterpolateType(HySDefine.InterpolateType.LINEAR); // 内挿方法設定
            //        }
            //        csRtnCellPrptyDt.AddSendPattern(csTrnPtn);
            //        // ===== end of for Debug =====
            //    }
            //}
            ////--------------------------------------
            //else if (csModelKind == MzOceanBaseDefine.JAPAN_KIND)
            //{
            //    csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);
            //    csRtnCellPrptyDt.SetStepTime((double)4 * 3600); // δT設定　sec ＝４時間
            //}
            //else if (csModelKind == MzOceanBaseDefine.FOREIGN_COUNTRYS_KIND)
            //{
            //    csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);
            //    csRtnCellPrptyDt.SetStepTime((double)4 * 3600); // δT設定　sec ＝４時間
            //}
            ////--------------------------------------
            else if (csModelKind == MzOceanBaseDefine.BRANCH_CONFLUENT_KIND)
            {   // 分岐合流
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);
                csRtnCellPrptyDt.SetStepTime((double)4 * 3600); // δT設定　sec ＝４時間
                // 層設定
                this.SetLayer(ref csRtnCellPrptyDt, 7, 6000);

                // 受信可能なパターン
                {
                    //  汎用情報
                    McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.COMMON_DATA, csModelKind);
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);  // 受信可能パターンの追加                                                          //  
                }
                // 送信パターンの設定
                {
                    // 汎用情報
                    McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.COMMON_DATA, csModelKind);
                    csRtnCellPrptyDt.AddSendPattern(csTrnPtn);  // 送信可能パターンの追加
                }
            }

            //--------------- ＣＳＶ出力モデル ------------ 
            else if (csModelKind == MzOceanBaseDefine.DEBUG_CSV_OUT_KIND)
            {
                //ＣＳＶファイル（時系列）出力モデルならば
                csRtnCellPrptyDt = new McCellModelPropertyInfo(csLibraryID, csModelKind);
                csRtnCellPrptyDt.RemoveInfoType(McPropertyInfo.TIME_STEP);  // <-- モデルに⊿Ｔ設定は不要の為

                csRtnCellPrptyDt.AddInfoType("OUTTIME_LAG", "出力時間間隔(秒)", McDefine.ValKind.DOUBLE);
                csRtnCellPrptyDt.SetInfo("OUTTIME_LAG", 1.0D * 3600.0D);

                csRtnCellPrptyDt.AddInfoType(HymcoStandardModelDefine.OVER_WRITE_OR_OTHER_SWITCH, "上書き／別名ファイル選択", McDefine.ValKind.LONG);
                csRtnCellPrptyDt.SetInfo(HymcoStandardModelDefine.OVER_WRITE_OR_OTHER_SWITCH, 0); // デフォルトは上書き

                csRtnCellPrptyDt.AddInfoType(HymcoStandardModelDefine.OVER_WRITE_FILE_NAME, "出力ファイル名(パス付き)", McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo(HymcoStandardModelDefine.OVER_WRITE_FILE_NAME, ".\\OutputData\\MzOcnDbgOutput.csv");

                csRtnCellPrptyDt.AddInfoType(HymcoStandardModelDefine.WRITE_DIRECTORY_NAME, "書き出しディレクトリ", McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo(HymcoStandardModelDefine.WRITE_DIRECTORY_NAME, "OutputData");

                csRtnCellPrptyDt.AddInfoType(HymcoStandardModelDefine.WRITE_FILE_NAME, "書き出しファイル名", McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo(HymcoStandardModelDefine.WRITE_FILE_NAME, "MzOcnDbgOutput.csv");

                csRtnCellPrptyDt.AddInfoType("DataName", "データ名", McDefine.ValKind.STRING);
                csRtnCellPrptyDt.SetInfo("DataName", ""); // デフォルトは上書き

                // 受信パターンの設定
                {
                    McTranInfoPattern csTrnPtn = MzFlowObjBaseFactory.CreateFlow(MzOceanBaseDefine.DEBUG_OUT, csModelKind);
                    csRtnCellPrptyDt.AddReceivePattern(csTrnPtn);  // 受信可能パターンの追加
                }
            }
            else
            {
                csRtnCellPrptyDt = null;
            }


            return csRtnCellPrptyDt;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル初期化表示／設定情報生成</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> McPropertyInfoRoot csInitialInf = CreateModelInitialInfo(csLibraryID, csModelKind ) </para>
        /// </example>
        /// <param name="csLibraryID">ライブラリー識別子</param>
        /// <param name="csModelKind">モデル種別識別子</param>
        /// <returns>初期情報クラス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override McPropertyInfoRoot CreateModelInitialInfo(HySID csLibraryID, HySObjectKind csModelKind)
        {
            if (this.EqualFactory(csLibraryID) == false)
            {
                return null;
            }

            McInitialInfo csRtnDt = new McInitialInfo(csLibraryID, csModelKind);

            if (csModelKind == MzOceanBaseDefine.OCEAN_COLUMN_KIND)
            {
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            }

            //else if (csModelKind == MzOceanBaseDefine.NEKTONS_KIND)
            //{
            //    csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            //    this.SetInitMass(ref csRtnDt, 1, 1, 1, 1, 1, 1, 1);
            //}
            //else if (csModelKind == MzOceanBaseDefine.COPEPODS_KIND)
            //{
            //    csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            //    this.SetInitMass(ref csRtnDt, 1, 1, 1, 1, 1, 1, 1);
            //}
            //else if (csModelKind == MzOceanBaseDefine.ZOOPLANKTONS_KIND)
            //{
            //    csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            //    this.SetInitMass(ref csRtnDt, 1, 1, 1, 1, 1, 1, 1);
            //}
            //else if (csModelKind == MzOceanBaseDefine.PHYTOPLANKTONS_KIND)
            //{   // 植物プランクトン　初期量
            //    csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            //    this.SetInitMass(ref csRtnDt, 1, 1E-2, 1E-9, 0, 0, 0, 0);
            //}
            //else if (csModelKind == MzOceanBaseDefine.BACTERIA_KIND)
            //{
            //    csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            //    this.SetInitMass(ref csRtnDt, 1, 1, 1, 1, 1, 1, 1);
            //}
            //else if (csModelKind == MzOceanBaseDefine.VIRUS_KIND)
            //{
            //    csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            //    this.SetInitMass(ref csRtnDt, 1, 1, 1, 1, 1, 1, 1);
            //}
            //else if (csModelKind == MzOceanBaseDefine.DETRITUS_KIND)
            //{    // デトリタス
            //    csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            //    this.SetInitMass(ref csRtnDt, 1E-2, 1E-9, 1E-9, 0, 0, 0, 0);
            //    csRtnDt.AddInfoType("m_dDtrtsSize", "デトリタスサイズ[mm]", McDefine.ValKind.DOUBLE);
            //    csRtnDt.SetInfo("m_dDtrtsSize", 30.0E-3);
            //    csRtnDt.AddInfoType("m_dDcty", "密度", McDefine.ValKind.DOUBLE);
            //    csRtnDt.SetInfo("m_dDcty", 1.2);
            //}
            ///*
            //else if (csModelKind == McOceanBaseDefine.MINERAL_KIND)
            //{
            //    csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            //    this.SetInitMass(ref csRtnDt, 1, 1, 1, 1, 1, 1, 1);
            //}
            //*/
            //else if (csModelKind == MzOceanBaseDefine.FERTILIZER_KIND)
            //{   // 栄養素
            //    csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            //    //this.SetInitMass(ref csRtnDt, 1, 1, 1, 1, 1, 1, 1);
            //    csRtnDt.AddInfoType("N_TotalMass_L0", "海面表層：N_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
            //    csRtnDt.SetInfo("N_TotalMass_L0", 48.2E-6);
            //    csRtnDt.AddInfoType("N_TotalMass_L1", "真光層：N_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
            //    csRtnDt.SetInfo("N_TotalMass_L1", 48.2E-6);
            //    csRtnDt.AddInfoType("P_TotalMass_L0", "海面表層：P_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
            //    csRtnDt.SetInfo("P_TotalMass_L0", 3.48E-6);
            //    csRtnDt.AddInfoType("P_TotalMass_L1", "真光層：P_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
            //    csRtnDt.SetInfo("P_TotalMass_L1", 3.48E-6);
            //    csRtnDt.AddInfoType("Si_TotalMass_L0", "海面表層：Si_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
            //    csRtnDt.SetInfo("Si_TotalMass_L0", 8.2E-6);
            //    csRtnDt.AddInfoType("Si_TotalMass_L1", "真光層：Si_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
            //    csRtnDt.SetInfo("Si_TotalMass_L1", 2.2E-6);
            //    csRtnDt.AddInfoType("Fe_TotalMass_L0", "海面表層：Fe_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
            //    csRtnDt.SetInfo("Fe_TotalMass_L0", 8.2E-6);
            //    csRtnDt.AddInfoType("Fe_TotalMass_L1", "真光層：Fe_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
            //    csRtnDt.SetInfo("Fe_TotalMass_L1", 2.2E-6);
            //}

            //else if (csModelKind == MzOceanBaseDefine.DISSOLVE_GAS_KIND)
            //{
            //    csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            //    //this.SetInitMass(ref csRtnDt, 1, 1, 1, 1, 1, 1, 1);
            //    csRtnDt.AddInfoType("O2_TotalMass_L0", "海面表層：O2_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
            //    csRtnDt.SetInfo("O2_TotalMass_L0", 8.11);
            //    csRtnDt.AddInfoType("O2_TotalMass_L1", "真光層：O2_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
            //    csRtnDt.SetInfo("O2_TotalMass_L1", 2.0);
            //    csRtnDt.AddInfoType("O2_TotalMass_L2", "透光層：O2_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
            //    csRtnDt.SetInfo("O2_TotalMass_L2", 5.0);
            //    csRtnDt.AddInfoType("O2_TotalMass_L3", "中深層：O2_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
            //    csRtnDt.SetInfo("O2_TotalMass_L3", 5.0);
            //    csRtnDt.AddInfoType("O2_TotalMass_L4", "漸深層：O2_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
            //    csRtnDt.SetInfo("O2_TotalMass_L4", 6.0);
            //    csRtnDt.AddInfoType("O2_TotalMass_L5", "深海層：O2_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
            //    csRtnDt.SetInfo("O2_TotalMass_L5", 6.0);
            //    csRtnDt.AddInfoType("O2_TotalMass_L6", "海底：O2_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
            //    csRtnDt.SetInfo("O2_TotalMass_L6", 6.0);

            //    csRtnDt.AddInfoType("CO2_TotalMass_L0", "海面表層：CO2_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
            //    csRtnDt.SetInfo("CO2_TotalMass_L0", 1.452);
            //    csRtnDt.AddInfoType("CO2_TotalMass_L1", "真光層：CO2_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
            //    csRtnDt.SetInfo("CO2_TotalMass_L1", 2.0);
            //    csRtnDt.AddInfoType("CO2_TotalMass_L2", "透光層：CO2_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
            //    csRtnDt.SetInfo("CO2_TotalMass_L2", 3.0);
            //    csRtnDt.AddInfoType("CO2_TotalMass_L3", "中深層：CO2_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
            //    csRtnDt.SetInfo("CO2_TotalMass_L3", 3.0);
            //    csRtnDt.AddInfoType("CO2_TotalMass_L4", "漸深層：CO2_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
            //    csRtnDt.SetInfo("CO2_TotalMass_L4", 4.0);
            //    csRtnDt.AddInfoType("CO2_TotalMass_L5", "深海層：CO2_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
            //    csRtnDt.SetInfo("CO2_TotalMass_L5", 4.0);
            //    csRtnDt.AddInfoType("CO2_TotalMass_L6", "海底：CO2_初期存在量[g/m3]", McDefine.ValKind.DOUBLE);
            //    csRtnDt.SetInfo("CO2_TotalMass_L6", 4.0);

            //}
            //else if (csModelKind == MzOceanBaseDefine.POM_KIND)
            //{
            //    csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            //    this.SetInitMass(ref csRtnDt, 1, 1, 1, 1, 1, 1, 1);
            //}
            //else if (csModelKind == MzOceanBaseDefine.DOM_KIND)
            //{
            //    csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            //    this.SetInitMass(ref csRtnDt, 1, 1, 1, 1, 1, 1, 1);
            //}
            //else if (csModelKind == MzOceanBaseDefine.InO_PARTICULATES_KIND)
            //{   // 粒子状無機物（Inorganic_Particulates_Mdl）クラス
            //    csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            //    this.SetInitMass(ref csRtnDt, 1, 1, 1, 1, 1, 1, 1);
            //}
            ////----------------
            else if (csModelKind == MzOceanBaseDefine.ATMOSPHERE_KIND)
            {
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            }
            //else if (csModelKind == MzOceanBaseDefine.SEA_SURFACE_KIND)
            //{
            //    csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            //}
            //else if (csModelKind == MzOceanBaseDefine.OCEAN_OVERALL_KIND)
            //{
            //}
            ////----------------
            //else if (csModelKind == MzOceanBaseDefine.HUMAN_FERTILIZER_KIND)
            //{
            //    csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            //    SetHumanInitFacility(ref csRtnDt, 100.0, 0.03);
            //    SetHumanInitCapital(ref csRtnDt, 10.0, 10.0);
            //    SetHumanInitDebt(ref csRtnDt, 200.0, 0.03);
            //    //SetHumanInitCredit(ref csRtnDt, 0.0, 0.03);
            //    SetHumanInitorder(ref csRtnDt, 10.0, 1.0, 1.0, 1.0);

            //}
            //else if (csModelKind == MzOceanBaseDefine.HUMAN_FISHING_KIND)
            //{
            //    csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            //    SetHumanInitFacility(ref csRtnDt, 100.0, 0.03);
            //    SetHumanInitCapital(ref csRtnDt, 10.0, 10.0);
            //    SetHumanInitDebt(ref csRtnDt, 200.0, 0.03);
            //    //SetHumanInitCredit(ref csRtnDt, 0.0, 0.03);
            //    SetHumanInitorder(ref csRtnDt, 10.0, 1.0, 1.0, 1.0);
            //}
            //--------------- 経済モデル ------------
            ////else if (csModelKind == McOceanBaseDefine.HUMAN_FACTORY_KIND)
            ////{
            ////    csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            ////}
            //else if (csModelKind == MzOceanBaseDefine.HUMAN_JPN_SOCIETY_KIND)
            //{
            //    csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            //    //SetHumanInitFacility(ref csRtnDt, 1000.0, 0.03);
            //    //SetHumanInitCapital(ref csRtnDt, 10.0, 90.0);
            //    //SetHumanInitDebt(ref csRtnDt, 1100.0, 0.03);
            //    //SetHumanInitCredit(ref csRtnDt, 0.0, 0.03);
            //    //SetHumanInitorder(ref csRtnDt, 100.0, 1.0, 1.0, 1.0);
            //    csRtnDt.AddInfoType("m_CO2_Emission_Credit_UnitCost", "CO2排出単価 万円/ton", McDefine.ValKind.DOUBLE);
            //    csRtnDt.SetInfo("m_CO2_Emission_Credit_UnitCost", 500);
            //    csRtnDt.AddInfoType("m_dFishFoodUnitCost", "魚：小売り価格", McDefine.ValKind.DOUBLE);
            //    csRtnDt.SetInfo("m_dFishFoodUnitCost", 1500.0 * 10000.0);
            //    csRtnDt.AddInfoType("m_d2ndFuelUnitCost", @"バイオ燃料(\/L)：小売り価格", McDefine.ValKind.DOUBLE);
            //    csRtnDt.SetInfo("m_d2ndFuelUnitCost", 200.0);
            //}
            //else if (csModelKind == MzOceanBaseDefine.HUMAN_FERTILIZZER_FACTORY_KIND)
            //{
            //    csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            //    SetHumanInitFacility(ref csRtnDt, 100.0, 0.03);
            //    SetHumanInitCapital(ref csRtnDt, 10.0, 10.0);
            //    SetHumanInitDebt(ref csRtnDt, 200.0, 0.03);
            //    SetHumanInitCredit(ref csRtnDt, 0.0, 0.03);
            //    SetHumanInitorder(ref csRtnDt, 100.0, 1.0, 1.0, 1.0);
            //}
            //else if (csModelKind == MzOceanBaseDefine.HUMAN_BIOFUEL_FACTORY_KIND)
            //{
            //    csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            //    SetHumanInitFacility(ref csRtnDt, 1000.0, 0.03);
            //    SetHumanInitCapital(ref csRtnDt, 10.0, 90.0);
            //    SetHumanInitDebt(ref csRtnDt, 1100.0, 0.03);
            //    SetHumanInitCredit(ref csRtnDt, 0.0, 0.03);
            //    SetHumanInitorder(ref csRtnDt, 100.0, 1.0, 1.0, 1.0);
            //}
            //else if (csModelKind == MzOceanBaseDefine.HUMAN_EC_ACTION_KIND || csModelKind == MzOceanBaseDefine.HUMAN_SEA_EC_ACTION_KIND)
            //{
            //    csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            //    SetHumanInitFacility(ref csRtnDt, 100.0, 0.03);
            //    SetHumanInitCapital(ref csRtnDt, 10.0, 10.0);
            //    SetHumanInitDebt(ref csRtnDt, 200.0, 0.03);
            //    SetHumanInitCredit(ref csRtnDt, 0.0, 0.03);
            //    SetHumanInitorder(ref csRtnDt, 1.0, 1.0, 1.0, 1.0);
            //}
            //else if (csModelKind == MzOceanBaseDefine.CO2_RESEARCH_EMISSION_KIND)
            //{
            //    // C02排出調査
            //    csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            //    SetHumanInitFacility(ref csRtnDt, 100.0, 0.03);
            //    SetHumanInitCapital(ref csRtnDt, 10.0, 10.0);
            //    SetHumanInitDebt(ref csRtnDt, 200.0, 0.03);
            //    SetHumanInitCredit(ref csRtnDt, 0.0, 0.03);
            //    SetHumanInitorder(ref csRtnDt, 1.0, 1.0, 1.0, 1.0);
            //}
            //else if (csModelKind == MzOceanBaseDefine.HUMAN_OCEAN_DEVELOP_KIND)
            //{
            //    csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            //    SetHumanInitFacility(ref csRtnDt, 1000.0, 0.03);
            //    SetHumanInitCapital(ref csRtnDt, 10.0, 90.0);
            //    SetHumanInitDebt(ref csRtnDt, 1100.0, 0.03);
            //    SetHumanInitCredit(ref csRtnDt, 0.0, 0.03);
            //    SetHumanInitorder(ref csRtnDt, 100.0, 1.0, 1.0, 1.0);

            //    csRtnDt.AddInfoType("m_d2ndFuelUnitCost", @"バイオ燃料(\/L)：仕入れ価格", McDefine.ValKind.DOUBLE);
            //    csRtnDt.SetInfo("m_d2ndFuelUnitCost", 200.0 );
            //    csRtnDt.AddInfoType("m_d2ndFuelMaterialsUnitCost", @"バイオ燃料(\/L)：小売り価格", McDefine.ValKind.DOUBLE);
            //    csRtnDt.SetInfo("m_d2ndFuelMaterialsUnitCost", 200.0);

            //    csRtnDt.AddInfoType("m_dFishMaterialsUnitCost", "魚：仕入れ価格", McDefine.ValKind.DOUBLE);
            //    csRtnDt.SetInfo("m_dFishMaterialsUnitCost", 15.0 * 10000.0);
            //    csRtnDt.AddInfoType("m_dFishNowUnitCost", "魚：小売り価格", McDefine.ValKind.DOUBLE);
            //    csRtnDt.SetInfo("m_dFishNowUnitCost", 1500.0 * 10000.0);

            //    csRtnDt.AddInfoType("m_CO2_Emission_Credit_UnitCost", "CO2排出単価 万円/ton", McDefine.ValKind.DOUBLE);
            //    csRtnDt.SetInfo("m_CO2_Emission_Credit_UnitCost", 500);
            //    csRtnDt.AddInfoType("m_Benefit", "初期利益：税金用", McDefine.ValKind.DOUBLE);
            //    csRtnDt.SetInfo("m_Benefit", 1);
            //    csRtnDt.AddInfoType("m_NextTax_Day", "最初の税金支払い：日", McDefine.ValKind.DOUBLE);
            //    csRtnDt.SetInfo("m_NextTax_Day", 10);
            //    csRtnDt.AddInfoType("m_EmploymentPeriod", "雇用者への支払い間隔：日", McDefine.ValKind.DOUBLE);
            //    csRtnDt.SetInfo("m_EmploymentPeriod", 30);
            //    csRtnDt.AddInfoType("m_NextEmploymentUnitCost", "賃金単価　:万円／(人・日)", McDefine.ValKind.DOUBLE);
            //    csRtnDt.SetInfo("m_NextEmploymentUnitCost", 1.6);

            //}
            ////----------------------------------
            //else if (csModelKind == MzOceanBaseDefine.JAPAN_KIND)
            //{
            //    csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            //}
            //else if (csModelKind == MzOceanBaseDefine.FOREIGN_COUNTRYS_KIND)
            //{
            //    csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            //}
            //----------------------------------
            else if (csModelKind == MzOceanBaseDefine.BRANCH_CONFLUENT_KIND)
            {
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            }
            //--------------- ＣＳＶ出力モデル ------------
            else if (csModelKind == MzOceanBaseDefine.DEBUG_CSV_OUT_KIND)
            {
                csRtnDt = new McInitialInfo(csLibraryID, csModelKind);
            }
            else
            { }
            return csRtnDt;
        }

        //-----------------------------------------
        /// <summary>
        /// 層設定
        /// </summary>
        /// <param name="csPrptyDt"></param>
        /// <param name="iLayerNum"></param>
        /// <param name="dDepth"></param>
        /// <param name="dFace"></param>
        protected virtual void SetLayer(ref McCellModelPropertyInfo csPrptyDt,
            int iLayerNum, double dDepth) //, double dFace)
        {
            //csPrptyDt.SetStepTime((double)4 * 3600); // δT設定　sec ＝４時間

            csPrptyDt.AddInfoType("m_lLayerNumber", "モデル内鉛直方向分割数", McDefine.ValKind.LONG);
            csPrptyDt.SetInfo("m_lLayerNumber", iLayerNum);
            csPrptyDt.AddInfoType("m_dDepth", "海洋深度 [m]", McDefine.ValKind.DOUBLE);
            csPrptyDt.SetInfo("m_dDepth", dDepth);
            //csPrptyDt.AddInfoType("m_dFace", "セルの広さ[Km2]", McDefine.ValKind.DOUBLE);
            //csPrptyDt.SetInfo("m_dFace", dFace);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="csPrptyDt"></param>
        /// <param name="dSelfSize">個体の大きさ mm</param>
        /// <param name="dSelfWeight">個体の重量 g</param>
        /// <param name="dBulkDensity">比重g</param>
        /// <param name="dEatK">一日の必要捕食量 ：個体重量比 </param>
        /// <param name="dIncDctyRatio">体内での比重の増加率 </param>
        protected virtual void SetMetabolism(ref McCellModelPropertyInfo csPrptyDt,
            double dSelfSize, double dSelfWeight, double dBulkDensity,
            double dEatK, double dMetabolismK, double dIncDctyRatio)
        {
            csPrptyDt.AddInfoType("m_dSelfSize", "一個体の大きさ mm ", McDefine.ValKind.DOUBLE);
            csPrptyDt.SetInfo("m_dSelfSize", dSelfSize);
            csPrptyDt.AddInfoType("m_dSelfWeight", "一個体の体重 g ", McDefine.ValKind.DOUBLE);
            csPrptyDt.SetInfo("m_dSelfWeight", dSelfWeight);
            csPrptyDt.AddInfoType("m_dBulkDensity", "比重 ", McDefine.ValKind.DOUBLE);
            csPrptyDt.SetInfo("m_dBulkDensity", dBulkDensity);

            csPrptyDt.AddInfoType("m_dEatK", "一日に必要な捕食量：個体の重量比", McDefine.ValKind.DOUBLE);
            csPrptyDt.SetInfo("m_dEatK", dEatK);
            csPrptyDt.AddInfoType("m_dMetabolismK", ">一日の代謝による体重減少量：個体の重量比", McDefine.ValKind.DOUBLE);
            csPrptyDt.SetInfo("m_dMetabolismK", dMetabolismK);
            csPrptyDt.AddInfoType("m_dIncDctyRatio", "体内での比重の増加率", McDefine.ValKind.DOUBLE);
            csPrptyDt.SetInfo("m_dIncDctyRatio", dIncDctyRatio);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="csPrptyDt"></param>
        /// <param name="CapturedRatio"></param>
        /// <param name="O2AbsRatio"></param>
        /// <param name="CO2GenRatio"></param>
        protected virtual void SetMetabolism2(ref McCellModelPropertyInfo csPrptyDt,
            double O2AbsRatio, double CO2GenRatio, double dMaxProliferation)
        {
            csPrptyDt.AddInfoType("m_dMaxProliferation", "1日当たりの増殖率", McDefine.ValKind.DOUBLE);
            csPrptyDt.SetInfo("m_dMaxProliferation", dMaxProliferation);

            csPrptyDt.AddInfoType("m_O2AbsRatio", "酸素吸収率", McDefine.ValKind.DOUBLE);
            csPrptyDt.SetInfo("m_O2AbsRatio", O2AbsRatio);
            csPrptyDt.AddInfoType("m_CO2GenRatio", "二酸化炭素発生率", McDefine.ValKind.DOUBLE);
            csPrptyDt.SetInfo("m_CO2GenRatio", CO2GenRatio);
        }

        protected virtual void SetEexcretion(ref McCellModelPropertyInfo csPrptyDt, double m_dEexcretionRatio, double m_dEexcretionSize)
        {
            csPrptyDt.AddInfoType("m_dEexcretionRatio", "排泄量：捕食量に対する重量比", McDefine.ValKind.DOUBLE);
            csPrptyDt.SetInfo("m_dEexcretionRatio", m_dEexcretionRatio);
            csPrptyDt.AddInfoType("m_dEexcretionSize", "排泄物サイズ：体の大きさに対する比", McDefine.ValKind.DOUBLE);
            csPrptyDt.SetInfo("m_dEexcretionSize", m_dEexcretionSize);
        }

        protected virtual void SetDeath(ref McCellModelPropertyInfo csPrptyDt, double dDeathRatio)
        {
            csPrptyDt.AddInfoType("m_dDeathRatio", "死亡率", McDefine.ValKind.DOUBLE);
            csPrptyDt.SetInfo("m_dDeathRatio", dDeathRatio);
        }

        /// <summary>
        /// 初期の数量を設定
        /// </summary>
        /// <param name="csIniDt"></param>
        /// <param name="d0"></param>
        /// <param name="d1"></param>
        /// <param name="d2"></param>
        /// <param name="d3"></param>
        /// <param name="d4"></param>
        /// <param name="d5"></param>
        /// <param name="d6"></param>
        protected virtual void SetInitMass(ref McInitialInfo csIniDt,
            double d0, double d1, double d2, double d3, double d4, double d5, double d6)
        {
            csIniDt.AddInfoType("TotalMass_L0", "海面表層：初期存在量", McDefine.ValKind.DOUBLE);
            csIniDt.SetInfo("TotalMass_L0", d0);
            csIniDt.AddInfoType("TotalMass_L1", "真光層：初期存在量", McDefine.ValKind.DOUBLE);
            csIniDt.SetInfo("TotalMass_L1", d1);
            csIniDt.AddInfoType("TotalMass_L2", "透光層：初期存在量", McDefine.ValKind.DOUBLE);
            csIniDt.SetInfo("TotalMass_L2", d2);
            csIniDt.AddInfoType("TotalMass_L3", "中深層：初期存在量", McDefine.ValKind.DOUBLE);
            csIniDt.SetInfo("TotalMass_L3", d3);
            csIniDt.AddInfoType("TotalMass_L4", "漸深層：初期存在量", McDefine.ValKind.DOUBLE);
            csIniDt.SetInfo("TotalMass_L4", d4);
            csIniDt.AddInfoType("TotalMass_L5", "深海層：初期存在量", McDefine.ValKind.DOUBLE);
            csIniDt.SetInfo("TotalMass_L5", d5);
            csIniDt.AddInfoType("TotalMass_L6", "海底：初期存在量", McDefine.ValKind.DOUBLE);
            csIniDt.SetInfo("TotalMass_L6", d6);

        }
        //-----------------------------------------

        /// <summary>
        /// 人間行為の間隔
        /// </summary>
        /// <param name="csPrptyDtName">日</param>
        /// <param name="dTime"></param>
        protected virtual void SetHumanActionSpanTime(ref McCellModelPropertyInfo csPrptyDt, string csPrptyDtName, double dDay)
        {
            csPrptyDt.AddInfoType("m_HmnActTimeSpan", csPrptyDtName, McDefine.ValKind.DOUBLE);
            csPrptyDt.SetInfo("m_HmnActTimeSpan", dDay);
        }
        
        /// <summary>
        /// 行った作業行為の生産への直接的寄与率
        /// </summary>
        /// <param name="csPrptyDt"></param>
        /// <param name="csPrptyDtName"></param>
        /// <param name="dVal"></param>
        protected virtual void SetHumanActionValue(ref McCellModelPropertyInfo csPrptyDt, string csPrptyDtName, double dVal)
        {
            csPrptyDt.AddInfoType("m_ContributionRatioForProduct", csPrptyDtName, McDefine.ValKind.DOUBLE);
            csPrptyDt.SetInfo("m_ContributionRatioForProduct", dVal);
        }

        /// <summary>
        /// 人間の行為によるCO3排出量：Kg/Day
        /// </summary>
        /// <param name="csPrptyDt"></param>
        /// <param name="sTitle"></param>
        /// <param name="dDay"></param>
        protected virtual void SetHumanActionCO2Emission(ref McCellModelPropertyInfo csPrptyDt, string sTitle, double dCO2)
        {
            csPrptyDt.AddInfoType("m_HmnCO2EmissionDay", sTitle, McDefine.ValKind.DOUBLE);
            csPrptyDt.SetInfo("m_HmnCO2EmissionDay", dCO2);
        }

        /// <summary>
        /// 設備
        /// </summary>
        /// <param name="csInitDt"></param>
        /// <param name="sTitle"></param>
        /// <param name="dFacility"></param>
        /// <param name="Depreciation"></param>
        protected virtual void SetHumanInitFacility(ref McInitialInfo csInitDt,
             double dFacility, double Depreciation,string sTitle="初期設備")
        {
            csInitDt.AddInfoType("m_Facility", sTitle + "：億円", McDefine.ValKind.DOUBLE);
            csInitDt.SetInfo("m_Facility", dFacility);
            csInitDt.AddInfoType("m_DepreciationRate", sTitle+":減価償却(年率 1～0)", McDefine.ValKind.DOUBLE);
            csInitDt.SetInfo("m_DepreciationRate", Depreciation);
        }
 
        /// <summary>
        /// 初期資本
        /// </summary>
        /// <param name="csInitDt"></param>
        /// <param name="CapitalStock"></param>
        /// <param name="Chash"></param>
        /// <param name="sTitle"></param>
        protected virtual void SetHumanInitCapital(ref McInitialInfo csInitDt,
             double CapitalStock, double Chash, string sTitle="初期資本額")
        {
            csInitDt.AddInfoType("m_CapitalStock", sTitle + "：億円", McDefine.ValKind.DOUBLE);
            csInitDt.SetInfo("m_CapitalStock", CapitalStock);
            csInitDt.AddInfoType("m_Chash", sTitle + "：億円" + ":キャッシュ", McDefine.ValKind.DOUBLE);
            csInitDt.SetInfo("m_Chash", Chash);
        }
        /// <summary>
        /// 初期負債
        /// </summary>
        /// <param name="csInitDt"></param>
        /// <param name="Debt"></param>
        /// <param name="DebtInterestRate"></param>
        /// <param name="sTitle"></param>
        protected virtual void SetHumanInitDebt(ref McInitialInfo csInitDt,
            double Debt, double DebtInterestRate, string sTitle="初期負債額")
        {
            csInitDt.AddInfoType("m_Debt", sTitle + "：億円", McDefine.ValKind.DOUBLE);
            csInitDt.SetInfo("m_Debt", Debt);
            csInitDt.AddInfoType("m_DebtInterestRate", sTitle + ":年利(1～0)", McDefine.ValKind.DOUBLE);
            csInitDt.SetInfo("m_DebtInterestRate", DebtInterestRate);
        }
        /// <summary>
        /// 初期債権
        /// </summary>
        /// <param name="csInitDt"></param>
        /// <param name="Credit"></param>
        /// <param name="CreditInterestRate"></param>
        /// <param name="sTitle"></param>
        protected virtual void SetHumanInitCredit(ref McInitialInfo csInitDt,
           double Credit, double CreditInterestRate, string sTitle="初期債権額")
        {
            csInitDt.AddInfoType("m_Credit", sTitle + "：億円", McDefine.ValKind.DOUBLE);
            csInitDt.SetInfo("m_Credit", Credit);
            csInitDt.AddInfoType("m_CreditInterestRate", sTitle + ":（負債と返却）年利(1～0)", McDefine.ValKind.DOUBLE);
            csInitDt.SetInfo("m_CreditInterestRate", CreditInterestRate);
        }
        /// <summary>
        /// 初回発注
        /// </summary>
        /// <param name="csInitDt"></param>
        /// <param name="InitOrderProduct"></param>
        /// <param name="InitOrderWork"></param>
        /// <param name="sTitle"></param>
        protected virtual void SetHumanInitorder(ref McInitialInfo csInitDt,
           double InitOrderProduct,double dNowUnitCost, double InitOrderWork, double InitEstimatedCost, string sTitle = "初期発注")
        {
            csInitDt.AddInfoType("m_dNextDealingChash", sTitle+"(製品)：億円", McDefine.ValKind.DOUBLE);
            csInitDt.SetInfo("m_dNextDealingChash", InitOrderProduct);
            csInitDt.AddInfoType("m_dNowUnitCost", sTitle + "(製品単価)：億円", McDefine.ValKind.DOUBLE);
            csInitDt.SetInfo("m_dNowUnitCost", dNowUnitCost);
            csInitDt.AddInfoType("m_OrdersPlaced", sTitle + "(非製品)：億円", McDefine.ValKind.DOUBLE);
            csInitDt.SetInfo("m_OrdersPlaced", InitOrderWork);
            csInitDt.AddInfoType("m_EstimatedCost", sTitle + "に対する見積もり額：億円", McDefine.ValKind.DOUBLE);
            csInitDt.SetInfo("m_EstimatedCost", InitEstimatedCost);
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル情報提供</para>
        /// </summary>
        /// <example>
        /// <para>usage:</para>
        /// <para>HySDataLinkedList csModelInfoList = GetCalModelInfoList();</para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>モデル情報のリスト</returns>
        /// <exception cref="">無し</exception>
        /// <remarks>
        /// <para>remarks:</para>
        /// <para>モデル情報(McModelInfo)をリスト形式で返却する</para>
        /// </remarks>
        public override HySDataLinkedList GetCalModelInfoList()
        {
            McModelInfo csModelInfo = null;

            //--
            csModelInfo = new McModelInfo(
                    (HySID)this.GetFactoryID(),
                    McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                    new HySObjectKind("CAL_OCEAN_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
                    MzOceanBaseDefine.OCEAN_COLUMN_KIND, // モデルの識別子
                    MzOceanBaseDefine.OCEAN_COLUMN_NAME  // モデルの名称
                                          );
            csModelInfo.SetVersionInf("Ver1.0 ");
            csModelInfo.SetSummaryInf("海の地域１単位面(Ocean Column)");
            csModelInfo.SetCreatorInf("S.H.");
            csModelInfo.SetIconName(@"Ocean\OceanLayer");
            csModelInfo.SetManualFileName(@".\Ocean\SampleModelExplanation.pdf"); // <-- モデル解説書

            m_csCalModelInforList.AddLast(csModelInfo);


            //csModelInfo = new McModelInfo(
            //        (HySID)this.GetFactoryID(),
            //        McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
            //        new HySObjectKind("CAL_OCEAN_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
            //        MzOceanBaseDefine.NEKTONS_KIND, // モデルの識別子
            //        MzOceanBaseDefine.NEKTONS_NAME  // モデルの名称
            //                               );
            //csModelInfo.SetVersionInf("Ver1.0");
            //csModelInfo.SetSummaryInf("ネクトン類（Nekton) （魚類含む）モデル");
            //csModelInfo.SetCreatorInf("S.H.");
            //csModelInfo.SetIconName(@"Ocean\Nekton02");
            //csModelInfo.SetManualFileName(@".\Ocean\SampleModelExplanation.pdf"); // <-- モデル解説書

            ////csModelInfo.SetLibraryDispMode(false);  // ライブラリーツリーは非表示
            //m_csCalModelInforList.AddLast(csModelInfo);

            //--
            //csModelInfo = new McModelInfo(
            //            (HySID)this.GetFactoryID(),
            //            McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
            //            new HySObjectKind("CAL_OCEAN_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
            //            MzOceanBaseDefine.COPEPODS_KIND, // モデルの識別子
            //            MzOceanBaseDefine.COPEPODS_NAME  // モデルの名称
            //                     );

            //csModelInfo.SetVersionInf("Ver1.0");
            //csModelInfo.SetSummaryInf("カイアシ類（Copepods)  動物プランクトンの一種");
            //csModelInfo.SetCreatorInf("S.H.");
            //csModelInfo.SetIconName(@"Ocean\Copepods");
            //csModelInfo.SetManualFileName(@".\Ocean\SampleModelExplanation.pdf"); // <-- モデル解説書

            //m_csCalModelInforList.AddLast(csModelInfo);

            //--
            //csModelInfo = new McModelInfo(
            //        (HySID)this.GetFactoryID(),
            //        McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
            //        new HySObjectKind("CAL_OCEAN_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
            //        MzOceanBaseDefine.ZOOPLANKTONS_KIND, // モデルの識別子
            //        MzOceanBaseDefine.ZOOPLANKTONS_NAME  // モデルの名称
            //                              );
            //csModelInfo.SetVersionInf("Ver1.0 ");
            //csModelInfo.SetSummaryInf("動物プランクトン（Zpoplankton)");
            //csModelInfo.SetCreatorInf("S.H.");
            //csModelInfo.SetIconName(@"Ocean\Zpoplankton02");
            //csModelInfo.SetManualFileName(@".\Ocean\SampleModelExplanation.pdf"); // <-- モデル解説書

            //m_csCalModelInforList.AddLast(csModelInfo);

            //--
            //csModelInfo = new McModelInfo(
            //        (HySID)this.GetFactoryID(),
            //        McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
            //        new HySObjectKind("CAL_OCEAN_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
            //        MzOceanBaseDefine.PHYTOPLANKTONS_KIND, // モデルの識別子
            //        MzOceanBaseDefine.PHYTOPLANKTONS_NAME  // モデルの名称
            //                              );
            //csModelInfo.SetVersionInf("Ver1.0 ");
            //csModelInfo.SetSummaryInf("植物プランクトン（Phytoplankton)");
            //csModelInfo.SetCreatorInf("S.H.");
            //csModelInfo.SetIconName(@"Ocean\Phytoplankton02");
            //csModelInfo.SetManualFileName(@".\Ocean\SampleModelExplanation.pdf"); // <-- モデル解説書

            //m_csCalModelInforList.AddLast(csModelInfo);

            ////--
            //csModelInfo = new McModelInfo(
            //        (HySID)this.GetFactoryID(),
            //        McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
            //        new HySObjectKind("CAL_OCEAN_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
            //        MzOceanBaseDefine.BACTERIA_KIND, // モデルの識別子
            //        MzOceanBaseDefine.BACTERIA_NAME  // モデルの名称
            //                              );
            //csModelInfo.SetVersionInf("Ver1.0 ");
            //csModelInfo.SetSummaryInf("細菌（Bacteria)");
            //csModelInfo.SetCreatorInf("S.H.");
            //csModelInfo.SetIconName(@"Ocean\Bacteria");
            //csModelInfo.SetManualFileName(@".\Ocean\SampleModelExplanation.pdf"); // <-- モデル解説書

            //m_csCalModelInforList.AddLast(csModelInfo);

            ////--
            //csModelInfo = new McModelInfo(
            //        (HySID)this.GetFactoryID(),
            //        McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
            //        new HySObjectKind("CAL_OCEAN_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
            //        MzOceanBaseDefine.VIRUS_KIND, // モデルの識別子
            //        MzOceanBaseDefine.VIRUS_NAME  // モデルの名称
            //                              );
            //csModelInfo.SetVersionInf("Ver1.0 ");
            //csModelInfo.SetSummaryInf("ウイルス（Virus)");
            //csModelInfo.SetCreatorInf("S.H.");
            //csModelInfo.SetIconName(@"Ocean\Virus");
            //csModelInfo.SetManualFileName(@".\Ocean\SampleModelExplanation.pdf"); // <-- モデル解説書

            //m_csCalModelInforList.AddLast(csModelInfo);

            ////--
            //csModelInfo = new McModelInfo(
            //        (HySID)this.GetFactoryID(),
            //        McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
            //        new HySObjectKind("CAL_OCEAN_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
            //        MzOceanBaseDefine.DETRITUS_KIND, // モデルの識別子
            //        MzOceanBaseDefine.DETRITUS_NAME  // モデルの名称
            //                              );
            //csModelInfo.SetVersionInf("Ver1.0 ");
            //csModelInfo.SetSummaryInf("デトリタス（Detritus)  死骸、糞等 ");
            //csModelInfo.SetCreatorInf("S.H.");
            //csModelInfo.SetIconName(@"Ocean\Detritus02");
            //csModelInfo.SetManualFileName(@".\Ocean\SampleModelExplanation.pdf"); // <-- モデル解説書

            //m_csCalModelInforList.AddLast(csModelInfo);

            //--
            //csModelInfo = new McModelInfo(
            //        (HySID)this.GetFactoryID(),
            //        McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
            //        new HySObjectKind("CAL_OCEAN_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
            //        MzOceanBaseDefine.FERTILIZER_KIND, // モデルの識別子
            //        MzOceanBaseDefine.FERTILIZER_NAME  // モデルの名称
            //                              );
            //csModelInfo.SetVersionInf("Ver1.0 ");
            //csModelInfo.SetSummaryInf("栄養素（Nutrient) ");
            //csModelInfo.SetCreatorInf("S.H.");
            //csModelInfo.SetIconName(@"Ocean\Nutrient");
            //csModelInfo.SetManualFileName(@".\Ocean\SampleModelExplanation.pdf"); // <-- モデル解説書

            //m_csCalModelInforList.AddLast(csModelInfo);

            //--
            //csModelInfo = new McModelInfo(
            //        (HySID)this.GetFactoryID(),
            //        McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
            //        new HySObjectKind("CAL_OCEAN_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
            //        McOceanBaseDefine.MINERAL_KIND, // モデルの識別子
            //        McOceanBaseDefine.MINERAL_NAME  // モデルの名称
            //                              );
            //csModelInfo.SetVersionInf("Ver1.0 ");
            //csModelInfo.SetSummaryInf("ミネラル（Mineral) ");
            //csModelInfo.SetCreatorInf("S.H.");
            //csModelInfo.SetIconName(@"Ocean\Mineral");
            //csModelInfo.SetManualFileName(@".\Ocean\SampleModelExplanation.pdf"); // <-- モデル解説書

            //m_csCalModelInforList.AddLast(csModelInfo);

            //--
            //csModelInfo = new McModelInfo(
            //        (HySID)this.GetFactoryID(),
            //        McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
            //        new HySObjectKind("CAL_OCEAN_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
            //        MzOceanBaseDefine.DISSOLVE_GAS_KIND, // モデルの識別子
            //        MzOceanBaseDefine.DISSOLVE_GAS_NAME  // モデルの名称
            //                              );
            //csModelInfo.SetVersionInf("Ver1.0 ");
            //csModelInfo.SetSummaryInf("溶融ガス(主にO2,CO2)");
            //csModelInfo.SetCreatorInf("S.H.");
            //csModelInfo.SetIconName(@"Ocean\dissolveGas");
            //csModelInfo.SetManualFileName(@".\Ocean\SampleModelExplanation.pdf"); // <-- モデル解説書

            //m_csCalModelInforList.AddLast(csModelInfo);

            //--
            //csModelInfo = new McModelInfo(
            //        (HySID)this.GetFactoryID(),
            //        McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
            //        new HySObjectKind("CAL_OCEAN_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
            //        McOceanBaseDefine.POM_KIND, // モデルの識別子
            //        McOceanBaseDefine.POM_NAME  // モデルの名称
            //                              );
            //csModelInfo.SetVersionInf("Ver1.0 ");
            //csModelInfo.SetSummaryInf("粒子状有機物（POM）  ");
            //csModelInfo.SetCreatorInf("S.H.");
            //csModelInfo.SetIconName(@"Ocean\POM");
            //csModelInfo.SetManualFileName(@".\Ocean\SampleModelExplanation.pdf"); // <-- モデル解説書

            //m_csCalModelInforList.AddLast(csModelInfo);

            //--
            //csModelInfo = new McModelInfo(
            //        (HySID)this.GetFactoryID(),
            //        McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
            //        new HySObjectKind("CAL_OCEAN_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
            //        McOceanBaseDefine.DOM_KIND, // モデルの識別子
            //        McOceanBaseDefine.DOM_NAME  // モデルの名称
            //                              );
            //csModelInfo.SetVersionInf("Ver1.0 ");
            //csModelInfo.SetSummaryInf("溶存有機物（DOM） ");
            //csModelInfo.SetCreatorInf("S.H.");
            //csModelInfo.SetIconName(@"Ocean\DOM");
            //csModelInfo.SetManualFileName(@".\Ocean\SampleModelExplanation.pdf"); // <-- モデル解説書

            //m_csCalModelInforList.AddLast(csModelInfo);

            //--
            //csModelInfo = new McModelInfo(
            //        (HySID)this.GetFactoryID(),
            //        McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
            //        new HySObjectKind("CAL_OCEAN_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
            //        McOceanBaseDefine.InO_PARTICULATES_KIND, // モデルの識別子
            //        McOceanBaseDefine.InO_PARTICULATES_NAME  // モデルの名称
            //                              );
            //csModelInfo.SetVersionInf("Ver1.0 ");
            //csModelInfo.SetSummaryInf("粒子状無機物（Inorganic Particulates）");
            //csModelInfo.SetCreatorInf("S.H.");
            //csModelInfo.SetIconName(@"Ocean\InorganicParticulates");
            //csModelInfo.SetManualFileName(@".\Ocean\SampleModelExplanation.pdf"); // <-- モデル解説書

            //m_csCalModelInforList.AddLast(csModelInfo);

            //--
            csModelInfo = new McModelInfo(
                    (HySID)this.GetFactoryID(),
                    McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
                    new HySObjectKind("CAL_OCEAN_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
                    MzOceanBaseDefine.ATMOSPHERE_KIND, // モデルの識別子
                    MzOceanBaseDefine.ATMOSPHERE_NAME  // モデルの名称
                                          );
            csModelInfo.SetVersionInf("Ver1.0 ");
            csModelInfo.SetSummaryInf("大気圏（atmosphere)  ");
            csModelInfo.SetCreatorInf("S.H.");
            csModelInfo.SetIconName(@"Ocean\Atmosphere");
            csModelInfo.SetManualFileName(@".\Ocean\SampleModelExplanation.pdf"); // <-- モデル解説書

            m_csCalModelInforList.AddLast(csModelInfo);

            ////--
            //csModelInfo = new McModelInfo(
            //        (HySID)this.GetFactoryID(),
            //        McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
            //        new HySObjectKind("CAL_OCEAN_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
            //        McOceanBaseDefine.SEA_SURFACE_KIND, // モデルの識別子
            //        McOceanBaseDefine.SEA_SURFACE_NAME  // モデルの名称
            //                              );
            //csModelInfo.SetVersionInf("Ver1.0 ");
            //csModelInfo.SetSummaryInf("海面（sea surface) ");
            //csModelInfo.SetCreatorInf("S.H.");
            //csModelInfo.SetIconName(@"Ocean\Surface");
            //csModelInfo.SetManualFileName(@".\Ocean\SampleModelExplanation.pdf"); // <-- モデル解説書

            //m_csCalModelInforList.AddLast(csModelInfo);

            ////--
            //csModelInfo = new McModelInfo(
            //    (HySID)this.GetFactoryID(),
            //    McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
            //    new HySObjectKind("CAL_OCEAN_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
            //    McOceanBaseDefine.OCEAN_OVERALL_KIND, // モデルの識別子
            //    McOceanBaseDefine.OCEAN_OVERALL_NAME  // モデルの名称
            //                  );
            //csModelInfo.SetVersionInf("Ver1.0 ");
            //csModelInfo.SetSummaryInf("海域全体(Ocean)");
            //csModelInfo.SetCreatorInf("S.H.");
            //csModelInfo.SetIconName(@"Ocean\OceanLayer");
            //csModelInfo.SetManualFileName(@".\Ocean\SampleModelExplanation.pdf"); // <-- モデル解説書

            //m_csCalModelInforList.AddLast(csModelInfo);


            //---------------------------
            //csModelInfo = new McModelInfo(
            //        (HySID)this.GetFactoryID(),
            //        McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
            //        new HySObjectKind("CAL_OCEAN_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
            //        MzOceanBaseDefine.HUMAN_FERTILIZER_KIND, // モデルの識別子
            //        MzOceanBaseDefine.HUMAN_FERTILIZER_NAME  // モデルの名称
            //                              );
            //csModelInfo.SetVersionInf("Ver1.0 ");
            //csModelInfo.SetSummaryInf("人間による施肥 ");
            //csModelInfo.SetCreatorInf("S.H.");
            //csModelInfo.SetIconName(@"Ocean\Ship02");
            //csModelInfo.SetManualFileName(@".\Ocean\SampleModelExplanation.pdf"); // <-- モデル解説書

            //m_csCalModelInforList.AddLast(csModelInfo);

            //-----
            //csModelInfo = new McModelInfo(
            //        (HySID)this.GetFactoryID(),
            //        McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
            //        new HySObjectKind("CAL_OCEAN_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
            //        MzOceanBaseDefine.HUMAN_FISHING_KIND, // モデルの識別子
            //        MzOceanBaseDefine.HUMAN_FISHING_NAME  // モデルの名称
            //                              );
            //csModelInfo.SetVersionInf("Ver1.0 ");
            //csModelInfo.SetSummaryInf("漁業事業者");
            //csModelInfo.SetCreatorInf("S.H.");
            //csModelInfo.SetIconName(@"Ocean\FishShip02");
            //csModelInfo.SetManualFileName(@".\Ocean\SampleModelExplanation.pdf"); // <-- モデル解説書

            //m_csCalModelInforList.AddLast(csModelInfo);

            //------------------ 経済モデル ------------------------
            //csModelInfo = new McModelInfo(
            //        (HySID)this.GetFactoryID(),
            //        McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
            //        new HySObjectKind("CAL_OCEAN_ECONOMIC_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
            //        MzOceanBaseDefine.HUMAN_OCEAN_DEVELOP_KIND, // モデルの識別子
            //        MzOceanBaseDefine.HUMAN_OCEAN_DEVELOP_NAME  // モデルの名称
            //      );
            //csModelInfo.SetVersionInf("Ver1.0 ");
            //csModelInfo.SetSummaryInf("遠海洋開発事業者");
            //csModelInfo.SetCreatorInf("S.H.");
            //csModelInfo.SetIconName(@"Ocean\Building1");
            //csModelInfo.SetManualFileName(@".\Ocean\SampleModelExplanation.pdf"); // <-- モデル解説書

            //m_csCalModelInforList.AddLast(csModelInfo);

            //--
            //csModelInfo = new McModelInfo(
            //        (HySID)this.GetFactoryID(),
            //        McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
            //        new HySObjectKind("CAL_OCEAN_ECONOMIC_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
            //        MzOceanBaseDefine.HUMAN_FERTILIZZER_FACTORY_KIND, // モデルの識別子
            //        MzOceanBaseDefine.HUMAN_FERTILIZZER_FACTORY_NAME  // モデルの名称
            //                  );
            //csModelInfo.SetVersionInf("Ver1.0 ");
            //csModelInfo.SetSummaryInf("遠海洋用の肥料生産工場");
            //csModelInfo.SetCreatorInf("S.H.");
            //csModelInfo.SetIconName(@"Ocean\Factory");
            //csModelInfo.SetManualFileName(@".\Ocean\SampleModelExplanation.pdf"); // <-- モデル解説書

            //m_csCalModelInforList.AddLast(csModelInfo);

            //--
            //csModelInfo = new McModelInfo(
            //        (HySID)this.GetFactoryID(),
            //        McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
            //        new HySObjectKind("CAL_OCEAN_ECONOMIC_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
            //        MzOceanBaseDefine.HUMAN_BIOFUEL_FACTORY_KIND, // モデルの識別子
            //        MzOceanBaseDefine.HUMAN_BIOFUEL_FACTORY_NAME  // モデルの名称
            //                  );
            //csModelInfo.SetVersionInf("Ver1.0 ");
            //csModelInfo.SetSummaryInf("バイオ燃料洋上プラント");
            //csModelInfo.SetCreatorInf("S.H.");
            //csModelInfo.SetIconName(@"Ocean\Plant02");
            //csModelInfo.SetManualFileName(@".\Ocean\SampleModelExplanation.pdf"); // <-- モデル解説書

            //m_csCalModelInforList.AddLast(csModelInfo);

            //----
            //csModelInfo = new McModelInfo(
            //        (HySID)this.GetFactoryID(),
            //        McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
            //        new HySObjectKind("CAL_OCEAN_ECONOMIC_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
            //        MzOceanBaseDefine.HUMAN_EC_ACTION_KIND, // モデルの識別子
            //        MzOceanBaseDefine.HUMAN_EC_ACTION_NAME  // モデルの名称
            //                  );

            //csModelInfo.SetVersionInf("Ver1.0 ");
            //csModelInfo.SetSummaryInf("人間の活動 ");
            //csModelInfo.SetCreatorInf("S.H.");
            //csModelInfo.SetIconName(@"Yen");
            //csModelInfo.SetManualFileName(@".\Ocean\SampleModelExplanation.pdf"); // <-- モデル解説書

            //m_csCalModelInforList.AddLast(csModelInfo);

            //----
            //csModelInfo = new McModelInfo(
            //        (HySID)this.GetFactoryID(),
            //        McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
            //        new HySObjectKind("CAL_OCEAN_ECONOMIC_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
            //        MzOceanBaseDefine.HUMAN_SEA_EC_ACTION_KIND, // モデルの識別子
            //        MzOceanBaseDefine.HUMAN_SEA_EC_ACTION_NAME  // モデルの名称
            //                  );

            //csModelInfo.SetVersionInf("Ver1.0 ");
            //csModelInfo.SetSummaryInf("洋上での人間活動 ");
            //csModelInfo.SetCreatorInf("S.H.");
            //csModelInfo.SetIconName(@"Ocean\HumanAct");
            //csModelInfo.SetManualFileName(@".\Ocean\SampleModelExplanation.pdf"); // <-- モデル解説書

            //m_csCalModelInforList.AddLast(csModelInfo);

            //----
            //csModelInfo = new McModelInfo(
            //        (HySID)this.GetFactoryID(),
            //        McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
            //        new HySObjectKind("CAL_OCEAN_ECONOMIC_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
            //        MzOceanBaseDefine.CO2_RESEARCH_EMISSION_KIND, // モデルの識別子
            //        MzOceanBaseDefine.CO2_RESEARCH_EMISSION_NAME  // モデルの名称
            //                  );

            //csModelInfo.SetVersionInf("Ver1.0 ");
            //csModelInfo.SetSummaryInf("海洋のCO2排出調査 ");
            //csModelInfo.SetCreatorInf("S.H.");
            //csModelInfo.SetIconName(@"Ocean\IBUKI");
            //csModelInfo.SetManualFileName(@".\Ocean\SampleModelExplanation.pdf"); // <-- モデル解説書

            //m_csCalModelInforList.AddLast(csModelInfo);

            //----
            //csModelInfo = new McModelInfo(
            //        (HySID)this.GetFactoryID(),
            //        McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
            //        new HySObjectKind("CAL_OCEAN_ECONOMIC_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
            //        MzOceanBaseDefine.HUMAN_JPN_SOCIETY_KIND, // モデルの識別子
            //        MzOceanBaseDefine.HUMAN_JPN_SOCIETY_NAME  // モデルの名称
            //                  );

            //csModelInfo.SetVersionInf("Ver1.0 ");
            //csModelInfo.SetSummaryInf("日本の社会（海洋モデル）");
            //csModelInfo.SetCreatorInf("S.H.");
            //csModelInfo.SetIconName(@"Ocean\Society02");
            //csModelInfo.SetManualFileName(@".\Ocean\SampleModelExplanation.pdf"); // <-- モデル解説書

            //m_csCalModelInforList.AddLast(csModelInfo);

            //----------------------------------------------------
            //--
            //csModelInfo = new McModelInfo(
            //        (HySID)this.GetFactoryID(),
            //        McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
            //        new HySObjectKind("CAL_OCEAN_ECONOMIC_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
            //        MzOceanBaseDefine.FOREIGN_COUNTRYS_KIND, // モデルの識別子
            //        MzOceanBaseDefine.FOREIGN_COUNTRYS_NAME  // モデルの名称
            //                              );
            //csModelInfo.SetVersionInf("Ver1.0 ");
            //csModelInfo.SetSummaryInf("諸外国");
            //csModelInfo.SetCreatorInf("S.H.");
            //csModelInfo.SetIconName(@"Ocean\International");
            //csModelInfo.SetManualFileName(@".\Ocean\SampleModelExplanation.pdf"); // <-- モデル解説書

            //m_csCalModelInforList.AddLast(csModelInfo);

            //--
            //csModelInfo = new McModelInfo(
            //        (HySID)this.GetFactoryID(),
            //        McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
            //        new HySObjectKind("CAL_OCEAN_ECONOMIC_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
            //        MzOceanBaseDefine.JAPAN_KIND, // モデルの識別子
            //        MzOceanBaseDefine.JAPAN_NAME  // モデルの名称
            //                              );
            //csModelInfo.SetVersionInf("Ver1.0 ");
            //csModelInfo.SetSummaryInf("日本国＿共通活動");
            //csModelInfo.SetCreatorInf("S.H.");
            //csModelInfo.SetIconName(@"Ocean\Japan1");
            //csModelInfo.SetManualFileName(@".\Ocean\SampleModelExplanation.pdf"); // <-- モデル解説書

            //m_csCalModelInforList.AddLast(csModelInfo);

            ////----------------------------------------------------
            ////--
            //csModelInfo = new McModelInfo(
            //        (HySID)this.GetFactoryID(),
            //        McModelLibraryDefine.DIVISION_CALCULATION_MODEL, // <-- 演算モデルは、必ずこの値にして下さい（LibraryCategoryXML.xmlに記述されている）
            //        new HySObjectKind("CAL_OCEAN_MODELS"), // LibraryCategoryXML.xmlに記述されている <Category>タグ内のＩＤに対応します。 
            //        McOceanBaseDefine.BRANCH_CONFLUENT_KIND, // モデルの識別子
            //        McOceanBaseDefine.BRANCH_CONFLUENTBRANCH_CONFLUENT_NAME  // モデルの名称
            //                              );
            //csModelInfo.SetVersionInf("Ver1.0 ");
            //csModelInfo.SetSummaryInf("各種データの合流と分岐 ");
            //csModelInfo.SetCreatorInf("S.H.");
            //csModelInfo.SetIconName(@"Ocean\BranchConverging1");
            //csModelInfo.SetManualFileName(@".\Ocean\SampleModelExplanation.pdf"); // <-- モデル解説書

            //m_csCalModelInforList.AddLast(csModelInfo);


            //------------------ 入出力モデル ------------------------
            //ＣＳＶファイル（時系列）出力モデルならば
            csModelInfo = new McModelInfo(
                    (HySID)this.GetFactoryID(),
                    McModelLibraryDefine.DIVISION_OUTPUT_MODEL,
                    McModelLibraryDefine.MODEL_CLASSIFICATION_OUTPUT_SPF_FILE,
                    MzOceanBaseDefine.DEBUG_CSV_OUT_KIND,
                    MzOceanBaseDefine.DEBUG_CSV_OUT_NAME);
            csModelInfo.SetVersionInf("Ver1.0");
            csModelInfo.SetSummaryInf("海洋モデル　ディバッグ用CSV出力");//""
            csModelInfo.SetCreatorInf("S.H.");//"CommonMP"
            csModelInfo.SetManualFileName(@".\Ocean\SampleModelExplanation.pdf");
            csModelInfo.SetIconName("csvWrite");
            m_csCalModelInforList.AddLast(csModelInfo);

            return m_csCalModelInforList;
        }

    }    // end of class

}
