﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;


using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYMCO.CoreImpl.Data;

namespace CommonMP.HYMCO.Ocean.McOceanBaseModel
{
    /// <summary><para>class outline:</para>
    /// <para>海の地域１単位面(Ocean Column)モデル内演算中データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[2021/12/31][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class MzOceanAreaColumnModelCalInfo : MzOceanModelElementCalInfo
    {
        /// <summary> 位置番号：Ｘ </summary>
        public int m_iXNo = 0;
        /// <summary> 位置番号：Ｙ </summary>
        public int m_iYNo = 0;

        /// <summary> 層名称 </summary>
        public string[] m_sLayerName = null;

        /// <summary> デトリタスの大きさ分布 </summary>
        public int m_iDetritusSizeNum = MzOceanBaseDefine.iPARTICLE_SIZE_NUM;
        public double[] m_DetritusSize = null;  // サイズ[mm] 0.1μm,0.2μm,0.5μm,1μm,2μm,5μm, ～ 1m

        //// ―――物質の量分布――――
        ///// <summary> デトリタス1（Detritus1)  </summary>
        //public double[] m_Density_1 = null; //1.075;   // デトリタス１密度  [g/cm^3]
        //public double[][] m_DetritusMass_1 = null;  // 量 g/m3
        //public double[] m_SumDetritusMass = null;  // 各層の総量 g/m3

        /////// <summary> デトリタス2（Detritus2)  </summary>
        ////public double m_Density_2 =1.027;   // デトリタス２密度  [g/cm^3]   珪素：2.33    ホタテ貝殻(SS,密度= 2.53g/cm3)
        ////public double[][] m_DetritusMass_2 = null;  // 量 g/m3

        /////// <summary> デトリタス3（Detritus3)  </summary>
        ////public double m_Density_3 = 1.043;   // デトリタス３密度  [g/cm^3] 
        ////public double[][] m_DetritusMass_3 = null;  // 量 g/m3

        /// <summary> 粒子状無機物（InOrganic_Particulates） </summary>
        public double m_DensityIOP = 3.0;   //  粒子状無機物密度  [g/cm^3]　 珪素：2.33、岩石：2.8～3.5g／cm 3程度　鉄鉱石：（5.2g/cm3
        public double[][] m_IOPMass = null;  // 量 g/m3

        // ―――1日平均した　総浮遊物重量（有機物：無機物含む）――――
        /// <summary> 一日平均総重量（有機物無機物全て含んで、不溶性のもの g/m3）  </summary>
        public double[] m_meanAllMass = null; //

        //-----------------
        /// <summary>
        /// 
        /// </summary>
        public MzOceanAreaColumnModelCalInfo()
        {
            m_sLayerName = new string[this.m_lLayerNumber];

            m_sLayerName[0] = "表層混合層(surface mixed layer)";
            m_sLayerName[1] = "真光層（euphotic zone)";
            m_sLayerName[2] = "透光層(disphotic zone)";
            m_sLayerName[3] = "中深層（Mesopelagic zone)";
            m_sLayerName[4] = "漸深層（Bathypelagic zone)";
            m_sLayerName[5] = "深海層（Abyssopelagic zone)";
            m_sLayerName[6] = "海底（Bottom）";


            /// <summary> 粒子状有機物（POM） </summary>
            //m_Density_1 = new double[m_lLayerNumber]; // 1.027;   // デトリタス１密度  [g/cm^3]
            //m_Density_2 = 1.075;   // デトリタス２密度  [g/cm^3]   珪素：2.33    ホタテ貝殻(SS,密度= 2.53g/cm3)
            //m_Density_3 = 1.043;   // デトリタス３密度  [g/cm^3] 
            m_DensityIOP = 3.0;   // 粒子状無機物密度  [g/cm^3] 珪素：2.33、岩石：2.8～3.5g／cm 3程度　鉄鉱石：（5.2g/cm3

            m_iDetritusSizeNum = MzOceanBaseDefine.iPARTICLE_SIZE_NUM;
            m_DetritusSize = new double[m_iDetritusSizeNum];   // サイズ[mm] 0.1μm,0.2μm,0.5μm,1μm,2μm,5μm, ～ 1m
            //m_DetritusMass_1 = new double[m_lLayerNumber][];
            //m_DetritusMass_2 = new double[m_lLayerNumber][];
            //m_DetritusMass_3 = new double[m_lLayerNumber][];
            m_IOPMass = new double[m_lLayerNumber][];

            for (int ll = 0; ll < m_lLayerNumber; ll++)
            {
                m_IOPMass[ll] = new double[m_iDetritusSizeNum];
                for (int i = 0; i < m_iDetritusSizeNum; i++)
                {
                    m_IOPMass[ll][i] = 0.0;
                }
            }

            double dOrdr = 0.1E-3;
            for (int i = 0; i < m_iDetritusSizeNum; i++)
            {
                if (i % 3 == 0)
                {
                    m_DetritusSize[i] = dOrdr * 1.0;
                }
                else if (i % 3 == 1)
                {
                    m_DetritusSize[i] = dOrdr * 2.0;
                }
                else if (i % 3 == 2)
                {
                    m_DetritusSize[i] = dOrdr * 5.0;
                    dOrdr = dOrdr * 10.0;
                }
            }

        }

        public override void SetLayerNum(long iLayerNum)
        {
            base.SetLayerNum(iLayerNum);
            this.m_sLayerName = new string[this.m_lLayerNumber];
            this.m_meanAllMass = new double[this.m_lLayerNumber];
            for (int ll = 0; ll < m_lLayerNumber; ll++)
            {
                m_sLayerName[ll] = "";
                m_meanAllMass[ll] = 0.0;
            }
        }

        public override void Clear()
        {
            base.Clear();
            for (int ll = 0; ll < m_lLayerNumber; ll++)
            {
                for (int i = 0; i < m_iDetritusSizeNum; i++)
                {
                    //m_DetritusMass_1[ll][i] = 0.0;
                    //m_IOPMass[ll][i] = 0.0;
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別院スタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            MzOceanAreaColumnModelCalInfo csRtn = new MzOceanAreaColumnModelCalInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            MzOceanAreaColumnModelCalInfo csOrgDt = (MzOceanAreaColumnModelCalInfo)csOrgInfo;
            base.CopyInfo(csOrgInfo);

            m_iXNo = csOrgDt.m_iXNo;
            m_iYNo = csOrgDt.m_iYNo;

            m_sLayerName = new string[csOrgDt.m_lLayerNumber];

            m_DensityIOP = csOrgDt.m_DensityIOP;   // 粒子状無機物密度  [g/cm^3] 珪素：2.33、岩石：2.8～3.5g／cm 3程度　鉄鉱石：（5.2g/cm3
       
            m_iDetritusSizeNum = csOrgDt.m_iDetritusSizeNum;
            m_IOPMass = new double[csOrgDt.m_lLayerNumber][];

            for (int i = 0; i < csOrgDt.m_lLayerNumber; i++)
            {
                m_sLayerName[i] = csOrgDt.m_sLayerName[i];
                m_IOPMass[i] = new double[m_iDetritusSizeNum];
            }

            for (int i = 0; i < csOrgDt.m_lLayerNumber; i++)
            {
                for (int k = 0; k < csOrgDt.m_iDetritusSizeNum; k++)
                {
                    m_IOPMass[i][k] = csOrgDt.m_IOPMass[i][k];
                }
            }

            return true;
        }


 

    }
}

