﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYMCO.CoreImpl.Data;

using CommonMP.HYMCO.CoreOptionl.HymcoExpansionModel;

namespace CommonMP.HYMCO.Ocean.McOceanBaseModel
{

    [Serializable]
    public class MzCmnBranchConfluentCalInfo : MzOceanModelElementCalInfo // MoCashflowModelElementCalInfo
    {
        /// <summary>Sum 入力</summary>        
        public double[][] m_SumRsvINdata = null;
        public double[][] m_SumSndINdata = null;
        /// <summary>Sum 出力数</summary>  
        public double[][] m_SumRsvOUTdata = null;
        public double[][] m_SumSndOUTdata = null;

        public MzCmnBranchConfluentCalInfo()
        {
//            this.SetLayerNum(7);
        }

        public override void SetLayerNum(long iLayerNum)
        {
            base.SetLayerNum(iLayerNum);

            this.m_SumRsvINdata = new double[this.m_lLayerNumber][];
            this.m_SumSndINdata = new double[this.m_lLayerNumber][];
            this.m_SumRsvOUTdata = new double[this.m_lLayerNumber][];
            this.m_SumSndOUTdata = new double[this.m_lLayerNumber][];

            for (int ll = 0; ll < m_lLayerNumber; ll++)
            {

                m_SumRsvINdata[ll] = new double[8];
                m_SumSndINdata[ll] = new double[8];
                m_SumRsvOUTdata[ll] = new double[8];
                m_SumSndOUTdata[ll] = new double[8];
            }
            Clear();
        }
        public override void Clear()
        {
            for (int ll = 0; ll < m_lLayerNumber; ll++)
            {
                for (int i = 0; i < 8; i++)
                {
                    m_SumRsvINdata[ll][i] = 0.0;
                    m_SumSndINdata[ll][i] = 0.0;
                    m_SumRsvOUTdata[ll][i] = 0.0;
                    m_SumSndOUTdata[ll][i] = 0.0;
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別院スタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            MzCmnBranchConfluentCalInfo csRtn = new MzCmnBranchConfluentCalInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }

        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            MzCmnBranchConfluentCalInfo csOrgDt = (MzCmnBranchConfluentCalInfo)csOrgInfo;
            this.SetLayerNum(csOrgDt.m_lLayerNumber);
            for (long lLp = 0; lLp < csOrgDt.m_lLayerNumber; lLp++)
            {
                for (int i = 0; i < 8; i++)
                {
                    this.m_SumRsvINdata[lLp][i] = csOrgDt.m_SumRsvINdata[lLp][i];
                    this.m_SumSndINdata[lLp][i] = csOrgDt.m_SumSndINdata[lLp][i];
                    this.m_SumRsvOUTdata[lLp][i] = csOrgDt.m_SumRsvOUTdata[lLp][i];
                    this.m_SumSndOUTdata[lLp][i] = csOrgDt.m_SumSndOUTdata[lLp][i];
                }
            }
            return true;
        }

    }
}
