﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.Ocean.McOceanBaseModel;

namespace CommonMP.HYMCO.Ocean.McOceanSampleModels
{
    /// <summary><para>class outline:</para>
    /// <para>海洋人工施肥作業 演算中データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[2021/12/31][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public class MzOceanHmnFertilizationCalInfo : MzOceanHumanActCalInfo
    {
        // ―――物質の量分布――――
        /// <summary> 無機物粒子  </summary>
        public double m_Si_Size = 2.0;   // SiO2  サイズμｍ
        public double m_Fe_Size = 2.0;   // Fe2O　サイズμｍ
        public double m_IOPMass_Si = 1.0E-2;  // 量 g/m3
        public double m_IOPMass_Fe = 1.0E-2;  // 量 g/m3


        /// <summary> 散布したP量  </summary>
        public double m_N_Fertilize = 1.0E-4;
        /// <summary> 散布したN量  </summary>
        public double m_P_Fertilize = 15.0E-4;


        public MzOceanHmnFertilizationCalInfo()
        {
        }

        public override void SetLayerNum(long iLayerNum)
        {
            base.SetLayerNum(iLayerNum);
        }

        public override void Clear()
        {
            base.Clear();
            m_IOPMass_Si = 1.0E-2;
            m_IOPMass_Fe = 1.0E-2;
            m_N_Fertilize = 1.0E-4;
            m_P_Fertilize = 15.0E-4;
        }

        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別院スタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            MzOceanHmnFertilizationCalInfo csRtn = new MzOceanHmnFertilizationCalInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }
 
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            base.CopyInfo(csOrgInfo);
            MzOceanHmnFertilizationCalInfo csOrgDt = (MzOceanHmnFertilizationCalInfo)csOrgInfo;
            m_Si_Size = csOrgDt.m_Si_Size;
            m_Fe_Size = csOrgDt.m_Fe_Size;
            m_IOPMass_Fe = csOrgDt.m_IOPMass_Fe;
            m_IOPMass_Si = csOrgDt.m_IOPMass_Si;
            return true;
        }
    }
}
