﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Controller;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Tool;

using CommonMP.HYMCO.CoreOptionl.HymcoExpansionModel;

using CommonMP.HYMCO.Ocean.McOceanBaseModel;

namespace CommonMP.HYMCO.Ocean.McOceanSampleModels
{
    /// <summary><para>class outline:</para>
    /// <para> 動物プランクトン（Zpoplanktons) モデルクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[2021/12/31][新規作成]</para>
    public class MzOceanZpoplanktons : MzOceanModelElement
    {
        /// <summary> 演算データ（キャスト用） </summary>
        MzOceanZpoplanktonsCalInfo m_ZoPInf = null; // 便利の為、キャスト用に定義しておく

        //=========================
        // 演算実行前処理関連メソッド
        //=========================

        /// <summary><para>method outline:</para>
        /// <para>入力側の接続情報チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = CheckReceiveDataConnection(ref csErrorInf)</para>
        /// </example>
        /// <param name="csErrorInf">エラー出力</param>
        /// <param name="lInputDataNum">入力情報数</param>
        /// <param name="csInputCellData">演算に必要な入力情報配列</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>受信するデータが自モデルが期待している情報か否かをチェックする</para>
        /// </remarks>
        protected override bool CheckReceiveDataConnection(ref McStructErrorInfo csErrorInf, long lInputDataNum, McReceiveCellDataIF[] csInputCellData)
        {
            // チェック処理を入れる
            bool bRtn = base.CheckReceiveDataConnection(ref csErrorInf, lInputDataNum, csInputCellData);

            //// ディバッグ用送信データ
            //m_csDebugSendCnnct = this.PrepareSndPattern(MzOceanBaseDefine.DEBUG_OUT);
            return bRtn;
        }

        ///// <summary><para>method outline:</para>
        ///// <para>出力側の接続情報チェック</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para>bool bRtn = CheckSendDataConnection(ref csErrorInf)</para>
        ///// </example>
        ///// <param name="csErrorInf">エラー出力</param>
        ///// <param name="lOutputDataNum">出力情報数</param>
        ///// <param name="csOutputCellData">出力情報配列</param>
        ///// <returns>=true:正常、=false:異常</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>送信端子に設定されている伝送データが自モデルが期待している情報か否かをチェックする</para>
        ///// </remarks>
        //protected override bool CheckSendDataConnection(ref McStructErrorInfo csErrorInf, long lOutputDataNum, McSendCellDataIF[] csOutputCellData)
        //{
        //    // チェック処理を入れる
        //    bool bRtn = base.CheckSendDataConnection(ref csErrorInf, lOutputDataNum, csOutputCellData);
        //    return bRtn;
        //}

        protected virtual void SendDEBUG()
        {
            for (int i = 0; i < m_csDebugSendCnnct.m_RcvInfNum; i++)
            {
                HySCellData[] csCell = m_csDebugSendCnnct.m_csSndInfArry[i].PrepareSendCellD1();
                for (int ll = 0; ll < m_ZoPInf.m_lLayerNumber; ll++)
                {
                    csCell[ll].m_dData[0] = m_ZoPInf.m_TotalSelfMass[ll];
                    csCell[ll].m_dData[1] = m_ZoPInf.m_O2[ll];
                    csCell[ll].m_dData[2] = m_ZoPInf.m_CO2[ll];
                }
            }
        }


        /// <summary><para>method outline:</para>
        /// <para>モデルを初期化する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Initialize(csInitialData)</para>
        /// </example>
        /// <param name="csInitialData">初期化設定情報</param>
        /// <param name="lInputDataNum">入力情報数</param>
        /// <param name="csInputCellData">演算に必要な入力情報配列</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override bool Initialize(ref McPropertyInfoRoot csInitialData, long lInputDataNum, ref McReceiveCellDataIF[] csInputCellData)
        {
            bool bRtn = base.Initialize(ref csInitialData, lInputDataNum, ref csInputCellData);

            McInitialInfo csInDt = csInitialData as McInitialInfo;
            if (csInDt != null)
            {   // 初期化情報有り
                this.InitMass(ref csInDt);

                m_ZoPInf.d_NowTotalMass = 0.0;
                for (int ll = 0; ll < m_ZoPInf.m_lLayerNumber; ll++)
                {
                    // ●次回要求する＝＝＝＝用
                    // 自分が要求するFood量
                    m_ZoPInf.m_ReqFoodMass[ll] = m_ZoPInf.m_dEatK * m_ZoPInf.m_TotalSelfMass[ll] / m_ZoPInf.m_dEexcretionRatio;
                    // 自分が要求するO2量
                    m_ZoPInf.m_ReqO2[ll] = (1.0 / m_ZoPInf.m_O2AbsRatio) * m_ZoPInf.m_TotalSelfMass[ll] / m_ZoPInf.m_dEexcretionRatio;

                    m_ZoPInf.m_EatenMass[ll] = m_ZoPInf.m_ReqFoodMass[ll];
                    m_ZoPInf.m_O2[ll] = m_ZoPInf.m_ReqO2[ll];

                    // 
                    m_csOcnBacedlInf.m_TotalReqedPredationMass[ll] = m_csOcnBacedlInf.m_TotalSelfMass[ll] * 0.1;
                    m_csOcnBacedlInf.m_dCapturedMass[ll] = m_csOcnBacedlInf.m_TotalSelfMass[ll] * 0.1;
                    m_csOcnBacedlInf.m_TotalSelfMass[ll] -= m_csOcnBacedlInf.m_dCapturedMass[ll];
                    m_ZoPInf.d_TotalOUT += m_csOcnBacedlInf.m_dCapturedMass[ll];
                    m_ZoPInf.d_NowTotalMass += m_ZoPInf.m_TotalSelfMass[ll];
                }
                m_ZoPInf.d_PreTotalMass = m_ZoPInf.d_NowTotalMass;
            }
            return bRtn;
        }

        //=======================
        // 演算実行処理関連メソッド
        //=======================
        /// <summary>
        /// 受信
        /// </summary>
        protected override void ReceiveData()
        {
            ClearAllCalValue();

            // 呼吸関係
            ReceiveBREATHING();

            // 捕食：ネクトン等からの要求量の取得
            ReceiveReqPREDATION();
            // 捕食：植物プランクトン等の取得
            ReceivePREDATION();

            m_ZoPInf.d_TotalIN = 0.0;
            for (int i = 0; i < m_ZoPInf.m_lLayerNumber; i++)
            {
                m_ZoPInf.d_TotalIN += m_ZoPInf.m_EatenMass[i];
            }
            return;
        }

        /// <summary>
        /// 送信例
        /// </summary>
        protected override void SendData()
        {
            // 被捕食：ネクトンに捕食される
            SendPREDATION(m_csOcnBacedlInf.m_dCapturedMass, 0.1, 0.005);
            // 捕食物:植物プランクトンの捕食
            SendReqPREDATION(m_ZoPInf.m_ReqFoodMass );

            // 呼吸
            SendBREATHING();

            // 糞・死
            SendEXCRETION_DEATH(m_csOcnBacedlInf.m_dExcretionDencity, m_csOcnBacedlInf.m_dBulkDensity);
  
            // Debug
            SendDEBUG();

            //----- Debug Check ------
            double dChk = (m_ZoPInf.d_NowTotalMass - m_ZoPInf.d_PreTotalMass) - (m_ZoPInf.d_TotalIN - m_ZoPInf.d_TotalOUT);
            McLog.DebugOut("MzOceanZpoplanktons", "SendData", "動物プランクトン総量チェック:" + dChk.ToString() + " = "
                + (m_ZoPInf.d_NowTotalMass - m_ZoPInf.d_PreTotalMass).ToString() + " - " + (m_ZoPInf.d_TotalIN - m_ZoPInf.d_TotalOUT).ToString());
            //------------------------

            return;
        }

        /// <summary><para>method outline:</para>
        /// <para>モデル演算</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lRtn = Calculate(ref csInputDataList)</para>
        /// </example>
        /// <param name="lOnlyReceveDataNum">入力だけの情報数</param>
        /// <param name="csOnlyReceiveCellData">入力だけの情報配列</param>
        /// <param name="lOnlySendDataNum">出力だけの情報数</param>
        /// <param name="csOnlySelDataCellData">出力だけの情報配列</param>
        /// <param name="lRcvSndDataNum">相互接続報数</param>
        /// <param name="csReceiveCellData">相互接続入力側情報配列</param>
        /// <param name="csSelDataCellData">相互接続出力側情報配列</param>
        /// <returns>=0:正常 -1:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>派生クラス側で必ずオーバライドする必要がある</para>
        /// </remarks>
        protected override long Calculate(
            long lOnlyReceveDataNum, ref McReceiveOnlyTranInfo[] csOnlyReceiveCellData,
            long lOnlySendDataNum, ref McSendOnlyTranInfo[] csOnlySelDataCellData,
            long lRcvSndDataNum, ref McRdvSndTranInfoPair[] csRcvSndCelDataCellData
            )
        {
            m_ZoPInf.d_dltMass = 0.0;
            // 水深
            double dH = 0.0;
            // 摂食-排糞-排瀧-自然
            for (int ll = 0; ll < m_ZoPInf.m_lLayerNumber; ll++)
            {
                double dMasAriveFood = m_ZoPInf.m_dEatK * m_ZoPInf.m_TotalSelfMass[ll];
                double dMass = 1E-42;
                double dDeath = 0.0;
                double dFNecessity = 0.0;
                double dDeathE = 0.0;
                double dBNecessity = 0.0;
                double dDeathB = 0.0;
                // 水温
                double dTmpT = MzOceanModelElement.Temperature(dH + m_csOcnBacedlInf.m_dLayerLength[ll] / 2.0);
                double dTmpTK = (dTmpT + 23.0) / 46.0;
                // 水圧　★水圧に関する考慮をしていない
                double dPrss = MzOceanModelElement.Presser(dH + m_csOcnBacedlInf.m_dLayerLength[ll] / 2.0);

                double dEatenFood = m_ZoPInf.m_EatenMass[ll];
                double dPreSelfMass = m_ZoPInf.m_TotalSelfMass[ll];
                //--------------------------------------
                // ●飢え死、窒息死
                if (m_ZoPInf.m_TotalSelfMass[ll] > 0.0)
                {
                    dMass = m_ZoPInf.m_TotalSelfMass[ll];
                    dFNecessity = dTmpTK * dMass * m_ZoPInf.m_dEatK;
                    // 飢え死
                    double dFoodRatio = m_ZoPInf.m_EatenMass[ll] / (dFNecessity + 1E-18);  // 摂食量より： 要求に対する摂食の実際量の割合
                    if (dFoodRatio < 1.0 - 1E-42)
                    {
                        if (dFoodRatio < 1E-3) { dFoodRatio = 1E-3; }
                        // 飢え死
                        dDeathE = dMass * (1.0 - dFoodRatio);
                    }

                    // 窒息死
                    dBNecessity = dTmpTK * dMass * m_ZoPInf.m_O2AbsRatio;
                    double dOxRatio = m_ZoPInf.m_O2[ll] / (dBNecessity + 1E-9);
                    if (dOxRatio < 1.0 - 1E-42)
                    {
                        if (dOxRatio < 1E-3) { dOxRatio = 1E-3; }
                        dDeathB = dMass * (1.0 - dOxRatio);
                    }

                    if (dDeathE > dDeathB)
                    {
                        dDeath = dDeathE;
                    }
                    else
                    {
                        dDeath = dDeathB;
                    }
                    dMass -= dDeath;
                }

                //--------------------------------------
                // ●体重増加分
                // 増殖に可能な食料と酸素量（個体維持から差し引いた分）
                double dPossibleE = m_ZoPInf.m_EatenMass[ll] - dTmpTK * dMass * m_ZoPInf.m_dEatK;
                double dPossibleB = m_ZoPInf.m_O2[ll] - dTmpTK * dMass * m_ZoPInf.m_O2AbsRatio;
                // 体重増加計算
                double dltMass = dTmpTK * dMass * m_ZoPInf.m_dMaxProliferation; // * (1.0 - m_ZoPInf.m_dEexcretionRatio);  // 温度考慮
                if (dltMass > dPossibleE) // * (1.0 - m_ZoPInf.m_dEexcretionRatio))
                { // 食べた体重以上には増えられない
                    dltMass = dPossibleE; // * (1.0 - m_ZoPInf.m_dEexcretionRatio);
                }
                // 増殖量計算：温度考慮及び、最も小さい量に律速される
                double dltMassE = dPossibleE; // * (1.0 - m_ZoPInf.m_dEexcretionRatio); // * ここで、dTを掛けてははいけない; 
                if (dltMassE < dltMass) { dltMass = dltMassE; }
                double dltMassB = dPossibleB; // * (1.0 - m_ZoPInf.m_dEexcretionRatio); // * ここで、dTを掛けてはいけない。;
                if (dltMassB < dltMass) { dltMass = dltMassB; }

                if (dltMass < 0.0) { dltMass = 0.0; }
                m_ZoPInf.d_dltMass += dltMass;

                //--------------------------------------
                // ●呼吸 O2消費,CO2排出
                //double dMM = (dMass + dltMass);  //  m_ZoPInf.m_EatenMass[ll] * (dMass / (m_ZoPInf.m_TotalSelfMass[ll] + 1E-8));  // 実際の代謝にかかわった全体重
                double dMM = dTmpTK * (dMass + dltMass) * m_ZoPInf.m_dMetabolismK;
                dMass -= dMM;
                m_ZoPInf.m_O2[ll] -=  m_ZoPInf.m_O2AbsRatio * dMM;
                m_ZoPInf.m_CO2[ll] += m_ZoPInf.m_CO2GenRatio * dMM;
                // 体重増加に必要なO2量計算されていない。

                //--------------------------------------
                // ●自然死
                m_ZoPInf.m_TotalSelfMass[ll] = (dMass + dltMass) * (1.0 - m_csOcnBacedlInf.m_dDeathRatio);
                dDeath += (dMass + dltMass) * m_csOcnBacedlInf.m_dDeathRatio;
                m_ZoPInf.m_Death[ll] = dDeath;
                // ゼロの場合には、僅かに残しておく(少数の生き残りを入れておく)
                if (m_ZoPInf.m_TotalSelfMass[ll] < m_ZoPInf.m_dSurvivor) { m_ZoPInf.m_TotalSelfMass[ll] = m_ZoPInf.m_dSurvivor; }

                //-------------------------------------
                // ●排泄分 ＝ 捕食量  ― 体重増加量 (食べ残しも含む)― 死亡
                m_ZoPInf.m_ExcretionMass[ll] = m_ZoPInf.m_EatenMass[ll] - dltMass - dDeath;
                    //m_ZoPInf.m_ExcretionMass[ll] = m_ZoPInf.m_EatenMass[ll] * m_ZoPInf.m_dEexcretionRatio + (dDD - dltMass);
                    //if (m_ZoPInf.m_ExcretionMass[ll] < 0.0) { m_ZoPInf.m_ExcretionMass[ll] = 0.0; }
                    //// ｛（前の生体量）＋（食べた量）―（死亡量）｝－　（現在の全生体量）　としてはダメか？
                    //double dExcretionMass = (dPreSelfMass + dEatenFood - dDeath) - m_ZoPInf.m_TotalSelfMass[ll];
                    //if( dExcretionMass < 0.0) { dExcretionMass = 0; }
                    //m_ZoPInf.m_ExcretionMass[ll] = dExcretionMass;
            }

            //-------------------------------------
            // ●捕獲犠牲者の計算 (被捕食者として)
            this.CalCapture();

            // 海水層モデルのデータ
            MzOceanAreaColumnModelCalInfo csColumInfo = this.GetOceanAreaColumnCalInfo();
            m_ZoPInf.d_TotalOUT = 0.0;
            m_ZoPInf.d_NowTotalMass = 0.0;

            dH = 0.0;
            for (int ll = 0; ll < m_ZoPInf.m_lLayerNumber; ll++)
            {
                // 水温
                double dTmpT = MzOceanModelElement.Temperature(dH + m_csOcnBacedlInf.m_dLayerLength[ll] / 2.0);
                double dTmpTK = (dTmpT + 23.0) / 46.0;

                // 水圧
                double dPrss = MzOceanModelElement.Presser(dH + m_csOcnBacedlInf.m_dLayerLength[ll] / 2.0);

                // 補正●排泄分 －＝ 捕食量
                m_ZoPInf.m_ExcretionMass[ll] -= m_ZoPInf.m_dCapturedMass[ll]; // * m_csOcnBacedlInf.m_dEexcretionRatio;
                if (m_ZoPInf.m_ExcretionMass[ll] < 0.0) { m_ZoPInf.m_ExcretionMass[ll] = 0.0; }


                // ●次回要求する＝＝＝＝用
                double dNxtMass = m_ZoPInf.m_TotalSelfMass[ll] * (1.0 + m_ZoPInf.m_dMaxProliferation);
                // 自分が要求するFood量
                m_ZoPInf.m_ReqFoodMass[ll] = dTmpTK * (1.0 / m_ZoPInf.m_dEatK) * dNxtMass; // / m_KBctInf.m_dEexcretionRatio;
                // 自分が要求するO2量
                m_ZoPInf.m_ReqO2[ll] = dTmpTK * m_ZoPInf.m_O2AbsRatio * dNxtMass; // * m_ZoPInf.m_dEexcretionRatio;  // / m_KBctInf.m_dEexcretionRatio;

                //// 自分が要求するFood量
                //m_ZoPInf.m_ReqFoodMass[ll] = 
                //    m_ZoPInf.m_dMaxProliferation * m_ZoPInf.m_TotalSelfMass[ll] +
                //    m_ZoPInf.m_dEatK * m_ZoPInf.m_TotalSelfMass[ll]  / m_ZoPInf.m_dEexcretionRatio;

                //// 自分が要求するO2量
                //m_ZoPInf.m_ReqO2[ll] = dTmpTK * m_ZoPInf.m_O2AbsRatio * m_ZoPInf.m_ReqFoodMass[ll] * m_ZoPInf.m_dMetabolismK;
                // 体重増加に必要なO2量計算されていない。

                // 海水層モデルのデータ内に入れる（集計用）
                csColumInfo.m_TotalSelfMass[ll] += m_ZoPInf.m_TotalSelfMass[ll];

                // チェック用
                // チェック用
                m_ZoPInf.d_NowTotalMass += m_ZoPInf.m_TotalSelfMass[ll];
                m_ZoPInf.d_TotalOUT += m_csOcnBacedlInf.m_Death[ll] + m_csOcnBacedlInf.m_ExcretionMass[ll]; // +m_csOcnBacedlInf.m_dCapturedMass[ll];

                dH += m_csOcnBacedlInf.m_dLayerLength[ll];

            }

            return 0;
        }

       
        //====================
        // その他必要なメソッド
        //====================

        /// <summary><para>method outline:</para>
        /// <para>プロパティ情報を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetProperty(csCellMdlPropertyInfo)</para>
        /// </example>
        /// <param name="csCellMdlPropertyInfo">セル型プロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool SetProperty(McCellModelPropertyIF csCellMdlPropertyInfo)
        {
            bool bRtn = base.SetProperty(csCellMdlPropertyInfo);

            // 使用しやすいようにキャストしておく
            m_ZoPInf = (MzOceanZpoplanktonsCalInfo)m_csCalInfo;

            // プロパティ設定
            McCellModelPropertyInfo csPrptyInfo = csCellMdlPropertyInfo as McCellModelPropertyInfo;
            if (csPrptyInfo != null)
            {               
                // 代謝設定
                this.SetMetabolism(ref csPrptyInfo);
                this.SetMetabolism2(ref csPrptyInfo);
                this.SetEexcretion(ref csPrptyInfo);
                this.SetDeath(ref csPrptyInfo);

                csPrptyInfo.GetInfo("m_CapturedRatio", ref m_ZoPInf.m_CapturedRatio);

                double dltT = m_csDltTime.TotalSec();
                double n = dltT /(24 * 3600) ;
                //m_ZoPInf.m_dEexcretionRatio = Math.Pow(m_ZoPInf.m_dEexcretionRatio, n);
                m_ZoPInf.m_CapturedRatio = 1.0 - Math.Pow((1.0 -m_ZoPInf.m_CapturedRatio), n);
                m_ZoPInf.m_dDeathRatio = 1.0 - Math.Pow((1.0-m_ZoPInf.m_dDeathRatio), n);
                m_ZoPInf.m_dMaxProliferation = Math.Pow(m_ZoPInf.m_dMaxProliferation, n);

                m_ZoPInf.m_dMetabolismK = 1.0 - Math.Pow((1.0 - m_ZoPInf.m_dMetabolismK), n);
            }
            return bRtn;
        }

    }
}
