﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;


using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYMCO.CoreOptionl.HymcoExpansionModel;
using CommonMP.HYMCO.Ocean.McOceanBaseModel;

namespace CommonMP.HYMCO.Ocean.McOceanSampleModels
{
    /// <summary><para>class outline:</para>
    /// <para>海の地域１単位面(Ocean Column)モデル内演算中データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[2021/12/31][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public  class MzOceanSeaSurfaceModelCalInfo : MzOceanModelElementCalInfo
    {
        /// <summary> 有機物サイズ分布 </summary>
        public int m_iDetritusSizeNum = MzOceanBaseDefine.iPARTICLE_SIZE_NUM;
        public double[] m_DetritusSize = null;  // サイズ[mm] 0.1μm,0.2μm,0.5μm,1μm,2μm,5μm, ～ 1m

        // ―――物質の量分布――――
        /// <summary> 有機物 </summary>
        public double m_OrganicDensity_3 = 1.043;   // 有機物 密度  [g/cm^3] 
        public double[] m_OrganicMass_3 = null;  // 量 g/m3
        /// <summary> 粒子状無機物（InOrganic_Particulates） </summary>
        public double m_DensityIOP1 = 2.4;   //  粒子状無機物密度  [g/cm^3]　 珪素：2.33、岩石：2.8～3.5g／cm 3程度　鉄鉱石：（5.2g/cm3
        public double[] m_IOPMass1 = null;  // 量 g/m3
        /// <summary> 粒子状無機物（InOrganic_Particulates） </summary>
        public double m_DensityIOP2 = 5.2;   //  粒子状無機物密度  [g/cm^3]　 珪素：2.33、岩石：2.8～3.5g／cm 3程度　鉄鉱石：（5.2g/cm3
        public double[] m_IOPMass2 = null;  // 量 g/m3


        /// <summary>
        /// 
        /// </summary>
        public MzOceanSeaSurfaceModelCalInfo()
        {
            //m_Density_1 = 1.027;   // ＰＯＭ１密度  [g/cm^3]
            //m_Density_2 = 1.075;   // ＰＯＭ２密度  [g/cm^3]   珪素：2.33    ホタテ貝殻(SS,密度= 2.53g/cm3)
            m_OrganicDensity_3 = 1.043;   // ＰＯＭ３密度  [g/cm^3] 
            m_DensityIOP1 = 2.4;   // 粒子状無機物密度  [g/cm^3] 珪素：2.33、岩石：2.8～3.5g／cm 3程度　鉄鉱石：（5.2g/cm3
            m_DensityIOP2 = 5.2;   // 粒子状無機物密度  [g/cm^3] 珪素：2.33、岩石：2.8～3.5g／cm 3程度　鉄鉱石：（5.2g/cm3
            m_iDetritusSizeNum = MzOceanBaseDefine.iPARTICLE_SIZE_NUM;

            m_DetritusSize = new double[m_iDetritusSizeNum];   // サイズ[mm] 0.1μm,0.2μm,0.5μm,1μm,2μm,5μm, ～ 1m
            m_OrganicMass_3 = new double[m_iDetritusSizeNum];
            m_IOPMass1 = new double[m_iDetritusSizeNum];
            m_IOPMass2 = new double[m_iDetritusSizeNum];

            double dOrdr = 0.1E-3;
            for (int i = 0; i < m_iDetritusSizeNum; i++)
            {
                if (i % 3 == 0)
                {
                    m_DetritusSize[i] = dOrdr * 1.0;
                }
                else if (i % 3 == 1)
                {
                    m_DetritusSize[i] = dOrdr * 2.0;
                }
                else if (i % 3 == 2)
                {
                    m_DetritusSize[i] = dOrdr * 5.0;
                    dOrdr = dOrdr * 10.0;
                }
            }
        }

        public override void Clear()
        {
            base.Clear();
        }

        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別院スタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            MzOceanSeaSurfaceModelCalInfo csRtn = new MzOceanSeaSurfaceModelCalInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            base.CopyInfo(csOrgInfo);
            MzOceanSeaSurfaceModelCalInfo csOrgDt = (MzOceanSeaSurfaceModelCalInfo)csOrgInfo;
            base.CopyInfo(csOrgInfo);

            m_OrganicDensity_3 = csOrgDt.m_OrganicDensity_3;   // ＰＯＭ３密度  [g/cm^3] 
            m_DensityIOP1 = csOrgDt.m_DensityIOP1;   // 粒子状無機物密度  [g/cm^3] 珪素：2.33、岩石：2.8～3.5g／cm 3程度　鉄鉱石：（5.2g/cm3
            m_DensityIOP2 = csOrgDt.m_DensityIOP2;   // 粒子状無機物密度  [g/cm^3] 珪素：2.33、岩石：2.8～3.5g／cm 3程度　鉄鉱石：（5.2g/cm3
            m_iDetritusSizeNum = csOrgDt.m_iDetritusSizeNum;

            for (int k = 0; k < csOrgDt.m_iDetritusSizeNum; k++)
            {
                m_DetritusSize[k] = csOrgDt.m_DetritusSize[k];
                m_OrganicMass_3[k] = csOrgDt.m_OrganicMass_3[k];
                m_IOPMass1[k] = csOrgDt.m_IOPMass1[k];
                m_IOPMass2[k] = csOrgDt.m_IOPMass2[k];
            }
            return true;
        }


    }
}
