﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSController;
using CommonMP.HYSSOP.CoreImpl;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSController;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface;
using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.CoreImpl.Controller;
using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.CoreImpl.Tool;

using CommonMP.HYMCO.CoreOptionl.HymcoExpansionModel;
using CommonMP.HYMCO.Ocean.McOceanBaseModel;

using CommonMP.HYMCO.Ocean.McOceanSampleModels;

namespace CommonMP.HYMCO.Ocean.McOceanSampleTest
{
    /// <summary><para>class outline:</para>
    /// <para>細菌（Bacterias)モデルクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[2021/12/31][新規作成]</para>
    /// </remarks>
    public class MzTestBacterias : MzOceanModelElement
    {
        /// <summary> 演算データ（キャスト用） </summary>
        MzTestBacteriasCalInfo m_KBctInf = null; // 便利の為、キャスト用に定義しておく


        /// <summary> 無機物肥料要素 </summary>
        protected McPatternRdvSndTranInfoPair m_csSndFertilizerCnnct = new McPatternRdvSndTranInfoPair();

        //=========================
        // 演算実行前処理関連メソッド
        //=========================

        /// <summary><para>method outline:</para>
        /// <para>入力側の接続情報チェック</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>bool bRtn = CheckReceiveDataConnection(ref csErrorInf)</para>
        /// </example>
        /// <param name="csErrorInf">エラー出力</param>
        /// <param name="lInputDataNum">入力情報数</param>
        /// <param name="csInputCellData">演算に必要な入力情報配列</param>
        /// <returns>=true:正常、=false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>受信するデータが自モデルが期待している情報か否かをチェックする</para>
        /// </remarks>
        protected override bool CheckReceiveDataConnection(ref McStructErrorInfo csErrorInf, long lInputDataNum, McReceiveCellDataIF[] csInputCellData)
        {
            // チェック処理を入れる
            bool bRtn = base.CheckReceiveDataConnection(ref csErrorInf, lInputDataNum, csInputCellData);

            // 分解した無機物の送信
            m_csSndFertilizerCnnct = this.PrepareSndPattern(MzOceanBaseDefine.BCT_FERTILIZER);

            // ディバッグ用送信データ
            //m_csDebugSendCnnct = this.PrepareSndPattern(MzOceanBaseDefine.DEBUG_OUT);
            return bRtn;
        }

        ///// <summary><para>method outline:</para>
        ///// <para>出力側の接続情報チェック</para>
        ///// </summary>
        ///// <example><para>usage:</para>
        ///// <para>bool bRtn = CheckSendDataConnection(ref csErrorInf)</para>
        ///// </example>
        ///// <param name="csErrorInf">エラー出力</param>
        ///// <param name="lOutputDataNum">出力情報数</param>
        ///// <param name="csOutputCellData">出力情報配列</param>
        ///// <returns>=true:正常、=false:異常</returns>
        ///// <exception cref="">無し</exception>
        ///// <remarks><para>remarks:</para>
        ///// <para>送信端子に設定されている伝送データが自モデルが期待している情報か否かをチェックする</para>
        ///// </remarks>
        //protected override bool CheckSendDataConnection(ref McStructErrorInfo csErrorInf, long lOutputDataNum, McSendCellDataIF[] csOutputCellData)
        //{
        //    // チェック処理を入れる
        //    bool bRtn = base.CheckSendDataConnection(ref csErrorInf, lOutputDataNum, csOutputCellData);
        //    return bRtn;
        //}

        protected virtual void SendDEBUG()
        {
            for (int i = 0; i < m_csDebugSendCnnct.m_RcvInfNum; i++)
            {
                HySCellData[] csCell = m_csDebugSendCnnct.m_csSndInfArry[i].PrepareSendCellD1();
                for (int ll = 0; ll < m_KBctInf.m_lLayerNumber; ll++)
                {
                    csCell[ll].m_dData[0] = m_KBctInf.m_TotalSelfMass[ll];
                    csCell[ll].m_dData[1] = m_KBctInf.m_O2[ll];
                    csCell[ll].m_dData[2] = m_KBctInf.m_CO2[ll];
                }
            }
        }

        protected override void ClearAllCalValue()
        {
            for (int ll = 0; ll < m_csOcnBacedlInf.m_lLayerNumber; ll++)
            {
                m_csOcnBacedlInf.m_Death[ll] = 0.0;
                m_csOcnBacedlInf.m_N[ll] = 0.0;
                m_csOcnBacedlInf.m_P[ll] = 0.0;
                m_csOcnBacedlInf.m_Fe[ll] = 0.0;
                m_csOcnBacedlInf.m_Si[ll] = 0.0;
            }
        }

        /// <summary>
        /// 受信
        /// </summary>
        protected override void ReceiveData()
        {
            ClearAllCalValue();
            m_KBctInf.d_PreTotalMass = m_KBctInf.d_NowTotalMass;
            for(int ll=0;ll< m_KBctInf.m_lLayerNumber;ll++)
            {
                m_KBctInf.m_PrvTotalSelfMass[ll] = m_KBctInf.m_TotalSelfMass[ll];
            }

            // 呼吸関係
            ReceiveBREATHING();

            // 被捕食：プランクトンからの要求量の取得
            ReceiveReqPREDATION();
            // 捕食：デトリタス摂取
            ReceivePREDATION();

            m_KBctInf.d_TotalIN = 0.0;
            for (int i = 0; i < m_KBctInf.m_lLayerNumber; i++)
            {
                m_KBctInf.d_TotalIN += m_KBctInf.m_EatenMass[i];
            }

            return;
        }

        /// <summary>
        /// 送信例
        /// </summary>
        protected override void SendData()
        {
            // 被捕食：プランクトンに捕食される
            SendPREDATION(m_csOcnBacedlInf.m_dCapturedMass, 0.1, 0.005);
            // 捕食物:デトリタスを分解
            SendReqPREDATION(m_csOcnBacedlInf.m_ReqFoodMass);

            // 呼吸
            SendBREATHING();

            // 死
            SendEXCRETION_DEATH(m_csOcnBacedlInf.m_dExcretionDencity, m_csOcnBacedlInf.m_dBulkDensity);

            // 肥料要素
            SendFertilizer();

            // Debug
            SendDEBUG();

            //----- Debug Check ------
            double dChk = (m_KBctInf.d_NowTotalMass - m_KBctInf.d_PreTotalMass) - (m_KBctInf.d_TotalIN - m_KBctInf.d_TotalOUT - m_KBctInf.d_Discompose);
            McLog.DebugOut("MzOceanBacterias", "SendData", "細菌総量チェック:" + dChk.ToString() + " = "
                + (m_KBctInf.d_NowTotalMass - m_KBctInf.d_PreTotalMass).ToString() + " - " + (m_KBctInf.d_TotalIN - m_KBctInf.d_TotalOUT - m_KBctInf.d_Discompose).ToString());
            //------------------------

            return;
        }

        /// <summary>
        /// 分解した肥料要素(無機物)を送信
        /// </summary>
        protected virtual void SendFertilizer()
        {
            for (int i = 0; i < m_csSndFertilizerCnnct.m_RcvInfNum; i++)
            {
                HySCellData[] csSndDt = m_csSndFertilizerCnnct.m_csSndInfArry[i].PrepareSendCellD1();
                if (csSndDt == null) { break; }
                for (int ll = 0; ll < m_csOcnBacedlInf.m_lLayerNumber; ll++)
                {
                    csSndDt[ll].m_dData[0] = m_KBctInf.m_N[ll];
                    csSndDt[ll].m_dData[1] = m_KBctInf.m_P[ll];
                    csSndDt[ll].m_dData[2] = m_KBctInf.m_Si[ll];
                    csSndDt[ll].m_dData[3] = m_KBctInf.m_Fe[ll];
                }
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>モデルを初期化する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>Initialize(csInitialData)</para>
        /// </example>
        /// <param name="csInitialData">初期化設定情報</param>
        /// <param name="lInputDataNum">入力情報数</param>
        /// <param name="csInputCellData">演算に必要な入力情報配列</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        protected override bool Initialize(ref McPropertyInfoRoot csInitialData, long lInputDataNum, ref McReceiveCellDataIF[] csInputCellData)
        {
            bool bRtn = base.Initialize(ref csInitialData, lInputDataNum, ref csInputCellData);
            McInitialInfo csInDt = csInitialData as McInitialInfo;
            if (csInDt != null)
            {   // 初期化情報有り
                this.InitMass(ref csInDt);

                m_KBctInf.d_NowTotalMass = 0.0;
                for (int ll = 0; ll < m_KBctInf.m_lLayerNumber; ll++)
                {
                    // ●次回要求する＝＝＝＝用
                    // 自分が要求するFood量
                    m_KBctInf.m_ReqFoodMass[ll] = m_KBctInf.m_dEatK * m_KBctInf.m_TotalSelfMass[ll] / m_KBctInf.m_dEexcretionRatio;
                    // 自分が要求するO2量
                    m_KBctInf.m_ReqO2[ll] = (1.0 / m_KBctInf.m_O2AbsRatio) * m_KBctInf.m_TotalSelfMass[ll] / m_KBctInf.m_dEexcretionRatio;

                    m_KBctInf.m_EatenMass[ll] = m_KBctInf.m_ReqFoodMass[ll];
                    m_KBctInf.m_O2[ll] = m_KBctInf.m_ReqO2[ll];

                    // 
                    m_csOcnBacedlInf.m_TotalReqedPredationMass[ll] = m_csOcnBacedlInf.m_TotalSelfMass[ll] * 0.1;
                    m_csOcnBacedlInf.m_dCapturedMass[ll] = m_csOcnBacedlInf.m_TotalSelfMass[ll] * 0.1;
                    m_csOcnBacedlInf.m_TotalSelfMass[ll] -= m_csOcnBacedlInf.m_dCapturedMass[ll];
                    m_KBctInf.d_TotalOUT += m_csOcnBacedlInf.m_dCapturedMass[ll];
                    m_KBctInf.d_NowTotalMass += m_KBctInf.m_TotalSelfMass[ll];
                }
                m_KBctInf.d_PreTotalMass = m_KBctInf.d_NowTotalMass;
            }
            return true;
        }

        //=======================
        // 演算実行処理関連メソッド
        //=======================

        /// <summary><para>method outline:</para>
        /// <para>モデル演算</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>long lRtn = Calculate(ref csInputDataList)</para>
        /// </example>
        /// <param name="lOnlyReceveDataNum">入力だけの情報数</param>
        /// <param name="csOnlyReceiveCellData">入力だけの情報配列</param>
        /// <param name="lOnlySendDataNum">出力だけの情報数</param>
        /// <param name="csOnlySelDataCellData">出力だけの情報配列</param>
        /// <param name="lRcvSndDataNum">相互接続報数</param>
        /// <param name="csReceiveCellData">相互接続入力側情報配列</param>
        /// <param name="csSelDataCellData">相互接続出力側情報配列</param>
        /// <returns>=0:正常 -1:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>派生クラス側で必ずオーバライドする必要がある</para>
        /// </remarks>
        protected override long Calculate(
            long lOnlyReceveDataNum, ref McReceiveOnlyTranInfo[] csOnlyReceiveCellData,
            long lOnlySendDataNum, ref McSendOnlyTranInfo[] csOnlySelDataCellData,
            long lRcvSndDataNum, ref McRdvSndTranInfoPair[] csRcvSndCelDataCellData
            )
        {
            m_KBctInf.d_Discompose = 0.0;

            double dT = m_csDltTime.GetTime() / (3600.0 * 24.0);

            // 後で論理を見直すこと


            // ★★　論理不足
            // デトリタスの沈降に伴う沈降が考えられていない

            // デトリタスの腐敗等の計算を行う　
            // 腐敗は、粒度の小さいものほど早く行われる　表面積比に比例するとする

            // 水深
            double dH = 0.0 ;

            // 摂食-排糞-排瀧-自然
            for (int ll = 0; ll < m_KBctInf.m_lLayerNumber; ll++)
            {
                double dMass = 1.0E-8;
                double dDeath = 0.0;
                double dFNecessity = 0.0;
                double dDeathE = 0.0;
                double dBNecessity = 0.0;
                double dDeathB = 0.0;
                // 水温
                double dTmpT = MzOceanModelElement.Temperature(dH + m_csOcnBacedlInf.m_dLayerLength[ll]/2.0);
                double dTmpTK = (dTmpT + 0.1) / 23.0;
                double dEatenFood = m_KBctInf.m_EatenMass[ll];

                //--------------------------------------
                // ●飢え死、窒息死
                if (m_KBctInf.m_TotalSelfMass[ll] > 0.0)
                {
                    dMass = m_KBctInf.m_TotalSelfMass[ll];
                    dFNecessity = dTmpTK * dMass * m_KBctInf.m_dEatK;
                    // 飢え死
                    double dFoodRatio = m_KBctInf.m_EatenMass[ll] / (dFNecessity + 1E-8);  // 摂食量より： 要求に対する摂食の実際量の割合
                    if (dFoodRatio < 1.0 - 1E-8)
                    {
                        if (dFoodRatio < 1E-3) { dFoodRatio = 1E-3; }
                        // 飢え死
                        dDeathE = dMass * (1.0 - dFoodRatio);
                        //dDeath += m_KBctInf.m_TotalSelfMass[ll] * (1.0 - dFoodRatio);
                        //dMass -= dDeath;
                    }
                    
                    // 窒息死
                    //double dRqOx = m_KBctInf.m_ReqO2[ll] * (dMass / m_KBctInf.m_TotalSelfMass[ll]) + 1E-8;
                    //double dOxRatio = m_KBctInf.m_O2[ll] / dRqOx;
                    //if (dOxRatio < 0.0)
                    //{
                    //    dDeath += dMass;
                    //    dMass = 0.0;
                    //}
                    //else if (dOxRatio < 1.0)
                    //{
                    //    if (dOxRatio < 1E-3) { dOxRatio = 1E-3; }
                    //    // 窒息死
                    //    dAliveB = m_KBctInf.m_TotalSelfMass[ll] * dOxRatio;
                    //    dDeath += dMass * (1.0 - dOxRatio);
                    //    dMass -= dDeath;
                    //}
                    dBNecessity = dTmpTK * dMass * m_KBctInf.m_O2AbsRatio;
                    double dOxRatio = m_KBctInf.m_O2[ll] / (dBNecessity + 1E-9);
                    if (dOxRatio < 1.0 - 1E-8)
                    {
                        if (dOxRatio < 1E-3) { dOxRatio = 1E-3; }
                        dDeathB = dMass * (1.0 - dOxRatio);
                    }

                    if(dDeathE > dDeathB)
                    {
                        dDeath = dDeathE;
                    }
                    else
                    {
                        dDeath = dDeathB;
                    }
                    dMass -= dDeath;

                }

                m_KBctInf.d_Discompose = 0.0;
                //--------------------------------------
                // ●体重増加分
                // 増殖に可能な食料と酸素量（個体維持から差し引いた分）
                double dPossibleE = m_KBctInf.m_EatenMass[ll] - dTmpTK * dMass * m_KBctInf.m_dEatK;
                double dPossibleB = m_KBctInf.m_O2[ll] - dTmpTK * dMass * m_KBctInf.m_O2AbsRatio;

                // 増殖量計算：温度考慮
                double dltMass = dTmpTK * dMass * m_KBctInf.m_dMaxProliferation; // * (1.0 - m_KBctInf.m_dEexcretionRatio);  // 温度考慮
                if ( dltMass > dPossibleE) // * (1.0 - m_KBctInf.m_dEexcretionRatio))
                { // 食べた体重以上には増えられない
                    dltMass = dPossibleE; // * (1.0 - m_KBctInf.m_dEexcretionRatio);
                }

                // 増殖量計算：温度考慮及び、最も小さい量に律速される
                double dltMassE = dTmpTK * dPossibleE; // * (1.0 - m_KBctInf.m_dEexcretionRatio); // * ここで、dTを掛けてははいけない; //(1.0 - m_KBctInf.m_dEexcretionRatio);
                if( dltMassE < dltMass) { dltMass = dltMassE; }
                double dltMassB = dTmpTK * dPossibleB; //  * (1.0 - m_KBctInf.m_dEexcretionRatio); // * ここで、dTを掛けてはいけない。;
                if ( dltMassB < dltMass) { dltMass = dltMassB; }

                if( dltMass < 0.0) { dltMass = 0.0; }

                ////double dDD = m_KBctInf.m_EatenMass[ll] * (1.0 - m_KBctInf.m_dEexcretionRatio);  // １００％の場合の体重増分
                ////dDD = dDD * (dTmp + 0.1) / 23.0;   // 温度の影響を考慮
                ////dltMass = dDD * dMass / (m_KBctInf.m_TotalSelfMass[ll] + 1E-8);    // 餓死等あり時の体重増加分
                //double dltMass = m_KBctInf.m_EatenMass[ll] - dMass * m_KBctInf.m_dEexcretionRatio;
                //if (dltMass > dMass * m_KBctInf.m_dMaxProliferation * (dTmpT + 0.1) / 23.0)   // 温度の影響を考慮)
                //{
                //    dltMass = dMass * m_KBctInf.m_dMaxProliferation * (dTmpT + 0.1) / 23.0;   // 温度の影響を考慮
                //}

                // ●分解分計算
                // 本体を維持
                double dDiscompose = dTmpTK * dMass * m_KBctInf.m_dEatK * m_KBctInf.m_dEexcretionRatio;
                // 増殖時の消費
                dDiscompose += dTmpTK * dltMass * m_KBctInf.m_dEexcretionRatio;
                if(dDiscompose < 0.0) { dDiscompose = 0.0; }

                m_KBctInf.d_Discompose += dDiscompose;
                
                // ●呼吸 O2消費,CO2排出
                //double dMM = (dMass + dltMass) * m_KBctInf.m_dMetabolismK;
                //dMass -= dMM;
                m_KBctInf.m_O2[ll] -= m_KBctInf.m_O2AbsRatio * dDiscompose;
                m_KBctInf.m_CO2[ll] += m_KBctInf.m_CO2GenRatio * dDiscompose;

                //----------------------------
                // 固形排泄は無しで、すべて無機物レベルまで分解されるとする
                // ●分解した有機物からの無機物溶けだし
                m_KBctInf.m_N[ll] += dDiscompose * m_KBctInf.m_DkK_N;
                m_KBctInf.m_P[ll] += dDiscompose * m_KBctInf.m_DkK_P;
                m_KBctInf.m_Si[ll] += dDiscompose * m_KBctInf.m_DkK_Si;
                m_KBctInf.m_Fe[ll] += dDiscompose * m_KBctInf.m_DkK_Fe;

                // 食べたものはすべて分解する
m_KBctInf.m_N[ll] = 1.0E-6; // m_csOcnBacedlInf.m_EatenMass[ll] * m_KBctInf.m_DkK_N;
m_KBctInf.m_P[ll] = 1.0E-6; // m_csOcnBacedlInf.m_EatenMass[ll] * m_KBctInf.m_DkK_P;
m_KBctInf.m_Si[ll] = 1.0E-6; // m_csOcnBacedlInf.m_EatenMass[ll] * m_KBctInf.m_DkK_Si;
m_KBctInf.m_Fe[ll] = 1.0E-6; // m_csOcnBacedlInf.m_EatenMass[ll] * m_KBctInf.m_DkK_Fe;

m_KBctInf.m_N[ll] = 0; // m_csOcnBacedlInf.m_EatenMass[ll] * m_KBctInf.m_DkK_N;
m_KBctInf.m_P[ll] = 0; // m_csOcnBacedlInf.m_EatenMass[ll] * m_KBctInf.m_DkK_P;
m_KBctInf.m_Si[ll] = 0; // m_csOcnBacedlInf.m_EatenMass[ll] * m_KBctInf.m_DkK_Si;
m_KBctInf.m_Fe[ll] = 0; // m_csOcnBacedlInf.m_EatenMass[ll] * m_KBctInf.m_DkK_Fe;


                //--------------------------------------
                // ●自然死
                m_KBctInf.m_TotalSelfMass[ll] = (dMass + dltMass) * (1.0 - m_csOcnBacedlInf.m_dDeathRatio);
                dDeath += (dMass + dltMass) * m_csOcnBacedlInf.m_dDeathRatio;
                // ゼロの場合には、僅かに残しておく
                if (m_KBctInf.m_TotalSelfMass[ll] < 1.0E-8) { m_KBctInf.m_TotalSelfMass[ll] = 1.0E-8; }
                m_KBctInf.m_Death[ll] = dDeath;

                // ●排泄分 ＝ 食べ残し＝ 捕食量 ― 体重増加量　―　分解量  －  死; //　－ 捕食量
                m_KBctInf.m_ExcretionMass[ll] = m_KBctInf.m_EatenMass[ll] - dltMass; // (m_KBctInf.m_TotalSelfMass[ll] - m_KBctInf.m_PrvTotalSelfMass[ll]);
                m_KBctInf.m_ExcretionMass[ll] -= dDiscompose;
                m_KBctInf.m_ExcretionMass[ll] -= m_KBctInf.m_Death[ll];

                //---------------------------

                dH += m_csOcnBacedlInf.m_dLayerLength[ll];
            }

            //-------------------------------------
            // ●捕獲(被捕食者として)
            this.CalCapture();

            dH = 0.0;
            MzOceanAreaColumnModelCalInfo csColumInfo = this.GetOceanAreaColumnCalInfo();
            m_KBctInf.d_NowTotalMass = 0.0;
            m_KBctInf.d_TotalOUT = 0.0;
            for (int ll = 0; ll < m_KBctInf.m_lLayerNumber; ll++)
            {
                // 水温
                double dTmpT = MzOceanModelElement.Temperature(dH + m_csOcnBacedlInf.m_dLayerLength[ll] / 2.0);
                double dTmpTK = (dTmpT + 0.1) / 23.0;

                // 補正●排泄分 －＝ 捕食量
                m_KBctInf.m_ExcretionMass[ll] -= m_KBctInf.m_dCapturedMass[ll]; // * m_csOcnBacedlInf.m_dEexcretionRatio;
                //m_KBctInf.m_ExcretionMass[ll] -= (m_KBctInf.m_TotalSelfMass[ll] - m_KBctInf.m_PrvTotalSelfMass[ll]);
                if (m_KBctInf.m_ExcretionMass[ll] < 0.0) { m_KBctInf.m_ExcretionMass[ll] = 0.0; }

                // ●次回要求する＝＝＝＝用
                double dNxtMass = m_KBctInf.m_TotalSelfMass[ll] * (1.0 + m_KBctInf.m_dMaxProliferation);
                // 自分が要求するFood量
                m_KBctInf.m_ReqFoodMass[ll] = dTmpTK * 1.0 / m_KBctInf.m_dEatK * dNxtMass; // / m_KBctInf.m_dEexcretionRatio;
                // 自分が要求するO2量
                m_KBctInf.m_ReqO2[ll] = dTmpTK * m_KBctInf.m_O2AbsRatio * dNxtMass * m_KBctInf.m_dEexcretionRatio;  // / m_KBctInf.m_dEexcretionRatio;

                // 海水層モデルのデータ内に入れる（集計用）
                csColumInfo.m_TotalSelfMass[ll] += m_KBctInf.m_TotalSelfMass[ll];

                // チェック用
                m_KBctInf.d_NowTotalMass += m_KBctInf.m_TotalSelfMass[ll];
                m_KBctInf.d_TotalOUT +=  m_csOcnBacedlInf.m_dCapturedMass[ll] + m_csOcnBacedlInf.m_Death[ll]+ m_csOcnBacedlInf.m_ExcretionMass[ll];

                dH += m_csOcnBacedlInf.m_dLayerLength[ll];
            }
            return 0;
        }

        //====================
        // その他必要なメソッド
        //====================

        /// <summary><para>method outline:</para>
        /// <para>プロパティ情報を設定する</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para>SetProperty(csCellMdlPropertyInfo)</para>
        /// </example>
        /// <param name="csCellMdlPropertyInfo">セル型プロパティ情報</param>
        /// <returns>無し</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool SetProperty(McCellModelPropertyIF csCellMdlPropertyInfo)
        {
            base.SetProperty(csCellMdlPropertyInfo);
            //// 使用しやすいようにキャストしておく
            m_KBctInf = (MzTestBacteriasCalInfo)m_csCalInfo;

            // プロパティ設定
            McCellModelPropertyInfo csPrptyInfo = csCellMdlPropertyInfo as McCellModelPropertyInfo;
            if (csPrptyInfo != null)
            {
                // 演算ステップ時刻設定
                this.m_csDltTime = new HySTime(csPrptyInfo.GetStepTime());
                // 層設定
                this.SetLayerProperty(ref csPrptyInfo);
                // 代謝設定
                this.SetMetabolism(ref csPrptyInfo);
                this.SetMetabolism2(ref csPrptyInfo);
                this.SetEexcretion(ref csPrptyInfo);
                this.SetDeath(ref csPrptyInfo);
                csPrptyInfo.GetInfo("m_CapturedRatio", ref m_KBctInf.m_CapturedRatio);

                csPrptyInfo.GetInfo("m_DkK_N", ref m_KBctInf.m_DkK_N);
                csPrptyInfo.GetInfo("m_DkK_P", ref m_KBctInf.m_DkK_P);
                csPrptyInfo.GetInfo("m_DkK_Si", ref m_KBctInf.m_DkK_Si);
                csPrptyInfo.GetInfo("m_DkK_Fe", ref m_KBctInf.m_DkK_Fe);


                double dltT = m_csDltTime.TotalSec();
                double n = dltT / (24 * 3600);
                m_KBctInf.m_CapturedRatio = 1.0 - Math.Pow((1.0 - m_KBctInf.m_CapturedRatio), n);
                m_KBctInf.m_dDeathRatio = 1.0 - Math.Pow((1.0 - m_KBctInf.m_dDeathRatio), n);
                m_KBctInf.m_dMaxProliferation = Math.Pow(m_KBctInf.m_dMaxProliferation, n);
            }

            return true;
        }

    }
}
