﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;


using CommonMP.HYSSOP.Interface.HSData;
using CommonMP.HYSSOP.Interface.HSViewer;
using CommonMP.HYSSOP.CoreImpl.HSData;
using CommonMP.HYSSOP.CoreImpl.HSTools;

using CommonMP.HYMCO.Interface.Model;
using CommonMP.HYMCO.Interface.Data;
using CommonMP.HYMCO.Interface.Controller;

using CommonMP.HYMCO.CoreImpl.Data;
using CommonMP.HYMCO.Ocean.McOceanBaseModel;

using CommonMP.HYMCO.Ocean.McOceanSampleModels;

namespace CommonMP.HYMCO.Ocean.McOceanSampleTest
{
    /// <summary><para>class outline:</para>
    /// <para>溶融ガスモデル内演算中データクラス</para>
    /// </summary>
    /// <remarks><para>history:</para>
    /// <para>[2021/12/31][新規作成]</para>
    /// <para>remarks</para>
    /// <para>演算中の状態、初期条件等を保持するデータクラス</para>
    /// </remarks>
    [Serializable]
    public  class MzTestDissolveGassCalInfo : MzOceanModelElementCalInfo
    {
        /// <summary>要求CO2</summary>
        public double[] m_ReqedCO2 = null;
        /// <summary>供給可能なCO2</summary>
        public double[] m_AvailableCO2 = null;

        /// <summary>要求CO2</summary>
        public double[] m_ReqedO2 = null;
        /// <summary>供給可能なO2</summary>
        public double[] m_AvailableO2 = null;


        //-----------------------------------------
        // 海面での　O2,CO2　＋は海面から大気へ放出、－は大気から海面への溶け込み
        public double m_SurfaceCO2 = 0.0;
        public double m_SurfaceO2 = 0.0;
        public double m_Emission_CO2 = 0.0;
        public double m_Emission_O2 = 0.0;

        // 海面上の定常　O2,CO2量　g/m3
        static public double S_O2 = 0;
        static public double S_CO2 = 0;

        // 海洋ベルトコンベア等で運ばれてくるO2,運び出されるCO2の量
        public double[] m_StreamInO2;
        public double[] m_StreamOutCO2;

        //-----------------------------------------
        // 集計用(１日当たりの放出／吸収量計算)の経過時間：日単位
        /// <summary>集計経過時間：sec 単位</summary>
        public double m_DaySec = 0;
        // 集計用
        /// <summary>集計値</summary>
        public double[] m_SumO2Emission = null;
        public double[] m_SumCO2Emission = null;
        /// <summary>平均値</summary>
        public double[] m_meanO2Emission = null;
        public double[] m_meanCO2Emission = null;

        public MzTestDissolveGassCalInfo()
        {
            MzTestDissolveGassCalInfo.S_O2 = MzOceanModelElement.GetDisolveO2(20);
            MzTestDissolveGassCalInfo.S_CO2 = MzOceanModelElement.GetDisolveCO2(20);
        }

        public override void Clear()
        {
            base.Clear();
            m_SurfaceO2 = 0.0;
            m_SurfaceCO2 = 0.0;
            m_Emission_O2 = 0.0;
            m_Emission_CO2 = 0.0;
            for (int ll = 0; ll < m_lLayerNumber; ll++)
            {
                m_ReqedCO2[ll] = 0.0;
                m_AvailableCO2[ll] = 0.0;
                m_ReqedO2[ll] = 0.0;
                m_AvailableO2[ll] = 0.0;
                m_meanO2Emission[ll] = 0.0;
                m_SumO2Emission[ll] = 0.0;
                m_meanCO2Emission[ll] = 0.0;
                m_SumCO2Emission[ll] = 0.0;
            }
        }

        public override void SetLayerNum(long iLayerNum)
        {
            base.SetLayerNum(iLayerNum);
            m_ReqedCO2 = new double[m_lLayerNumber];
            m_AvailableCO2 = new double[m_lLayerNumber];
            m_ReqedO2 = new double[m_lLayerNumber];
            m_AvailableO2 = new double[m_lLayerNumber];
            m_meanO2Emission = new double[m_lLayerNumber];
            m_SumO2Emission = new double[m_lLayerNumber];
            m_meanCO2Emission = new double[m_lLayerNumber];
            m_SumCO2Emission = new double[m_lLayerNumber];
            m_StreamInO2 = new double[m_lLayerNumber];
            m_StreamOutCO2 = new double[m_lLayerNumber];
            for( int ll=0;ll<m_lLayerNumber;ll++)
            {
                m_ReqedCO2[ll]=0.0;
                m_AvailableCO2[ll] = 0.0;
                m_ReqedO2[ll] = 0.0;
                m_AvailableO2[ll] = 0.0;
                m_meanO2Emission[ll] = 0.0;
                m_SumO2Emission[ll] = 0.0;
                m_meanCO2Emission[ll] = 0.0;
                m_SumCO2Emission[ll] = 0.0;
            }
        }

        /// <summary><para>method outline:</para>
        /// <para>自己複製</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> Clone( ) </para>
        /// </example>
        /// <param name="">無し</param>
        /// <returns>同一内容で　別院スタンス</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>収束演算時、特定の時刻に状態を戻す場合等に使用する</para>
        /// </remarks>
        public override McCalInfo Clone()
        {
            MzTestDissolveGassCalInfo csRtn = new MzTestDissolveGassCalInfo();
            csRtn.CopyInfo(this);
            return csRtn;
        }
   
        /// <summary><para>method outline:</para>
        /// <para>引数で与えられた情報を自分にコピーを行う</para>
        /// </summary>
        /// <example><para>usage:</para>
        /// <para> bool bRtn = CopyInfo(csOrgInfo) </para>
        /// </example>
        /// <param name="csOrgInfo">コピー元情報</param>
        /// <returns> bool true :正常 , false:異常</returns>
        /// <exception cref="">無し</exception>
        /// <remarks><para>remarks:</para>
        /// <para>無し</para>
        /// </remarks>
        public override bool CopyInfo(McCalInfo csOrgInfo)
        {
            base.CopyInfo(csOrgInfo);
            //this.SetLayerNum(m_lLayerNumber);
            MzTestDissolveGassCalInfo csOrgDt = (MzTestDissolveGassCalInfo)csOrgInfo;

            m_SurfaceCO2 = csOrgDt.m_SurfaceCO2;
            m_SurfaceO2 = csOrgDt.m_SurfaceO2;
            m_Emission_CO2 = csOrgDt.m_Emission_CO2;
            m_Emission_O2 = csOrgDt.m_Emission_O2;

            for (int ll = 0; ll < m_lLayerNumber; ll++)
            {
                this.m_ReqedCO2[ll] = csOrgDt.m_ReqedCO2[ll];
                this.m_AvailableCO2[ll] = csOrgDt.m_AvailableCO2[ll];
                this.m_ReqedO2[ll] = csOrgDt.m_ReqedO2[ll];
                this.m_AvailableO2[ll] = csOrgDt.m_AvailableO2[ll];

                this.m_DaySec = csOrgDt.m_DaySec;
                this.m_SumO2Emission[ll] = csOrgDt.m_SumO2Emission[ll];
                this.m_SumCO2Emission[ll] = csOrgDt.m_SumCO2Emission[ll];
                this.m_meanO2Emission[ll] = csOrgDt.m_meanO2Emission[ll];
                this.m_meanCO2Emission[ll] = csOrgDt.m_meanCO2Emission[ll];
                this.m_StreamInO2[ll] = csOrgDt.m_StreamInO2[ll];
                this.m_StreamOutCO2[ll] = csOrgDt.m_StreamOutCO2[ll];
            }
            return true;
        }

    }
}
